/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.process.ImageProcessor;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.cache.CacheException;
import loci.formats.cache.ICacheSource;
import loci.plugins.Util;

public class ImageProcessorSource
implements ICacheSource {
    protected IFormatReader reader;

    public ImageProcessorSource(IFormatReader reader) throws CacheException {
        this.reader = reader;
    }

    public int getObjectCount() {
        return this.reader.getImageCount();
    }

    public Object getObject(int index) throws CacheException {
        ImageProcessor ip = null;
        try {
            ip = Util.openProcessors(this.reader, index)[0];
        }
        catch (FormatException exc) {
            throw new CacheException(exc);
        }
        catch (IOException exc) {
            throw new CacheException(exc);
        }
        return ip;
    }
}

