/*
 * Decompiled with CFR 0.152.
 */
package bioformatsconverter;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.APNGWriter;
import loci.formats.out.OMETiffWriter;

public class Main {
    private static boolean imageopen = false;
    private static String filename = "";
    private static boolean collectmeta = true;
    private static boolean collectmetaorig = false;
    private static boolean filtermeta = true;

    public static void progress(int i, int size) {
        float prog = (float)(i + 1) / (float)size * 100.0f;
        prog = Main.Round(prog, 2);
        System.out.print("\r\r Progress = " + prog + " %");
    }

    public static float Round(float Rval, int Rpl) {
        float p = (float)Math.pow(10.0, Rpl);
        float tmp = Math.round(Rval *= p);
        return tmp / p;
    }

    public static void saveImageToOMETIFFstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        int numbimgs = myimagereader.getImageCount();
        int xres = myimagereader.getSizeX();
        int yres = myimagereader.getSizeY();
        int zres = myimagereader.getSizeZ();
        int cres = myimagereader.getSizeC();
        int tres = myimagereader.getSizeT();
        String dimorder = myimagereader.getDimensionOrder();
        System.out.println("=============================================");
        System.out.println("Image INFO:");
        System.out.println("(" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        System.out.println("Number of images to save: " + numbimgs);
        System.out.println("Dimensions Order: " + dimorder);
        System.out.println("(voxel size) X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        System.out.println("TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        System.out.println("TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        System.out.println("=============================================");
        System.out.println("Saving to OME-TIFF...");
        BufferedImage buffimage = null;
        boolean eostack = false;
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        int i_helper = 0;
        int numbstacks = tres * cres;
        for (int t = 0; t < tres; ++t) {
            Main.progress(i_helper, numbstacks);
            int tdigits = Integer.toString(t).length();
            String tnumb = Integer.toString(t);
            if (tdigits == 1) {
                tnumb = "T00" + tnumb;
            } else if (tdigits == 2) {
                tnumb = "T0" + tnumb;
            }
            for (int c = 0; c < cres; ++c) {
                int cdigits = Integer.toString(c).length();
                String cnumb = Integer.toString(c);
                if (cdigits == 1) {
                    cnumb = "C00" + cnumb;
                } else if (cdigits == 2) {
                    cnumb = "C0" + cnumb;
                }
                String savefilename = out_dn + tnumb + "_" + cnumb + "_" + infilname + ".tiff";
                OMETiffWriter ometiffwriter = new OMETiffWriter();
                ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                ometiffwriter.setId(savefilename);
                for (int z = 0; z < zres; ++z) {
                    int i = myimagereader.getIndex(z, c, t);
                    eostack = false;
                    if (z == zres - 1) {
                        eostack = true;
                    }
                    buffimage = myimagereader.openImage(i);
                    metarestore.setPixelsSizeC(1, z, 0);
                    metarestore.setPixelsSizeT(1, z, 0);
                    metarestore.setPixelsSizeZ(zres, z, 0);
                    ometiffwriter.saveImage(buffimage, eostack);
                }
                ++i_helper;
            }
        }
    }

    public static void saveImageToPNG(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        myimagereader.setId(in_fn);
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)myimagereader.getMetadataStore());
        OMEXMLMetadata omexmlmetadata = (OMEXMLMetadata)metaretrieve;
        int numbimgs = myimagereader.getImageCount();
        int xres = myimagereader.getSizeX();
        int yres = myimagereader.getSizeY();
        int zres = myimagereader.getSizeZ();
        int cres = myimagereader.getSizeC();
        int tres = myimagereader.getSizeT();
        String dimorder = myimagereader.getDimensionOrder();
        System.out.println("=============================================");
        System.out.println("Image INFO:");
        System.out.println("(" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        System.out.println("Number of images to save: " + numbimgs);
        System.out.println("Dimensions Order: " + dimorder);
        System.out.println("(voxel size) X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        System.out.println("TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        System.out.println("TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        System.out.println("=============================================");
        System.out.println("Saving to PNG...");
        FileWriter fstream = new FileWriter(out_dn + "metadata.txt");
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("Image Dimensions (XYZ)(CT): (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        out.newLine();
        out.write("Voxel Physical Size X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        out.newLine();
        out.write("TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        out.newLine();
        out.write("TimeStepSize: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        out.close();
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        BufferedImage buffimage = null;
        boolean eofiles = false;
        for (int t = 0; t < tres; ++t) {
            int tdigits = Integer.toString(t).length();
            String tnumb = Integer.toString(t);
            if (tdigits == 1) {
                tnumb = "00" + tnumb;
            } else if (tdigits == 2) {
                tnumb = "0" + tnumb;
            }
            String timeoutdirname = out_dn + "T" + tnumb + "/";
            new File(timeoutdirname).mkdir();
            for (int z = 0; z < zres; ++z) {
                int zdigits = Integer.toString(z).length();
                String znumb = Integer.toString(z);
                if (zdigits == 1) {
                    znumb = "00" + znumb;
                } else if (zdigits == 2) {
                    znumb = "0" + znumb;
                }
                for (int c = 0; c < cres; ++c) {
                    int cdigits = Integer.toString(c).length();
                    String cnumb = Integer.toString(c);
                    if (cdigits == 1) {
                        cnumb = "00" + cnumb;
                    } else if (cdigits == 2) {
                        cnumb = "0" + cnumb;
                    }
                    String channeloutdirname = timeoutdirname + "C" + cnumb + "/";
                    new File(channeloutdirname).mkdir();
                    int i = myimagereader.getIndex(z, c, t);
                    eofiles = false;
                    if (i == numbimgs) {
                        eofiles = true;
                    }
                    buffimage = myimagereader.openImage(i);
                    String savefilename = channeloutdirname + infilname + "_T" + tnumb + "_Z" + znumb + "_C" + cnumb + ".png";
                    Main.progress(i, numbimgs);
                    if (z == 0) {
                        fstream = new FileWriter(channeloutdirname + "voxelscale.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(0, 0));
                        out.newLine();
                        out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(0, 0));
                        out.newLine();
                        out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
                        out.newLine();
                        out.close();
                        fstream = new FileWriter(channeloutdirname + "voxelspacing.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(0, 0));
                        out.newLine();
                        out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(0, 0));
                        out.newLine();
                        out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
                        out.newLine();
                        out.close();
                    }
                    APNGWriter pngwriter = new APNGWriter();
                    pngwriter.setMetadataRetrieve(meta);
                    pngwriter.setId(savefilename);
                    pngwriter.saveImage(buffimage, false);
                    pngwriter.close();
                }
            }
        }
        System.out.println("");
        System.out.println("=============================================");
        System.out.println("Finished...");
    }

    public static void saveImageToOMETIFF(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        myimagereader.setId(in_fn);
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)myimagereader.getMetadataStore());
        OMEXMLMetadata omexmlmetadata = (OMEXMLMetadata)metaretrieve;
        int numbimgs = myimagereader.getImageCount();
        int xres = myimagereader.getSizeX();
        int yres = myimagereader.getSizeY();
        int zres = myimagereader.getSizeZ();
        int cres = myimagereader.getSizeC();
        int tres = myimagereader.getSizeT();
        String dimorder = myimagereader.getDimensionOrder();
        System.out.println("=============================================");
        System.out.println("Image INFO:");
        System.out.println("(" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        System.out.println("Number of images to save: " + numbimgs);
        System.out.println("Dimensions Order: " + dimorder);
        System.out.println("(voxel size) X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        System.out.println("TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        System.out.println("TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        System.out.println("=============================================");
        System.out.println("Saving to OME-TIFF...");
        FileWriter fstream = new FileWriter(out_dn + "metadata.txt");
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("Image Dimensions (XYZ)(CT): (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        out.newLine();
        out.write("Voxel Physical Size X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        out.newLine();
        out.write("TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        out.newLine();
        out.write("TimeStepSize: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        out.close();
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        BufferedImage buffimage = null;
        boolean eofiles = false;
        for (int t = 0; t < tres; ++t) {
            int tdigits = Integer.toString(t).length();
            String tnumb = Integer.toString(t);
            if (tdigits == 1) {
                tnumb = "00" + tnumb;
            } else if (tdigits == 2) {
                tnumb = "0" + tnumb;
            }
            String timeoutdirname = out_dn + "T" + tnumb + "/";
            new File(timeoutdirname).mkdir();
            for (int z = 0; z < zres; ++z) {
                int zdigits = Integer.toString(z).length();
                String znumb = Integer.toString(z);
                if (zdigits == 1) {
                    znumb = "00" + znumb;
                } else if (zdigits == 2) {
                    znumb = "0" + znumb;
                }
                for (int c = 0; c < cres; ++c) {
                    int cdigits = Integer.toString(c).length();
                    String cnumb = Integer.toString(c);
                    if (cdigits == 1) {
                        cnumb = "00" + cnumb;
                    } else if (cdigits == 2) {
                        cnumb = "0" + cnumb;
                    }
                    String channeloutdirname = timeoutdirname + "C" + cnumb + "/";
                    new File(channeloutdirname).mkdir();
                    int i = myimagereader.getIndex(z, c, t);
                    eofiles = false;
                    if (i == numbimgs) {
                        eofiles = true;
                    }
                    buffimage = myimagereader.openImage(i);
                    String savefilename = channeloutdirname + infilname + "_T" + tnumb + "_Z" + znumb + "_C" + cnumb + ".tif";
                    Main.progress(i, numbimgs);
                    if (z == 0) {
                        fstream = new FileWriter(channeloutdirname + "voxelscale.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(0, 0));
                        out.newLine();
                        out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(0, 0));
                        out.newLine();
                        out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
                        out.newLine();
                        out.close();
                        fstream = new FileWriter(channeloutdirname + "voxelspacing.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(0, 0));
                        out.newLine();
                        out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(0, 0));
                        out.newLine();
                        out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
                        out.newLine();
                        out.close();
                    }
                    OMETiffWriter ometiffwriter = new OMETiffWriter();
                    ometiffwriter.setMetadataRetrieve(metaretrieve);
                    ometiffwriter.setId(savefilename);
                    ometiffwriter.saveImage(buffimage, false);
                }
            }
        }
        System.out.println("");
        System.out.println("=============================================");
        System.out.println("Finished...");
    }

    public static void main(String[] args) throws Exception {
        System.out.println("=============================================");
        System.out.println("BIOFORMATS CONVERTER v1.0");
        System.out.println("author: Jerome Avondo.");
        System.out.println("");
        System.out.println("for more info use --help");
        System.out.println("=============================================");
        int helper = 0;
        String inputfilename = "";
        String outputdirectory = "";
        String stackmode = "";
        String filemode = "";
        for (String s : args) {
            if (s.equals("--help")) {
                System.out.println("This program takes as input one of the many");
                System.out.println("supported image filetypes by the bioformats");
                System.out.println("library and saves it as a stack of OME-TIFF.");
                System.out.println("files for your image.");
                System.out.println("");
                System.out.println("usage: bioformatsConverter [inputfilename] [filemode] [outputmode]");
                System.out.println("");
                System.out.println("[filemode] can either be 'TIFF' or 'PNG'.");
                System.out.println("[outputmode] can either be 'single' or 'stack' when you save as TIFFs.");
                System.out.println("=============================================");
                return;
            }
            if (helper == 0) {
                inputfilename = s;
            }
            if (helper == 1) {
                filemode = s;
            }
            if (helper == 2) {
                stackmode = s;
            }
            ++helper;
        }
        outputdirectory = inputfilename.replace(".", "_");
        outputdirectory = outputdirectory + "/";
        boolean exists = new File(inputfilename).exists();
        if (exists) {
            new File(outputdirectory).mkdir();
            System.out.println("inputfilename: " + inputfilename);
            System.out.println("outputdirectory: " + outputdirectory);
            System.out.println("filemode: " + filemode);
            System.out.println("stackmode: " + stackmode);
            if (filemode.equals("TIFF")) {
                if (stackmode.equals("stack")) {
                    Main.saveImageToOMETIFFstack(inputfilename, outputdirectory);
                } else if (stackmode.equals("single")) {
                    Main.saveImageToOMETIFF(inputfilename, outputdirectory);
                }
            } else if (filemode.equals("PNG")) {
                Main.saveImageToPNG(inputfilename, outputdirectory);
            }
        } else {
            System.out.println("\nERROR: inputfilename: '" + inputfilename + "' DOES NOT EXIST!\n");
        }
    }
}

