/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import loci.common.DataTools;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.XMLTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataConverter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;

public final class MetadataTools {
    private MetadataTools() {
    }

    public static IMetadata createOMEXMLMetadata() {
        return MetadataTools.createOMEXMLMetadata(null);
    }

    public static IMetadata createOMEXMLMetadata(String xml) {
        return MetadataTools.createOMEXMLMetadata(xml, null);
    }

    public static IMetadata createOMEXMLMetadata(String xml, String version) {
        IMetadata meta;
        block6: {
            Object ome = null;
            meta = null;
            ReflectedUniverse r = new ReflectedUniverse();
            try {
                ome = MetadataTools.createOMEXMLRoot(xml);
                if (version == null) {
                    if (ome == null) {
                        r.exec("import ome.xml.OMEXMLFactory");
                        version = (String)r.exec("OMEXMLFactory.LATEST_VERSION");
                    } else {
                        r.setVar("ome", ome);
                        version = MetadataTools.getOMEXMLVersion(ome);
                    }
                }
                String metaClass = "OMEXML" + version.replaceAll("[^\\w]", "") + "Metadata";
                r.exec("import loci.formats.ome." + metaClass);
                meta = (IMetadata)r.exec("new " + metaClass + "()");
                if (ome != null) {
                    meta.setRoot(ome);
                }
            }
            catch (ReflectException exc) {
                if (!FormatHandler.debug) break block6;
                LogTools.trace(exc);
            }
        }
        return meta;
    }

    public static Object createOMEXMLRoot(String xml) {
        if (xml == null) {
            return null;
        }
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import ome.xml.OMEXMLFactory");
            r.setVar("xml", xml);
            return r.exec("OMEXMLFactory.newOMENodeFromSource(xml)");
        }
        catch (ReflectException exc) {
            if (FormatHandler.debug) {
                LogTools.trace(exc);
            }
            return null;
        }
    }

    public static boolean isOMEXMLMetadata(Object o) {
        return MetadataTools.isInstance(o, "loci.formats.ome", "OMEXMLMetadata");
    }

    public static boolean isOMEXMLRoot(Object o) {
        return MetadataTools.isInstance(o, "ome.xml", "OMEXMLNode");
    }

    public static String getOMEXMLVersion(Object o) {
        block7: {
            if (o == null) {
                return null;
            }
            String name = o.getClass().getName();
            if (MetadataTools.isOMEXMLMetadata(o)) {
                String numbers;
                String prefix = "loci.formats.ome.OMEXML";
                String suffix = "Metadata";
                if (name.startsWith("loci.formats.ome.OMEXML") && name.endsWith("Metadata") && (numbers = name.substring("loci.formats.ome.OMEXML".length(), name.length() - "Metadata".length())).length() == 6) {
                    return numbers.substring(0, 4) + "-" + numbers.substring(4, 6).toUpperCase();
                }
            } else if (MetadataTools.isOMEXMLRoot(o)) {
                ReflectedUniverse r = new ReflectedUniverse();
                r.setVar("ome", o);
                try {
                    return (String)r.exec("ome.getVersion()");
                }
                catch (ReflectException exc) {
                    if (!FormatHandler.debug) break block7;
                    LogTools.trace(exc);
                }
            }
        }
        return null;
    }

    public static IMetadata getOMEMetadata(MetadataRetrieve src) {
        if (MetadataTools.isOMEXMLMetadata(src)) {
            return (IMetadata)src;
        }
        IMetadata omexmlMeta = MetadataTools.createOMEXMLMetadata();
        MetadataTools.convertMetadata(src, (MetadataStore)omexmlMeta);
        return omexmlMeta;
    }

    public static String getOMEXML(MetadataRetrieve src) {
        IMetadata omexmlMeta = MetadataTools.getOMEMetadata(src);
        ReflectedUniverse r = new ReflectedUniverse();
        r.setVar("omexmlMeta", omexmlMeta);
        try {
            return (String)r.exec("omexmlMeta.dumpXML()");
        }
        catch (ReflectException exc) {
            if (FormatHandler.debug) {
                LogTools.trace(exc);
            }
            return null;
        }
    }

    public static void validateOMEXML(String xml) {
        XMLTools.validateXML(xml, "OME-XML");
    }

    public static void populatePixels(MetadataStore store, IFormatReader r) {
        MetadataTools.populatePixels(store, r, false);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane) {
        if (store == null || r == null) {
            return;
        }
        int oldSeries = r.getSeries();
        for (int i = 0; i < r.getSeriesCount(); ++i) {
            r.setSeries(i);
            store.setPixelsID("Pixels:" + i, i, 0);
            store.setImageDefaultPixels("Pixels:" + i, i);
            store.setPixelsSizeX(new Integer(r.getSizeX()), i, 0);
            store.setPixelsSizeY(new Integer(r.getSizeY()), i, 0);
            store.setPixelsSizeZ(new Integer(r.getSizeZ()), i, 0);
            store.setPixelsSizeC(new Integer(r.getSizeC()), i, 0);
            store.setPixelsSizeT(new Integer(r.getSizeT()), i, 0);
            store.setPixelsPixelType(FormatTools.getPixelTypeString(r.getPixelType()), i, 0);
            store.setPixelsBigEndian(new Boolean(!r.isLittleEndian()), i, 0);
            store.setPixelsDimensionOrder(r.getDimensionOrder(), i, 0);
            store.setDisplayOptionsDisplay(r.isRGB() ? "RGB" : "Grey", i);
            if (r.getSizeC() > 0) {
                Integer sampleCount = new Integer(r.getRGBChannelCount());
                for (int c = 0; c < r.getEffectiveSizeC(); ++c) {
                    store.setLogicalChannelSamplesPerPixel(sampleCount, i, c);
                    for (int rgb = 0; rgb < r.getRGBChannelCount(); ++rgb) {
                        store.setChannelComponentIndex(new Integer(c * r.getRGBChannelCount() + rgb), i, c, rgb);
                        store.setChannelComponentPixels("Pixels:" + i, i, c, rgb);
                    }
                }
            }
            if (!doPlane) continue;
            for (int q = 0; q < r.getImageCount(); ++q) {
                int[] coords = r.getZCTCoords(q);
                store.setPlaneTheZ(new Integer(coords[0]), i, 0, q);
                store.setPlaneTheC(new Integer(coords[1]), i, 0, q);
                store.setPlaneTheT(new Integer(coords[2]), i, 0, q);
            }
        }
        r.setSeries(oldSeries);
    }

    public static void setDefaultCreationDate(MetadataStore store, String id, int series) {
        Location file2 = new Location(id).getAbsoluteFile();
        long time = System.currentTimeMillis();
        if (file2.exists()) {
            time = file2.lastModified();
        }
        store.setImageCreationDate(DataTools.convertDate(time, 0), series);
    }

    public static void populateOriginalMetadata(Object omexmlMeta, String key, String value) {
        block2: {
            ReflectedUniverse r = new ReflectedUniverse();
            r.setVar("omexmlMeta", omexmlMeta);
            r.setVar("key", key);
            r.setVar("value", value);
            try {
                r.exec("omexmlMeta.setOriginalMetadata(key, value)");
            }
            catch (ReflectException exc) {
                if (!FormatHandler.debug) break block2;
                LogTools.trace(exc);
            }
        }
    }

    public static String getOriginalMetadata(Object omexmlMeta, String key) {
        ReflectedUniverse r = new ReflectedUniverse();
        r.setVar("omexmlMeta", omexmlMeta);
        r.setVar("key", key);
        try {
            return (String)r.exec("omexmlMeta.getOriginalMetadata(key)");
        }
        catch (ReflectException exc) {
            if (FormatHandler.debug) {
                LogTools.trace(exc);
            }
            return null;
        }
    }

    public static void convertMetadata(String xml, MetadataStore dest) {
        String storeVersion;
        Object ome = MetadataTools.createOMEXMLRoot(xml);
        String rootVersion = MetadataTools.getOMEXMLVersion(ome);
        if (rootVersion.equals(storeVersion = MetadataTools.getOMEXMLVersion(dest))) {
            ReflectedUniverse r = new ReflectedUniverse();
            try {
                r.setVar("xml", xml);
                r.setVar("omexmlMeta", dest);
                r.exec("omexmlMeta.createRoot(xml)");
            }
            catch (ReflectException exc) {
                if (FormatHandler.debug) {
                    LogTools.trace(exc);
                }
            }
        } else {
            IMetadata src = MetadataTools.createOMEXMLMetadata(xml);
            MetadataTools.convertMetadata(src, dest);
        }
    }

    public static void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        MetadataConverter.convertMetadata(src, dest);
    }

    private static boolean isInstance(Object o, String packageName, String className) {
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import " + packageName + "." + className);
            Class c = (Class)r.getVar(className);
            return c.isInstance(o);
        }
        catch (ReflectException exc) {
            if (FormatHandler.debug) {
                LogTools.trace(exc);
            }
            return false;
        }
    }
}

