/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;

public class FluoviewReader
extends BaseTiffReader {
    private static final String FLUOVIEW_MAGIC_STRING = "FLUOVIEW";
    private static final int MMHEADER = 34361;
    private static final int MMSTAMP = 34362;
    private float voxelX = 1.0f;
    private float voxelY = 1.0f;
    private float voxelZ = 1.0f;
    private float voxelC = 1.0f;
    private float voxelT = 1.0f;
    private BufferedImage zeroImage = null;
    private String dimensionOrder;
    private String[] gains;
    private String[] voltages;
    private String[] offsets;
    private String[] channelNames;
    private String[] lensNA;
    private String mag;
    private String detManu;
    private String objManu;
    private String comment;
    private Double gamma;

    public FluoviewReader() {
        super("Olympus Fluoview/ABD TIFF", new String[]{"tif", "tiff"});
        this.blockCheckLen = 524288;
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        try {
            RandomAccessStream stream = new RandomAccessStream(name);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException e) {
            if (debug) {
                this.trace(e);
            }
            return false;
        }
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        Hashtable ifd = TiffTools.getFirstIFD(stream);
        String com = TiffTools.getComment(ifd);
        if (com == null) {
            com = "";
        }
        if (ifd == null) {
            return false;
        }
        return com.indexOf(FLUOVIEW_MAGIC_STRING) != -1 && ifd.containsKey(new Integer(34361)) || ifd.containsKey(new Integer(34362));
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int[] lengths = new int[4];
        int[] pos = this.getZCTCoords(no);
        int[] realPos = new int[4];
        for (int i = 2; i < this.dimensionOrder.length(); ++i) {
            char axis = this.dimensionOrder.charAt(i);
            if (axis == 'Z') {
                lengths[i - 2] = this.getSizeZ();
                realPos[i - 2] = pos[0];
                continue;
            }
            if (axis == 'C') {
                lengths[i - 2] = this.getEffectiveSizeC();
                realPos[i - 2] = pos[1];
                continue;
            }
            if (axis == 'T') {
                lengths[i - 2] = this.getSizeT();
                realPos[i - 2] = pos[2];
                continue;
            }
            if (axis != 'S') continue;
            lengths[i - 2] = this.getSeriesCount();
            realPos[i - 2] = this.getSeries();
        }
        int image = FormatTools.positionToRaster(lengths, realPos);
        if ((long)this.getSizeY() == TiffTools.getImageLength(this.ifds[0])) {
            TiffTools.getSamples(this.ifds[image], this.in, buf, x, y, w, h);
        } else {
            FormatTools.assertId(this.currentId, true, 1);
            FormatTools.checkPlaneNumber(this, no);
            FormatTools.checkBufferSize(this, buf.length, w, h);
            TiffTools.getSamples(this.ifds[0], this.in, buf, x, image, w, 1L);
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.voxelT = 1.0f;
        this.voxelC = 1.0f;
        this.voxelZ = 1.0f;
        this.voxelY = 1.0f;
        this.voxelX = 1.0f;
        this.zeroImage = null;
        this.dimensionOrder = null;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        short[] s = TiffTools.getIFDShortArray(this.ifds[0], 34361, true);
        byte[] mmheader = new byte[s.length];
        for (int i = 0; i < mmheader.length; ++i) {
            mmheader[i] = (byte)s[i];
            if (mmheader[i] >= 0) continue;
            int n = i;
            mmheader[n] = (byte)(mmheader[n] + 1);
        }
        RandomAccessStream ras = new RandomAccessStream(mmheader);
        ras.order(this.isLittleEndian());
        this.put("Header Flag", ras.readShort());
        this.put("Image Type", ras.readChar());
        this.put("Image name", ras.readString(257));
        ras.skipBytes(4);
        this.put("Number of colors", ras.readInt());
        ras.skipBytes(4);
        ras.skipBytes(4);
        this.put("Comment size", ras.readInt());
        ras.skipBytes(4);
        String[] names = new String[10];
        int[] sizes = new int[10];
        double[] resolutions = new double[10];
        for (int i = 0; i < 10; ++i) {
            names[i] = ras.readString(16);
            sizes[i] = ras.readInt();
            double origin = ras.readDouble();
            resolutions[i] = ras.readDouble();
            this.put("Dimension " + (i + 1) + " Name", names[i]);
            this.put("Dimension " + (i + 1) + " Size", sizes[i]);
            this.put("Dimension " + (i + 1) + " Origin", origin);
            this.put("Dimension " + (i + 1) + " Resolution", resolutions[i]);
            this.put("Dimension " + (i + 1) + " Units", ras.readString(64));
        }
        ras.skipBytes(4);
        this.put("Map type", ras.readShort());
        this.put("Map min", ras.readDouble());
        this.put("Map max", ras.readDouble());
        this.put("Min value", ras.readDouble());
        this.put("Max value", ras.readDouble());
        ras.skipBytes(4);
        this.put("Gamma", ras.readDouble());
        this.put("Offset", ras.readDouble());
        this.put("Gray Channel Name", ras.readString(16));
        this.put("Gray Channel Size", ras.readInt());
        this.put("Gray Channel Origin", ras.readDouble());
        this.put("Gray Channel Resolution", ras.readDouble());
        this.put("Gray Channel Units", ras.readString(64));
        ras.skipBytes(4);
        this.put("Voice field", ras.readInt());
        ras.skipBytes(4);
        double[][] stamps = new double[8][this.ifds.length];
        for (int i = 0; i < this.ifds.length; ++i) {
            int j;
            s = TiffTools.getIFDShortArray(this.ifds[i], 34362, true);
            byte[] stamp = new byte[s.length];
            for (j = 0; j < s.length; ++j) {
                stamp[j] = (byte)s[j];
                if (stamp[j] >= 0) continue;
                int n = j;
                stamp[n] = (byte)(stamp[n] + 1);
            }
            ras = new RandomAccessStream(stamp);
            for (j = 0; j < 8; ++j) {
                stamps[j][i] = ras.readDouble();
            }
        }
        this.dimensionOrder = "XY";
        int seriesCount = 1;
        this.core[0].sizeT = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeZ = 1;
        for (int i = 0; i < 10; ++i) {
            String name = names[i];
            int size = sizes[i];
            float voxel = (float)resolutions[i];
            if (name == null || size == 0 || (name = name.toLowerCase().trim()).length() == 0) continue;
            if (name.equals("x")) {
                this.voxelX = voxel;
                continue;
            }
            if (name.equals("y")) {
                this.voxelY = voxel;
                continue;
            }
            if (name.equals("z") || name.equals("event")) {
                this.core[0].sizeZ *= size;
                if (this.dimensionOrder.indexOf("Z") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "Z";
                }
                this.voxelZ = voxel;
                continue;
            }
            if (name.equals("ch") || name.equals("wavelength")) {
                this.core[0].sizeC *= size;
                if (this.dimensionOrder.indexOf("C") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "C";
                }
                this.voxelC = voxel;
                continue;
            }
            if (name.equals("time") || name.equals("t") || name.equals("animation")) {
                this.core[0].sizeT *= size;
                if (this.dimensionOrder.indexOf("T") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "T";
                }
                this.voxelT = voxel;
                continue;
            }
            if (this.dimensionOrder.indexOf("S") == -1) {
                this.dimensionOrder = this.dimensionOrder + "S";
            }
            seriesCount *= size;
        }
        if (this.dimensionOrder.indexOf("Z") == -1) {
            this.dimensionOrder = this.dimensionOrder + "Z";
        }
        if (this.dimensionOrder.indexOf("T") == -1) {
            this.dimensionOrder = this.dimensionOrder + "T";
        }
        if (this.dimensionOrder.indexOf("C") == -1) {
            this.dimensionOrder = this.dimensionOrder + "C";
        }
        if (this.dimensionOrder.indexOf("S") == -1) {
            this.dimensionOrder = this.dimensionOrder + "S";
        }
        this.core[0].imageCount = this.ifds.length / seriesCount;
        if (this.getSizeZ() > this.getImageCount()) {
            this.core[0].sizeZ = this.getImageCount();
        }
        if (this.getSizeT() > this.getImageCount()) {
            this.core[0].sizeT = this.getImageCount();
        }
        if (!(this.getImageCount() != 1 || this.getSizeT() != this.getSizeY() && this.getSizeZ() != this.getSizeY() || this.getSizeT() <= this.getImageCount() && this.getSizeZ() <= this.getImageCount())) {
            this.core[0].sizeY = 1;
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        this.core[0].dimensionOrder = this.dimensionOrder.replaceAll("S", "");
        if (seriesCount > 1) {
            CoreMetadata oldCore = this.core[0];
            this.core = new CoreMetadata[seriesCount];
            for (int i = 0; i < seriesCount; ++i) {
                this.core[i] = oldCore;
            }
        }
        this.comment = TiffTools.getComment(this.ifds[0]);
        this.gains = new String[this.getSizeC()];
        this.offsets = new String[this.getSizeC()];
        this.voltages = new String[this.getSizeC()];
        this.channelNames = new String[this.getSizeC()];
        this.lensNA = new String[this.getSizeC()];
        if (this.comment != null && this.comment.startsWith("[")) {
            int start = this.comment.indexOf("[Acquisition Parameters]");
            int end = this.comment.indexOf("[Acquisition Parameters End]");
            if (start != -1 && end != -1 && end > start) {
                String parms = this.comment.substring(start + 24, end).trim();
                StringTokenizer st = new StringTokenizer(parms, "\n");
                block7: while (st.hasMoreTokens()) {
                    int i;
                    String token = st.nextToken();
                    int eq = token.indexOf("=");
                    if (eq == -1) continue;
                    String key = token.substring(0, eq);
                    String value = token.substring(eq + 1);
                    this.addMeta(key, value);
                    if (key.startsWith("Gain Ch")) {
                        for (i = 0; i < this.gains.length; ++i) {
                            if (this.gains[i] != null) continue;
                            this.gains[i] = value;
                            continue block7;
                        }
                        continue;
                    }
                    if (key.startsWith("PMT Voltage Ch")) {
                        for (i = 0; i < this.voltages.length; ++i) {
                            if (this.voltages[i] != null) continue;
                            this.voltages[i] = value;
                            continue block7;
                        }
                        continue;
                    }
                    if (key.startsWith("Offset Ch")) {
                        for (i = 0; i < this.offsets.length; ++i) {
                            if (this.offsets[i] != null) continue;
                            this.offsets[i] = value;
                            continue block7;
                        }
                        continue;
                    }
                    if (key.equals("Magnification")) {
                        this.mag = value;
                        continue;
                    }
                    if (key.equals("System Configuration")) {
                        this.detManu = value;
                        continue;
                    }
                    if (key.equals("Objective Lens")) {
                        this.objManu = value;
                        continue;
                    }
                    if (key.equals("Gamma")) {
                        this.gamma = new Double(value);
                        continue;
                    }
                    if (key.startsWith("Channel ") && key.endsWith("Dye")) {
                        for (i = 0; i < this.channelNames.length; ++i) {
                            if (this.channelNames[i] != null) continue;
                            this.channelNames[i] = value;
                            continue block7;
                        }
                        continue;
                    }
                    if (!key.startsWith("Confocal Aperture-Ch")) continue;
                    for (i = 0; i < this.lensNA.length; ++i) {
                        if (this.lensNA[i] != null) continue;
                        this.lensNA[i] = value.substring(0, value.length() - 2);
                        continue block7;
                    }
                }
            }
            start = this.comment.indexOf("[Version Info]");
            end = this.comment.indexOf("[Version Info End]");
            if (start != -1 && end != -1 && end > start) {
                this.comment = this.comment.substring(start + 14, end).trim();
                start = this.comment.indexOf("=") + 1;
                end = this.comment.indexOf("\n");
                this.comment = end > start ? this.comment.substring(start, end).trim() : this.comment.substring(start).trim();
            } else {
                this.comment = "";
            }
        }
        this.addMeta("Comment", this.comment);
    }

    protected void initMetadataStore() throws FormatException {
        int i;
        super.initMetadataStore();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        store.setImageDescription(this.comment, 0);
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        store.setDimensionsPhysicalSizeX(new Float(this.voxelX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(this.voxelY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(this.voxelZ), 0, 0);
        store.setDimensionsTimeIncrement(new Float(this.voxelT), 0, 0);
        if ((int)this.voxelC > 0) {
            store.setDimensionsWaveIncrement(new Integer((int)this.voxelC), 0, 0);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.channelNames[i] == null) continue;
            store.setLogicalChannelName(this.channelNames[i].trim(), 0, i);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.voltages[i] != null) {
                if (this.detManu != null) {
                    store.setDetectorManufacturer(this.detManu, 0, 0);
                }
                store.setDetectorSettingsVoltage(new Float(this.voltages[i]), 0, 0);
            }
            if (this.gains[i] != null) {
                store.setDetectorSettingsGain(new Float(this.gains[i]), 0, i);
            }
            if (this.offsets[i] != null) {
                store.setDetectorSettingsOffset(new Float(this.offsets[i]), 0, i);
            }
            store.setDetectorType("Unknown", 0, i);
            store.setDetectorID("Detector:" + i, 0, i);
            store.setDetectorSettingsDetector("Detector:" + i, 0, i);
        }
        if (this.mag != null && this.mag.toLowerCase().endsWith("x")) {
            this.mag = this.mag.substring(0, this.mag.length() - 1);
        } else if (this.mag == null) {
            this.mag = "1";
        }
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        if (this.objManu != null) {
            String[] objectiveData = this.objManu.split(" ");
            store.setObjectiveModel(objectiveData[0], 0, 0);
            if (objectiveData.length > 2) {
                store.setObjectiveImmersion(objectiveData[2], 0, 0);
            }
        }
        if (this.mag != null) {
            store.setObjectiveCalibratedMagnification(new Float(this.mag), 0, 0);
        }
        for (int i2 = 0; i2 < this.getSizeC(); ++i2) {
            if (this.lensNA[i2] == null) continue;
            store.setObjectiveLensNA(new Float(this.lensNA[i2]), 0, i2);
        }
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
    }
}

