/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Point;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class InCellReader
extends FormatReader {
    private Image[][][] imageFiles;
    private MinimalTiffReader tiffReader;
    private int seriesCount;
    private Vector emWaves;
    private Vector exWaves;
    private int totalImages;
    private String creationDate;
    private int startRow;
    private int startCol;
    private int fieldCount;
    private int wellRows;
    private int wellCols;
    private Hashtable wellCoordinates;
    private Vector posX;
    private Vector posY;
    private int firstRow;
    private int firstCol;
    private int lastCol;

    public InCellReader() {
        super("InCell 1000", "xdce");
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader.get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int well = this.getWellFromSeries(this.getSeries());
        int field = this.getFieldFromSeries(this.getSeries());
        this.tiffReader.setId(this.imageFiles[well][field][no].filename);
        return this.tiffReader.openBytes(0, buf, x, y, w, h);
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        String[] files = new String[this.getSeriesCount() * this.getImageCount() + 1];
        int nextFile = 0;
        if (this.imageFiles != null) {
            for (int series = 0; series < this.getSeriesCount(); ++series) {
                int well = this.getWellFromSeries(series);
                int field = this.getFieldFromSeries(series);
                for (int plane = 0; plane < this.getImageCount(); ++plane) {
                    files[nextFile++] = this.imageFiles[well][field][plane].filename;
                }
            }
        }
        files[files.length - 1] = this.currentId;
        return files;
    }

    public void close() throws IOException {
        super.close();
        this.imageFiles = null;
        if (this.tiffReader != null) {
            this.tiffReader.close();
        }
        this.tiffReader = null;
        this.seriesCount = 0;
        this.totalImages = 0;
        this.exWaves = null;
        this.emWaves = null;
        this.wellCoordinates = null;
        this.posX = null;
        this.posY = null;
        this.creationDate = null;
        this.wellCols = 0;
        this.wellRows = 0;
        this.startCol = 0;
        this.startRow = 0;
        this.fieldCount = 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int field;
        int well;
        int i;
        if (debug) {
            this.debug("InCellReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.firstRow = Integer.MAX_VALUE;
        this.firstCol = Integer.MAX_VALUE;
        this.lastCol = Integer.MIN_VALUE;
        this.emWaves = new Vector();
        this.exWaves = new Vector();
        this.wellCoordinates = new Hashtable();
        this.posX = new Vector();
        this.posY = new Vector();
        byte[] b = new byte[(int)this.in.length()];
        this.in.read(b);
        this.core[0].dimensionOrder = "XYZCT";
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        DefaultHandler handler = new MinimalInCellHandler();
        DataTools.parseXML(b, handler);
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.seriesCount = this.totalImages / (this.getSizeZ() * this.getSizeC() * this.getSizeT());
        int z = this.getSizeZ();
        int c = this.getSizeC();
        int t = this.getSizeT();
        this.core = new CoreMetadata[this.seriesCount];
        for (int i2 = 0; i2 < this.seriesCount; ++i2) {
            this.core[i2] = new CoreMetadata();
            this.core[i2].sizeZ = z;
            this.core[i2].sizeC = c;
            this.core[i2].sizeT = t;
            this.core[i2].imageCount = z * c * t;
            this.core[i2].dimensionOrder = "XYZCT";
        }
        this.tiffReader = new MinimalTiffReader();
        this.tiffReader.setId(this.imageFiles[this.getWellFromSeries((int)0)][this.getFieldFromSeries((int)0)][0].filename);
        boolean nextTiming = false;
        for (i = 0; i < this.seriesCount; ++i) {
            this.core[i].sizeX = this.tiffReader.getSizeX();
            this.core[i].sizeY = this.tiffReader.getSizeY();
            this.core[i].interleaved = this.tiffReader.isInterleaved();
            this.core[i].indexed = this.tiffReader.isIndexed();
            this.core[i].rgb = this.tiffReader.isRGB();
            this.core[i].pixelType = this.tiffReader.getPixelType();
            this.core[i].littleEndian = this.tiffReader.isLittleEndian();
        }
        MetadataTools.populatePixels(store, this, true);
        handler = new InCellHandler(store);
        DataTools.parseXML(b, handler);
        store.setInstrumentID("Instrument:0", 0);
        for (i = 0; i < this.seriesCount; ++i) {
            well = this.getWellFromSeries(i);
            field = this.getFieldFromSeries(i);
            store.setImageID("Image:" + i, i);
            store.setImageInstrumentRef("Instrument:0", i);
            store.setImageName("Well #" + well + ", Field #" + field, i);
            store.setImageCreationDate(this.creationDate, i);
        }
        for (i = 0; i < this.seriesCount; ++i) {
            well = this.getWellFromSeries(i);
            field = this.getFieldFromSeries(i);
            for (int q = 0; q < this.core[i].imageCount; ++q) {
                Image img = this.imageFiles[well][field][q];
                store.setPlaneTimingDeltaT(img.deltaT, i, 0, q);
                store.setPlaneTimingExposureTime(img.exposure, i, 0, q);
            }
        }
        for (i = 0; i < this.seriesCount; ++i) {
            for (int q = 0; q < this.emWaves.size(); ++q) {
                store.setLogicalChannelEmWave((Integer)this.emWaves.get(q), i, q);
                store.setLogicalChannelExWave((Integer)this.exWaves.get(q), i, q);
            }
        }
        int[][] plate = new int[this.wellRows][this.wellCols];
        for (int i3 = 0; i3 < this.seriesCount; ++i3) {
            int well2 = this.getWellFromSeries(i3);
            int field2 = this.getFieldFromSeries(i3);
            store.setWellSampleIndex(new Integer(i3), 0, well2, field2);
            store.setWellSampleImageRef("Image:" + i3, 0, well2, field2);
            store.setWellSamplePosX((Float)this.posX.get(field2), 0, well2, field2);
            store.setWellSamplePosY((Float)this.posY.get(field2), 0, well2, field2);
        }
    }

    private int getFieldFromSeries(int series) {
        return series % this.fieldCount;
    }

    private int getWellFromSeries(int series) {
        int well = series / this.fieldCount;
        int wellRow = well / (this.lastCol - this.firstCol + 1);
        int wellCol = well % (this.lastCol - this.firstCol + 1);
        return (wellRow + this.firstRow) * this.wellCols + wellCol + this.firstCol;
    }

    static /* synthetic */ Image[][][] access$002(InCellReader x0, Image[][][] x1) {
        x0.imageFiles = x1;
        return x1;
    }

    class Image {
        public String filename;
        public Float deltaT;
        public Float exposure;

        Image() {
        }
    }

    class InCellHandler
    extends DefaultHandler {
        private String currentQName;
        private boolean openImage;
        private int nextEmWave = 0;
        private int nextExWave = 0;
        private MetadataStore store;
        private int nextPlate = 0;
        private int currentRow = -1;
        private int currentCol = -1;
        private int currentField = 0;
        private int currentImage;
        private Float timestamp;
        private Float exposure;

        public InCellHandler(MetadataStore store) {
            this.store = store;
        }

        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            if (this.currentQName.equals("UserComment")) {
                this.store.setImageDescription(value, 0);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("Image")) {
                Point p = new Point(this.currentRow, this.currentCol);
                InCellReader.this.wellCoordinates.put(new Integer(this.currentField), p);
                this.openImage = false;
                int well = this.currentRow * InCellReader.this.wellCols + this.currentCol;
                ((InCellReader)InCellReader.this).imageFiles[well][this.currentField][this.currentImage].deltaT = this.timestamp;
                ((InCellReader)InCellReader.this).imageFiles[well][this.currentField][this.currentImage].exposure = this.exposure;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            int i;
            this.currentQName = qName;
            for (i = 0; i < attributes.getLength(); ++i) {
                InCellReader.this.addMeta(qName + " - " + attributes.getQName(i), attributes.getValue(i));
            }
            if (qName.equals("Image")) {
                this.openImage = true;
                float time = Float.parseFloat(attributes.getValue("acquisition_time_ms"));
                this.timestamp = new Float(time / 1000.0f);
            } else if (qName.equals("Identifier")) {
                this.currentField = Integer.parseInt(attributes.getValue("field_index"));
                int z = Integer.parseInt(attributes.getValue("z_index"));
                int c = Integer.parseInt(attributes.getValue("wave_index"));
                int t = Integer.parseInt(attributes.getValue("time_index"));
                this.currentImage = InCellReader.this.getIndex(z, c, t);
            } else if (qName.equals("Creation")) {
                String date = attributes.getValue("date");
                String time = attributes.getValue("time");
                InCellReader.this.creationDate = date + "T" + time;
            } else if (qName.equals("ObjectiveCalibration")) {
                this.store.setObjectiveNominalMagnification(new Integer((int)Float.parseFloat(attributes.getValue("magnification"))), 0, 0);
                this.store.setObjectiveModel(attributes.getValue("objective_name"), 0, 0);
                this.store.setObjectiveLensNA(new Float(attributes.getValue("numerical_aperture")), 0, 0);
                this.store.setObjectiveCorrection("Unknown", 0, 0);
                this.store.setObjectiveImmersion("Unknown", 0, 0);
                Float pixelSizeX = new Float(attributes.getValue("pixel_width"));
                Float pixelSizeY = new Float(attributes.getValue("pixel_height"));
                Float refractive = new Float(attributes.getValue("refractive_index"));
                this.store.setObjectiveID("Objective:0", 0, 0);
                for (int i2 = 0; i2 < InCellReader.this.getSeriesCount(); ++i2) {
                    this.store.setObjectiveSettingsObjective("Objective:0", i2);
                    this.store.setObjectiveSettingsRefractiveIndex(refractive, i2);
                    this.store.setDimensionsPhysicalSizeX(pixelSizeX, i2, 0);
                    this.store.setDimensionsPhysicalSizeY(pixelSizeY, i2, 0);
                }
            } else if (qName.equals("ExcitationFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.exWaves.add(new Integer(wave));
                }
            } else if (qName.equals("EmissionFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.emWaves.add(new Integer(wave));
                }
            } else if (qName.equals("Camera")) {
                this.store.setDetectorModel(attributes.getValue("name"), 0, 0);
                this.store.setDetectorType("Unknown", 0, 0);
                this.store.setDetectorID("Detector:0", 0, 0);
                for (i = 0; i < InCellReader.this.getSeriesCount(); ++i) {
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsDetector("Detector:0", i, q);
                    }
                }
            } else if (qName.equals("Binning")) {
                String binning = attributes.getValue("value");
                for (int i3 = 0; i3 < InCellReader.this.getSeriesCount(); ++i3) {
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsBinning(binning, i3, q);
                    }
                }
            } else if (qName.equals("Gain")) {
                Float gain = new Float(attributes.getValue("value"));
                for (int i4 = 0; i4 < InCellReader.this.getSeriesCount(); ++i4) {
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsGain(gain, i4, q);
                    }
                }
            } else if (qName.equals("PlateTemperature")) {
                Float temperature = new Float(attributes.getValue("value"));
                for (int i5 = 0; i5 < InCellReader.this.getSeriesCount(); ++i5) {
                    this.store.setImagingEnvironmentTemperature(temperature, i5);
                }
            } else if (qName.equals("Plate")) {
                this.store.setPlateName(new Location(InCellReader.this.getCurrentFile()).getName(), this.nextPlate);
                for (int r = 0; r < InCellReader.this.wellRows; ++r) {
                    for (int c = 0; c < InCellReader.this.wellCols; ++c) {
                        this.store.setWellRow(new Integer(r), this.nextPlate, r * InCellReader.this.wellCols + c);
                        this.store.setWellColumn(new Integer(c), this.nextPlate, r * InCellReader.this.wellCols + c);
                    }
                }
                ++this.nextPlate;
            } else if (qName.equals("Row")) {
                this.currentRow = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Column")) {
                this.currentCol = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Exposure") && this.openImage) {
                float exp = Float.parseFloat(attributes.getValue("time"));
                this.exposure = new Float(exp / 1000.0f);
            } else if (qName.equals("NamingRows")) {
                String row = attributes.getValue("begin");
                try {
                    InCellReader.this.startRow = Integer.parseInt(row);
                }
                catch (NumberFormatException e) {
                    InCellReader.this.startRow = row.charAt(0) - 65 + 1;
                }
            } else if (qName.equals("NamingColumns")) {
                String col = attributes.getValue("begin");
                try {
                    InCellReader.this.startCol = Integer.parseInt(col);
                }
                catch (NumberFormatException e) {
                    InCellReader.this.startCol = col.charAt(0) - 65 + 1;
                }
            } else if (qName.equals("offset_point")) {
                InCellReader.this.posX.add(new Float(attributes.getValue("x")));
                InCellReader.this.posY.add(new Float(attributes.getValue("y")));
            }
        }
    }

    class MinimalInCellHandler
    extends DefaultHandler {
        private String currentImageFile;
        private int wellRow;
        private int wellCol;

        MinimalInCellHandler() {
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("PlateMap")) {
                int imageCount = InCellReader.this.getSizeZ() * InCellReader.this.getSizeC() * InCellReader.this.getSizeT();
                InCellReader.access$002(InCellReader.this, new Image[InCellReader.this.wellRows * InCellReader.this.wellCols][InCellReader.this.fieldCount][imageCount]);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Plate")) {
                InCellReader.this.wellRows = Integer.parseInt(attributes.getValue("rows"));
                InCellReader.this.wellCols = Integer.parseInt(attributes.getValue("columns"));
            } else if (qName.equals("Images")) {
                InCellReader.this.totalImages = Integer.parseInt(attributes.getValue("number"));
            } else if (qName.equals("Image")) {
                String file2 = attributes.getValue("filename");
                String thumb = attributes.getValue("thumbnail");
                Location current = new Location(InCellReader.this.currentId).getAbsoluteFile();
                Location imageFile = new Location(current.getParentFile(), file2);
                this.currentImageFile = imageFile.exists() ? imageFile.getAbsolutePath() : file2;
            } else if (qName.equals("Identifier")) {
                int field = Integer.parseInt(attributes.getValue("field_index"));
                int z = Integer.parseInt(attributes.getValue("z_index"));
                int c = Integer.parseInt(attributes.getValue("wave_index"));
                int t = Integer.parseInt(attributes.getValue("time_index"));
                ((InCellReader)InCellReader.this).core[0].imageCount = InCellReader.this.getSizeZ() * InCellReader.this.getSizeC() * InCellReader.this.getSizeT();
                int index = InCellReader.this.getIndex(z, c, t);
                Image img = new Image();
                img.filename = this.currentImageFile;
                ((InCellReader)InCellReader.this).imageFiles[this.wellRow * ((InCellReader)InCellReader.this).wellCols + this.wellCol][field][index] = img;
            } else if (qName.equals("offset_point")) {
                InCellReader.this.fieldCount++;
            } else if (qName.equals("TimePoint")) {
                ++((InCellReader)InCellReader.this).core[0].sizeT;
            } else if (qName.equals("Wavelength")) {
                ++((InCellReader)InCellReader.this).core[0].sizeC;
            } else if (qName.equals("ZDimensionParameters")) {
                String nz = attributes.getValue("number_of_slices");
                if (nz != null) {
                    ((InCellReader)InCellReader.this).core[0].sizeZ = Integer.parseInt(nz);
                } else {
                    ((InCellReader)InCellReader.this).core[0].sizeZ = 1;
                }
            } else if (qName.equals("Row")) {
                this.wellRow = Integer.parseInt(attributes.getValue("number")) - 1;
                InCellReader.this.firstRow = Math.min(InCellReader.this.firstRow, this.wellRow);
            } else if (qName.equals("Column")) {
                this.wellCol = Integer.parseInt(attributes.getValue("number")) - 1;
                InCellReader.this.firstCol = Math.min(InCellReader.this.firstCol, this.wellCol);
                InCellReader.this.lastCol = Math.max(InCellReader.this.lastCol, this.wellCol);
            }
        }
    }
}

