/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.common.LogTools;
import loci.formats.FormatException;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class TiffReader
extends BaseTiffReader {
    public static final String[] TIFF_SUFFIXES = new String[]{"tif", "tiff", "tf2", "tf8", "btf"};

    public TiffReader() {
        super("Tagged Image File Format", TIFF_SUFFIXES);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        Object software;
        boolean ij;
        super.initStandardMetadata();
        String comment = TiffTools.getComment(this.ifds[0]);
        this.status("Checking comment style");
        if (this.ifds.length > 1) {
            this.core[0].orderCertain = false;
        }
        boolean bl = ij = comment != null && comment.startsWith("ImageJ=");
        if (ij) {
            int nl = comment.indexOf("\n");
            this.put("ImageJ", nl < 0 ? comment.substring(7) : comment.substring(7, nl));
            this.metadata.remove("Comment");
            int z = 1;
            int t = 1;
            int c = this.getSizeC();
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                int value;
                String token;
                block14: {
                    token = st.nextToken();
                    value = 0;
                    int eq = token.indexOf("=");
                    if (eq != -1 && eq + 1 < token.length()) {
                        try {
                            value = Integer.parseInt(token.substring(eq + 1));
                        }
                        catch (NumberFormatException e) {
                            if (!debug) break block14;
                            LogTools.trace(e);
                        }
                    }
                }
                if (token.startsWith("channels=")) {
                    c = value;
                    continue;
                }
                if (token.startsWith("slices=")) {
                    z = value;
                    continue;
                }
                if (!token.startsWith("frames=")) continue;
                t = value;
            }
            if (z * c * t == c) {
                t = this.getImageCount();
            }
            this.core[0].dimensionOrder = "XYCZT";
            if (z * t * (this.isRGB() ? 1 : c) == this.ifds.length) {
                this.core[0].sizeZ = z;
                this.core[0].sizeT = t;
                this.core[0].sizeC = c;
            } else {
                this.core[0].sizeT = this.ifds.length;
                this.core[0].imageCount = this.ifds.length;
            }
        }
        String check = (software = TiffTools.getIFDValue(this.ifds[0], 305)) instanceof String ? (String)software : (software instanceof String[] ? ((String[])software)[0] : null);
        boolean metamorph = comment != null && software != null && check.indexOf("MetaMorph") != -1;
        this.put("MetaMorph", metamorph ? "yes" : "no");
        if (metamorph) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int colon = line.indexOf(":");
                if (colon < 0) {
                    this.addMeta("Comment", line);
                    continue;
                }
                String key = line.substring(0, colon);
                String value = line.substring(colon + 1);
                this.addMeta(key, value);
            }
        }
    }
}

