/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.VirtualStack;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Vector;
import loci.formats.ChannelMerger;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.cache.Cache;
import loci.formats.cache.CacheException;
import loci.formats.cache.CrosshairStrategy;
import loci.plugins.ImageProcessorSource;
import loci.plugins.RecordedImageProcessor;
import loci.plugins.Util;

public class BFVirtualStack
extends VirtualStack {
    protected IFormatReader reader;
    protected String id;
    protected Cache cache;
    private Vector[] methodStacks;
    private int currentSlice = -1;
    private RecordedImageProcessor currentProcessor;
    private boolean colorize;
    private boolean merge;
    private boolean record;
    private int series;
    private int[] len;

    protected static int getWidth(IFormatReader r, String path) throws FormatException, IOException {
        r.setId(path);
        return r.getSizeX();
    }

    protected static int getHeight(IFormatReader r, String path) throws FormatException, IOException {
        r.setId(path);
        return r.getSizeY();
    }

    public BFVirtualStack(String path, IFormatReader r, boolean colorize, boolean merge, boolean record) throws FormatException, IOException, CacheException {
        super(BFVirtualStack.getWidth(r, path), BFVirtualStack.getHeight(r, path), null, path);
        this.reader = r;
        this.id = path;
        this.colorize = colorize;
        this.merge = merge && !r.isIndexed();
        this.record = record;
        this.series = r.getSeries();
        int[] subC = r.getChannelDimLengths();
        this.len = new int[subC.length + 2];
        System.arraycopy(subC, 0, this.len, 0, subC.length);
        this.len[this.len.length - 2] = r.getSizeZ();
        this.len[this.len.length - 1] = r.getSizeT();
        CrosshairStrategy strategy = new CrosshairStrategy(this.len);
        this.cache = new Cache(strategy, new ImageProcessorSource(r), true);
        this.methodStacks = new Vector[r.getImageCount()];
        for (int i = 0; i < this.methodStacks.length; ++i) {
            this.methodStacks[i] = new Vector();
        }
    }

    public String getPath() {
        return this.id;
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public Cache getCache() {
        return this.cache;
    }

    public RecordedImageProcessor getRecordedProcessor() {
        return this.currentProcessor;
    }

    public Vector getMethodStack() {
        if (this.currentSlice >= 0) {
            return this.methodStacks[this.currentSlice];
        }
        return null;
    }

    public synchronized ImageProcessor getProcessor(int n) {
        Vector currentStack;
        this.reader.setSeries(this.series);
        if (this.currentSlice >= 0 && this.currentProcessor != null && (currentStack = this.currentProcessor.getMethodStack()).size() > 1) {
            this.methodStacks[this.currentSlice].addAll(currentStack);
        }
        int[] pos = this.reader.getZCTCoords(n - 1);
        if (this.merge) {
            pos = new ChannelMerger(this.reader).getZCTCoords(n - 1);
        }
        int[] cachePos = FormatTools.rasterToPosition(this.len, n - 1);
        ImageProcessor ip = null;
        try {
            ip = (ImageProcessor)this.cache.getObject(cachePos);
            this.cache.setCurrentPos(cachePos);
        }
        catch (CacheException exc) {
            exc.printStackTrace();
        }
        try {
            if (ip == null) {
                ip = Util.openProcessors(this.reader, this.reader.getIndex(pos[0], pos[1], pos[2]))[0];
            }
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        if (this.colorize) {
            byte[] lut = new byte[256];
            byte[] blank = new byte[256];
            for (int i = 0; i < lut.length; ++i) {
                lut[i] = (byte)i;
                blank[i] = 0;
            }
            IndexColorModel model = null;
            model = pos[1] < 3 ? new IndexColorModel(8, 256, pos[1] == 0 ? lut : blank, pos[1] == 1 ? lut : blank, pos[1] == 2 ? lut : blank) : new IndexColorModel(8, 256, lut, lut, lut);
            if (ip != null) {
                ip.setColorModel((ColorModel)model);
            }
        } else if (this.merge) {
            this.currentSlice = n - 1;
            ImageProcessor[] otherChannels = new ImageProcessor[this.reader.getSizeC() - 1];
            for (int i = 0; i < otherChannels.length; ++i) {
                int channel = i >= pos[1] ? i + 1 : i;
                try {
                    cachePos[0] = channel;
                    otherChannels[i] = (ImageProcessor)this.cache.getObject(cachePos);
                }
                catch (CacheException exc) {
                    exc.printStackTrace();
                }
                if (otherChannels[i] != null) continue;
                try {
                    int index = this.reader.getIndex(pos[0], channel, pos[2]);
                    otherChannels[i] = Util.openProcessors(this.reader, index)[0];
                    continue;
                }
                catch (FormatException exc) {
                    exc.printStackTrace();
                    continue;
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
            this.currentProcessor = new RecordedImageProcessor(ip, this.currentSlice, pos[1], otherChannels);
            this.currentProcessor.setDoRecording(this.record);
            return this.currentProcessor;
        }
        if (ip != null) {
            this.currentSlice = n - 1;
            this.currentProcessor = new RecordedImageProcessor(ip, this.currentSlice);
            this.currentProcessor.setDoRecording(this.record);
            return this.currentProcessor;
        }
        return null;
    }

    public int getWidth() {
        this.reader.setSeries(this.series);
        return this.reader.getSizeX();
    }

    public int getHeight() {
        this.reader.setSeries(this.series);
        return this.reader.getSizeY();
    }

    public int getSize() {
        if (this.reader.getCurrentFile() == null) {
            return 0;
        }
        this.reader.setSeries(this.series);
        if (this.merge) {
            return new ChannelMerger(this.reader).getImageCount();
        }
        return this.reader.getImageCount();
    }
}

