/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.io.FileInfo;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.xml.parsers.ParserConfigurationException;
import loci.formats.FormatTools;
import loci.formats.cache.Cache;
import loci.formats.gui.CacheIndicator;
import loci.formats.gui.XMLWindow;
import loci.plugins.BFVirtualStack;
import loci.plugins.BrowserOptionsWindow;
import org.xml.sax.SAXException;

public class DataBrowser
extends StackWindow
implements ActionListener {
    protected static final int MIN_BROWSER_WIDTH = 400;
    protected volatile boolean done;
    protected JSpinner fpsSpin;
    protected Button animate;
    protected Button options;
    protected Button metadata;
    protected boolean anim = false;
    protected boolean allowShow = false;
    protected XMLWindow metaWindow;
    protected BrowserOptionsWindow optionsWindow;
    protected String xml;
    protected Scrollbar[] cSliders;
    protected int[] cLengths;
    protected int[] cIndex;
    private int slice;

    public DataBrowser(ImagePlus imp) {
        this(imp, null, null, null);
    }

    public DataBrowser(final ImagePlus imp, ImageCanvas ic, String[] channels, int[] cLengths) {
        super(imp, ic);
        int blockIncrement;
        boolean hasT;
        if (channels == null || channels.length == 0) {
            channels = new String[]{"Channel"};
        }
        if (cLengths == null || cLengths.length == 0) {
            cLengths = new int[]{imp.getNChannels()};
        }
        this.cLengths = cLengths;
        this.cIndex = new int[cLengths.length];
        this.metaWindow = new XMLWindow("OME Metadata - " + this.getTitle());
        while (this.getComponentCount() > 1) {
            this.remove(1);
        }
        Panel controls = new Panel(){

            public Dimension getPreferredSize() {
                int minWidth = 400;
                int w = imp.getCanvas().getWidth();
                if (w < minWidth) {
                    w = minWidth;
                }
                int h = super.getPreferredSize().height;
                return new Dimension(w, h);
            }
        };
        String cols = "5dlu, right:pref, 3dlu, pref:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        String rows = "4dlu, pref, 3dlu, pref";
        for (int i = 0; i < channels.length; ++i) {
            rows = rows + ", 3dlu, pref";
        }
        rows = rows + ", 6dlu";
        controls.setLayout(new FormLayout(cols, rows));
        controls.setBackground(Color.white);
        int c = imp.getNChannels();
        int z = imp.getNSlices();
        int t = imp.getNFrames();
        boolean hasZ = z > 1;
        boolean hasC = c > 1;
        boolean bl = hasT = t > 1;
        if (this.sliceSelector != null) {
            this.remove(this.sliceSelector);
        }
        if (this.frameSelector != null) {
            this.remove(this.frameSelector);
        }
        if (this.channelSelector != null) {
            this.remove(this.channelSelector);
        }
        ImageJ ij = IJ.getInstance();
        if (hasC) {
            this.channelSelector = new Scrollbar(0, 1, 1, 1, c + 1);
            this.add(this.channelSelector);
            if (ij != null) {
                this.channelSelector.addKeyListener((KeyListener)ij);
            }
            this.channelSelector.addAdjustmentListener((AdjustmentListener)((Object)this));
            this.channelSelector.setFocusable(false);
            this.channelSelector.setUnitIncrement(1);
            this.channelSelector.setBlockIncrement(1);
        }
        if (hasZ) {
            this.sliceSelector = new Scrollbar(0, 1, 1, 1, z + 1);
            this.add(this.sliceSelector);
            if (ij != null) {
                this.sliceSelector.addKeyListener((KeyListener)ij);
            }
            this.sliceSelector.addAdjustmentListener((AdjustmentListener)((Object)this));
            this.sliceSelector.setFocusable(false);
            blockIncrement = Math.max(z / 10, 1);
            this.sliceSelector.setUnitIncrement(1);
            this.sliceSelector.setBlockIncrement(blockIncrement);
        }
        if (hasT) {
            this.frameSelector = new Scrollbar(0, 1, 1, 1, t + 1);
            this.add(this.frameSelector);
            if (ij != null) {
                this.frameSelector.addKeyListener((KeyListener)ij);
            }
            this.frameSelector.addAdjustmentListener((AdjustmentListener)((Object)this));
            this.frameSelector.setFocusable(false);
            blockIncrement = Math.max(t / 10, 1);
            this.frameSelector.setUnitIncrement(1);
            this.frameSelector.setBlockIncrement(blockIncrement);
        }
        Label zLabel = new Label("Z-depth");
        zLabel.setEnabled(hasZ);
        Label tLabel = new Label("Time");
        tLabel.setEnabled(hasT);
        Label[] cLabels = new Label[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            cLabels[i] = new Label(channels[i]);
            cLabels[i].setEnabled(hasC);
        }
        Scrollbar zSlider = hasZ ? this.sliceSelector : DataBrowser.makeDummySlider();
        final Scrollbar tSlider = hasT ? this.frameSelector : DataBrowser.makeDummySlider();
        this.cSliders = new Scrollbar[channels.length];
        Panel[] cPanels = new Panel[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            if (channels.length == 1) {
                this.cSliders[i] = hasC ? this.channelSelector : DataBrowser.makeDummySlider();
            } else if (cLengths[i] == 1) {
                this.cSliders[i] = DataBrowser.makeDummySlider();
            } else {
                this.cSliders[i] = new Scrollbar(0, 1, 1, 1, cLengths[i] + 1);
                this.cSliders[i].addAdjustmentListener((AdjustmentListener)((Object)this));
            }
            cPanels[i] = DataBrowser.makeHeavyPanel(this.cSliders[i]);
        }
        Panel zPanel = DataBrowser.makeHeavyPanel(zSlider);
        Panel tPanel = DataBrowser.makeHeavyPanel(tSlider);
        this.fpsSpin = new JSpinner(new SpinnerNumberModel(10, 1, 99, 1));
        this.fpsSpin.setToolTipText("Animation rate in frames per second");
        Label fpsLabel = new Label(" FPS");
        Panel fpsPanel = new Panel();
        fpsPanel.setLayout(new BorderLayout());
        fpsPanel.add((Component)this.fpsSpin, "Center");
        fpsPanel.add((Component)fpsLabel, "East");
        ImageStack stack = imp.getStack();
        if (stack instanceof BFVirtualStack) {
            BFVirtualStack bfvs = (BFVirtualStack)stack;
            Cache cache = bfvs.getCache();
            if (hasZ) {
                CacheIndicator zCache = new CacheIndicator(cache, channels.length, zSlider, 10, 20);
                zPanel.add((Component)zCache, "South");
            }
            if (hasT) {
                CacheIndicator tCache = new CacheIndicator(cache, channels.length + 1, tSlider, 10, 20);
                tPanel.add((Component)tCache, "South");
            }
            for (int i = 0; i < channels.length; ++i) {
                if (cLengths[i] <= 1) continue;
                CacheIndicator cCache = new CacheIndicator(cache, i, this.cSliders[i], 10, 20);
                cPanels[i].add((Component)cCache, "South");
            }
            String[] axes = new String[channels.length + 2];
            System.arraycopy(channels, 0, axes, 0, channels.length);
            axes[channels.length] = "Z";
            axes[channels.length + 1] = "T";
            this.optionsWindow = new BrowserOptionsWindow("Options - " + this.getTitle(), cache, axes);
        }
        this.animate = new Button("Animate");
        this.animate.addActionListener(this);
        this.fpsSpin.setEnabled(hasT);
        fpsLabel.setEnabled(hasT);
        this.animate.setEnabled(hasT);
        this.options = new Button("Options");
        this.options.addActionListener(this);
        this.options.setEnabled(this.optionsWindow != null);
        this.metadata = new Button("Metadata");
        this.metadata.addActionListener(this);
        this.metadata.setEnabled(false);
        CellConstraints cc = new CellConstraints();
        controls.add((Component)zLabel, cc.xy(2, 2));
        controls.add((Component)zPanel, cc.xyw(4, 2, 3));
        controls.add((Component)fpsPanel, cc.xy(8, 2));
        controls.add((Component)tLabel, cc.xy(2, 4));
        controls.add((Component)tPanel, cc.xyw(4, 4, 3));
        controls.add((Component)this.animate, cc.xy(8, 4));
        int row = 6;
        if (channels.length == 1) {
            controls.add((Component)this.options, cc.xy(6, row));
            controls.add((Component)this.metadata, cc.xy(8, row));
            controls.add((Component)cLabels[0], cc.xy(2, row));
            controls.add((Component)cPanels[0], cc.xy(4, row));
        } else {
            controls.add((Component)this.options, cc.xy(8, row));
            controls.add((Component)this.metadata, cc.xy(8, row + 2));
            for (int i = 0; i < channels.length; ++i) {
                int w = i < 2 ? 3 : 5;
                controls.add((Component)cLabels[i], cc.xy(2, row));
                controls.add((Component)cPanels[i], cc.xyw(4, row, w));
                row += 2;
            }
        }
        this.add(controls, "South");
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi.description != null && fi.description.startsWith("<?xml")) {
            this.setXML(fi.description);
        }
        this.allowShow = true;
        this.pack();
        this.setVisible(true);
        if (hasT) {
            new Thread("DataBrowser-Animation"){

                public void run() {
                    while (DataBrowser.this.isVisible()) {
                        int ms = 200;
                        if (DataBrowser.this.anim) {
                            int sizeT;
                            int c = imp.getChannel();
                            int z = imp.getSlice();
                            int t = imp.getFrame() + 1;
                            if (t > (sizeT = tSlider.getMaximum() - 1)) {
                                t = 1;
                            }
                            DataBrowser.this.setPosition(c, z, t);
                            imp.setPosition(c, z, t);
                            DataBrowser.this.updateSlice();
                            int fps = ((Number)DataBrowser.this.fpsSpin.getValue()).intValue();
                            ms = 1000 / fps;
                        }
                        try {
                            Thread.sleep(ms);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }.start();
        }
    }

    public void setXML(String xml) {
        try {
            this.metaWindow.setXML(xml);
        }
        catch (ParserConfigurationException exc) {
            exc.printStackTrace();
        }
        catch (SAXException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        this.metadata.setEnabled(this.metaWindow.getDocument() != null);
    }

    public void toggleAnimation() {
        this.animate.setLabel(this.anim ? "Animate" : "Stop");
        this.anim = !this.anim;
    }

    public void showOptionsWindow() {
        Rectangle r = this.getBounds();
        Dimension w = this.optionsWindow.getSize();
        int x = Math.max(5, r.x + (r.width - w.width) / 2);
        int y = Math.max(5, r.y + (r.height - w.height) / 2);
        this.optionsWindow.setLocation(x, y);
        this.optionsWindow.setVisible(true);
    }

    public void showMetadataWindow() {
        Rectangle r = this.getBounds();
        Dimension w = this.metaWindow.getSize();
        int x = r.x + (r.width - w.width) / 2;
        int y = r.y + (r.height - w.height) / 2;
        if (x < 5) {
            x = 5;
        }
        if (y < 5) {
            y = 5;
        }
        this.metaWindow.setLocation(x, y);
        this.metaWindow.setVisible(true);
    }

    public void dispose() {
        super.dispose();
    }

    public void pack() {
        if (this.allowShow) {
            super.pack();
        }
    }

    public void setVisible(boolean b) {
        if (this.allowShow) {
            super.setVisible(b);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.animate) {
            this.toggleAnimation();
        } else if (src == this.options) {
            this.showOptionsWindow();
        } else if (src == this.metadata) {
            this.showMetadataWindow();
        } else {
            super.actionPerformed(e);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Object src = e.getSource();
        for (int i = 0; i < this.cSliders.length; ++i) {
            if (src != this.cSliders[i]) continue;
            this.cIndex[i] = this.cSliders[i].getValue() - 1;
            int channel = FormatTools.positionToRaster(this.cLengths, this.cIndex) + 1;
            if (this.channelSelector != null) {
                this.channelSelector.setValue(channel);
                super.adjustmentValueChanged(new AdjustmentEvent(this.channelSelector, 601, 5, channel));
                this.updateSlice();
            }
            return;
        }
        super.adjustmentValueChanged(e);
        this.updateSlice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            DataBrowser dataBrowser = this;
            synchronized (dataBrowser) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            if (this.slice <= 0 || this.slice == this.imp.getCurrentSlice()) continue;
            this.imp.setSlice(this.slice);
            this.slice = 0;
        }
    }

    private void updateSlice() {
        int[] dims = new int[]{this.imp.getNChannels(), this.imp.getNSlices(), this.imp.getNFrames()};
        int[] pos = new int[]{this.imp.getChannel() - 1, this.imp.getSlice() - 1, this.imp.getFrame() - 1};
        this.slice = FormatTools.positionToRaster(dims, pos) + 1;
    }

    protected static Scrollbar makeDummySlider() {
        Scrollbar scrollbar = new Scrollbar(0, 1, 1, 1, 2);
        scrollbar.setFocusable(false);
        scrollbar.setUnitIncrement(1);
        scrollbar.setBlockIncrement(1);
        scrollbar.setEnabled(false);
        return scrollbar;
    }

    protected static Panel makeHeavyPanel(Component c) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add(c, "Center");
        return panel;
    }
}

