/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniParser {
    public static final String HEADER_KEY = "header";

    public Vector<HashMap<String, String>> parseINI(String path) throws IOException {
        return this.parseINI(IniParser.openTextResource(path));
    }

    public Vector<HashMap<String, String>> parseINI(String path, Class c) throws IOException {
        return this.parseINI(IniParser.openTextResource(path, c));
    }

    public Vector<HashMap<String, String>> parseINI(BufferedReader in) throws IOException {
        int num;
        Vector<HashMap<String, String>> list = new Vector<HashMap<String, String>>();
        HashMap<String, String> attrs = null;
        int no = 1;
        StringBuffer sb = new StringBuffer();
        while ((num = this.readLine(in, sb)) != 0) {
            String line = sb.toString();
            if (line.equals("")) {
                no += num;
                continue;
            }
            if (line.startsWith("[")) {
                attrs = new HashMap<String, String>();
                list.add(attrs);
                int end = line.length();
                if (line.endsWith("]")) {
                    --end;
                }
                String header = line.substring(1, end);
                attrs.put(HEADER_KEY, header);
                no += num;
                continue;
            }
            int equals = line.indexOf("=");
            if (equals < 0) {
                throw new IOException(no + ": bad line");
            }
            String key = line.substring(0, equals).trim();
            String value = line.substring(equals + 1).trim();
            attrs.put(key, value);
            no += num;
        }
        return list;
    }

    public static BufferedReader openTextResource(String path) throws IOException {
        return IniParser.openTextResource(path, IniParser.class);
    }

    public static BufferedReader openTextResource(String path, Class c) throws IOException {
        return new BufferedReader(new InputStreamReader(c.getResourceAsStream(path)));
    }

    private int readLine(BufferedReader in, StringBuffer sb) throws IOException {
        String line;
        int no = 0;
        sb.setLength(0);
        while ((line = in.readLine()) != null) {
            boolean slash;
            ++no;
            int hash = line.indexOf("#");
            if (hash >= 0) {
                line = line.substring(0, hash);
            }
            if (slash = (line = line.trim()).endsWith("\\")) {
                line = line.substring(0, line.length() - 1).trim() + " ";
            }
            sb.append(line);
            if (slash) continue;
            break;
        }
        return no;
    }
}

