/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.ByteVector;
import loci.formats.meta.FilterMetadata;

public class APNGReader
extends FormatReader {
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private Vector<PNGBlock> blocks;
    private Vector<int[]> frameCoordinates;
    private byte[][] lut;

    public APNGReader() {
        super("Animated PNG", "png");
        this.blockCheckLen = 64;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return true;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        byte[][] t = AWTImageTools.getPixelBytes(this.openImage(no, x, y, w, h), false);
        for (int c = 0; c < t.length; ++c) {
            System.arraycopy(t[c], 0, buf, c * t[c].length, t[c].length);
        }
        return buf;
    }

    public BufferedImage openImage(int no, int x, int y, int w, int h) throws FormatException, IOException {
        Object b;
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        if (no == 0) {
            this.in.seek(0L);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(this.in, 4096));
            return ImageIO.read(dis).getSubimage(x, y, w, h);
        }
        ByteVector stream = new ByteVector();
        stream.add(PNG_SIGNATURE);
        boolean fdatValid = false;
        int fctlCount = 0;
        int[] coords = this.frameCoordinates.get(no);
        for (int i = 0; i < this.blocks.size(); ++i) {
            PNGBlock block = this.blocks.get(i);
            if (!(block.type.equals("IDAT") || block.type.equals("fdAT") || block.type.equals("acTL") || block.type.equals("fcTL"))) {
                b = new byte[block.length + 12];
                DataTools.unpackBytes(block.length, (byte[])b, 0, 4, this.isLittleEndian());
                byte[] typeBytes = block.type.getBytes();
                System.arraycopy(typeBytes, 0, b, 4, 4);
                this.in.seek(block.offset);
                this.in.read((byte[])b, 8, ((Object)b).length - 12);
                if (block.type.equals("IHDR")) {
                    DataTools.unpackBytes(coords[2], (byte[])b, 8, 4, this.isLittleEndian());
                    DataTools.unpackBytes(coords[3], (byte[])b, 12, 4, this.isLittleEndian());
                }
                int crc = (int)this.computeCRC((byte[])b, ((Object)b).length - 4);
                DataTools.unpackBytes(crc, (byte[])b, ((Object)b).length - 4, 4, this.isLittleEndian());
                stream.add((byte[])b);
                b = null;
                continue;
            }
            if (block.type.equals("fcTL")) {
                fdatValid = fctlCount == no;
                ++fctlCount;
                continue;
            }
            if (!block.type.equals("fdAT")) continue;
            this.in.seek(block.offset + 4L);
            if (!fdatValid) continue;
            b = new byte[block.length + 8];
            DataTools.unpackBytes(block.length - 4, (byte[])b, 0, 4, this.isLittleEndian());
            b[4] = 73;
            b[5] = 68;
            b[6] = 65;
            b[7] = 84;
            this.in.read((byte[])b, 8, ((Object)b).length - 12);
            int crc = (int)this.computeCRC((byte[])b, ((Object)b).length - 4);
            DataTools.unpackBytes(crc, (byte[])b, ((Object)b).length - 4, 4, this.isLittleEndian());
            stream.add((byte[])b);
            b = null;
        }
        RandomAccessInputStream s = new RandomAccessInputStream(stream.toByteArray());
        DataInputStream dis = new DataInputStream(new BufferedInputStream(s, 4096));
        b = ImageIO.read(dis);
        dis.close();
        BufferedImage first = this.openImage(0, 0, 0, this.getSizeX(), this.getSizeY());
        WritableRaster firstRaster = first.getRaster();
        WritableRaster currentRaster = ((BufferedImage)b).getRaster();
        firstRaster.setDataElements(coords[0], coords[1], currentRaster);
        return new BufferedImage(first.getColorModel(), firstRaster, false, null);
    }

    public void close() throws IOException {
        super.close();
        this.lut = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("APNGReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        byte[] signature = new byte[8];
        this.in.read(signature);
        if (signature[0] != -119 || signature[1] != 80 || signature[2] != 78 || signature[3] != 71 || signature[4] != 13 || signature[5] != 10 || signature[6] != 26 || signature[7] != 10) {
            throw new FormatException("Invalid PNG signature.");
        }
        this.blocks = new Vector();
        this.frameCoordinates = new Vector();
        while (this.in.getFilePointer() < this.in.length()) {
            int length = this.in.readInt();
            String type = this.in.readString(4);
            PNGBlock block = new PNGBlock();
            block.length = length;
            block.type = type;
            block.offset = this.in.getFilePointer();
            this.blocks.add(block);
            if (type.equals("acTL")) {
                this.core[0].imageCount = this.in.readInt();
                int loop = this.in.readInt();
                this.addMeta("Loop count", loop);
            } else if (type.equals("fcTL")) {
                this.in.skipBytes(4);
                int w = this.in.readInt();
                int h = this.in.readInt();
                int x = this.in.readInt();
                int y = this.in.readInt();
                this.frameCoordinates.add(new int[]{x, y, w, h});
                this.in.skipBytes(length - 20);
            } else {
                this.in.skipBytes(length);
            }
            this.in.skipBytes(4);
        }
        if (this.core[0].imageCount == 0) {
            this.core[0].imageCount = 1;
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = this.getImageCount();
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].interleaved = false;
        BufferedImage img = ImageIO.read(new DataInputStream(new RandomAccessInputStream(this.currentId)));
        this.core[0].sizeX = img.getWidth();
        this.core[0].sizeY = img.getHeight();
        this.core[0].rgb = img.getRaster().getNumBands() > 1;
        this.core[0].sizeC = img.getRaster().getNumBands();
        this.core[0].pixelType = AWTImageTools.getPixelType(img);
        this.core[0].indexed = img.getColorModel() instanceof IndexColorModel;
        this.core[0].falseColor = false;
        if (this.isIndexed()) {
            this.lut = new byte[3][256];
            IndexColorModel model = (IndexColorModel)img.getColorModel();
            model.getReds(this.lut[0]);
            model.getGreens(this.lut[1]);
            model.getBlues(this.lut[2]);
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }

    private long computeCRC(byte[] buf, int len) {
        CRC32 crc = new CRC32();
        crc.update(buf, 0, len);
        return crc.getValue();
    }

    class PNGBlock {
        public long offset;
        public int length;
        public String type;

        PNGBlock() {
        }
    }
}

