/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.exporter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import loci.common.DataTools;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.gui.GUITools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.plugins.LociExporter;
import loci.plugins.util.RecordedImageProcessor;

public class Exporter {
    private ImagePlus imp;
    private LociExporter plugin;

    public Exporter(LociExporter plugin, ImagePlus imp) {
        this.plugin = plugin;
        this.imp = imp;
    }

    public void run(ImageProcessor ip) {
        ByteArrayOutputStream buf;
        String save;
        String options;
        String outfile = null;
        if (this.plugin.arg != null && this.plugin.arg.startsWith("outfile=")) {
            outfile = Macro.getValue((String)this.plugin.arg, (String)"outfile", null);
            this.plugin.arg = null;
        }
        if (outfile == null && (options = Macro.getOptions()) != null && (save = Macro.getValue((String)options, (String)"save", null)) != null) {
            outfile = save;
        }
        if (outfile == null || outfile.length() == 0) {
            int ret;
            int returnVal;
            String dir = null;
            String name = null;
            JFileChooser fc = GUITools.buildFileChooser(new ImageWriter(), false);
            fc.setDialogTitle("Bio-Formats Exporter");
            String defaultDir = OpenDialog.getDefaultDirectory();
            if (defaultDir != null) {
                fc.setCurrentDirectory(new File(defaultDir));
            }
            FileFilter[] ff = fc.getChoosableFileFilters();
            ExtensionFileFilter defaultFilter = null;
            for (int i = 0; i < ff.length; ++i) {
                if (!(ff[i] instanceof ExtensionFileFilter)) continue;
                ExtensionFileFilter eff = (ExtensionFileFilter)ff[i];
                if (i != 0 && !eff.getExtension().equals("ome.tif")) continue;
                defaultFilter = eff;
                break;
            }
            if (defaultFilter != null) {
                fc.setFileFilter(defaultFilter);
            }
            if ((returnVal = fc.showSaveDialog((Component)IJ.getInstance())) != 0) {
                Macro.abort();
                return;
            }
            File f = fc.getSelectedFile();
            if (f.exists() && (ret = JOptionPane.showConfirmDialog(fc, "The file " + f.getName() + " already exists. \n" + "Would you like to replace it?", "Replace?", 0, 2)) != 0) {
                f = null;
            }
            if (f == null) {
                Macro.abort();
            } else {
                dir = fc.getCurrentDirectory().getPath() + File.separator;
                name = fc.getName(f);
                FileFilter filter = fc.getFileFilter();
                if (filter instanceof ExtensionFileFilter) {
                    ExtensionFileFilter eff = (ExtensionFileFilter)filter;
                    String[] ext = eff.getExtensions();
                    String lName = name.toLowerCase();
                    boolean hasExtension = false;
                    for (int i = 0; i < ext.length; ++i) {
                        if (!lName.endsWith("." + ext[i])) continue;
                        hasExtension = true;
                        break;
                    }
                    if (!hasExtension && ext.length > 0) {
                        name = name + "." + ext[0];
                    }
                }
                OpenDialog.setDefaultDirectory((String)dir);
                if (Recorder.record) {
                    Recorder.recordPath((String)"save", (String)(dir + name));
                }
            }
            if (dir == null || name == null) {
                return;
            }
            outfile = new File(dir, name).getAbsolutePath();
            if (outfile == null) {
                return;
            }
        }
        try {
            boolean notSupportedType;
            IFormatWriter w = new ImageWriter().getWriter(outfile);
            FileInfo fi = this.imp.getOriginalFileInfo();
            String xml = fi == null ? null : (fi.description == null ? null : (fi.description.indexOf("xml") == -1 ? null : fi.description));
            IMetadata store = MetadataTools.createOMEXMLMetadata(xml);
            if (store == null) {
                IJ.error((String)"OME-XML Java library not found.");
            } else if (store instanceof MetadataRetrieve) {
                if (xml == null) {
                    store.createRoot();
                    int ptype = 0;
                    int channels = 1;
                    switch (this.imp.getType()) {
                        case 0: 
                        case 3: {
                            ptype = 1;
                            break;
                        }
                        case 4: {
                            channels = 3;
                            ptype = 1;
                            break;
                        }
                        case 1: {
                            ptype = 3;
                            break;
                        }
                        case 2: {
                            ptype = 6;
                        }
                    }
                    store.setPixelsSizeX(new Integer(this.imp.getWidth()), 0, 0);
                    store.setPixelsSizeY(new Integer(this.imp.getHeight()), 0, 0);
                    store.setPixelsSizeZ(new Integer(this.imp.getNSlices()), 0, 0);
                    store.setPixelsSizeC(new Integer(channels * this.imp.getNChannels()), 0, 0);
                    store.setPixelsSizeT(new Integer(this.imp.getNFrames()), 0, 0);
                    store.setPixelsPixelType(FormatTools.getPixelTypeString(ptype), 0, 0);
                    store.setPixelsBigEndian(Boolean.FALSE, 0, 0);
                    store.setPixelsDimensionOrder("XYCZT", 0, 0);
                    store.setLogicalChannelSamplesPerPixel(new Integer(channels), 0, 0);
                }
                if (this.imp.getImageStackSize() != this.imp.getNChannels() * this.imp.getNSlices() * this.imp.getNFrames()) {
                    IJ.showMessageWithCancel((String)"Bio-Formats Exporter Warning", (String)("The number of planes in the stack (" + this.imp.getImageStackSize() + ") does not match the number of expected planes (" + this.imp.getNChannels() * this.imp.getNSlices() * this.imp.getNFrames() + ")." + "\nIf you select 'OK', only " + this.imp.getImageStackSize() + " planes will be exported. If you wish to export all of the " + "planes,\nselect 'Cancel' and convert the Image5D window " + "to a stack."));
                    store.setPixelsSizeZ(new Integer(this.imp.getImageStackSize()), 0, 0);
                    store.setPixelsSizeC(new Integer(1), 0, 0);
                    store.setPixelsSizeT(new Integer(1), 0, 0);
                }
                w.setMetadataRetrieve(store);
            }
            w.setId(outfile);
            String[] codecs = w.getCompressionTypes();
            ImageProcessor proc = this.imp.getImageStack().getProcessor(1);
            Image firstImage = proc.createImage();
            firstImage = AWTImageTools.makeBuffered(firstImage, proc.getColorModel());
            int thisType = AWTImageTools.getPixelType((BufferedImage)firstImage);
            if (proc instanceof ColorProcessor) {
                thisType = 1;
            }
            boolean bl = notSupportedType = !w.isSupportedType(thisType);
            if (notSupportedType) {
                IJ.error((String)("Pixel type (" + FormatTools.getPixelTypeString(thisType) + ") not supported by this format."));
            }
            if (codecs != null && codecs.length > 1) {
                GenericDialog gd = new GenericDialog("Bio-Formats Exporter Options");
                if (codecs != null) {
                    gd.addChoice("Compression type: ", codecs, codecs[0]);
                }
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                if (codecs != null) {
                    w.setCompression(gd.getNextChoice());
                }
            }
            Class<?> c = null;
            try {
                c = Class.forName("ij.CompositeImage");
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            boolean fakeRGB = this.imp.getClass().equals(c);
            int n = fakeRGB ? this.imp.getNChannels() : 1;
            int size = this.imp.getImageStackSize();
            ImageStack is = this.imp.getImageStack();
            boolean doStack = w.canDoStacks() && size > 1;
            int start = doStack ? 0 : this.imp.getCurrentSlice() - 1;
            int end = doStack ? size : start + 1;
            boolean littleEndian = w.getMetadataRetrieve().getPixelsBigEndian(0, 0) == false;
            byte[] plane = null;
            w.setInterleaved(false);
            for (int i = start; i < end; i += n) {
                byte[] b;
                if (doStack) {
                    IJ.showStatus((String)("Saving plane " + (i + 1) + "/" + size));
                    IJ.showProgress((double)((double)(i + 1) / (double)size));
                } else {
                    IJ.showStatus((String)"Saving image");
                }
                proc = is.getProcessor(i + 1);
                if (proc instanceof RecordedImageProcessor) {
                    proc = ((RecordedImageProcessor)proc).getChild();
                }
                int x = proc.getWidth();
                int y = proc.getHeight();
                if (proc instanceof ByteProcessor) {
                    if (fakeRGB) {
                        plane = new byte[n * x * y];
                        for (int j = 0; j < n; ++j) {
                            b = (byte[])is.getProcessor(i + j + 1).getPixels();
                            System.arraycopy(b, 0, plane, j * x * y, b.length);
                        }
                    } else {
                        plane = (byte[])proc.getPixels();
                    }
                } else if (proc instanceof ShortProcessor) {
                    if (fakeRGB) {
                        plane = new byte[n * x * y * 2];
                        for (int j = 0; j < n; ++j) {
                            b = DataTools.shortsToBytes((short[])is.getProcessor(i + j + 1).getPixels(), littleEndian);
                            System.arraycopy(b, 0, plane, j * x * y * 2, b.length);
                        }
                    } else {
                        plane = DataTools.shortsToBytes((short[])proc.getPixels(), littleEndian);
                    }
                } else if (proc instanceof FloatProcessor) {
                    if (fakeRGB) {
                        plane = new byte[n * x * y * 4];
                        for (int j = 0; j < n; ++j) {
                            b = DataTools.floatsToBytes((float[])is.getProcessor(i + j + 1).getPixels(), littleEndian);
                            System.arraycopy(b, 0, plane, j * x * y * 4, b.length);
                        }
                    } else {
                        plane = DataTools.floatsToBytes((float[])proc.getPixels(), littleEndian);
                    }
                } else if (proc instanceof ColorProcessor) {
                    byte[][] pix = new byte[3][x * y];
                    ((ColorProcessor)proc).getRGB(pix[0], pix[1], pix[2]);
                    plane = new byte[3 * x * y];
                    System.arraycopy(pix[0], 0, plane, 0, x * y);
                    System.arraycopy(pix[1], 0, plane, x * y, x * y);
                    System.arraycopy(pix[2], 0, plane, 2 * x * y, x * y);
                }
                if (notSupportedType) {
                    IJ.error((String)"Pixel type not supported by this format.");
                    continue;
                }
                w.saveBytes(plane, i == end - n);
            }
            w.close();
        }
        catch (FormatException e) {
            e.printStackTrace();
            buf = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(buf));
            IJ.error((String)(e.getMessage() + ":\n" + buf.toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
            buf = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(buf));
            IJ.error((String)(e.getMessage() + ":\n" + buf.toString()));
        }
    }
}

