/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import thredds.datatype.DateRange;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfCFWriter {
    public void makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, DateRange range, boolean addLatLon, int horizStride, int stride_z, int stride_time) throws IOException, InvalidRangeException {
        FileWriter writer = new FileWriter(location, false);
        NetcdfDataset ncd = (NetcdfDataset)gds.getNetcdfFile();
        for (Attribute att : gds.getGlobalAttributes()) {
            writer.writeGlobalAttribute(att);
        }
        writer.writeGlobalAttribute(new Attribute("Conventions", "CF-1.0"));
        writer.writeGlobalAttribute(new Attribute("History", "Translated to CF-1.0 Conventions by Netcdf-Java CDM (NetcdfCFWriter)\nOriginal Dataset = " + gds.getLocationURI() + "; Translation Date = " + new Date()));
        ArrayList<Variable> varList = new ArrayList<Variable>();
        ArrayList<String> varNameList = new ArrayList<String>();
        ArrayList<CoordinateAxis> axisList = new ArrayList<CoordinateAxis>();
        for (String gridName : gridList) {
            ProjectionImpl proj;
            if (varNameList.contains(gridName)) continue;
            varNameList.add(gridName);
            GridDatatype grid = gds.findGridDatatype(gridName);
            GridCoordSystem gcsOrg = grid.getCoordinateSystem();
            Range timeRange = null;
            if (range != null) {
                CoordinateAxis1DTime timeAxis = gcsOrg.getTimeAxis1D();
                int startIndex = timeAxis.findTimeIndexFromDate(range.getStart().getDate());
                int endIndex = timeAxis.findTimeIndexFromDate(range.getEnd().getDate());
                timeRange = new Range(startIndex, endIndex);
            }
            if (llbb != null || null != timeRange || horizStride > 1) {
                grid = grid.makeSubset(timeRange, null, llbb, 1, horizStride, horizStride);
            }
            Variable gridV = (Variable)((Object)grid.getVariable());
            varList.add(gridV);
            GridCoordSystem gcs = grid.getCoordinateSystem();
            for (CoordinateAxis axis : gcs.getCoordinateAxes()) {
                if (varNameList.contains(axis.getName())) continue;
                varNameList.add(axis.getName());
                varList.add(axis);
                axisList.add(axis);
            }
            for (CoordinateTransform ct : gcs.getCoordinateTransforms()) {
                Variable v = ncd.findVariable(ct.getName());
                if (varNameList.contains(ct.getName()) || null == v) continue;
                varNameList.add(ct.getName());
                varList.add(v);
            }
            if (!addLatLon || null == (proj = gcs.getProjection()) || proj instanceof LatLonProjection) continue;
            this.addLatLon2D(ncd, varList, proj, gcs.getXHorizAxis(), gcs.getYHorizAxis());
            addLatLon = false;
        }
        writer.writeVariables(varList);
        NetcdfFileWriteable ncfile = writer.getNetcdf();
        Group root = ncfile.getRootGroup();
        for (String gridName : gridList) {
            GridDatatype grid = gds.findGridDatatype(gridName);
            Variable newV = root.findVariable(gridName);
            StringBuffer sbuff = new StringBuffer();
            GridCoordSystem gcs = grid.getCoordinateSystem();
            for (CoordinateAxis axis : gcs.getCoordinateAxes()) {
                sbuff.append(axis.getName()).append(" ");
            }
            if (addLatLon) {
                sbuff.append("lat lon");
            }
            newV.addAttribute(new Attribute("coordinates", sbuff.toString()));
            for (CoordinateTransform ct : gcs.getCoordinateTransforms()) {
                Variable v = ncd.findVariable(ct.getName());
                if (ct.getTransformType() != TransformType.Projection) continue;
                newV.addAttribute(new Attribute("grid_mapping", v.getName()));
            }
        }
        for (CoordinateAxis axis : axisList) {
            Variable newV = root.findVariable(axis.getName());
            if ((axis.getAxisType() == AxisType.Height || axis.getAxisType() == AxisType.Pressure || axis.getAxisType() == AxisType.GeoZ) && null != axis.getPositive()) {
                newV.addAttribute(new Attribute("positive", axis.getPositive()));
            }
            if (axis.getAxisType() == AxisType.Lat) {
                newV.addAttribute(new Attribute("units", "degrees_north"));
                newV.addAttribute(new Attribute("standard_name", "latitude"));
            }
            if (axis.getAxisType() != AxisType.Lon) continue;
            newV.addAttribute(new Attribute("units", "degrees_east"));
            newV.addAttribute(new Attribute("standard_name", "longitude"));
        }
        writer.finish();
    }

    private void addLatLon2D(NetcdfFile ncfile, List<Variable> varList, Projection proj, CoordinateAxis xaxis, CoordinateAxis yaxis) throws IOException {
        double[] xData = (double[])xaxis.read().get1DJavaArray(Double.TYPE);
        double[] yData = (double[])yaxis.read().get1DJavaArray(Double.TYPE);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(yaxis.getDimension(0));
        dims.add(xaxis.getDimension(0));
        Variable latVar = new Variable(ncfile, null, null, "lat");
        latVar.setDataType(DataType.DOUBLE);
        latVar.setDimensions(dims);
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = new Variable(ncfile, null, null, "lon");
        lonVar.setDataType(DataType.DOUBLE);
        lonVar.setDimensions(dims);
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int nx = xData.length;
        int ny = yData.length;
        ProjectionPointImpl projPoint = new ProjectionPointImpl();
        LatLonPointImpl latlonPoint = new LatLonPointImpl();
        double[] latData = new double[nx * ny];
        double[] lonData = new double[nx * ny];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                projPoint.setLocation(xData[j], yData[i]);
                proj.projToLatLon(projPoint, latlonPoint);
                latData[i * nx + j] = latlonPoint.getLatitude();
                lonData[i * nx + j] = latlonPoint.getLongitude();
            }
        }
        Array latDataArray = Array.factory(DataType.DOUBLE.getClassType(), new int[]{ny, nx}, (Object)latData);
        latVar.setCachedData(latDataArray, false);
        Array lonDataArray = Array.factory(DataType.DOUBLE.getClassType(), new int[]{ny, nx}, (Object)lonData);
        lonVar.setCachedData(lonDataArray, false);
        varList.add(latVar);
        varList.add(lonVar);
    }

    public static void main(String[] args) throws IOException, InvalidRangeException, ParseException {
        String fileIn = "C:/data/ncmodels/NAM_CONUS_80km_20051206_0000.nc";
        String fileOut = "C:/temp3/cf3.nc";
        GridDataset gds = GridDataset.open(fileIn);
        NetcdfCFWriter writer = new NetcdfCFWriter();
        ArrayList<String> gridList = new ArrayList<String>();
        gridList.add("RH");
        gridList.add("T");
        DateFormatter format = new DateFormatter();
        Date start = format.isoDateTimeFormat("2005-12-06T18:00:00Z");
        Date end = format.isoDateTimeFormat("2005-12-07T18:00:00Z");
        writer.makeFile(fileOut, gds, gridList, new LatLonRect(new LatLonPointImpl(37.0, -109.0), 400.0, 7.0), new DateRange(start, end), true, 1, 1, 1);
    }
}

