/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.TiffIFDEntry;
import loci.formats.TiffRational;
import loci.formats.UnknownTagException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.LZWCodec;
import loci.formats.codec.LuraWaveCodec;
import loci.formats.codec.NikonCodec;
import loci.formats.codec.PackbitsCodec;
import loci.formats.codec.ZlibCodec;

public final class TiffTools {
    public static final int BYTES_PER_ENTRY = 12;
    public static final int BIG_TIFF_BYTES_PER_ENTRY = 20;
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_TIFF = 1;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int LONG8 = 16;
    public static final int SLONG8 = 17;
    public static final int IFD8 = 18;
    public static final int[] BYTES_PER_ELEMENT = new int[]{-1, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, -1, -1, -1, 8, 8, 8};
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int SUBFILE_TYPE = 255;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRIC_INTERPRETATION = 262;
    public static final int THRESHHOLDING = 263;
    public static final int CELL_WIDTH = 264;
    public static final int CELL_LENGTH = 265;
    public static final int FILL_ORDER = 266;
    public static final int DOCUMENT_NAME = 269;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIP_OFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNTS = 279;
    public static final int MIN_SAMPLE_VALUE = 280;
    public static final int MAX_SAMPLE_VALUE = 281;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int PAGE_NAME = 285;
    public static final int X_POSITION = 286;
    public static final int Y_POSITION = 287;
    public static final int FREE_OFFSETS = 288;
    public static final int FREE_BYTE_COUNTS = 289;
    public static final int GRAY_RESPONSE_UNIT = 290;
    public static final int GRAY_RESPONSE_CURVE = 291;
    public static final int T4_OPTIONS = 292;
    public static final int T6_OPTIONS = 293;
    public static final int RESOLUTION_UNIT = 296;
    public static final int PAGE_NUMBER = 297;
    public static final int TRANSFER_FUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int ARTIST = 315;
    public static final int HOST_COMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int WHITE_POINT = 318;
    public static final int PRIMARY_CHROMATICITIES = 319;
    public static final int COLOR_MAP = 320;
    public static final int HALFTONE_HINTS = 321;
    public static final int TILE_WIDTH = 322;
    public static final int TILE_LENGTH = 323;
    public static final int TILE_OFFSETS = 324;
    public static final int TILE_BYTE_COUNTS = 325;
    public static final int INK_SET = 332;
    public static final int INK_NAMES = 333;
    public static final int NUMBER_OF_INKS = 334;
    public static final int DOT_RANGE = 336;
    public static final int TARGET_PRINTER = 337;
    public static final int EXTRA_SAMPLES = 338;
    public static final int SAMPLE_FORMAT = 339;
    public static final int S_MIN_SAMPLE_VALUE = 340;
    public static final int S_MAX_SAMPLE_VALUE = 341;
    public static final int TRANSFER_RANGE = 342;
    public static final int JPEG_TABLES = 347;
    public static final int JPEG_PROC = 512;
    public static final int JPEG_INTERCHANGE_FORMAT = 513;
    public static final int JPEG_INTERCHANGE_FORMAT_LENGTH = 514;
    public static final int JPEG_RESTART_INTERVAL = 515;
    public static final int JPEG_LOSSLESS_PREDICTORS = 517;
    public static final int JPEG_POINT_TRANSFORMS = 518;
    public static final int JPEG_Q_TABLES = 519;
    public static final int JPEG_DC_TABLES = 520;
    public static final int JPEG_AC_TABLES = 521;
    public static final int Y_CB_CR_COEFFICIENTS = 529;
    public static final int Y_CB_CR_SUB_SAMPLING = 530;
    public static final int Y_CB_CR_POSITIONING = 531;
    public static final int REFERENCE_BLACK_WHITE = 532;
    public static final int COPYRIGHT = 33432;
    public static final int EXIF = 34665;
    public static final int UNCOMPRESSED = 1;
    public static final int CCITT_1D = 2;
    public static final int GROUP_3_FAX = 3;
    public static final int GROUP_4_FAX = 4;
    public static final int LZW = 5;
    public static final int JPEG = 7;
    public static final int PACK_BITS = 32773;
    public static final int PROPRIETARY_DEFLATE = 32946;
    public static final int DEFLATE = 8;
    public static final int THUNDERSCAN = 32809;
    public static final int JPEG_2000 = 33003;
    public static final int ALT_JPEG = 33007;
    public static final int NIKON = 34713;
    public static final int LURAWAVE = 65535;
    public static final int WHITE_IS_ZERO = 0;
    public static final int BLACK_IS_ZERO = 1;
    public static final int RGB = 2;
    public static final int RGB_PALETTE = 3;
    public static final int TRANSPARENCY_MASK = 4;
    public static final int CMYK = 5;
    public static final int Y_CB_CR = 6;
    public static final int CIE_LAB = 8;
    public static final int CFA_ARRAY = 32803;
    public static final int MAGIC_NUMBER = 42;
    public static final int BIG_TIFF_MAGIC_NUMBER = 43;
    public static final int LITTLE = 73;
    public static final int BIG = 77;

    private TiffTools() {
    }

    public static boolean isValidHeader(byte[] block) {
        return TiffTools.checkHeader(block) != null;
    }

    public static boolean isValidHeader(RandomAccessInputStream stream) {
        try {
            return TiffTools.checkHeader(stream) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Boolean checkHeader(byte[] block) {
        try {
            RandomAccessInputStream s = new RandomAccessInputStream(block);
            Boolean result = TiffTools.checkHeader(s);
            s.close();
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Boolean checkHeader(RandomAccessInputStream stream) throws IOException {
        boolean bigEndian;
        if (stream.length() < 4L) {
            return null;
        }
        stream.seek(0L);
        int endianOne = stream.read();
        int endianTwo = stream.read();
        boolean littleEndian = endianOne == 73 && endianTwo == 73;
        boolean bl = bigEndian = endianOne == 77 && endianTwo == 77;
        if (!littleEndian && !bigEndian) {
            return null;
        }
        stream.order(littleEndian);
        short magic = stream.readShort();
        if (magic != 42 && magic != 43) {
            return null;
        }
        return new Boolean(littleEndian);
    }

    public static boolean isBigTiff(Hashtable ifd) throws FormatException {
        return (Boolean)TiffTools.getIFDValue(ifd, 1, false, Boolean.class);
    }

    public static boolean isLittleEndian(Hashtable ifd) throws FormatException {
        return (Boolean)TiffTools.getIFDValue(ifd, 0, true, Boolean.class);
    }

    public static Hashtable[] getIFDs(RandomAccessInputStream in) throws IOException {
        Hashtable ifd;
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        in.seek(2L);
        boolean bigTiff = in.readShort() == 43;
        long offset = TiffTools.getFirstOffset(in, bigTiff);
        long ifdMax = (in.length() - 8L) / 18L;
        Vector<Hashtable> v = new Vector<Hashtable>();
        for (long ifdNum = 0L; ifdNum < ifdMax && (ifd = TiffTools.getIFD(in, ifdNum, offset, bigTiff)) != null && ifd.size() > 1; ++ifdNum) {
            v.add(ifd);
            long l = offset = bigTiff ? in.readLong() : (long)in.readInt() & 0xFFFFFFFFL;
            if (offset > 0L && offset < in.length()) continue;
            if (offset == 0L) break;
            TiffTools.debug("getIFDs: invalid IFD offset: " + offset);
            break;
        }
        Object[] ifds = new Hashtable[v.size()];
        v.copyInto(ifds);
        return ifds;
    }

    public static Hashtable getFirstIFD(RandomAccessInputStream in) throws IOException {
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        in.seek(2L);
        boolean bigTiff = in.readShort() == 43;
        long offset = TiffTools.getFirstOffset(in, bigTiff);
        Hashtable ifd = TiffTools.getIFD(in, 0L, offset, bigTiff);
        ifd.put(new Integer(1), new Boolean(bigTiff));
        return ifd;
    }

    public static TiffIFDEntry getFirstIFDEntry(RandomAccessInputStream in, int tag) throws IOException {
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        in.seek(2L);
        boolean bigTiff = in.readShort() == 43;
        long offset = TiffTools.getFirstOffset(in, bigTiff);
        in.seek(offset);
        long numEntries = bigTiff ? in.readLong() : (long)(in.readShort() & 0xFFFF);
        int i = 0;
        while ((long)i < numEntries) {
            in.seek(offset + 2L + (long)((bigTiff ? 20 : 12) * i));
            int entryTag = in.readShort() & 0xFFFF;
            if (entryTag == tag) {
                int valueCount;
                int entryType = in.readShort() & 0xFFFF;
                int n = valueCount = bigTiff ? (int)(in.readLong() & 0xFFFFFFFFFFFFFFFFL) : in.readInt();
                if (valueCount < 0) {
                    throw new RuntimeException("Count of '" + valueCount + "' unexpected.");
                }
                long valueOffset = bigTiff ? in.readLong() : (long)in.readInt();
                return new TiffIFDEntry(entryTag, entryType, valueCount, valueOffset);
            }
            ++i;
        }
        throw new UnknownTagException();
    }

    public static long getFirstOffset(RandomAccessInputStream in) throws IOException {
        return TiffTools.getFirstOffset(in, false);
    }

    public static long getFirstOffset(RandomAccessInputStream in, boolean bigTiff) throws IOException {
        if (bigTiff) {
            in.skipBytes(4);
        }
        return bigTiff ? in.readLong() : (long)in.readInt();
    }

    public static Hashtable getIFD(RandomAccessInputStream in, long ifdNum, long offset) throws IOException {
        return TiffTools.getIFD(in, ifdNum, offset, false);
    }

    public static Hashtable getIFD(RandomAccessInputStream in, long ifdNum, long offset, boolean bigTiff) throws IOException {
        Hashtable<Integer, Comparable<Boolean>> ifd = new Hashtable<Integer, Comparable<Boolean>>();
        ifd.put(new Integer(0), new Boolean(in.isLittleEndian()));
        ifd.put(new Integer(1), new Boolean(bigTiff));
        TiffTools.debug("getIFDs: seeking IFD #" + ifdNum + " at " + offset);
        in.seek(offset);
        long numEntries = bigTiff ? in.readLong() : (long)(in.readShort() & 0xFFFF);
        TiffTools.debug("getIFDs: " + numEntries + " directory entries to read");
        if (numEntries == 0L || numEntries == 1L) {
            return ifd;
        }
        int bytesPerEntry = bigTiff ? 20 : 12;
        int baseOffset = bigTiff ? 8 : 2;
        int threshhold = bigTiff ? 8 : 4;
        int i = 0;
        while ((long)i < numEntries) {
            int j;
            in.seek(offset + (long)baseOffset + (long)(bytesPerEntry * i));
            int tag = in.readShort() & 0xFFFF;
            int type = in.readShort() & 0xFFFF;
            int count = bigTiff ? (int)(in.readLong() & 0xFFFFFFFFFFFFFFFFL) : in.readInt();
            TiffTools.debug("getIFDs: read " + TiffTools.getIFDTagName(tag) + " (type=" + TiffTools.getIFDTypeName(type) + "; count=" + count + ")");
            if (count < 0) {
                return null;
            }
            Object value = null;
            if (type < 0 || type >= BYTES_PER_ELEMENT.length) {
                return null;
            }
            if (count > threshhold / BYTES_PER_ELEMENT[type]) {
                long pointer = bigTiff ? in.readLong() : (long)in.readInt() & 0xFFFFFFFFL;
                in.seek(pointer);
            }
            if (type == 1) {
                if (count == 1) {
                    value = new Short(in.readByte());
                } else {
                    byte[] bytes = new byte[count];
                    in.readFully(bytes);
                    short[] shorts = new short[count];
                    for (j = 0; j < count; ++j) {
                        shorts[j] = (short)(bytes[j] & 0xFF);
                    }
                    value = shorts;
                }
            } else if (type == 2) {
                byte[] ascii = new byte[count];
                in.read(ascii);
                int nullCount = 0;
                for (j = 0; j < count; ++j) {
                    if (ascii[j] != 0 && j != count - 1) continue;
                    ++nullCount;
                }
                String[] strings = nullCount == 1 ? null : new String[nullCount];
                Object s = null;
                int c = 0;
                int ndx = -1;
                for (int j2 = 0; j2 < count; ++j2) {
                    if (ascii[j2] == 0) {
                        s = new String(ascii, ndx + 1, j2 - ndx - 1);
                        ndx = j2;
                    } else {
                        s = j2 == count - 1 ? new String(ascii, ndx + 1, j2 - ndx) : null;
                    }
                    if (strings == null || s == null) continue;
                    strings[c++] = s;
                }
                value = strings == null ? s : strings;
            } else if (type == 3) {
                if (count == 1) {
                    value = new Integer(in.readShort() & 0xFFFF);
                } else {
                    int[] shorts = new int[count];
                    for (int j3 = 0; j3 < count; ++j3) {
                        shorts[j3] = in.readShort() & 0xFFFF;
                    }
                    value = shorts;
                }
            } else if (type == 4) {
                if (count == 1) {
                    value = new Long(in.readInt());
                } else {
                    long[] longs = new long[count];
                    for (int j4 = 0; j4 < count; ++j4) {
                        longs[j4] = in.readInt();
                    }
                    value = longs;
                }
            } else if (type == 16 || type == 17 || type == 18) {
                if (count == 1) {
                    value = new Long(in.readLong());
                } else {
                    long[] longs = new long[count];
                    for (int j5 = 0; j5 < count; ++j5) {
                        longs[j5] = in.readLong();
                    }
                    value = longs;
                }
            } else if (type == 5 || type == 10) {
                if (count == 1) {
                    value = new TiffRational(in.readInt(), in.readInt());
                } else {
                    TiffRational[] rationals = new TiffRational[count];
                    for (int j6 = 0; j6 < count; ++j6) {
                        rationals[j6] = new TiffRational(in.readInt(), in.readInt());
                    }
                    value = rationals;
                }
            } else if (type == 6 || type == 7) {
                if (count == 1) {
                    value = new Byte(in.readByte());
                } else {
                    byte[] sbytes = new byte[count];
                    in.read(sbytes);
                    value = sbytes;
                }
            } else if (type == 8) {
                if (count == 1) {
                    value = new Short(in.readShort());
                } else {
                    short[] sshorts = new short[count];
                    for (int j7 = 0; j7 < count; ++j7) {
                        sshorts[j7] = in.readShort();
                    }
                    value = sshorts;
                }
            } else if (type == 9) {
                if (count == 1) {
                    value = new Integer(in.readInt());
                } else {
                    int[] slongs = new int[count];
                    for (int j8 = 0; j8 < count; ++j8) {
                        slongs[j8] = in.readInt();
                    }
                    value = slongs;
                }
            } else if (type == 11) {
                if (count == 1) {
                    value = new Float(in.readFloat());
                } else {
                    float[] floats = new float[count];
                    for (int j9 = 0; j9 < count; ++j9) {
                        floats[j9] = in.readFloat();
                    }
                    value = floats;
                }
            } else if (type == 12) {
                if (count == 1) {
                    value = new Double(in.readDouble());
                } else {
                    double[] doubles = new double[count];
                    for (int j10 = 0; j10 < count; ++j10) {
                        doubles[j10] = in.readDouble();
                    }
                    value = doubles;
                }
            }
            if (value != null) {
                ifd.put(new Integer(tag), (Comparable<Boolean>)value);
            }
            ++i;
        }
        in.seek(offset + (long)baseOffset + (long)bytesPerEntry * numEntries);
        return ifd;
    }

    public static String getIFDTagName(int tag) {
        return TiffTools.getFieldName(tag);
    }

    public static String getIFDTypeName(int type) {
        return TiffTools.getFieldName(type);
    }

    public static String getFieldName(int value) {
        Field[] fields = TiffTools.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getInt(null) != value) continue;
                return fields[i].getName();
            }
            catch (IllegalAccessException exc) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "" + value;
    }

    public static Object getIFDValue(Hashtable ifd, int tag) {
        return ifd.get(new Integer(tag));
    }

    public static Object getIFDValue(Hashtable ifd, int tag, boolean checkNull, Class checkClass) throws FormatException {
        Object value = ifd.get(new Integer(tag));
        if (checkNull && value == null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry not found");
        }
        if (checkClass != null && value != null && !checkClass.isInstance(value)) {
            Class<?> cType = checkClass.getComponentType();
            Object array = null;
            if (cType == value.getClass()) {
                array = Array.newInstance(value.getClass(), 1);
                Array.set(array, 0, value);
            }
            if (cType == Boolean.TYPE && value instanceof Boolean) {
                array = Array.newInstance(Boolean.TYPE, 1);
                Array.setBoolean(array, 0, (Boolean)value);
            } else if (cType == Byte.TYPE && value instanceof Byte) {
                array = Array.newInstance(Byte.TYPE, 1);
                Array.setByte(array, 0, (Byte)value);
            } else if (cType == Character.TYPE && value instanceof Character) {
                array = Array.newInstance(Character.TYPE, 1);
                Array.setChar(array, 0, ((Character)value).charValue());
            } else if (cType == Double.TYPE && value instanceof Double) {
                array = Array.newInstance(Double.TYPE, 1);
                Array.setDouble(array, 0, (Double)value);
            } else if (cType == Float.TYPE && value instanceof Float) {
                array = Array.newInstance(Float.TYPE, 1);
                Array.setFloat(array, 0, ((Float)value).floatValue());
            } else if (cType == Integer.TYPE && value instanceof Integer) {
                array = Array.newInstance(Integer.TYPE, 1);
                Array.setInt(array, 0, (Integer)value);
            } else if (cType == Long.TYPE && value instanceof Long) {
                array = Array.newInstance(Long.TYPE, 1);
                Array.setLong(array, 0, (Long)value);
            } else if (cType == Short.TYPE && value instanceof Short) {
                array = Array.newInstance(Short.TYPE, 1);
                Array.setShort(array, 0, (Short)value);
            }
            if (array != null) {
                return array;
            }
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected " + checkClass.getName());
        }
        return value;
    }

    public static long getIFDLongValue(Hashtable ifd, int tag, boolean checkNull, long defaultValue) throws FormatException {
        long value = defaultValue;
        Number number = (Number)TiffTools.getIFDValue(ifd, tag, checkNull, Number.class);
        if (number != null) {
            value = number.longValue();
        }
        return value;
    }

    public static int getIFDIntValue(Hashtable ifd, int tag) {
        int value = -1;
        try {
            value = TiffTools.getIFDIntValue(ifd, tag, false, -1);
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return value;
    }

    public static int getIFDIntValue(Hashtable ifd, int tag, boolean checkNull, int defaultValue) throws FormatException {
        int value = defaultValue;
        Number number = (Number)TiffTools.getIFDValue(ifd, tag, checkNull, Number.class);
        if (number != null) {
            value = number.intValue();
        }
        return value;
    }

    public static TiffRational getIFDRationalValue(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        return (TiffRational)TiffTools.getIFDValue(ifd, tag, checkNull, TiffRational.class);
    }

    public static long[] getIFDLongArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        long[] results = null;
        if (value instanceof long[]) {
            results = (long[])value;
        } else if (value instanceof Number) {
            results = new long[]{((Number)value).longValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new long[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].longValue();
            }
        } else if (value instanceof int[]) {
            int[] integers = (int[])value;
            results = new long[integers.length];
            for (int i = 0; i < integers.length; ++i) {
                results[i] = integers[i];
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, long[], Number[] or int[])");
        }
        return results;
    }

    public static int[] getIFDIntArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        int[] results = null;
        if (value instanceof int[]) {
            results = (int[])value;
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            results = new int[v.length];
            for (int i = 0; i < v.length; ++i) {
                results[i] = (int)v[i];
            }
        } else if (value instanceof Number) {
            results = new int[]{((Number)value).intValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new int[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].intValue();
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, int[] or Number[])");
        }
        return results;
    }

    public static short[] getIFDShortArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        short[] results = null;
        if (value instanceof short[]) {
            results = (short[])value;
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            results = new short[v.length];
            for (int i = 0; i < v.length; ++i) {
                results[i] = (short)v[i];
            }
        } else if (value instanceof Number) {
            results = new short[]{((Number)value).shortValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new short[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].shortValue();
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, short[] or Number[])");
        }
        return results;
    }

    public static String getComment(Hashtable ifd) {
        if (ifd == null) {
            return null;
        }
        Object o = TiffTools.getIFDValue(ifd, 270);
        String comment = null;
        if (o instanceof String) {
            comment = (String)o;
        } else if (o instanceof String[]) {
            String[] s = (String[])o;
            if (s.length > 0) {
                comment = s[0];
            }
        } else if (o != null) {
            comment = o.toString();
        }
        if (comment != null) {
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
        }
        return comment;
    }

    public static String getComment(String id) throws FormatException, IOException {
        RandomAccessInputStream in = new RandomAccessInputStream(id);
        Hashtable ifd = TiffTools.getFirstIFD(in);
        in.close();
        return TiffTools.getComment(ifd);
    }

    public static long getTileWidth(Hashtable ifd) throws FormatException {
        long tileWidth = TiffTools.getIFDLongValue(ifd, 322, false, 0L);
        return tileWidth == 0L ? TiffTools.getImageWidth(ifd) : tileWidth;
    }

    public static long getTileLength(Hashtable ifd) throws FormatException {
        long tileLength = TiffTools.getIFDLongValue(ifd, 323, false, 0L);
        return tileLength == 0L ? TiffTools.getRowsPerStrip(ifd)[0] : tileLength;
    }

    public static long getTilesPerRow(Hashtable ifd) throws FormatException {
        long tileWidth = TiffTools.getTileWidth(ifd);
        long imageWidth = TiffTools.getImageWidth(ifd);
        long nTiles = imageWidth / tileWidth;
        if (nTiles * tileWidth < imageWidth) {
            ++nTiles;
        }
        return nTiles;
    }

    public static long getTilesPerColumn(Hashtable ifd) throws FormatException {
        long tileLength = TiffTools.getTileLength(ifd);
        long imageLength = TiffTools.getImageLength(ifd);
        long nTiles = imageLength / tileLength;
        if (nTiles * tileLength < imageLength) {
            ++nTiles;
        }
        return nTiles;
    }

    public static byte[] getTile(Hashtable ifd, RandomAccessInputStream in, int row, int col) throws FormatException, IOException {
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        if (TiffTools.getPlanarConfiguration(ifd) == 2) {
            samplesPerPixel = 1;
        }
        int bpp = TiffTools.getBytesPerSample(ifd)[0];
        int width = (int)TiffTools.getTileWidth(ifd);
        int height = (int)TiffTools.getTileLength(ifd);
        byte[] buf = new byte[width * height * samplesPerPixel * bpp];
        return TiffTools.getTile(ifd, in, buf, row, col);
    }

    public static byte[] getTile(Hashtable ifd, RandomAccessInputStream in, byte[] buf, int row, int col) throws FormatException, IOException {
        int size;
        byte[] jpegTable = (byte[])TiffTools.getIFDValue(ifd, 347, false, null);
        CodecOptions options = new CodecOptions();
        options.interleaved = true;
        options.littleEndian = TiffTools.isLittleEndian(ifd);
        long tileWidth = TiffTools.getTileWidth(ifd);
        long tileLength = TiffTools.getTileLength(ifd);
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        int planarConfig = TiffTools.getPlanarConfiguration(ifd);
        int compression = TiffTools.getCompression(ifd);
        long numTileCols = TiffTools.getTilesPerRow(ifd);
        int pixel = TiffTools.getBytesPerSample(ifd)[0];
        int effectiveChannels = planarConfig == 2 ? 1 : samplesPerPixel;
        long[] stripOffsets = TiffTools.getStripOffsets(ifd);
        long[] stripByteCounts = TiffTools.getStripByteCounts(ifd);
        int tileNumber = (int)((long)row * numTileCols + (long)col);
        byte[] tile = new byte[(int)stripByteCounts[tileNumber]];
        in.seek(stripOffsets[tileNumber] & 0xFFFFFFFFL);
        in.read(tile);
        options.maxBytes = size = (int)(tileWidth * tileLength * (long)pixel * (long)effectiveChannels);
        if (jpegTable != null) {
            byte[] q = new byte[jpegTable.length + tile.length - 4];
            System.arraycopy(jpegTable, 0, q, 0, jpegTable.length - 2);
            System.arraycopy(tile, 2, q, jpegTable.length - 2, tile.length - 2);
            tile = TiffTools.uncompress(q, compression, options);
        } else {
            tile = TiffTools.uncompress(tile, compression, options);
        }
        TiffTools.undifference(tile, ifd);
        TiffTools.unpackBytes(buf, 0, tile, ifd);
        return buf;
    }

    public static byte[][] getSamples(Hashtable ifd, RandomAccessInputStream in) throws FormatException, IOException {
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        int bpp = TiffTools.getBytesPerSample(ifd)[0];
        long width = TiffTools.getImageWidth(ifd);
        long length = TiffTools.getImageLength(ifd);
        byte[] b = new byte[(int)(width * length * (long)samplesPerPixel * (long)bpp)];
        TiffTools.getSamples(ifd, in, b);
        byte[][] samples = new byte[samplesPerPixel][(int)(width * length * (long)bpp)];
        for (int i = 0; i < samplesPerPixel; ++i) {
            System.arraycopy(b, (int)((long)i * width * length * (long)bpp), samples[i], 0, samples[i].length);
        }
        b = null;
        return samples;
    }

    public static byte[] getSamples(Hashtable ifd, RandomAccessInputStream in, byte[] buf) throws FormatException, IOException {
        long width = TiffTools.getImageWidth(ifd);
        long length = TiffTools.getImageLength(ifd);
        return TiffTools.getSamples(ifd, in, buf, 0, 0, width, length);
    }

    public static byte[] getSamples(Hashtable ifd, RandomAccessInputStream in, byte[] buf, int x, int y, long width, long height) throws FormatException, IOException {
        TiffTools.debug("parsing IFD entries");
        boolean littleEndian = TiffTools.isLittleEndian(ifd);
        in.order(littleEndian);
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        long tileWidth = TiffTools.getTileWidth(ifd);
        long tileLength = TiffTools.getTileLength(ifd);
        long numTileRows = TiffTools.getTilesPerColumn(ifd);
        long numTileCols = TiffTools.getTilesPerRow(ifd);
        int planarConfig = TiffTools.getPlanarConfiguration(ifd);
        TiffTools.printIFD(ifd);
        if (width * height > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth x ImageLength > 2147483647 is not supported (" + width + " x " + height + ")");
        }
        int numSamples = (int)(width * height);
        TiffTools.debug("reading image data (samplesPerPixel=" + samplesPerPixel + "; numSamples=" + numSamples + ")");
        int pixel = TiffTools.getBytesPerSample(ifd)[0];
        int effectiveChannels = planarConfig == 2 ? 1 : samplesPerPixel;
        long nrows = numTileRows;
        if (planarConfig == 2) {
            numTileRows *= (long)samplesPerPixel;
        }
        Region imageBounds = new Region(x, y, (int)width, (int)(height * (long)(samplesPerPixel / effectiveChannels)));
        int endX = (int)width + x;
        int endY = (int)height + y;
        int row = 0;
        while ((long)row < numTileRows) {
            int col = 0;
            while ((long)col < numTileCols) {
                Region tileBounds = new Region(col * (int)tileWidth, (int)((long)row * tileLength), (int)tileWidth, (int)tileLength);
                if (imageBounds.intersects(tileBounds)) {
                    if (planarConfig == 2) {
                        tileBounds.y = (int)((long)row % nrows * tileLength);
                    }
                    byte[] tile = TiffTools.getTile(ifd, in, row, col);
                    int tileX = Math.max(tileBounds.x, x);
                    int tileY = Math.max(tileBounds.y, y);
                    int realX = tileX % (int)tileWidth;
                    int realY = tileY % (int)tileLength;
                    int twidth = (int)Math.min((long)(endX - tileX), tileWidth - (long)realX);
                    int theight = (int)Math.min((long)(endY - tileY), tileLength - (long)realY);
                    int rowLen = pixel * (int)tileWidth;
                    int copy = pixel * twidth;
                    int tileSize = (int)(tileWidth * tileLength * (long)pixel);
                    int planeSize = (int)(width * height * (long)pixel);
                    int outputRowLen = (int)((long)pixel * width);
                    realX *= pixel;
                    realY *= rowLen;
                    for (int q = 0; q < effectiveChannels; ++q) {
                        int src = q * tileSize + realX + realY;
                        int dest = q * planeSize + pixel * (tileX - x) + outputRowLen * (tileY - y);
                        if (planarConfig == 2) {
                            dest = (int)((long)dest + (long)planeSize * ((long)row / nrows));
                        }
                        for (int tileRow = 0; tileRow < theight; ++tileRow) {
                            System.arraycopy(tile, src, buf, dest, copy);
                            src += rowLen;
                            dest += outputRowLen;
                        }
                    }
                }
                ++col;
            }
            ++row;
        }
        return buf;
    }

    public static void planarUnpack(byte[] samples, int startIndex, byte[] bytes, Hashtable ifd) throws FormatException {
        int numBytes;
        BitBuffer bb = new BitBuffer(bytes);
        int realBytes = numBytes = TiffTools.getBytesPerSample(ifd)[0];
        if (numBytes == 3) {
            ++numBytes;
        }
        int bitsPerSample = TiffTools.getBitsPerSample(ifd)[0];
        boolean littleEndian = TiffTools.isLittleEndian(ifd);
        int photoInterp = TiffTools.getPhotometricInterpretation(ifd);
        for (int j = 0; j < bytes.length / realBytes; ++j) {
            int value = bb.getBits(bitsPerSample);
            if (photoInterp == 0) {
                value = (int)(Math.pow(2.0, bitsPerSample) - 1.0 - (double)value);
            } else if (photoInterp == 5) {
                value = Integer.MAX_VALUE - value;
            }
            if (numBytes * (startIndex + j) >= samples.length) continue;
            DataTools.unpackBytes(value, samples, numBytes * (startIndex + j), numBytes, littleEndian);
        }
    }

    public static void unpackBytes(byte[] samples, int startIndex, byte[] bytes, Hashtable ifd) throws FormatException {
        if (TiffTools.getPlanarConfiguration(ifd) == 2) {
            TiffTools.planarUnpack(samples, startIndex, bytes, ifd);
            return;
        }
        int compression = TiffTools.getCompression(ifd);
        int photoInterp = TiffTools.getPhotometricInterpretation(ifd);
        if (compression == 7) {
            photoInterp = 2;
        }
        int[] bitsPerSample = TiffTools.getBitsPerSample(ifd);
        int nChannels = bitsPerSample.length;
        int nSamples = samples.length / nChannels;
        int totalBits = 0;
        for (int i = 0; i < nChannels; ++i) {
            totalBits += bitsPerSample[i];
        }
        int sampleCount = 8 * bytes.length / totalBits;
        if (photoInterp == 6) {
            sampleCount *= 3;
        }
        TiffTools.debug("unpacking " + sampleCount + " samples (startIndex=" + startIndex + "; totalBits=" + totalBits + "; numBytes=" + bytes.length + ")");
        long imageWidth = TiffTools.getImageWidth(ifd);
        int bps0 = bitsPerSample[0];
        int numBytes = TiffTools.getBytesPerSample(ifd)[0];
        boolean noDiv8 = bps0 % 8 != 0;
        boolean bps8 = bps0 == 8;
        int row = startIndex / (int)imageWidth;
        boolean col = false;
        boolean cw = false;
        boolean ch = false;
        boolean littleEndian = TiffTools.isLittleEndian(ifd);
        int[] reference = TiffTools.getIFDIntArray(ifd, 532, false);
        int[] subsampling = TiffTools.getIFDIntArray(ifd, 530, false);
        TiffRational[] coefficients = (TiffRational[])TiffTools.getIFDValue(ifd, 529);
        boolean count = false;
        BitBuffer bb = new BitBuffer(bytes);
        block1: for (int j = 0; j < sampleCount; ++j) {
            for (int i = 0; i < nChannels; ++i) {
                int index = numBytes * (j * nChannels + i);
                int ndx = startIndex + j;
                if (ndx >= nSamples) continue block1;
                int outputIndex = i * nSamples + ndx * numBytes;
                if (noDiv8) {
                    short s = 0;
                    if (i == 0 && photoInterp == 3 || photoInterp != 32803 && photoInterp != 3) {
                        s = (short)(bb.getBits(bps0) & 0xFFFF);
                        if ((long)ndx % imageWidth == imageWidth - 1L && bps0 < 8) {
                            bb.skipBits(imageWidth * (long)bps0 * (long)sampleCount % 8L);
                        }
                    }
                    if (photoInterp == 0 || photoInterp == 5) {
                        s = (short)(Math.pow(2.0, bitsPerSample[0]) - 1.0 - (double)s);
                    }
                    if (outputIndex + numBytes > samples.length) continue;
                    DataTools.unpackBytes(s, samples, outputIndex, numBytes, littleEndian);
                    continue;
                }
                if (bps8) {
                    if (outputIndex >= samples.length) continue block1;
                    if (photoInterp != 6) {
                        samples[outputIndex] = (byte)(bytes[index] & 0xFF);
                    }
                    if (photoInterp == 0) {
                        samples[outputIndex] = (byte)(255 - samples[outputIndex]);
                        continue;
                    }
                    if (photoInterp == 5) {
                        samples[outputIndex] = (byte)(Integer.MAX_VALUE - samples[outputIndex]);
                        continue;
                    }
                    if (photoInterp != 6 || i != bitsPerSample.length - 1) continue;
                    float lumaRed = 0.299f;
                    float lumaGreen = 0.587f;
                    float lumaBlue = 0.114f;
                    if (coefficients != null) {
                        lumaRed = coefficients[0].floatValue();
                        lumaGreen = coefficients[1].floatValue();
                        lumaBlue = coefficients[2].floatValue();
                    }
                    int subX = subsampling == null ? 2 : subsampling[0];
                    int subY = subsampling == null ? 2 : subsampling[1];
                    int block = subX * subY;
                    int lumaIndex = j + 2 * (j / block);
                    int chromaIndex = j / block * (block + 2) + block;
                    if (chromaIndex + 1 >= bytes.length) continue block1;
                    int tile = ndx / block;
                    int nTiles = (int)(imageWidth / (long)subX);
                    int pixel = ndx % block;
                    long r = subY * (tile / nTiles) + pixel / subX;
                    long c = subX * (tile % nTiles) + pixel % subX;
                    int idx = (int)(r * imageWidth + c);
                    if (idx >= nSamples) continue;
                    int y = (bytes[lumaIndex] & 0xFF) - reference[0];
                    int cb = (bytes[chromaIndex] & 0xFF) - reference[2];
                    int cr = (bytes[chromaIndex + 1] & 0xFF) - reference[4];
                    int red = (int)((float)cr * (2.0f - 2.0f * lumaRed) + (float)y);
                    int blue = (int)((float)cb * (2.0f - 2.0f * lumaBlue) + (float)y);
                    int green = (int)(((float)y - lumaBlue * (float)blue - lumaRed * (float)red) / lumaGreen);
                    samples[idx] = (byte)red;
                    samples[nSamples + idx] = (byte)green;
                    samples[2 * nSamples + idx] = (byte)blue;
                    continue;
                }
                int offset = numBytes + index < bytes.length ? index : bytes.length - numBytes;
                long v = DataTools.bytesToLong(bytes, offset, numBytes, littleEndian);
                if (photoInterp == 0) {
                    long max = (long)Math.pow(2.0, numBytes * 8) - 1L;
                    v = max - v;
                } else if (photoInterp == 5) {
                    v = Integer.MAX_VALUE - v;
                }
                if (ndx * numBytes >= nSamples) continue block1;
                DataTools.unpackBytes(v, samples, i * nSamples + ndx * numBytes, numBytes, littleEndian);
            }
        }
    }

    public static boolean isSupportedDecompression(int decompression) {
        return decompression == 1 || decompression == 5 || decompression == 7 || decompression == 33007 || decompression == 33003 || decompression == 32773 || decompression == 32946 || decompression == 8 || decompression == 34713 || decompression == 65535;
    }

    public static byte[] uncompress(byte[] input, int compression, CodecOptions options) throws FormatException, IOException {
        if (compression < 0) {
            compression += 65536;
        }
        if (!TiffTools.isSupportedDecompression(compression)) {
            String compressionName = TiffTools.getCodecName(compression);
            String message = null;
            message = compressionName != null ? "Sorry, " + compressionName + " compression mode is not supported" : "Unknown Compression type (" + compression + ")";
            throw new FormatException(message);
        }
        BaseCodec codec = null;
        if (compression == 1) {
            return input;
        }
        if (compression == 5) {
            codec = new LZWCodec();
        } else if (compression == 7 || compression == 33007) {
            codec = new JPEGCodec();
        } else if (compression == 33003) {
            codec = new JPEG2000Codec();
        } else if (compression == 32773) {
            codec = new PackbitsCodec();
        } else if (compression == 32946 || compression == 8) {
            codec = new ZlibCodec();
        } else if (compression == 34713) {
            codec = new NikonCodec();
        } else if (compression == 65535) {
            codec = new LuraWaveCodec();
        }
        if (codec != null) {
            return codec.decompress(input, options);
        }
        throw new FormatException("Unhandled compression (" + compression + ")");
    }

    public static void undifference(byte[] input, Hashtable ifd) throws FormatException {
        int predictor = TiffTools.getIFDIntValue(ifd, 317, false, 1);
        if (predictor == 2) {
            TiffTools.debug("reversing horizontal differencing");
            int[] bitsPerSample = TiffTools.getBitsPerSample(ifd);
            int len = bitsPerSample.length;
            long width = TiffTools.getImageWidth(ifd);
            boolean little = TiffTools.isLittleEndian(ifd);
            int planarConfig = TiffTools.getPlanarConfiguration(ifd);
            if (planarConfig == 2 || bitsPerSample[len - 1] == 0) {
                len = 1;
            }
            if (bitsPerSample[0] <= 8) {
                for (int b = 0; b < input.length; ++b) {
                    if ((long)(b / len) % width == 0L) continue;
                    int n = b;
                    input[n] = (byte)(input[n] + input[b - len]);
                }
            } else if (bitsPerSample[0] <= 16) {
                short[] s = (short[])DataTools.makeDataArray(input, 2, false, little);
                for (int b = 0; b < s.length; ++b) {
                    if ((long)(b / len) % width == 0L) continue;
                    int n = b;
                    s[n] = (short)(s[n] + s[b - len]);
                }
                for (int i = 0; i < s.length; ++i) {
                    DataTools.unpackShort(s[i], input, i * 2, little);
                }
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    public static void putIFDValue(Hashtable ifd, int tag, Object value) {
        ifd.put(new Integer(tag), value);
    }

    public static void putIFDValue(Hashtable ifd, int tag, short value) {
        TiffTools.putIFDValue(ifd, tag, new Short(value));
    }

    public static void putIFDValue(Hashtable ifd, int tag, int value) {
        TiffTools.putIFDValue(ifd, tag, new Integer(value));
    }

    public static void putIFDValue(Hashtable ifd, int tag, long value) {
        TiffTools.putIFDValue(ifd, tag, new Long(value));
    }

    public static void writeIFDValue(DataOutput ifdOut, ByteArrayOutputStream extraBuf, DataOutputStream extraOut, long offset, int tag, Object value, boolean bigTiff, boolean littleEndian) throws FormatException, IOException {
        if (value instanceof Short) {
            value = new short[]{(Short)value};
        } else if (value instanceof Integer) {
            value = new int[]{(Integer)value};
        } else if (value instanceof Long) {
            value = new long[]{(Long)value};
        } else if (value instanceof TiffRational) {
            value = new TiffRational[]{(TiffRational)value};
        } else if (value instanceof Float) {
            value = new float[]{((Float)value).floatValue()};
        } else if (value instanceof Double) {
            value = new double[]{(Double)value};
        }
        int dataLength = bigTiff ? 8 : 4;
        DataTools.writeShort(ifdOut, tag, littleEndian);
        if (value instanceof short[]) {
            short[] q = (short[])value;
            DataTools.writeShort(ifdOut, 1, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeByte(q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    ifdOut.writeByte(0);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
            }
        } else if (value instanceof String) {
            char[] q = ((String)value).toCharArray();
            DataTools.writeShort(ifdOut, 2, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length + 1, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length + 1, littleEndian);
            }
            if (q.length < dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeByte(q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    ifdOut.writeByte(0);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
                extraOut.writeByte(0);
            }
        } else if (value instanceof int[]) {
            int[] q = (int[])value;
            DataTools.writeShort(ifdOut, 3, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength / 2) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    DataTools.writeShort(ifdOut, q[i], littleEndian);
                }
                for (i = q.length; i < dataLength / 2; ++i) {
                    DataTools.writeShort(ifdOut, 0, littleEndian);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeShort(extraOut, q[i], littleEndian);
                }
            }
        } else if (value instanceof long[]) {
            long[] q = (long[])value;
            if (bigTiff) {
                DataTools.writeShort(ifdOut, 16, littleEndian);
                DataTools.writeLong(ifdOut, q.length, littleEndian);
                if (q.length <= dataLength / 4) {
                    int i;
                    for (i = 0; i < q.length; ++i) {
                        DataTools.writeLong(ifdOut, q[0], littleEndian);
                    }
                    for (i = q.length; i < dataLength / 4; ++i) {
                        DataTools.writeLong(ifdOut, 0L, littleEndian);
                    }
                } else {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                    for (int i = 0; i < q.length; ++i) {
                        DataTools.writeLong(extraOut, q[i], littleEndian);
                    }
                }
            } else {
                DataTools.writeShort(ifdOut, 4, littleEndian);
                DataTools.writeInt(ifdOut, q.length, littleEndian);
                if (q.length <= dataLength / 4) {
                    int i;
                    for (i = 0; i < q.length; ++i) {
                        DataTools.writeInt(ifdOut, (int)q[0], littleEndian);
                    }
                    for (i = q.length; i < dataLength / 4; ++i) {
                        DataTools.writeInt(ifdOut, 0, littleEndian);
                    }
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                    for (int i = 0; i < q.length; ++i) {
                        DataTools.writeInt(extraOut, (int)q[i], littleEndian);
                    }
                }
            }
        } else if (value instanceof TiffRational[]) {
            Object[] q = value;
            DataTools.writeShort(ifdOut, 5, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (bigTiff && q.length == 1) {
                DataTools.writeInt(ifdOut, (int)((TiffRational)q[0]).getNumerator(), littleEndian);
                DataTools.writeInt(ifdOut, (int)((TiffRational)q[0]).getDenominator(), littleEndian);
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeInt(extraOut, (int)((TiffRational)q[i]).getNumerator(), littleEndian);
                    DataTools.writeInt(extraOut, (int)((TiffRational)q[i]).getDenominator(), littleEndian);
                }
            }
        } else if (value instanceof float[]) {
            float[] q = (float[])value;
            DataTools.writeShort(ifdOut, 11, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength / 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    DataTools.writeFloat(ifdOut, q[0], littleEndian);
                }
                for (i = q.length; i < dataLength / 4; ++i) {
                    DataTools.writeInt(ifdOut, 0, littleEndian);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeFloat(extraOut, q[i], littleEndian);
                }
            }
        } else if (value instanceof double[]) {
            double[] q = (double[])value;
            DataTools.writeShort(ifdOut, 12, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (bigTiff) {
                DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
            } else {
                DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
            }
            for (int i = 0; i < q.length; ++i) {
                DataTools.writeDouble(extraOut, q[i], littleEndian);
            }
        } else {
            throw new FormatException("Unknown IFD value type (" + value.getClass().getName() + "): " + value);
        }
    }

    public static void overwriteIFDValue(String file2, int ifd, int tag, Object value) throws FormatException, IOException {
        int i;
        TiffTools.debug("overwriteIFDValue (ifd=" + ifd + "; tag=" + tag + "; value=" + value + ")");
        byte[] header = new byte[4];
        RandomAccessInputStream raf = new RandomAccessInputStream(file2);
        raf.seek(0L);
        raf.readFully(header);
        if (!TiffTools.isValidHeader(header)) {
            throw new FormatException("Invalid TIFF header");
        }
        boolean little = header[0] == 73 && header[1] == 73;
        boolean bigTiff = header[2] == 43 || header[3] == 43;
        long offset = bigTiff ? 8L : 4L;
        long num = 0L;
        int baseOffset = bigTiff ? 8 : 2;
        int bytesPerEntry = bigTiff ? 20 : 12;
        raf.seek(offset);
        for (i = 0; i <= ifd; ++i) {
            long l = offset = bigTiff ? DataTools.read8SignedBytes(raf, little) : DataTools.read4UnsignedBytes(raf, little);
            if (offset <= 0L) {
                throw new FormatException("No such IFD (" + ifd + " of " + i + ")");
            }
            raf.seek(offset);
            long l2 = num = bigTiff ? DataTools.read8SignedBytes(raf, little) : (long)DataTools.read2UnsignedBytes(raf, little);
            if (i >= ifd) continue;
            raf.seek(offset + (long)baseOffset + (long)bytesPerEntry * num);
        }
        i = 0;
        while ((long)i < num) {
            long oldOffset;
            int oldTag = DataTools.read2UnsignedBytes(raf, little);
            int oldType = DataTools.read2UnsignedBytes(raf, little);
            int oldCount = bigTiff ? (int)(DataTools.read8SignedBytes(raf, little) & 0xFFFFFFFFFFFFFFFFL) : DataTools.read4SignedBytes(raf, little);
            long l = oldOffset = bigTiff ? DataTools.read8SignedBytes(raf, little) : (long)DataTools.read4SignedBytes(raf, little);
            if (oldTag == tag) {
                long newOffset;
                int newCount;
                ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(bytesPerEntry);
                DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
                ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
                DataOutputStream extraOut = new DataOutputStream(extraBuf);
                TiffTools.writeIFDValue(ifdOut, extraBuf, extraOut, oldOffset, tag, value, bigTiff, little);
                byte[] bytes = ifdBuf.toByteArray();
                byte[] extra = extraBuf.toByteArray();
                int newTag = DataTools.bytesToInt(bytes, 0, 2, little);
                int newType = DataTools.bytesToInt(bytes, 2, 2, little);
                if (bigTiff) {
                    newCount = (int)(DataTools.bytesToLong(bytes, 4, little) & 0xFFFFFFFFFFFFFFFFL);
                    newOffset = DataTools.bytesToLong(bytes, 12, little);
                } else {
                    newCount = DataTools.bytesToInt(bytes, 4, little);
                    newOffset = DataTools.bytesToInt(bytes, 8, little);
                }
                boolean terminate = false;
                TiffTools.debug("overwriteIFDValue:\n\told: (tag=" + oldTag + "; type=" + oldType + "; count=" + oldCount + "; offset=" + oldOffset + ");\n\tnew: (tag=" + newTag + "; type=" + newType + "; count=" + newCount + "; offset=" + newOffset + ")");
                if (extra.length == 0) {
                    TiffTools.debug("overwriteIFDValue: new entry is inline");
                } else if (oldOffset + (long)(oldCount * BYTES_PER_ELEMENT[oldType]) == raf.length()) {
                    newOffset = oldOffset;
                    terminate = true;
                    TiffTools.debug("overwriteIFDValue: old entry is at EOF");
                } else if (newCount <= oldCount) {
                    newOffset = oldOffset;
                    TiffTools.debug("overwriteIFDValue: new entry is <= old entry");
                } else {
                    newOffset = raf.length();
                    TiffTools.debug("overwriteIFDValue: old entry will be orphaned");
                }
                long filePointer = raf.getFilePointer();
                raf.close();
                RandomAccessOutputStream out = new RandomAccessOutputStream(file2);
                out.seek(filePointer - (long)(bigTiff ? 18 : 10));
                DataTools.writeShort(out, newType, little);
                if (bigTiff) {
                    DataTools.writeLong(out, newCount, little);
                } else {
                    DataTools.writeInt(out, newCount, little);
                }
                if (bigTiff) {
                    DataTools.writeLong(out, newOffset, little);
                } else {
                    DataTools.writeInt(out, (int)newOffset, little);
                }
                if (extra.length > 0) {
                    out.seek(newOffset);
                    out.write(extra);
                }
                return;
            }
            ++i;
        }
        throw new FormatException("Tag not found (" + TiffTools.getIFDTagName(tag) + ")");
    }

    public static void overwriteComment(String id, Object value) throws FormatException, IOException {
        TiffTools.overwriteIFDValue(id, 0, 270, value);
    }

    public static long writeImage(byte[] buf, Hashtable ifd, RandomAccessOutputStream out, long offset, boolean last, boolean bigTiff, ColorModel colorModel, int pixelType, boolean interleaved) throws FormatException, IOException {
        boolean indexed;
        if (buf == null) {
            throw new FormatException("Byte array is null");
        }
        TiffTools.debug("writeImage (offset=" + offset + "; last=" + last + ")");
        boolean little = TiffTools.isLittleEndian(ifd);
        int width = (int)TiffTools.getImageWidth(ifd);
        int height = (int)TiffTools.getImageLength(ifd);
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int plane = width * height * bytesPerPixel;
        int nChannels = buf.length / plane;
        boolean bl = indexed = colorModel != null && colorModel instanceof IndexColorModel;
        if (ifd == null) {
            ifd = new Hashtable();
        }
        TiffTools.putIFDValue(ifd, 256, width);
        TiffTools.putIFDValue(ifd, 257, height);
        if (TiffTools.getIFDValue(ifd, 258) == null) {
            int bps = 8 * bytesPerPixel;
            int[] bpsArray = new int[nChannels];
            Arrays.fill(bpsArray, bps);
            TiffTools.putIFDValue(ifd, 258, bpsArray);
        }
        if (FormatTools.isFloatingPoint(pixelType)) {
            TiffTools.putIFDValue(ifd, 339, 3);
        }
        if (TiffTools.getIFDValue(ifd, 259) == null) {
            TiffTools.putIFDValue(ifd, 259, 1);
        }
        if (TiffTools.getIFDValue(ifd, 262) == null) {
            int photometricInterpretation = indexed ? 3 : (nChannels == 1 ? 1 : 2);
            TiffTools.putIFDValue(ifd, 262, photometricInterpretation);
        }
        if (TiffTools.getIFDValue(ifd, 277) == null) {
            TiffTools.putIFDValue(ifd, 277, nChannels);
        }
        if (TiffTools.getIFDValue(ifd, 282) == null) {
            TiffTools.putIFDValue(ifd, 282, new TiffRational(1L, 1L));
        }
        if (TiffTools.getIFDValue(ifd, 283) == null) {
            TiffTools.putIFDValue(ifd, 283, new TiffRational(1L, 1L));
        }
        if (TiffTools.getIFDValue(ifd, 296) == null) {
            TiffTools.putIFDValue(ifd, 296, 1);
        }
        if (TiffTools.getIFDValue(ifd, 305) == null) {
            TiffTools.putIFDValue(ifd, 305, "LOCI Bio-Formats");
        }
        if (TiffTools.getIFDValue(ifd, 270) == null) {
            TiffTools.putIFDValue(ifd, 270, "");
        }
        if (indexed && TiffTools.getIFDValue(ifd, 320) == null) {
            byte[][] lut = new byte[3][256];
            IndexColorModel model = (IndexColorModel)colorModel;
            model.getReds(lut[0]);
            model.getGreens(lut[1]);
            model.getBlues(lut[2]);
            int[] colorMap = new int[768];
            for (int i = 0; i < lut.length; ++i) {
                for (int j = 0; j < lut[0].length; ++j) {
                    colorMap[i * lut[0].length + j] = (lut[i][j] & 0xFF) << 8;
                }
            }
            TiffTools.putIFDValue(ifd, 320, colorMap);
        }
        int compression = TiffTools.getIFDIntValue(ifd, 259, false, 1);
        boolean fullImageCompression = false;
        if (compression == 33003 || compression == 7) {
            fullImageCompression = true;
        }
        int pixels = fullImageCompression ? width * height : width;
        int stripSize = Math.max(8192, pixels * bytesPerPixel * nChannels);
        int rowsPerStrip = stripSize / (width * bytesPerPixel * nChannels);
        int stripsPerImage = (height + rowsPerStrip - 1) / rowsPerStrip;
        int[] bps = (int[])TiffTools.getIFDValue(ifd, 258, true, int[].class);
        ByteArrayOutputStream[] stripBuf = new ByteArrayOutputStream[stripsPerImage];
        DataOutputStream[] stripOut = new DataOutputStream[stripsPerImage];
        for (int i = 0; i < stripsPerImage; ++i) {
            stripBuf[i] = new ByteArrayOutputStream(stripSize);
            stripOut[i] = new DataOutputStream(stripBuf[i]);
        }
        for (int y = 0; y < height; ++y) {
            int strip = y / rowsPerStrip;
            for (int x = 0; x < width; ++x) {
                int ndx = y * width * bytesPerPixel + x * bytesPerPixel;
                for (int c = 0; c < nChannels; ++c) {
                    for (int n = 0; n < bps[c] / 8; ++n) {
                        int off = interleaved ? ndx * nChannels + c * bytesPerPixel + n : c * plane + ndx + n;
                        stripOut[strip].writeByte(buf[off]);
                    }
                }
            }
        }
        int planarConfig = TiffTools.getPlanarConfiguration(ifd);
        int predictor = TiffTools.getIFDIntValue(ifd, 317, false, 1);
        byte[][] strips = new byte[stripsPerImage][];
        for (int i = 0; i < stripsPerImage; ++i) {
            strips[i] = stripBuf[i].toByteArray();
            TiffTools.difference(strips[i], bps, width, planarConfig, predictor);
            strips[i] = TiffTools.compress(strips[i], ifd);
        }
        long[] stripByteCounts = new long[stripsPerImage];
        long[] stripOffsets = new long[stripsPerImage];
        TiffTools.putIFDValue(ifd, 273, stripOffsets);
        TiffTools.putIFDValue(ifd, 278, rowsPerStrip);
        TiffTools.putIFDValue(ifd, 279, stripByteCounts);
        Object[] keys = ifd.keySet().toArray();
        Arrays.sort(keys);
        int keyCount = keys.length;
        if (ifd.containsKey(new Integer(0))) {
            --keyCount;
        }
        if (ifd.containsKey(new Integer(1))) {
            --keyCount;
        }
        int bytesPerEntry = bigTiff ? 20 : 12;
        int ifdBytes = (bigTiff ? 16 : 6) + bytesPerEntry * keyCount;
        long pixelBytes = 0L;
        for (int i = 0; i < stripsPerImage; ++i) {
            stripByteCounts[i] = strips[i].length;
            stripOffsets[i] = pixelBytes + offset + (long)ifdBytes;
            pixelBytes += stripByteCounts[i];
        }
        ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(ifdBytes);
        DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
        ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
        DataOutputStream extraOut = new DataOutputStream(extraBuf);
        offset += (long)ifdBytes + pixelBytes;
        if (bigTiff) {
            DataTools.writeLong(ifdOut, keyCount, little);
        } else {
            DataTools.writeShort(ifdOut, keyCount, little);
        }
        for (int k = 0; k < keys.length; ++k) {
            Object key = keys[k];
            if (!(key instanceof Integer)) {
                throw new FormatException("Malformed IFD tag (" + key + ")");
            }
            if ((Integer)key == 0 || (Integer)key == 1) continue;
            Object value = ifd.get(key);
            String sk = TiffTools.getIFDTagName((Integer)key);
            String sv = value instanceof int[] ? "int[" + ((int[])value).length + "]" : value.toString();
            TiffTools.debug("writeImage: writing " + sk + " (value=" + sv + ")");
            TiffTools.writeIFDValue(ifdOut, extraBuf, extraOut, offset, (Integer)key, value, bigTiff, little);
        }
        if (bigTiff) {
            DataTools.writeLong(ifdOut, last ? 0L : offset + (long)extraBuf.size(), little);
        } else {
            DataTools.writeInt(ifdOut, last ? 0 : (int)(offset + (long)extraBuf.size()), little);
        }
        byte[] ifdArray = ifdBuf.toByteArray();
        byte[] extraArray = extraBuf.toByteArray();
        long numBytes = ifdArray.length + extraArray.length;
        out.write(ifdArray);
        for (int i = 0; i < strips.length; ++i) {
            out.write(strips[i]);
            numBytes += (long)strips[i].length;
        }
        out.write(extraArray);
        return numBytes;
    }

    public static void writeHeader(RandomAccessOutputStream out, boolean littleEndian, boolean bigTiff) throws IOException {
        if (littleEndian) {
            out.writeByte(73);
            out.writeByte(73);
        } else {
            out.writeByte(77);
            out.writeByte(77);
        }
        if (bigTiff) {
            DataTools.writeShort(out, 43, littleEndian);
        } else {
            DataTools.writeShort(out, 42, littleEndian);
        }
        DataTools.writeInt(out, 8, littleEndian);
        if (bigTiff) {
            DataTools.writeLong(out, 16L, littleEndian);
        }
    }

    public static boolean isTiled(Hashtable ifd) throws FormatException {
        Object offsets = ifd.get(new Integer(273));
        Object tileWidth = ifd.get(new Integer(322));
        return offsets == null || tileWidth != null;
    }

    public static long getImageWidth(Hashtable ifd) throws FormatException {
        long width = TiffTools.getIFDLongValue(ifd, 256, true, 0L);
        if (width > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth > 2147483647 is not supported.");
        }
        return width;
    }

    public static long getImageLength(Hashtable ifd) throws FormatException {
        long length = TiffTools.getIFDLongValue(ifd, 257, true, 0L);
        if (length > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageLength > 2147483647 is not supported.");
        }
        return length;
    }

    public static int[] getBitsPerSample(Hashtable ifd) throws FormatException {
        int samplesPerPixel;
        int[] bitsPerSample = TiffTools.getIFDIntArray(ifd, 258, false);
        if (bitsPerSample == null) {
            bitsPerSample = new int[]{1};
        }
        if (bitsPerSample.length < (samplesPerPixel = TiffTools.getSamplesPerPixel(ifd))) {
            throw new FormatException("BitsPerSample length (" + bitsPerSample.length + ") does not match SamplesPerPixel (" + samplesPerPixel + ")");
        }
        int nSamples = Math.min(bitsPerSample.length, samplesPerPixel);
        for (int i = 0; i < nSamples; ++i) {
            if (bitsPerSample[i] >= 1) continue;
            throw new FormatException("Illegal BitsPerSample (" + bitsPerSample[i] + ")");
        }
        return bitsPerSample;
    }

    public static int getPixelType(Hashtable ifd) throws FormatException {
        int bps = TiffTools.getBitsPerSample(ifd)[0];
        int bitFormat = TiffTools.getIFDIntValue(ifd, 339);
        while (bps % 8 != 0) {
            ++bps;
        }
        if (bps == 24) {
            bps = 32;
        }
        if (bitFormat == 3) {
            return 6;
        }
        switch (bps) {
            case 16: {
                return bitFormat == 2 ? 2 : 3;
            }
            case 32: {
                return bitFormat == 2 ? 4 : 5;
            }
        }
        return bitFormat == 2 ? 0 : 1;
    }

    public static int[] getBytesPerSample(Hashtable ifd) throws FormatException {
        int[] bitsPerSample = TiffTools.getBitsPerSample(ifd);
        int[] bps = new int[bitsPerSample.length];
        for (int i = 0; i < bitsPerSample.length; ++i) {
            bps[i] = bitsPerSample[i];
            while (bps[i] % 8 != 0) {
                int n = i;
                bps[n] = bps[n] + 1;
            }
            int n = i;
            bps[n] = bps[n] / 8;
            if (bps[i] != 0) continue;
            bps[i] = 1;
        }
        return bps;
    }

    public static int getSamplesPerPixel(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDIntValue(ifd, 277, false, 1);
    }

    public static int getCompression(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDIntValue(ifd, 259, false, 1);
    }

    public static int getPhotometricInterpretation(Hashtable ifd) throws FormatException {
        int photoInterp = TiffTools.getIFDIntValue(ifd, 262, true, 0);
        if (photoInterp == 4) {
            throw new FormatException("Sorry, Transparency Mask PhotometricInterpretation is not supported");
        }
        if (photoInterp == 8) {
            throw new FormatException("Sorry, CIELAB PhotometricInterpretation is not supported");
        }
        if (photoInterp != 0 && photoInterp != 1 && photoInterp != 2 && photoInterp != 3 && photoInterp != 5 && photoInterp != 6 && photoInterp != 32803) {
            throw new FormatException("Unknown PhotometricInterpretation (" + photoInterp + ")");
        }
        return photoInterp;
    }

    public static int getPlanarConfiguration(Hashtable ifd) throws FormatException {
        int planarConfig = TiffTools.getIFDIntValue(ifd, 284, false, 1);
        if (planarConfig != 1 && planarConfig != 2) {
            throw new FormatException("Sorry, PlanarConfiguration (" + planarConfig + ") not supported.");
        }
        return planarConfig;
    }

    public static long[] getStripOffsets(Hashtable ifd) throws FormatException {
        int tag = TiffTools.isTiled(ifd) ? 324 : 273;
        long[] offsets = TiffTools.getIFDLongArray(ifd, tag, false);
        if (TiffTools.isTiled(ifd) && offsets == null) {
            offsets = TiffTools.getIFDLongArray(ifd, 273, false);
        }
        if (TiffTools.isTiled(ifd)) {
            return offsets;
        }
        long rowsPerStrip = TiffTools.getRowsPerStrip(ifd)[0];
        long numStrips = (TiffTools.getImageLength(ifd) + rowsPerStrip - 1L) / rowsPerStrip;
        if (TiffTools.getPlanarConfiguration(ifd) == 2) {
            numStrips *= (long)TiffTools.getSamplesPerPixel(ifd);
        }
        if ((long)offsets.length < numStrips) {
            throw new FormatException("StripOffsets length (" + offsets.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        return offsets;
    }

    public static long[] getStripByteCounts(Hashtable ifd) throws FormatException {
        int tag = TiffTools.isTiled(ifd) ? 325 : 279;
        long[] byteCounts = TiffTools.getIFDLongArray(ifd, tag, false);
        if (TiffTools.isTiled(ifd) && byteCounts == null) {
            byteCounts = TiffTools.getIFDLongArray(ifd, 279, false);
        }
        if (byteCounts == null) {
            long[] offsets = TiffTools.getStripOffsets(ifd);
            int bytesPerSample = TiffTools.getBytesPerSample(ifd)[0];
            long imageWidth = TiffTools.getImageWidth(ifd);
            long imageLength = TiffTools.getImageLength(ifd);
            byteCounts = new long[offsets.length];
            int samples = TiffTools.getSamplesPerPixel(ifd);
            long imageSize = imageWidth * imageLength * (long)bytesPerSample * (long)(TiffTools.getPlanarConfiguration(ifd) == 2 ? 1 : samples);
            long count = imageSize / (long)byteCounts.length;
            Arrays.fill(byteCounts, count);
        }
        long[] counts = new long[byteCounts.length];
        if (TiffTools.getCompression(ifd) == 5) {
            for (int i = 0; i < byteCounts.length; ++i) {
                counts[i] = byteCounts[i] * 2L;
            }
        } else {
            System.arraycopy(byteCounts, 0, counts, 0, counts.length);
        }
        if (TiffTools.isTiled(ifd)) {
            return counts;
        }
        long rowsPerStrip = TiffTools.getRowsPerStrip(ifd)[0];
        long numStrips = (TiffTools.getImageLength(ifd) + rowsPerStrip - 1L) / rowsPerStrip;
        if (TiffTools.getPlanarConfiguration(ifd) == 2) {
            numStrips *= (long)TiffTools.getSamplesPerPixel(ifd);
        }
        if ((long)counts.length < numStrips) {
            throw new FormatException("StripByteCounts length (" + counts.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        return counts;
    }

    public static long[] getRowsPerStrip(Hashtable ifd) throws FormatException {
        if (TiffTools.isTiled(ifd)) {
            return new long[]{TiffTools.getImageLength(ifd)};
        }
        long[] rowsPerStrip = TiffTools.getIFDLongArray(ifd, 278, false);
        if (rowsPerStrip == null) {
            return new long[]{TiffTools.getImageLength(ifd)};
        }
        long imageLength = TiffTools.getImageLength(ifd);
        for (int i = 0; i < rowsPerStrip.length; ++i) {
            rowsPerStrip[i] = Math.min(rowsPerStrip[i], imageLength);
        }
        long rows = rowsPerStrip[0];
        for (int i = 1; i < rowsPerStrip.length; ++i) {
            if (rows == rowsPerStrip[i]) continue;
            throw new FormatException("Sorry, non-uniform RowsPerStrip is not supported");
        }
        return rowsPerStrip;
    }

    public static boolean isSupportedCompression(int compression) {
        return compression == 1 || compression == 5 || compression == 7 || compression == 33003;
    }

    public static byte[] compress(byte[] input, Hashtable ifd) throws FormatException, IOException {
        int compression = TiffTools.getIFDIntValue(ifd, 259, false, 1);
        if (!TiffTools.isSupportedCompression(compression)) {
            String compressionName = TiffTools.getCodecName(compression);
            if (compressionName != null) {
                throw new FormatException("Sorry, " + compressionName + " compression mode is not supported");
            }
            throw new FormatException("Unknown Compression type (" + compression + ")");
        }
        CodecOptions options = new CodecOptions();
        options.width = (int)TiffTools.getImageWidth(ifd);
        options.height = (int)TiffTools.getImageLength(ifd);
        options.bitsPerSample = TiffTools.getBitsPerSample(ifd)[0];
        options.channels = TiffTools.getSamplesPerPixel(ifd);
        options.littleEndian = TiffTools.isLittleEndian(ifd);
        options.interleaved = true;
        options.signed = false;
        if (compression == 1) {
            return input;
        }
        if (compression == 5) {
            return new LZWCodec().compress(input, options);
        }
        if (compression == 7) {
            return new JPEGCodec().compress(input, options);
        }
        if (compression == 33003) {
            return new JPEG2000Codec().compress(input, options);
        }
        throw new FormatException("Unhandled compression (" + compression + ")");
    }

    public static void difference(byte[] input, int[] bitsPerSample, long width, int planarConfig, int predictor) throws FormatException {
        if (predictor == 2) {
            TiffTools.debug("performing horizontal differencing");
            for (int b = input.length - 1; b >= 0; --b) {
                if ((long)(b / bitsPerSample.length) % width == 0L) continue;
                int n = b;
                input[n] = (byte)(input[n] - input[b - bitsPerSample.length]);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    public static void debug(String message) {
        int debugLevel;
        int n = debugLevel = FormatHandler.debug ? FormatHandler.debugLevel : 0;
        if (debugLevel >= 3) {
            String msg = System.currentTimeMillis() + ": " + message;
            if (debugLevel > 3) {
                LogTools.trace(msg);
            } else {
                LogTools.println(msg);
            }
        }
    }

    public static void printIFD(Hashtable ifd) {
        StringBuffer sb = new StringBuffer();
        sb.append("IFD directory entry values:");
        Integer[] tags = ifd.keySet().toArray(new Integer[0]);
        for (int entry = 0; entry < tags.length; ++entry) {
            sb.append("\n\t");
            sb.append(TiffTools.getIFDTagName(tags[entry]));
            sb.append("=");
            Object value = ifd.get(tags[entry]);
            if (value instanceof Boolean || value instanceof Number || value instanceof String) {
                sb.append(value);
                continue;
            }
            ReflectedUniverse r = new ReflectedUniverse();
            r.setVar("value", value);
            try {
                int nElements = (Integer)r.exec("value.length");
                for (int i = 0; i < nElements; ++i) {
                    r.setVar("index", i);
                    sb.append(r.exec("value[index]"));
                    if (i >= nElements - 1) continue;
                    sb.append(",");
                }
                continue;
            }
            catch (ReflectException re) {
                // empty catch block
            }
        }
        TiffTools.debug(sb.toString());
    }

    public static String getCodecName(int codec) {
        switch (codec) {
            case 1: {
                return "Uncompressed";
            }
            case 2: {
                return "CCITT Group 3 1-Dimensional Modified Huffman";
            }
            case 3: {
                return "CCITT T.4 bi-level encoding (Group 3 Fax)";
            }
            case 4: {
                return "CCITT T.6 bi-level encoding (Group 4 Fax)";
            }
            case 5: {
                return "LZW";
            }
            case 7: 
            case 33007: {
                return "JPEG";
            }
            case 32773: {
                return "PackBits";
            }
            case 8: 
            case 32946: {
                return "Deflate (Zlib)";
            }
            case 32809: {
                return "Thunderscan";
            }
            case 33003: {
                return "JPEG-2000";
            }
            case 34713: {
                return "Nikon";
            }
            case 65535: {
                return "LuraWave";
            }
        }
        return null;
    }
}

