/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class FEIReader
extends FormatReader {
    private int originalWidth;

    public FEIReader() {
        super("FEI", "img");
        this.blockCheckLen = 2;
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        return stream.readString(this.blockCheckLen).startsWith("XL");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.in.seek(1536L);
        byte[] segment = new byte[this.getSizeX() / 2];
        int skip = this.originalWidth / 2 - this.getSizeX() / 2;
        int halfRow = this.getSizeX() / 2;
        for (int q = 0; q < 4; ++q) {
            for (int row = q; row < h; row += 4) {
                for (int s = 0; s < 2; ++s) {
                    this.in.read(segment);
                    this.in.skipBytes(skip);
                    for (int col = s; col < w; col += 2) {
                        buf[row * w + col] = segment[col / 2];
                    }
                }
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("FEIReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Reading file header");
        this.in.seek(1306L);
        this.in.order(true);
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        this.originalWidth = this.getSizeX();
        if (1424 < this.getSizeX()) {
            this.core[0].sizeX = 1424;
            this.core[0].sizeY = 968;
        } else {
            this.core[0].sizeX = 712;
            this.core[0].sizeY = 484;
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].littleEndian = true;
        this.core[0].pixelType = 1;
        this.core[0].rgb = false;
        this.core[0].indexed = false;
        this.core[0].interleaved = false;
        this.core[0].dimensionOrder = "XYCZT";
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

