/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class InCellReader
extends FormatReader {
    private Image[][][][] imageFiles;
    private MinimalTiffReader tiffReader;
    private int seriesCount;
    private Vector emWaves;
    private Vector exWaves;
    private int totalImages;
    private String creationDate;
    private String rowName;
    private String colName;
    private int startRow;
    private int startCol;
    private int fieldCount;
    private int wellRows;
    private int wellCols;
    private Hashtable wellCoordinates;
    private Vector posX;
    private Vector posY;
    private int firstRow;
    private int firstCol;
    private int lastCol;
    private boolean[][] exclude;
    private Vector channelsPerTimepoint;
    private boolean oneTimepointPerSeries;
    private int totalChannels;

    public InCellReader() {
        super("InCell 1000", "xdce");
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader.get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int[] coordinates = this.getZCTCoords(no);
        int well = this.getWellFromSeries(this.getSeries());
        int field = this.getFieldFromSeries(this.getSeries());
        int timepoint = this.oneTimepointPerSeries ? this.getSeries() % this.channelsPerTimepoint.size() : coordinates[2];
        int image = this.getIndex(coordinates[0], coordinates[1], 0);
        this.tiffReader.setId(this.imageFiles[well][field][timepoint][image].filename);
        return this.tiffReader.openBytes(0, buf, x, y, w, h);
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        Vector<String> files = new Vector<String>();
        if (this.imageFiles != null) {
            for (int well = 0; well < this.wellRows * this.wellCols; ++well) {
                for (int field = 0; field < this.fieldCount; ++field) {
                    for (int time = 0; time < this.imageFiles[well][field].length; ++time) {
                        for (int p = 0; p < this.imageFiles[well][field][time].length; ++p) {
                            if (this.imageFiles[well][field][time][p] == null) continue;
                            files.add(this.imageFiles[well][field][time][p].filename);
                        }
                    }
                }
            }
        }
        files.add(this.currentId);
        return files.toArray(new String[0]);
    }

    public void close() throws IOException {
        super.close();
        this.imageFiles = null;
        if (this.tiffReader != null) {
            this.tiffReader.close();
        }
        this.tiffReader = null;
        this.seriesCount = 0;
        this.totalImages = 0;
        this.exWaves = null;
        this.emWaves = null;
        this.wellCoordinates = null;
        this.posX = null;
        this.posY = null;
        this.creationDate = null;
        this.wellCols = 0;
        this.wellRows = 0;
        this.startCol = 0;
        this.startRow = 0;
        this.fieldCount = 0;
        this.exclude = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int timepoint;
        int field;
        int well;
        int i;
        this.debug("InCellReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.firstRow = Integer.MAX_VALUE;
        this.firstCol = Integer.MAX_VALUE;
        this.lastCol = Integer.MIN_VALUE;
        this.emWaves = new Vector();
        this.exWaves = new Vector();
        this.channelsPerTimepoint = new Vector();
        this.wellCoordinates = new Hashtable();
        this.posX = new Vector();
        this.posY = new Vector();
        byte[] b = new byte[(int)this.in.length()];
        this.in.read(b);
        this.core[0].dimensionOrder = "XYZCT";
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        DefaultHandler handler = new MinimalInCellHandler();
        DataTools.parseXML(b, handler);
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        Vector wells = new Vector();
        this.seriesCount = 0;
        if (this.exclude != null) {
            for (int row = 0; row < this.wellRows; ++row) {
                for (int col = 0; col < this.wellCols; ++col) {
                    if (this.exclude[row][col]) continue;
                    this.seriesCount += this.imageFiles[row * this.wellCols + col].length;
                }
            }
            int expectedSeries = this.totalImages / (this.getSizeZ() * this.getSizeC() * this.getSizeT());
            this.seriesCount = Math.min(this.seriesCount, expectedSeries);
        } else {
            this.seriesCount = this.totalImages / (this.getSizeZ() * this.getSizeC() * this.getSizeT());
        }
        this.totalChannels = this.getSizeC();
        this.oneTimepointPerSeries = false;
        for (int i2 = 1; i2 < this.channelsPerTimepoint.size(); ++i2) {
            if (this.channelsPerTimepoint.get(i2).equals(this.channelsPerTimepoint.get(i2 - 1))) continue;
            this.oneTimepointPerSeries = true;
            break;
        }
        if (this.oneTimepointPerSeries) {
            int imageCount = 0;
            for (int i3 = 0; i3 < this.channelsPerTimepoint.size(); ++i3) {
                int c = (Integer)this.channelsPerTimepoint.get(i3);
                imageCount += c * this.getSizeZ();
            }
            this.seriesCount = this.totalImages / imageCount * this.getSizeT();
        }
        int sizeT = this.getSizeT();
        int sizeC = this.getSizeC();
        int z = this.getSizeZ();
        int t = this.oneTimepointPerSeries ? 1 : this.getSizeT();
        this.core = new CoreMetadata[this.seriesCount];
        for (int i4 = 0; i4 < this.seriesCount; ++i4) {
            int c = this.oneTimepointPerSeries ? (Integer)this.channelsPerTimepoint.get(i4 % sizeT) : sizeC;
            this.core[i4] = new CoreMetadata();
            this.core[i4].sizeZ = z;
            this.core[i4].sizeC = c;
            this.core[i4].sizeT = t;
            this.core[i4].imageCount = z * c * t;
            this.core[i4].dimensionOrder = "XYZCT";
        }
        this.tiffReader = new MinimalTiffReader();
        this.tiffReader.setId(this.imageFiles[this.getWellFromSeries((int)0)][this.getFieldFromSeries((int)0)][0][0].filename);
        boolean nextTiming = false;
        for (i = 0; i < this.seriesCount; ++i) {
            this.core[i].sizeX = this.tiffReader.getSizeX();
            this.core[i].sizeY = this.tiffReader.getSizeY();
            this.core[i].interleaved = this.tiffReader.isInterleaved();
            this.core[i].indexed = this.tiffReader.isIndexed();
            this.core[i].rgb = this.tiffReader.isRGB();
            this.core[i].pixelType = this.tiffReader.getPixelType();
            this.core[i].littleEndian = this.tiffReader.isLittleEndian();
        }
        MetadataTools.populatePixels(store, this, true);
        handler = new InCellHandler(store);
        DataTools.parseXML(b, handler);
        store.setInstrumentID("Instrument:0", 0);
        for (i = 0; i < this.seriesCount; ++i) {
            well = this.getWellFromSeries(i);
            field = this.getFieldFromSeries(i) + 1;
            timepoint = this.oneTimepointPerSeries ? i % this.channelsPerTimepoint.size() + 1 : -1;
            store.setImageID("Image:" + i, i);
            store.setImageInstrumentRef("Instrument:0", i);
            int wellRow = well / this.wellCols;
            int wellCol = well % this.wellCols;
            char rowChar = this.rowName.charAt(this.rowName.length() - 1);
            char colChar = this.colName.charAt(this.colName.length() - 1);
            String row = this.rowName.substring(0, this.rowName.length() - 1);
            String col = this.colName.substring(0, this.colName.length() - 1);
            row = Character.isDigit(rowChar) ? row + (wellRow + Integer.parseInt(String.valueOf(rowChar))) : row + (char)(rowChar + wellRow);
            col = Character.isDigit(colChar) ? col + (wellCol + Integer.parseInt(String.valueOf(colChar))) : col + (char)(colChar + wellCol);
            String imageName = "Well " + row + "-" + col + ", Field #" + field;
            if (timepoint >= 0) {
                imageName = imageName + ", Timepoint #" + timepoint;
            }
            store.setImageName(imageName, i);
            store.setImageCreationDate(this.creationDate, i);
        }
        for (i = 0; i < this.seriesCount; ++i) {
            well = this.getWellFromSeries(i);
            field = this.getFieldFromSeries(i);
            timepoint = this.oneTimepointPerSeries ? i % this.channelsPerTimepoint.size() : 0;
            for (int time = 0; time < this.getSizeT(); ++time) {
                if (!this.oneTimepointPerSeries) {
                    timepoint = time;
                }
                int c = (Integer)this.channelsPerTimepoint.get(timepoint);
                for (int q = 0; q < this.getSizeZ() * c; ++q) {
                    Image img = this.imageFiles[well][field][timepoint][q];
                    if (img == null) continue;
                    int plane = time * this.getSizeZ() * c + q;
                    store.setPlaneTimingDeltaT(img.deltaT, i, 0, plane);
                    store.setPlaneTimingExposureTime(img.exposure, i, 0, plane);
                }
            }
        }
        for (i = 0; i < this.seriesCount; ++i) {
            for (int q = 0; q < this.emWaves.size(); ++q) {
                store.setLogicalChannelEmWave((Integer)this.emWaves.get(q), i, q);
                store.setLogicalChannelExWave((Integer)this.exWaves.get(q), i, q);
            }
        }
        store.setPlateRowNamingConvention(this.rowName, 0);
        store.setPlateColumnNamingConvention(this.colName, 0);
        store.setPlateWellOriginX(new Double(0.5), 0);
        store.setPlateWellOriginY(new Double(0.5), 0);
        int[][] plate = new int[this.wellRows][this.wellCols];
        for (int i5 = 0; i5 < this.seriesCount; ++i5) {
            int well2 = this.getWellFromSeries(i5);
            int field2 = this.getFieldFromSeries(i5);
            store.setWellSampleIndex(new Integer(i5), 0, well2, field2);
            store.setWellSampleImageRef("Image:" + i5, 0, well2, field2);
            store.setWellSamplePosX((Float)this.posX.get(field2), 0, well2, field2);
            store.setWellSamplePosY((Float)this.posY.get(field2), 0, well2, field2);
        }
    }

    private int getFieldFromSeries(int series) {
        if (this.oneTimepointPerSeries) {
            series /= this.channelsPerTimepoint.size();
        }
        return series % this.fieldCount;
    }

    private int getWellFromSeries(int series) {
        if (this.oneTimepointPerSeries) {
            series /= this.channelsPerTimepoint.size();
        }
        int well = series / this.fieldCount;
        int wellRow = well / (this.lastCol - this.firstCol + 1);
        int wellCol = well % (this.lastCol - this.firstCol + 1);
        return (wellRow + this.firstRow) * this.wellCols + wellCol + this.firstCol;
    }

    static /* synthetic */ Image[][][][] access$002(InCellReader x0, Image[][][][] x1) {
        x0.imageFiles = x1;
        return x1;
    }

    static /* synthetic */ boolean[][] access$502(InCellReader x0, boolean[][] x1) {
        x0.exclude = x1;
        return x1;
    }

    class Image {
        public String filename;
        public Float deltaT;
        public Float exposure;

        Image() {
        }
    }

    class InCellHandler
    extends DefaultHandler {
        private String currentQName;
        private boolean openImage;
        private int nextEmWave = 0;
        private int nextExWave = 0;
        private MetadataStore store;
        private int nextPlate = 0;
        private int currentRow = -1;
        private int currentCol = -1;
        private int currentField = 0;
        private int currentImage;
        private Float timestamp;
        private Float exposure;

        public InCellHandler(MetadataStore store) {
            this.store = store;
        }

        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            if (this.currentQName.equals("UserComment")) {
                this.store.setImageDescription(value, 0);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("Image")) {
                InCellReader.this.wellCoordinates.put(new Integer(this.currentField), new int[]{this.currentRow, this.currentCol});
                this.openImage = false;
                int well = this.currentRow * InCellReader.this.wellCols + this.currentCol;
                if (InCellReader.this.imageFiles[well][this.currentField][this.currentImage][0] != null) {
                    ((InCellReader)InCellReader.this).imageFiles[well][this.currentField][this.currentImage][0].deltaT = this.timestamp;
                    ((InCellReader)InCellReader.this).imageFiles[well][this.currentField][this.currentImage][0].exposure = this.exposure;
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            int i;
            this.currentQName = qName;
            for (i = 0; i < attributes.getLength(); ++i) {
                InCellReader.this.addMeta(qName + " - " + attributes.getQName(i), attributes.getValue(i));
            }
            if (qName.equals("Image")) {
                this.openImage = true;
                float time = Float.parseFloat(attributes.getValue("acquisition_time_ms"));
                this.timestamp = new Float(time / 1000.0f);
            } else if (qName.equals("Identifier")) {
                int t;
                this.currentField = Integer.parseInt(attributes.getValue("field_index"));
                int z = Integer.parseInt(attributes.getValue("z_index"));
                int c = Integer.parseInt(attributes.getValue("wave_index"));
                this.currentImage = t = Integer.parseInt(attributes.getValue("time_index"));
            } else if (qName.equals("Creation")) {
                String date = attributes.getValue("date");
                String time = attributes.getValue("time");
                InCellReader.this.creationDate = date + "T" + time;
            } else if (qName.equals("ObjectiveCalibration")) {
                this.store.setObjectiveNominalMagnification(new Integer((int)Float.parseFloat(attributes.getValue("magnification"))), 0, 0);
                this.store.setObjectiveModel(attributes.getValue("objective_name"), 0, 0);
                this.store.setObjectiveLensNA(new Float(attributes.getValue("numerical_aperture")), 0, 0);
                this.store.setObjectiveCorrection("Unknown", 0, 0);
                this.store.setObjectiveImmersion("Unknown", 0, 0);
                Float pixelSizeX = new Float(attributes.getValue("pixel_width"));
                Float pixelSizeY = new Float(attributes.getValue("pixel_height"));
                Float refractive = new Float(attributes.getValue("refractive_index"));
                this.store.setObjectiveID("Objective:0", 0, 0);
                for (int i2 = 0; i2 < InCellReader.this.getSeriesCount(); ++i2) {
                    this.store.setObjectiveSettingsObjective("Objective:0", i2);
                    this.store.setObjectiveSettingsRefractiveIndex(refractive, i2);
                    this.store.setDimensionsPhysicalSizeX(pixelSizeX, i2, 0);
                    this.store.setDimensionsPhysicalSizeY(pixelSizeY, i2, 0);
                }
            } else if (qName.equals("ExcitationFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.exWaves.add(new Integer(wave));
                }
            } else if (qName.equals("EmissionFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.emWaves.add(new Integer(wave));
                }
            } else if (qName.equals("Camera")) {
                this.store.setDetectorModel(attributes.getValue("name"), 0, 0);
                this.store.setDetectorType("Unknown", 0, 0);
                this.store.setDetectorID("Detector:0", 0, 0);
                for (i = 0; i < InCellReader.this.getSeriesCount(); ++i) {
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsDetector("Detector:0", i, q);
                    }
                }
            } else if (qName.equals("Binning")) {
                String binning = attributes.getValue("value");
                for (int i3 = 0; i3 < InCellReader.this.getSeriesCount(); ++i3) {
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsBinning(binning, i3, q);
                    }
                }
            } else if (qName.equals("Gain")) {
                Float gain = new Float(attributes.getValue("value"));
                for (int i4 = 0; i4 < InCellReader.this.getSeriesCount(); ++i4) {
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsGain(gain, i4, q);
                    }
                }
            } else if (qName.equals("PlateTemperature")) {
                Float temperature = new Float(attributes.getValue("value"));
                for (int i5 = 0; i5 < InCellReader.this.getSeriesCount(); ++i5) {
                    this.store.setImagingEnvironmentTemperature(temperature, i5);
                }
            } else if (qName.equals("Plate")) {
                this.store.setPlateName(new Location(InCellReader.this.getCurrentFile()).getName(), this.nextPlate);
                for (int r = 0; r < InCellReader.this.wellRows; ++r) {
                    for (int c = 0; c < InCellReader.this.wellCols; ++c) {
                        this.store.setWellRow(new Integer(r), this.nextPlate, r * InCellReader.this.wellCols + c);
                        this.store.setWellColumn(new Integer(c), this.nextPlate, r * InCellReader.this.wellCols + c);
                    }
                }
                ++this.nextPlate;
            } else if (qName.equals("Row")) {
                this.currentRow = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Column")) {
                this.currentCol = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Exposure") && this.openImage) {
                float exp = Float.parseFloat(attributes.getValue("time"));
                this.exposure = new Float(exp / 1000.0f);
            } else if (qName.equals("NamingRows")) {
                InCellReader.this.rowName = attributes.getValue("begin");
                try {
                    InCellReader.this.startRow = Integer.parseInt(InCellReader.this.rowName);
                }
                catch (NumberFormatException e) {
                    InCellReader.this.startRow = InCellReader.this.rowName.charAt(0) - 65 + 1;
                }
            } else if (qName.equals("NamingColumns")) {
                InCellReader.this.colName = attributes.getValue("begin");
                try {
                    InCellReader.this.startCol = Integer.parseInt(InCellReader.this.colName);
                }
                catch (NumberFormatException e) {
                    InCellReader.this.startCol = InCellReader.this.colName.charAt(0) - 65 + 1;
                }
            } else if (qName.equals("offset_point")) {
                InCellReader.this.posX.add(new Float(attributes.getValue("x")));
                InCellReader.this.posY.add(new Float(attributes.getValue("y")));
            }
        }
    }

    class MinimalInCellHandler
    extends DefaultHandler {
        private String currentImageFile;
        private int wellRow;
        private int wellCol;
        private int nChannels = 0;

        MinimalInCellHandler() {
        }

        public void endElement(String uri, String localName, String qName) {
            block6: {
                block7: {
                    block5: {
                        if (!qName.equals("PlateMap")) break block5;
                        InCellReader.access$002(InCellReader.this, new Image[InCellReader.this.wellRows * InCellReader.this.wellCols][InCellReader.this.fieldCount][InCellReader.this.getSizeT()][]);
                        for (int well = 0; well < InCellReader.this.wellRows * InCellReader.this.wellCols; ++well) {
                            for (int field = 0; field < InCellReader.this.fieldCount; ++field) {
                                for (int t = 0; t < InCellReader.this.getSizeT(); ++t) {
                                    int channels = (Integer)InCellReader.this.channelsPerTimepoint.get(t);
                                    ((InCellReader)InCellReader.this).imageFiles[well][field][t] = new Image[channels * InCellReader.this.getSizeZ()];
                                }
                            }
                        }
                        break block6;
                    }
                    if (!qName.equals("TimePoint")) break block7;
                    InCellReader.this.channelsPerTimepoint.add(new Integer(this.nChannels));
                    this.nChannels = 0;
                    break block6;
                }
                if (!qName.equals("Times")) break block6;
                if (InCellReader.this.channelsPerTimepoint.size() == 0) {
                    InCellReader.this.channelsPerTimepoint.add(new Integer(InCellReader.this.getSizeC()));
                }
                for (int i = 0; i < InCellReader.this.channelsPerTimepoint.size(); ++i) {
                    int c = (Integer)InCellReader.this.channelsPerTimepoint.get(i);
                    if (c != 0) continue;
                    InCellReader.this.channelsPerTimepoint.setElementAt(new Integer(InCellReader.this.getSizeC()), i);
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Plate")) {
                InCellReader.this.wellRows = Integer.parseInt(attributes.getValue("rows"));
                InCellReader.this.wellCols = Integer.parseInt(attributes.getValue("columns"));
            } else if (qName.equals("Exclude")) {
                if (InCellReader.this.exclude == null) {
                    InCellReader.access$502(InCellReader.this, new boolean[InCellReader.this.wellRows][InCellReader.this.wellCols]);
                }
                int row = Integer.parseInt(attributes.getValue("row")) - 1;
                int col = Integer.parseInt(attributes.getValue("col")) - 1;
                ((InCellReader)InCellReader.this).exclude[row][col] = true;
            } else if (qName.equals("Images")) {
                InCellReader.this.totalImages = Integer.parseInt(attributes.getValue("number"));
            } else if (qName.equals("Image")) {
                String file2 = attributes.getValue("filename");
                String thumb = attributes.getValue("thumbnail");
                Location current = new Location(InCellReader.this.currentId).getAbsoluteFile();
                Location imageFile = new Location(current.getParentFile(), file2);
                this.currentImageFile = imageFile.getAbsolutePath();
            } else if (qName.equals("Identifier")) {
                int field = Integer.parseInt(attributes.getValue("field_index"));
                int z = Integer.parseInt(attributes.getValue("z_index"));
                int c = Integer.parseInt(attributes.getValue("wave_index"));
                int t = Integer.parseInt(attributes.getValue("time_index"));
                int channels = (Integer)InCellReader.this.channelsPerTimepoint.get(t);
                int index = FormatTools.getIndex("XYZCT", InCellReader.this.getSizeZ(), channels, 1, InCellReader.this.getSizeZ() * channels, z, c, 0);
                Image img = new Image();
                img.filename = this.currentImageFile;
                ((InCellReader)InCellReader.this).imageFiles[this.wellRow * ((InCellReader)InCellReader.this).wellCols + this.wellCol][field][t][index] = img;
            } else if (qName.equals("offset_point")) {
                InCellReader.this.fieldCount++;
            } else if (qName.equals("TimePoint")) {
                ++((InCellReader)InCellReader.this).core[0].sizeT;
            } else if (qName.equals("Wavelength")) {
                ++((InCellReader)InCellReader.this).core[0].sizeC;
            } else if (qName.equals("AcqWave")) {
                ++this.nChannels;
            } else if (qName.equals("ZDimensionParameters")) {
                String nz = attributes.getValue("number_of_slices");
                if (nz != null) {
                    ((InCellReader)InCellReader.this).core[0].sizeZ = Integer.parseInt(nz);
                } else {
                    ((InCellReader)InCellReader.this).core[0].sizeZ = 1;
                }
            } else if (qName.equals("Row")) {
                this.wellRow = Integer.parseInt(attributes.getValue("number")) - 1;
                InCellReader.this.firstRow = Math.min(InCellReader.this.firstRow, this.wellRow);
            } else if (qName.equals("Column")) {
                this.wellCol = Integer.parseInt(attributes.getValue("number")) - 1;
                InCellReader.this.firstCol = Math.min(InCellReader.this.firstCol, this.wellCol);
                InCellReader.this.lastCol = Math.max(InCellReader.this.lastCol, this.wellCol);
            }
        }
    }
}

