/*
 * Decompiled with CFR 0.152.
 */
package bioformatsconverter;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.APNGWriter;
import loci.formats.out.OMETiffWriter;

public class Main {
    private static boolean imageopen = false;
    private static String filename = "";
    private static boolean collectmeta = true;
    private static boolean collectmetaorig = false;
    private static boolean filtermeta = true;
    private static int savemode = 0;
    private static int stackmode = 0;

    public static void progress(int i, int size) {
        float prog = (float)(i + 1) / (float)size * 100.0f;
        prog = Main.Round(prog, 2);
        System.out.print("\r\r      Progress = " + prog + " %");
        if ((double)prog == 100.0) {
            System.out.println("\n");
        }
    }

    public static float Round(float Rval, int Rpl) {
        float p = (float)Math.pow(10.0, Rpl);
        float tmp = Math.round(Rval *= p);
        return tmp / p;
    }

    public static void saveImageToOMETIFF(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        myimagereader.setId(in_fn);
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)myimagereader.getMetadataStore());
        OMEXMLMetadata omexmlmetadata = (OMEXMLMetadata)metaretrieve;
        int numbimgs = myimagereader.getImageCount();
        int xres = myimagereader.getSizeX();
        int yres = myimagereader.getSizeY();
        int zres = myimagereader.getSizeZ();
        int cres = myimagereader.getSizeC();
        int tres = myimagereader.getSizeT();
        String dimorder = myimagereader.getDimensionOrder();
        System.out.println("    Image INFO:");
        System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        System.out.println("    Number of images to save: " + numbimgs);
        System.out.println("    Dimensions Order: " + dimorder);
        System.out.println("    (voxel size) X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        System.out.println("    =============================================");
        System.out.println("    Saving to OME-TIFF...");
        FileWriter fstream = new FileWriter(out_dn + "metadata.txt");
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("Image Dimensions (XYZ)(CT): (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        out.newLine();
        out.write("Voxel Physical Size X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        out.newLine();
        out.write("TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        out.newLine();
        out.write("TimeStepSize: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        out.close();
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        BufferedImage buffimage = null;
        boolean eofiles = false;
        for (int t = 0; t < tres; ++t) {
            int tdigits = Integer.toString(t).length();
            String tnumb = Integer.toString(t);
            if (tdigits == 1) {
                tnumb = "00" + tnumb;
            } else if (tdigits == 2) {
                tnumb = "0" + tnumb;
            }
            String timeoutdirname = out_dn + "T" + tnumb + "/";
            new File(timeoutdirname).mkdir();
            for (int z = 0; z < zres; ++z) {
                int zdigits = Integer.toString(z).length();
                String znumb = Integer.toString(z);
                if (zdigits == 1) {
                    znumb = "00" + znumb;
                } else if (zdigits == 2) {
                    znumb = "0" + znumb;
                }
                for (int c = 0; c < cres; ++c) {
                    int cdigits = Integer.toString(c).length();
                    String cnumb = Integer.toString(c);
                    if (cdigits == 1) {
                        cnumb = "00" + cnumb;
                    } else if (cdigits == 2) {
                        cnumb = "0" + cnumb;
                    }
                    String channeloutdirname = timeoutdirname + "C" + cnumb + "/";
                    new File(channeloutdirname).mkdir();
                    int i = myimagereader.getIndex(z, c, t);
                    eofiles = false;
                    if (i == numbimgs) {
                        eofiles = true;
                    }
                    buffimage = myimagereader.openImage(i);
                    String savefilename = channeloutdirname + infilname + "_T" + tnumb + "_Z" + znumb + "_C" + cnumb + ".tif";
                    Main.progress(i, numbimgs);
                    if (z == 0) {
                        fstream = new FileWriter(channeloutdirname + "voxelscale.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(0, 0));
                        out.newLine();
                        out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(0, 0));
                        out.newLine();
                        out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
                        out.newLine();
                        out.close();
                        fstream = new FileWriter(channeloutdirname + "voxelspacing.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(0, 0));
                        out.newLine();
                        out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(0, 0));
                        out.newLine();
                        out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
                        out.newLine();
                        out.close();
                    }
                    OMETiffWriter ometiffwriter = new OMETiffWriter();
                    ometiffwriter.setMetadataRetrieve(metaretrieve);
                    ometiffwriter.setId(savefilename);
                    ometiffwriter.saveImage(buffimage, false);
                }
            }
        }
    }

    public static void saveImageToOMETIFF_Zstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        int numbimgs = myimagereader.getImageCount();
        int xres = myimagereader.getSizeX();
        int yres = myimagereader.getSizeY();
        int zres = myimagereader.getSizeZ();
        int cres = myimagereader.getSizeC();
        int tres = myimagereader.getSizeT();
        String dimorder = myimagereader.getDimensionOrder();
        System.out.println("    Image INFO:");
        System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        System.out.println("    Number of images to save: " + numbimgs);
        System.out.println("    Dimensions Order: " + dimorder);
        System.out.println("    (voxel size) X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        System.out.println("    =============================================");
        System.out.println("    Saving to OME-TIFF...");
        BufferedImage buffimage = null;
        boolean eostack = false;
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        for (int t = 0; t < tres; ++t) {
            int tdigits = Integer.toString(t).length();
            String tnumb = Integer.toString(t);
            if (tdigits == 1) {
                tnumb = "T00" + tnumb;
            } else if (tdigits == 2) {
                tnumb = "T0" + tnumb;
            }
            for (int c = 0; c < cres; ++c) {
                int cdigits = Integer.toString(c).length();
                String cnumb = Integer.toString(c);
                if (cdigits == 1) {
                    cnumb = "C00" + cnumb;
                } else if (cdigits == 2) {
                    cnumb = "C0" + cnumb;
                }
                String savefilename = out_dn + tnumb + "_" + cnumb + "_" + infilname + ".tiff";
                OMETiffWriter ometiffwriter = new OMETiffWriter();
                ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
                ometiffwriter.setId(savefilename);
                for (int z = 0; z < zres; ++z) {
                    int i = myimagereader.getIndex(z, c, t);
                    Main.progress(i, numbimgs);
                    eostack = false;
                    if (z == zres - 1) {
                        eostack = true;
                    }
                    buffimage = myimagereader.openImage(i);
                    metarestore.setPixelsSizeC(1, z, 0);
                    metarestore.setPixelsSizeT(1, z, 0);
                    metarestore.setPixelsSizeZ(zres, z, 0);
                    ometiffwriter.saveImage(buffimage, eostack);
                }
            }
        }
    }

    public static void saveImageToOMETIFF_ZCstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        int numbimgs = myimagereader.getImageCount();
        int xres = myimagereader.getSizeX();
        int yres = myimagereader.getSizeY();
        int zres = myimagereader.getSizeZ();
        int cres = myimagereader.getSizeC();
        int tres = myimagereader.getSizeT();
        String dimorder = myimagereader.getDimensionOrder();
        System.out.println("    Image INFO:");
        System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        System.out.println("    Number of images to save: " + numbimgs);
        System.out.println("    Dimensions Order: " + dimorder);
        System.out.println("    (voxel size) X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        System.out.println("    =============================================");
        System.out.println("    Saving to OME-TIFF...");
        BufferedImage buffimage = null;
        boolean eostack = false;
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        for (int t = 0; t < tres; ++t) {
            int tdigits = Integer.toString(t).length();
            String tnumb = Integer.toString(t);
            if (tdigits == 1) {
                tnumb = "T00" + tnumb;
            } else if (tdigits == 2) {
                tnumb = "T0" + tnumb;
            }
            String savefilename = out_dn + tnumb + "_" + infilname + ".tiff";
            OMETiffWriter ometiffwriter = new OMETiffWriter();
            ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
            ometiffwriter.setId(savefilename);
            for (int c = 0; c < cres; ++c) {
                for (int z = 0; z < zres; ++z) {
                    int i = myimagereader.getIndex(z, c, t);
                    Main.progress(i, numbimgs);
                    eostack = false;
                    if (c * (zres - 1) + z == cres * (zres - 1)) {
                        eostack = true;
                    }
                    buffimage = myimagereader.openImage(i);
                    metarestore.setPixelsSizeC(cres, z, 0);
                    metarestore.setPixelsSizeT(1, z, 0);
                    metarestore.setPixelsSizeZ(zres, z, 0);
                    ometiffwriter.saveImage(buffimage, eostack);
                }
            }
        }
    }

    public static void saveImageToOMETIFF_ZCTstack(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        try {
            myimagereader.setId(in_fn);
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        MetadataStore metarestore = myimagereader.getMetadataStore();
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)metarestore);
        int numbimgs = myimagereader.getImageCount();
        int xres = myimagereader.getSizeX();
        int yres = myimagereader.getSizeY();
        int zres = myimagereader.getSizeZ();
        int cres = myimagereader.getSizeC();
        int tres = myimagereader.getSizeT();
        String dimorder = myimagereader.getDimensionOrder();
        System.out.println("    Image INFO:");
        System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        System.out.println("    Number of images to save: " + numbimgs);
        System.out.println("    Dimensions Order: " + dimorder);
        System.out.println("    (voxel size) X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        System.out.println("    =============================================");
        System.out.println("    Saving to OME-TIFF...");
        BufferedImage buffimage = null;
        boolean eostack = false;
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        String savefilename = out_dn + "_" + infilname + ".tiff";
        metarestore.setPixelsSizeC(cres, 0, 0);
        metarestore.setPixelsSizeT(tres, 0, 0);
        metarestore.setPixelsSizeZ(zres, 0, 0);
        OMETiffWriter ometiffwriter = new OMETiffWriter();
        ometiffwriter.setMetadataRetrieve((MetadataRetrieve)((Object)metarestore));
        ometiffwriter.setId(savefilename);
        for (int t = 0; t < tres; ++t) {
            for (int c = 0; c < cres; ++c) {
                for (int z = 0; z < zres; ++z) {
                    int i = myimagereader.getIndex(z, c, t);
                    Main.progress(i, numbimgs);
                    eostack = false;
                    if (i == t * c * z - 1) {
                        eostack = true;
                    }
                    buffimage = myimagereader.openImage(i);
                    ometiffwriter.saveImage(buffimage, eostack);
                }
            }
        }
    }

    public static void saveImageToPNG(String in_fn, String out_dn) throws Exception {
        if (in_fn.length() == 0) {
            System.out.println("\nERROR: Input filename is NULL!\n");
            return;
        }
        if (out_dn.length() == 0) {
            System.out.println("\nERROR: Output dirname is NULL!\n");
            return;
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        ClassList defaultClasses = new ClassList("readers.txt", IFormatReader.class);
        IFormatReader myimagereader = new ImageReader(defaultClasses);
        myimagereader.setMetadataCollected(collectmeta);
        myimagereader.setOriginalMetadataPopulated(collectmetaorig);
        myimagereader.setMetadataFiltered(filtermeta);
        myimagereader.setMetadataStore(meta);
        myimagereader = new ChannelSeparator(myimagereader);
        myimagereader.setId(in_fn);
        MetadataRetrieve metaretrieve = (MetadataRetrieve)((Object)myimagereader.getMetadataStore());
        OMEXMLMetadata omexmlmetadata = (OMEXMLMetadata)metaretrieve;
        int numbimgs = myimagereader.getImageCount();
        int xres = myimagereader.getSizeX();
        int yres = myimagereader.getSizeY();
        int zres = myimagereader.getSizeZ();
        int cres = myimagereader.getSizeC();
        int tres = myimagereader.getSizeT();
        String dimorder = myimagereader.getDimensionOrder();
        System.out.println("    Image INFO:");
        System.out.println("    (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        System.out.println("    Number of images to save: " + numbimgs);
        System.out.println("    Dimensions Order: " + dimorder);
        System.out.println("    (voxel size) X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        System.out.println("    TimeStep: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        System.out.println("    TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        System.out.println("    =============================================");
        System.out.println("    Saving to PNG...");
        FileWriter fstream = new FileWriter(out_dn + "metadata.txt");
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("Image Dimensions (XYZ)(CT): (" + xres + "," + yres + "," + zres + ") (" + cres + "," + tres + ")");
        out.newLine();
        out.write("Voxel Physical Size X: " + metaretrieve.getDimensionsPhysicalSizeX(0, 0) + " Y: " + metaretrieve.getDimensionsPhysicalSizeY(0, 0) + " Z: " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
        out.newLine();
        out.write("TimeStart: (sec) " + metaretrieve.getImageCreationDate(0));
        out.newLine();
        out.write("TimeStepSize: (sec) " + metaretrieve.getDimensionsTimeIncrement(0, 0));
        out.close();
        int index = in_fn.lastIndexOf("/");
        String infilname = index != -1 ? in_fn.substring(index + 1, in_fn.length()) : in_fn;
        infilname = infilname.replace('.', '_');
        BufferedImage buffimage = null;
        boolean eofiles = false;
        for (int t = 0; t < tres; ++t) {
            int tdigits = Integer.toString(t).length();
            String tnumb = Integer.toString(t);
            if (tdigits == 1) {
                tnumb = "00" + tnumb;
            } else if (tdigits == 2) {
                tnumb = "0" + tnumb;
            }
            String timeoutdirname = out_dn + infilname + "_T" + tnumb + "_";
            for (int z = 0; z < zres; ++z) {
                int zdigits = Integer.toString(z).length();
                String znumb = Integer.toString(z);
                if (zdigits == 1) {
                    znumb = "00" + znumb;
                } else if (zdigits == 2) {
                    znumb = "0" + znumb;
                }
                for (int c = 0; c < cres; ++c) {
                    int cdigits = Integer.toString(c).length();
                    String cnumb = Integer.toString(c);
                    if (cdigits == 1) {
                        cnumb = "00" + cnumb;
                    } else if (cdigits == 2) {
                        cnumb = "0" + cnumb;
                    }
                    String channeloutdirname = timeoutdirname + "C" + cnumb + "/";
                    new File(channeloutdirname).mkdir();
                    int i = myimagereader.getIndex(z, c, t);
                    eofiles = false;
                    if (i == numbimgs) {
                        eofiles = true;
                    }
                    buffimage = myimagereader.openImage(i);
                    String savefilename = channeloutdirname + infilname + "_T" + tnumb + "_Z" + znumb + "_C" + cnumb + ".png";
                    Main.progress(i, numbimgs);
                    if (z == 0) {
                        fstream = new FileWriter(channeloutdirname + "voxelscale.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(0, 0));
                        out.newLine();
                        out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(0, 0));
                        out.newLine();
                        out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
                        out.newLine();
                        out.close();
                        fstream = new FileWriter(channeloutdirname + "voxelspacing.txt");
                        out = new BufferedWriter(fstream);
                        out.write("x " + metaretrieve.getDimensionsPhysicalSizeX(0, 0));
                        out.newLine();
                        out.write("y " + metaretrieve.getDimensionsPhysicalSizeY(0, 0));
                        out.newLine();
                        out.write("z " + metaretrieve.getDimensionsPhysicalSizeZ(0, 0));
                        out.newLine();
                        out.close();
                    }
                    APNGWriter pngwriter = new APNGWriter();
                    pngwriter.setMetadataRetrieve(meta);
                    pngwriter.setId(savefilename);
                    pngwriter.saveImage(buffimage, true);
                    pngwriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readSettings(String fn) {
        File aFile = new File(fn);
        String filecontents = new String();
        filecontents = "";
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    filecontents = filecontents + line;
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            System.out.println("ERROR: Settings.txt file could not be found!");
        }
        StringTokenizer st = new StringTokenizer(filecontents);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("savemode:")) {
                token = st.nextToken();
                if (token.equals("TIFF")) {
                    System.out.println("savemode: TIFF");
                    savemode = 1;
                    continue;
                }
                if (!token.equals("PNG")) continue;
                System.out.println("savemode: PNG");
                savemode = 2;
                continue;
            }
            if (!token.equals("stackmode:")) continue;
            token = st.nextToken();
            if (token.equals("SINGLE_TIFFS")) {
                System.out.println("tiffmode: single tiffs");
                stackmode = 1;
                continue;
            }
            if (token.equals("Z_STACK_TIFFS")) {
                System.out.println("tiffmode: Z_STACK tiffs");
                stackmode = 2;
                continue;
            }
            if (token.equals("ZC_STACK_TIFFS")) {
                System.out.println("tiffmode: ZC_STACK tiffs");
                stackmode = 3;
                continue;
            }
            if (!token.equals("ZCT_STACK_TIFFS")) continue;
            System.out.println("tiffmode: ZCT_STACK tiffs");
            stackmode = 4;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("=============================================");
        System.out.println("BIOFORMATS CONVERTER v1.5");
        System.out.println("author: Jerome Avondo.");
        System.out.println("");
        System.out.println("=============================================");
        Main.readSettings("settings.txt");
        if (savemode == 0 || stackmode == 0) {
            System.out.println("ERROR: Reading the Setting.txt file");
            return;
        }
        System.out.println("=============================================");
        System.out.println("");
        String inputdir = "IN/";
        File dir = new File(inputdir);
        String[] children = dir.list();
        if (children == null) {
            System.out.println("ERROR: Could not find the IN/ directory!");
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            boolean fileexists;
            String current_file = inputdir + children[i];
            String outputsubdir = children[i];
            outputsubdir = outputsubdir.replace(".", "_");
            outputsubdir = outputsubdir + "/";
            boolean dircreate = new File("OUT/" + outputsubdir).mkdir();
            if (dircreate) {
                // empty if block
            }
            if (fileexists = new File(current_file).exists()) {
                System.out.println("=============================================");
                System.out.println("CURRENT FILE: " + current_file);
                System.out.println("File : " + (i + 1) + " of " + children.length);
                System.out.println("=============================================");
                if (savemode == 1) {
                    if (stackmode == 1) {
                        Main.saveImageToOMETIFF(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode == 2) {
                        Main.saveImageToOMETIFF_Zstack(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode == 3) {
                        Main.saveImageToOMETIFF_ZCstack(current_file, "OUT/" + outputsubdir);
                        continue;
                    }
                    if (stackmode != 4) continue;
                    Main.saveImageToOMETIFF_ZCTstack(current_file, "OUT/" + outputsubdir);
                    continue;
                }
                if (savemode != 2) continue;
                Main.saveImageToPNG(current_file, "OUT/" + outputsubdir);
                continue;
            }
            System.out.println("ERROR: Could not find " + current_file + " !");
            return;
        }
        System.out.println("=============================================");
        System.out.println("Finished...");
    }
}

