/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexReader
extends FormatReader {
    public static final int FLEX = 65200;
    protected double[][][] factors;
    private int binX;
    private int binY;
    private int plateCount;
    private int wellCount;
    private int fieldCount;
    private int wellRows;
    private int wellColumns;
    private Vector<String> channelNames;
    private Vector<Float> xPositions;
    private Vector<Float> yPositions;
    private Vector<Float> xSizes;
    private Vector<Float> ySizes;
    private Vector<String> cameraIDs;
    private Vector<String> objectiveIDs;
    private Vector<String> lightSourceIDs;
    private Hashtable<String, Vector<String>> lightSourceCombinationIDs;
    private Vector<String> cameraRefs;
    private Vector<String> binnings;
    private Vector<String> objectiveRefs;
    private Vector<String> lightSourceCombinationRefs;
    private Vector<String> filterSets;
    private Vector<String> measurementFiles;
    private String plateName;
    private String plateBarcode;
    private String[][] flexFiles;
    private IFDList[][] ifds;
    private int[][] wellNumber;

    public FlexReader() {
        super("Evotec Flex", "flex");
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        if (!noPixels) {
            for (int i = 0; i < this.flexFiles.length; ++i) {
                for (int j = 0; j < this.flexFiles[i].length; ++j) {
                    if (this.flexFiles[i][j] == null) continue;
                    files.add(this.flexFiles[i][j]);
                }
            }
        }
        for (String file2 : this.measurementFiles) {
            files.add(file2);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] lengths = new int[]{this.fieldCount, this.wellCount, this.plateCount};
        int[] pos = FormatTools.rasterToPosition(lengths, this.getSeries());
        int imageNumber = this.getImageCount() * pos[0] + no;
        int wellRow = this.wellNumber[pos[1]][0];
        int wellCol = this.wellNumber[pos[1]][1];
        if (this.wellCount == 1) {
            wellRow = 0;
            wellCol = 0;
        }
        IFD ifd = (IFD)this.ifds[wellRow][wellCol].get(imageNumber);
        RandomAccessInputStream s = new RandomAccessInputStream(this.flexFiles[wellRow][wellCol]);
        TiffParser tp = new TiffParser(s);
        int nBytes = ifd.getBitsPerSample()[0] / 8;
        byte[] bytes = tp.getSamples(ifd, buf, x, y, w, h);
        s.close();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int num = bytes.length / bpp;
        double factor = this.factors[wellRow][wellCol][imageNumber];
        if (factor != 1.0 || nBytes != bpp) {
            for (int i = num - 1; i >= 0; --i) {
                int q = nBytes == 1 ? bytes[i] & 0xFF : DataTools.bytesToInt(bytes, i * bpp, bpp, this.isLittleEndian());
                q = (int)((double)q * factor);
                DataTools.unpackBytes(q, buf, i * bpp, bpp, this.isLittleEndian());
            }
        } else {
            System.arraycopy(bytes, 0, buf, 0, bytes.length);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.factors = null;
            this.binY = 0;
            this.binX = 0;
            this.fieldCount = 0;
            this.wellCount = 0;
            this.plateCount = 0;
            this.channelNames = null;
            this.measurementFiles = null;
            this.ySizes = null;
            this.xSizes = null;
            this.lightSourceIDs = null;
            this.objectiveIDs = null;
            this.cameraIDs = null;
            this.lightSourceCombinationIDs = null;
            this.lightSourceCombinationRefs = null;
            this.binnings = null;
            this.objectiveRefs = null;
            this.cameraRefs = null;
            this.wellColumns = 0;
            this.wellRows = 0;
            this.yPositions = null;
            this.xPositions = null;
            this.filterSets = null;
            this.plateBarcode = null;
            this.plateName = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        this.debug("FlexReader.initFile(" + id + ")");
        super.initFile(id);
        this.measurementFiles = new Vector();
        boolean doGrouping = true;
        Location currentFile = new Location(id).getAbsoluteFile();
        int nRows = 0;
        int nCols = 0;
        Hashtable<String, String> v = new Hashtable<String, String>();
        try {
            String name = currentFile.getName();
            int[] well = this.getWell(name);
            if (well[0] > nRows) {
                nRows = well[0];
            }
            if (well[1] > nCols) {
                nCols = well[1];
            }
            v.put(well[0] + "," + well[1], currentFile.getAbsolutePath());
        }
        catch (NumberFormatException e) {
            this.traceDebug(e);
            doGrouping = false;
        }
        if (!this.isGroupFiles()) {
            doGrouping = false;
        }
        if (this.isGroupFiles()) {
            try {
                this.findMeasurementFiles(currentFile);
            }
            catch (NullPointerException e) {
                this.traceDebug(e);
            }
            catch (IOException e) {
                this.traceDebug(e);
            }
            if (this.measurementFiles.size() == 0) {
                this.warn("Measurement files not found.");
            }
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        if (doGrouping) {
            String[] files;
            Location dir = currentFile.getParentFile();
            for (String file2 : files = dir.list(true)) {
                if (file2.endsWith(".flex") && file2.length() == 14 && !id.endsWith(file2)) {
                    int[] well = this.getWell(file2);
                    if (well[0] > nRows) {
                        nRows = well[0];
                    }
                    if (well[1] > nCols) {
                        nCols = well[1];
                    }
                    String path = new Location(dir, file2).getAbsolutePath();
                    v.put(well[0] + "," + well[1], path);
                    continue;
                }
                if (id.endsWith(file2)) continue;
                doGrouping = false;
                break;
            }
            ++nRows;
            ++nCols;
            if (doGrouping) {
                this.flexFiles = new String[nRows][nCols];
                this.ifds = new IFDList[nRows][nCols];
                this.factors = new double[nRows][nCols][];
                this.wellCount = v.size();
                this.wellNumber = new int[this.wellCount][2];
                RandomAccessInputStream s = null;
                boolean firstFile = true;
                int currentWell = 0;
                for (int row = 0; row < this.flexFiles.length; ++row) {
                    for (int col = 0; col < this.flexFiles[row].length; ++col) {
                        this.flexFiles[row][col] = (String)v.get(row + "," + col);
                        if (this.flexFiles[row][col] == null) continue;
                        this.wellNumber[currentWell][0] = row;
                        this.wellNumber[currentWell][1] = col;
                        s = new RandomAccessInputStream(this.flexFiles[row][col]);
                        TiffParser tp = new TiffParser(s);
                        this.ifds[row][col] = tp.getIFDs();
                        s.close();
                        this.parseFlexFile(currentWell, row, col, firstFile, store);
                        if (firstFile) {
                            firstFile = false;
                        }
                        ++currentWell;
                    }
                }
            }
        }
        if (!doGrouping) {
            this.wellCount = 1;
            this.flexFiles = new String[1][1];
            this.ifds = new IFDList[1][1];
            this.factors = new double[1][1][];
            this.flexFiles[0][0] = currentFile.getAbsolutePath();
            this.wellNumber = new int[][]{this.getWell(this.flexFiles[0][0])};
            RandomAccessInputStream s = new RandomAccessInputStream(this.flexFiles[0][0]);
            TiffParser tp = new TiffParser(s);
            this.ifds[0][0] = tp.getIFDs();
            s.close();
            this.parseFlexFile(0, 0, 0, true, store);
        }
        MetadataTools.populatePixels(store, this, true);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        if (this.plateName == null) {
            this.plateName = currentFile.getParentFile().getName();
        }
        if (this.plateBarcode != null) {
            this.plateName = this.plateBarcode + " " + this.plateName;
        }
        store.setPlateName(this.plateName, 0);
        store.setPlateRowNamingConvention("A", 0);
        store.setPlateColumnNamingConvention("1", 0);
        int[] lengths = new int[]{this.fieldCount, this.wellCount, this.plateCount};
        for (int row = 0; row < this.wellRows; ++row) {
            for (int col = 0; col < this.wellColumns; ++col) {
                store.setWellRow(new Integer(row), 0, row * this.wellColumns + col);
                store.setWellColumn(new Integer(col), 0, row * this.wellColumns + col);
            }
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            int sizeIndex;
            int[] pos = FormatTools.rasterToPosition(lengths, i);
            String imageID = MetadataTools.createLSID("Image", i);
            store.setImageID(imageID, i);
            store.setImageInstrumentRef(instrumentID, i);
            char wellRow = (char)(65 + this.wellNumber[pos[1]][0]);
            store.setImageName("Well " + wellRow + "-" + (this.wellNumber[pos[1]][1] + 1) + "; Field #" + (pos[0] + 1), i);
            int seriesIndex = i * this.getImageCount();
            if (seriesIndex < this.objectiveRefs.size()) {
                store.setObjectiveSettingsObjective(this.objectiveRefs.get(seriesIndex), i);
            }
            if (seriesIndex < this.lightSourceCombinationRefs.size()) {
                String lightSourceCombo = this.lightSourceCombinationRefs.get(seriesIndex);
                Vector<String> lightSources = this.lightSourceCombinationIDs.get(lightSourceCombo);
                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                    int index = i * this.getImageCount() + c;
                    if (index < this.cameraRefs.size()) {
                        store.setDetectorSettingsDetector(this.cameraRefs.get(index), i, c);
                    }
                    if (index < this.binnings.size()) {
                        store.setDetectorSettingsBinning(this.binnings.get(index), i, c);
                    }
                    if (lightSources != null && c < lightSources.size()) {
                        store.setLightSourceSettingsLightSource(lightSources.get(c), i, c);
                    } else if (c > 0 && lightSources != null && lightSources.size() == 1) {
                        store.setLightSourceSettingsLightSource(lightSources.get(0), i, c);
                    }
                    if (index >= this.filterSets.size()) continue;
                    store.setLogicalChannelFilterSet(this.filterSets.get(index), i, c);
                }
            }
            if ((sizeIndex = i * this.getImageCount()) < this.xSizes.size()) {
                store.setDimensionsPhysicalSizeX(this.xSizes.get(sizeIndex), i, 0);
            }
            if (sizeIndex < this.ySizes.size()) {
                store.setDimensionsPhysicalSizeY(this.ySizes.get(sizeIndex), i, 0);
            }
            int well = this.wellNumber[pos[1]][0] * this.wellColumns + this.wellNumber[pos[1]][1];
            if (this.wellRows == 0 && this.wellColumns == 0) {
                well = pos[1];
                store.setWellRow(new Integer(this.wellNumber[pos[1]][0]), pos[2], pos[1]);
                store.setWellColumn(new Integer(this.wellNumber[pos[1]][1]), pos[2], pos[1]);
            }
            store.setWellSampleIndex(new Integer(i), pos[2], well, pos[0]);
            store.setWellSampleImageRef(imageID, pos[2], well, pos[0]);
            if (pos[0] < this.xPositions.size()) {
                store.setWellSamplePosX(this.xPositions.get(pos[0]), pos[2], well, pos[0]);
            }
            if (pos[0] >= this.yPositions.size()) continue;
            store.setWellSamplePosY(this.yPositions.get(pos[0]), pos[2], well, pos[0]);
        }
    }

    private int[] getWell(String file2) {
        String name = file2.substring(file2.lastIndexOf(File.separator) + 1);
        if (name.length() == 14) {
            try {
                int row = Integer.parseInt(name.substring(0, 3)) - 1;
                int col = Integer.parseInt(name.substring(3, 6)) - 1;
                return new int[]{row, col};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new int[]{0, 0};
    }

    private IFDList firstWellIfds() {
        for (int i = 0; i < this.ifds.length; ++i) {
            for (int j = 0; j < this.ifds[i].length; ++j) {
                if (this.ifds[i][j] == null) continue;
                return this.ifds[i][j];
            }
        }
        return null;
    }

    private void parseFlexFile(int currentWell, int wellRow, int wellCol, boolean firstFile, MetadataStore store) throws FormatException, IOException {
        int i;
        int i2;
        int fsize;
        if (this.flexFiles[wellRow][wellCol] == null) {
            return;
        }
        if (this.channelNames == null) {
            this.channelNames = new Vector();
        }
        if (this.xPositions == null) {
            this.xPositions = new Vector();
        }
        if (this.yPositions == null) {
            this.yPositions = new Vector();
        }
        if (this.xSizes == null) {
            this.xSizes = new Vector();
        }
        if (this.ySizes == null) {
            this.ySizes = new Vector();
        }
        if (this.cameraIDs == null) {
            this.cameraIDs = new Vector();
        }
        if (this.lightSourceIDs == null) {
            this.lightSourceIDs = new Vector();
        }
        if (this.objectiveIDs == null) {
            this.objectiveIDs = new Vector();
        }
        if (this.lightSourceCombinationIDs == null) {
            this.lightSourceCombinationIDs = new Hashtable();
        }
        if (this.lightSourceCombinationRefs == null) {
            this.lightSourceCombinationRefs = new Vector();
        }
        if (this.cameraRefs == null) {
            this.cameraRefs = new Vector();
        }
        if (this.objectiveRefs == null) {
            this.objectiveRefs = new Vector();
        }
        if (this.binnings == null) {
            this.binnings = new Vector();
        }
        if (this.filterSets == null) {
            this.filterSets = new Vector();
        }
        IFD ifd = (IFD)this.ifds[wellRow][wellCol].get(0);
        String xml = ifd.getIFDStringValue(65200, true);
        byte[] c = xml.getBytes();
        for (int i3 = 0; i3 < c.length; ++i3) {
            if (c[i3] <= 126 && (c[i3] == 9 || c[i3] >= 32)) continue;
            c[i3] = 32;
        }
        Vector<String> n = new Vector<String>();
        Vector f = new Vector();
        FlexHandler handler = new FlexHandler(n, f, store, firstFile, currentWell);
        XMLTools.parseXML(c, (DefaultHandler)handler);
        if (firstFile) {
            this.populateCoreMetadata(wellRow, wellCol, n);
        }
        int totalPlanes = this.getSeriesCount() * this.getImageCount();
        int nsize = n.size();
        if (nsize != (fsize = f.size()) || nsize != totalPlanes) {
            this.warnDebug("mismatch between image count, names and factors (count=" + totalPlanes + ", names=" + nsize + ", factors=" + fsize + ")");
        }
        for (i2 = 0; i2 < nsize; ++i2) {
            this.addGlobalMeta("Name " + i2, n.get(i2));
        }
        for (i2 = 0; i2 < fsize; ++i2) {
            this.addGlobalMeta("Factor " + i2, f.get(i2));
        }
        this.factors[wellRow][wellCol] = new double[totalPlanes];
        int max = 0;
        for (i = 0; i < fsize; ++i) {
            String factor = (String)f.get(i);
            double q = 1.0;
            try {
                q = Double.parseDouble(factor);
            }
            catch (NumberFormatException exc) {
                this.warnDebug("invalid factor #" + i + ": " + factor);
            }
            if (i >= this.factors[wellRow][wellCol].length) continue;
            this.factors[wellRow][wellCol][i] = q;
            if (!(q > this.factors[wellRow][wellCol][max])) continue;
            max = i;
        }
        if (fsize < this.factors[wellRow][wellCol].length) {
            Arrays.fill(this.factors[wellRow][wellCol], fsize, this.factors[wellRow][wellCol].length, 1.0);
        }
        if (this.factors[wellRow][wellCol][max] > 256.0) {
            this.core[0].pixelType = 5;
        } else if (this.factors[wellRow][wellCol][max] > 1.0) {
            this.core[0].pixelType = 3;
        }
        for (i = 1; i < this.core.length; ++i) {
            this.core[i].pixelType = this.getPixelType();
        }
    }

    private void populateCoreMetadata(int wellRow, int wellCol, Vector<String> imageNames) throws FormatException {
        if (this.getSizeC() == 0 && this.getSizeT() == 0) {
            Vector<String> uniqueChannels = new Vector<String>();
            for (int i = 0; i < imageNames.size(); ++i) {
                String name = imageNames.get(i);
                String[] tokens = name.split("_");
                if (tokens.length > 1) {
                    int fieldIndex = Integer.parseInt(tokens[0]);
                    if (fieldIndex > this.fieldCount) {
                        this.fieldCount = fieldIndex;
                    }
                } else {
                    tokens = name.split(":");
                }
                String channel = tokens[tokens.length - 1];
                if (uniqueChannels.contains(channel)) continue;
                uniqueChannels.add(channel);
            }
            if (this.fieldCount == 0) {
                this.fieldCount = 1;
            }
            this.core[0].sizeC = Math.max(uniqueChannels.size(), 1);
            if (this.getSizeZ() == 0) {
                this.core[0].sizeZ = 1;
            }
            this.core[0].sizeT = imageNames.size() / (this.fieldCount * this.getSizeC() * this.getSizeZ());
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = Math.max(this.channelNames.size(), 1);
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.plateCount == 0) {
            this.plateCount = 1;
        }
        if (this.wellCount == 0) {
            this.wellCount = 1;
        }
        if (this.fieldCount == 0) {
            this.fieldCount = 1;
        }
        IFDList ifdList = this.ifds[wellRow][wellCol];
        IFD ifd = (IFD)ifdList.get(0);
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        if (this.getImageCount() * this.fieldCount != ifdList.size()) {
            this.core[0].imageCount = ifdList.size() / this.fieldCount;
            this.core[0].sizeZ = 1;
            this.core[0].sizeC = 1;
            this.core[0].sizeT = ifdList.size() / this.fieldCount;
        }
        this.core[0].sizeX = (int)ifd.getImageWidth();
        this.core[0].sizeY = (int)ifd.getImageLength();
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].indexed = false;
        this.core[0].littleEndian = ifd.isLittleEndian();
        this.core[0].pixelType = ifd.getPixelType();
        int seriesCount = this.plateCount * this.wellCount * this.fieldCount;
        if (seriesCount > 1) {
            CoreMetadata oldCore = this.core[0];
            this.core = new CoreMetadata[seriesCount];
            Arrays.fill(this.core, oldCore);
        }
    }

    private void findMeasurementFiles(Location flexFile) throws IOException {
        String[] files;
        Location plateDir = flexFile.getParentFile();
        for (String file2 : files = plateDir.list(true)) {
            String lfile = file2.toLowerCase();
            if (!lfile.endsWith(".mea") && !lfile.endsWith(".res")) continue;
            this.measurementFiles.add(new Location(plateDir, file2).getAbsolutePath());
        }
        if (this.measurementFiles.size() > 0) {
            return;
        }
        Location flexDir = null;
        try {
            flexDir = plateDir.getParentFile();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (flexDir == null) {
            return;
        }
        Location measurementDir = null;
        String[] flexDirList = flexDir.list(true);
        if (flexDirList.length > 1) {
            for (String file3 : flexDirList) {
                if (file3.equals(plateDir.getName()) || !plateDir.getName().startsWith(file3)) continue;
                measurementDir = new Location(flexDir, file3);
                break;
            }
        }
        if (measurementDir == null) {
            String[] topDirList;
            Location topDir = flexDir.getParentFile();
            String[] arr$ = topDirList = topDir.list(true);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String file4 = arr$[i$];
                if (flexDir.getAbsolutePath().endsWith(file4)) continue;
                measurementDir = new Location(topDir, file4);
                break;
            }
            if (measurementDir == null) {
                return;
            }
        } else {
            plateDir = measurementDir;
        }
        if (!plateDir.getAbsolutePath().equals(measurementDir.getAbsolutePath())) {
            String[] measurementPlates = measurementDir.list(true);
            String plate = plateDir.getName();
            plateDir = null;
            if (measurementPlates != null) {
                for (String file4 : measurementPlates) {
                    if (file4.indexOf(plate) == -1 && plate.indexOf(file4) == -1) continue;
                    plateDir = new Location(measurementDir, file4);
                    break;
                }
            }
        }
        if (plateDir == null) {
            return;
        }
        for (String file5 : files = plateDir.list(true)) {
            this.measurementFiles.add(new Location(plateDir, file5).getAbsolutePath());
        }
    }

    public class FlexHandler
    extends DefaultHandler {
        private Vector names;
        private Vector factors;
        private MetadataStore store;
        private int nextLaser = -1;
        private int nextCamera = 0;
        private int nextObjective = -1;
        private int nextImage = 0;
        private int nextPlate = 0;
        private String parentQName;
        private String lightSourceID;
        private String sliderName;
        private int nextFilter;
        private int nextDichroic;
        private int nextFilterSet;
        private int nextSliderRef;
        private boolean populateCore = true;
        private int well = 0;
        private StringBuffer charData = new StringBuffer();

        public FlexHandler(Vector names, Vector factors, MetadataStore store, boolean populateCore, int well) {
            this.names = names;
            this.factors = factors;
            this.store = store;
            this.populateCore = populateCore;
            this.well = well;
        }

        public void characters(char[] ch, int start, int length) {
            this.charData.append(new String(ch, start, length));
        }

        public void endElement(String uri, String localName, String qName) {
            String value = this.charData.toString();
            this.charData = new StringBuffer();
            if (qName.equals("Image")) {
                FlexReader.this.binnings.add(FlexReader.this.binX + "x" + FlexReader.this.binY);
            } else if (qName.equals("PlateName")) {
                if (FlexReader.this.plateName == null) {
                    FlexReader.this.plateName = value;
                }
            } else if (qName.equals("Barcode")) {
                if (FlexReader.this.plateBarcode == null) {
                    FlexReader.this.plateBarcode = value;
                }
                this.store.setPlateExternalIdentifier(value, this.nextPlate - 1);
            } else if (qName.equals("Wavelength")) {
                String lsid = MetadataTools.createLSID("LightSource", 0, this.nextLaser);
                this.store.setLightSourceID(lsid, 0, this.nextLaser);
                this.store.setLaserWavelength(new Integer(value), 0, this.nextLaser);
                this.store.setLaserType("Unknown", 0, this.nextLaser);
                this.store.setLaserLaserMedium("Unknown", 0, this.nextLaser);
            } else if (qName.equals("Magnification")) {
                this.store.setObjectiveCalibratedMagnification(new Float(value), 0, this.nextObjective);
            } else if (qName.equals("NumAperture")) {
                this.store.setObjectiveLensNA(new Float(value), 0, this.nextObjective);
            } else if (qName.equals("Immersion")) {
                if (value.equals("1.33")) {
                    value = "Water";
                } else if (value.equals("1.00")) {
                    value = "Air";
                } else {
                    FlexReader.this.warn("Unknown immersion medium: " + value);
                }
                this.store.setObjectiveImmersion(value, 0, this.nextObjective);
            } else if (qName.equals("OffsetX") || qName.equals("OffsetY")) {
                Float offset = new Float(Float.parseFloat(value) * 1000000.0f);
                if (qName.equals("OffsetX")) {
                    FlexReader.this.xPositions.add(offset);
                } else {
                    FlexReader.this.yPositions.add(offset);
                }
            } else if (qName.equals("XSize") && "Plate".equals(this.parentQName)) {
                FlexReader.this.wellRows = Integer.parseInt(value);
            } else if (qName.equals("YSize") && "Plate".equals(this.parentQName)) {
                FlexReader.this.wellColumns = Integer.parseInt(value);
            } else if ("Image".equals(this.parentQName)) {
                int nImages;
                if (FlexReader.this.fieldCount == 0) {
                    FlexReader.this.fieldCount = 1;
                }
                if ((nImages = FlexReader.this.firstWellIfds().size() / FlexReader.this.fieldCount) == 0) {
                    nImages = 1;
                }
                int currentSeries = (this.nextImage - 1) / nImages;
                currentSeries += this.well * FlexReader.this.fieldCount;
                int currentImage = (this.nextImage - 1) % nImages;
                if (qName.equals("DateTime")) {
                    this.store.setImageCreationDate(value, currentSeries);
                } else if (qName.equals("CameraBinningX")) {
                    FlexReader.this.binX = Integer.parseInt(value);
                } else if (qName.equals("CameraBinningY")) {
                    FlexReader.this.binY = Integer.parseInt(value);
                } else if (qName.equals("ObjectiveRef")) {
                    String objectiveID = MetadataTools.createLSID("Objective", 0, FlexReader.this.objectiveIDs.indexOf(value));
                    FlexReader.this.objectiveRefs.add(objectiveID);
                } else if (qName.equals("CameraRef")) {
                    String detectorID = MetadataTools.createLSID("Detector", 0, FlexReader.this.cameraIDs.indexOf(value));
                    FlexReader.this.cameraRefs.add(detectorID);
                } else if (qName.equals("ImageResolutionX")) {
                    float v = Float.parseFloat(value) * 1000000.0f;
                    FlexReader.this.xSizes.add(new Float(v));
                } else if (qName.equals("ImageResolutionY")) {
                    float v = Float.parseFloat(value) * 1000000.0f;
                    FlexReader.this.ySizes.add(new Float(v));
                } else if (qName.equals("PositionX")) {
                    Float v = new Float(Float.parseFloat(value) * 1000000.0f);
                    this.store.setStagePositionPositionX(v, currentSeries, 0, currentImage);
                } else if (qName.equals("PositionY")) {
                    Float v = new Float(Float.parseFloat(value) * 1000000.0f);
                    this.store.setStagePositionPositionY(v, currentSeries, 0, currentImage);
                } else if (qName.equals("PositionZ")) {
                    Float v = new Float(Float.parseFloat(value) * 1000000.0f);
                    this.store.setStagePositionPositionZ(v, currentSeries, 0, currentImage);
                } else if (qName.equals("TimepointOffsetUsed")) {
                    this.store.setPlaneTimingDeltaT(new Float(value), currentSeries, 0, currentImage);
                } else if (qName.equals("CameraExposureTime")) {
                    this.store.setPlaneTimingExposureTime(new Float(value), currentSeries, 0, currentImage);
                } else if (qName.equals("LightSourceCombinationRef")) {
                    FlexReader.this.lightSourceCombinationRefs.add(value);
                } else if (qName.equals("FilterCombinationRef")) {
                    FlexReader.this.filterSets.add("FilterSet:" + value);
                }
            } else if (qName.equals("FilterCombination")) {
                ++this.nextFilterSet;
                this.nextSliderRef = 0;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Array")) {
                int len = attributes.getLength();
                for (int i = 0; i < len; ++i) {
                    String name = attributes.getQName(i);
                    if (name.equals("Name")) {
                        this.names.add(attributes.getValue(i));
                        continue;
                    }
                    if (!name.equals("Factor")) continue;
                    this.factors.add(attributes.getValue(i));
                }
            } else if (qName.equals("LightSource")) {
                this.parentQName = qName;
                String type = attributes.getValue("LightSourceType");
                FlexReader.this.lightSourceIDs.add(attributes.getValue("ID"));
                ++this.nextLaser;
            } else if (qName.equals("LightSourceCombination")) {
                this.lightSourceID = attributes.getValue("ID");
                FlexReader.this.lightSourceCombinationIDs.put(this.lightSourceID, new Vector());
            } else if (qName.equals("LightSourceRef")) {
                Vector v = (Vector)FlexReader.this.lightSourceCombinationIDs.get(this.lightSourceID);
                if (v != null) {
                    int id = FlexReader.this.lightSourceIDs.indexOf(attributes.getValue("ID"));
                    String lightSourceID = MetadataTools.createLSID("LightSource", 0, id);
                    v.add(lightSourceID);
                    FlexReader.this.lightSourceCombinationIDs.put(lightSourceID, v);
                }
            } else if (qName.equals("Camera")) {
                this.parentQName = qName;
                String detectorID = MetadataTools.createLSID("Detector", 0, this.nextCamera);
                this.store.setDetectorID(detectorID, 0, this.nextCamera);
                this.store.setDetectorType(attributes.getValue("CameraType"), 0, this.nextCamera);
                FlexReader.this.cameraIDs.add(attributes.getValue("ID"));
                ++this.nextCamera;
            } else if (qName.equals("Objective")) {
                this.parentQName = qName;
                String objectiveID = MetadataTools.createLSID("Objective", 0, ++this.nextObjective);
                this.store.setObjectiveID(objectiveID, 0, this.nextObjective);
                this.store.setObjectiveCorrection("Unknown", 0, this.nextObjective);
                FlexReader.this.objectiveIDs.add(attributes.getValue("ID"));
            } else if (qName.equals("Field")) {
                this.parentQName = qName;
                int fieldNo = Integer.parseInt(attributes.getValue("No"));
                if (fieldNo > FlexReader.this.fieldCount && FlexReader.this.fieldCount < FlexReader.this.firstWellIfds().size()) {
                    FlexReader.this.fieldCount++;
                }
            } else if (qName.equals("Plane")) {
                this.parentQName = qName;
                int planeNo = Integer.parseInt(attributes.getValue("No"));
                if (planeNo > FlexReader.this.getSizeZ() && this.populateCore) {
                    ++((FlexReader)FlexReader.this).core[0].sizeZ;
                }
            } else if (qName.equals("WellShape")) {
                this.parentQName = qName;
            } else if (qName.equals("Image")) {
                this.parentQName = qName;
                ++this.nextImage;
                String x = attributes.getValue("CameraBinningX");
                String y = attributes.getValue("CameraBinningY");
                if (x != null) {
                    FlexReader.this.binX = Integer.parseInt(x);
                }
                if (y != null) {
                    FlexReader.this.binY = Integer.parseInt(y);
                }
            } else if (qName.equals("Plate")) {
                this.parentQName = qName;
                if (qName.equals("Plate")) {
                    ++this.nextPlate;
                    FlexReader.this.plateCount++;
                }
            } else if (qName.equals("WellCoordinate")) {
                if (FlexReader.this.wellNumber.length == 1) {
                    ((FlexReader)FlexReader.this).wellNumber[0][0] = Integer.parseInt(attributes.getValue("Row")) - 1;
                    ((FlexReader)FlexReader.this).wellNumber[0][1] = Integer.parseInt(attributes.getValue("Col")) - 1;
                }
            } else if (qName.equals("Slider")) {
                this.sliderName = attributes.getValue("Name");
            } else if (qName.equals("Filter")) {
                String id = attributes.getValue("ID");
                if (this.sliderName.endsWith("Dichro")) {
                    this.store.setDichroicID("Dichroic:" + id, 0, this.nextDichroic);
                    this.store.setDichroicModel(id, 0, this.nextDichroic);
                    ++this.nextDichroic;
                } else {
                    this.store.setFilterID("Filter:" + id, 0, this.nextFilter);
                    this.store.setFilterModel(id, 0, this.nextFilter);
                    this.store.setFilterFilterWheel(this.sliderName, 0, this.nextFilter);
                    ++this.nextFilter;
                }
            } else if (qName.equals("FilterCombination")) {
                this.store.setFilterSetID("FilterSet:" + attributes.getValue("ID"), 0, this.nextFilterSet);
            } else if (qName.equals("SliderRef")) {
                String filterName = attributes.getValue("Filter");
                String filterID = "Filter:" + filterName;
                String dichroicID = "Dichroic:" + filterName;
                String slider = attributes.getValue("ID");
                if (this.nextSliderRef == 0 && slider.startsWith("Camera")) {
                    this.store.setFilterSetEmFilter(filterID, 0, this.nextFilterSet);
                } else if (this.nextSliderRef == 1 && slider.startsWith("Camera")) {
                    this.store.setFilterSetExFilter(filterID, 0, this.nextFilterSet);
                } else if (slider.equals("Primary_Dichro")) {
                    this.store.setFilterSetDichroic(dichroicID, 0, this.nextFilterSet);
                }
                String lname = filterName.toLowerCase();
                if (!lname.startsWith("empty") && !lname.startsWith("blocked")) {
                    ++this.nextSliderRef;
                }
            }
        }
    }
}

