/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;

public class L2DReader
extends FormatReader {
    public static final String DATE_FORMAT = "yyyy, m, d";
    private Vector[] tiffs;
    private Vector<String> used;
    private MinimalTiffReader reader;

    public L2DReader() {
        super("Li-Cor L2D", new String[]{"l2d", "scn"});
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.reader.setId((String)this.tiffs[this.series].get(no));
        return this.reader.openBytes(0, buf, x, y, w, h);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            Vector<String> files = new Vector<String>();
            for (int i = 0; i < this.used.size(); ++i) {
                String f = this.used.get(i).toLowerCase();
                if (f.endsWith(".tif") || f.endsWith(".tiff")) continue;
                files.add(this.used.get(i));
            }
            return files.toArray(new String[0]);
        }
        return this.used.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.reader != null) {
            this.reader.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiffs = null;
            this.reader = null;
            this.used = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("L2DReader.initFile(" + id + ")");
        if (id.toLowerCase().endsWith(".scn")) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            String[] list = parent.list();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].toLowerCase().endsWith(".l2d")) continue;
                this.initFile(new Location(parent.getAbsolutePath(), list[i]).getAbsolutePath());
                break;
            }
            return;
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.used = new Vector();
        this.used.add(new Location(id).getAbsolutePath());
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        Vector<String> scans = new Vector<String>();
        String line = this.in.readLine().trim();
        while (line != null && line.length() > 0) {
            if (!line.startsWith("#")) {
                String key = line.substring(0, line.indexOf("="));
                String value = line.substring(line.indexOf("=") + 1);
                this.addGlobalMeta(key, value);
                if (key.equals("ScanNames")) {
                    StringTokenizer names = new StringTokenizer(value, ",");
                    while (names.hasMoreTokens()) {
                        scans.add(names.nextToken().trim());
                    }
                }
            }
            line = this.in.readLine().trim();
        }
        this.in.close();
        this.tiffs = new Vector[scans.size()];
        this.core = new CoreMetadata[scans.size()];
        Vector<String> comments = new Vector<String>();
        Vector<String> wavelengths = new Vector<String>();
        Vector<String> dates = new Vector<String>();
        String model = null;
        for (int i = 0; i < scans.size(); ++i) {
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            this.tiffs[i] = new Vector();
            String scanName = (String)scans.get(i);
            Location scanDir = new Location(parent, scanName);
            String scanPath = new Location(scanDir, scanName + ".scn").getAbsolutePath();
            this.addDirectory(scanDir.getAbsolutePath());
            RandomAccessInputStream scan = new RandomAccessInputStream(scanPath);
            line = scan.readLine().trim();
            while (line != null && line.length() > 0) {
                if (!line.startsWith("#")) {
                    String key = line.substring(0, line.indexOf("="));
                    String value = line.substring(line.indexOf("=") + 1);
                    this.addSeriesMeta(key, value);
                    if (!key.equals("ExperimentNames")) {
                        if (key.equals("ImageNames")) {
                            StringTokenizer names = new StringTokenizer(value, ",");
                            while (names.hasMoreTokens()) {
                                String path = names.nextToken().trim();
                                String tiff = new Location(scanDir, path).getAbsolutePath();
                                this.tiffs[i].add(tiff);
                            }
                        } else if (key.equals("Comments")) {
                            comments.add(value);
                        } else if (key.equals("ScanDate")) {
                            dates.add(value);
                        } else if (key.equals("ScannerName")) {
                            model = value;
                        } else if (key.equals("ScanChannels")) {
                            wavelengths.add(value);
                        }
                    }
                }
                line = scan.readLine().trim();
            }
            if (comments.size() == i) {
                comments.add(null);
            }
            if (dates.size() == i) {
                dates.add(null);
            }
            if (wavelengths.size() != i) continue;
            wavelengths.add(null);
        }
        this.setSeries(0);
        this.reader = new MinimalTiffReader();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        for (int i = 0; i < scans.size(); ++i) {
            this.core[i].imageCount = this.tiffs[i].size();
            this.core[i].sizeC = this.tiffs[i].size();
            this.core[i].sizeT = 1;
            this.core[i].sizeZ = 1;
            this.core[i].dimensionOrder = "XYCZT";
            for (int t = 0; t < this.tiffs[i].size(); ++t) {
                this.reader.setId((String)this.tiffs[i].get(t));
                if (t != 0) continue;
                this.core[i].sizeX = this.reader.getSizeX();
                this.core[i].sizeY = this.reader.getSizeY();
                this.core[i].sizeC *= this.reader.getSizeC();
                this.core[i].rgb = this.reader.isRGB();
                this.core[i].indexed = this.reader.isIndexed();
                this.core[i].littleEndian = this.reader.isLittleEndian();
                this.core[i].pixelType = this.reader.getPixelType();
            }
        }
        MetadataTools.populatePixels(store, this);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i = 0; i < scans.size(); ++i) {
            store.setImageInstrumentRef(instrumentID, i);
            store.setImageName((String)scans.get(i), i);
            store.setImageDescription((String)comments.get(i), i);
            String date = (String)dates.get(i);
            if (date != null) {
                date = DateTools.formatDate(date, DATE_FORMAT);
                store.setImageCreationDate(date, i);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            String c = (String)wavelengths.get(i);
            if (c == null) continue;
            String[] waves = c.split("[, ]");
            if (waves.length < this.getEffectiveSizeC()) {
                this.debug("Expected " + this.getEffectiveSizeC() + " wavelengths; got " + waves.length + " wavelengths.");
            }
            for (int q = 0; q < waves.length; ++q) {
                String lightSourceID = MetadataTools.createLSID("LightSource", 0, q);
                store.setLightSourceID(lightSourceID, 0, q);
                store.setLaserWavelength(new Integer(waves[q].trim()), 0, q);
                store.setLogicalChannelLightSource(lightSourceID, i, q);
            }
        }
        store.setMicroscopeModel(model, 0);
    }

    private void addDirectory(String path) {
        Location dir = new Location(path);
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            Location file2 = new Location(path, files[i]);
            if (file2.isDirectory()) {
                this.addDirectory(file2.getAbsolutePath());
                continue;
            }
            String check = files[i].toLowerCase();
            if (!check.endsWith(".tif") && !check.endsWith(".data") && !check.endsWith(".log") && !check.endsWith(".scn")) continue;
            this.used.add(file2.getAbsolutePath());
        }
    }
}

