/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.ByteArrayHandle;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ChannelSeparator;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.LZOCodec;
import loci.formats.in.PictReader;
import loci.formats.meta.FilterMetadata;

public class OpenlabReader
extends FormatReader {
    public static final long LIFF_MAGIC_BYTES = 281472450523250L;
    private static final int MAC_1_BIT = 1;
    private static final int MAC_4_GREYS = 2;
    private static final int MAC_16_GREYS = 3;
    private static final int MAC_16_COLORS = 4;
    private static final int MAC_256_GREYS = 5;
    private static final int MAC_256_COLORS = 6;
    private static final int MAC_16_BIT_COLOR = 7;
    private static final int MAC_24_BIT_COLOR = 8;
    private static final int DEEP_GREY_9 = 9;
    private static final int DEEP_GREY_10 = 10;
    private static final int DEEP_GREY_11 = 11;
    private static final int DEEP_GREY_12 = 12;
    private static final int DEEP_GREY_13 = 13;
    private static final int DEEP_GREY_14 = 14;
    private static final int DEEP_GREY_15 = 15;
    private static final int DEEP_GREY_16 = 16;
    private static final int IMAGE_TYPE_1 = 67;
    private static final int IMAGE_TYPE_2 = 68;
    private static final int CALIBRATION = 69;
    private static final int USER = 72;
    private static PictReader pict = new PictReader();
    private int version;
    private int numSeries;
    private PlaneInfo[] planes;
    private float xcal;
    private float ycal;
    private long nextTag = 0L;
    private int tag = 0;
    private int subTag = 0;
    private String fmt = "";
    private int[][] planeOffsets;
    private Vector luts;
    private int lastPlane;
    private String gain;
    private String detectorOffset;
    private String xPos;
    private String yPos;
    private String zPos;

    public OpenlabReader() {
        super("Openlab LIFF", "liff");
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readLong() == 281472450523250L;
    }

    public byte[][] get8BitLookupTable() {
        Object lut = this.luts.get(this.planeOffsets[this.series][this.lastPlane]);
        if (lut == null) {
            return null;
        }
        return lut instanceof byte[][] ? (byte[][])lut : (byte[][])null;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastPlane = no;
        int index = this.planeOffsets[this.series][no];
        long first = this.planes[index].planeOffset;
        long last = no == this.getImageCount() - 1 ? this.in.length() : this.planes[this.planeOffsets[this.series][no + 1]].planeOffset;
        this.in.seek(first);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (!this.planes[index].pict) {
            if (this.version == 2) {
                this.readPlane(this.in, x, y, w, h, buf);
            } else {
                this.in.skipBytes(16);
                int bytes = bpp * this.getRGBChannelCount();
                byte[] b = new byte[(int)(last - first)];
                this.in.read(b);
                CodecOptions options = new CodecOptions();
                options.width = this.getSizeX();
                options.height = this.getSizeY();
                options.bitsPerSample = bytes * 8;
                options.maxBytes = this.getSizeX() * this.getSizeY() * bytes;
                b = new LZOCodec().decompress(b, options);
                if (this.getSizeX() * this.getSizeY() * 4 <= b.length) {
                    for (int yy = y; yy < h + y; ++yy) {
                        for (int xx = x; xx < w + x; ++xx) {
                            System.arraycopy(b, (yy * (this.getSizeX() + 4) + xx) * 4 + 1, buf, ((yy - y) * w + xx - x) * 3, 3);
                        }
                    }
                } else {
                    int src = b.length / this.getSizeY();
                    if (src - this.getSizeX() * bytes != 16) {
                        src = this.getSizeX() * bytes;
                    }
                    int dest = w * bytes;
                    for (int row = 0; row < h; ++row) {
                        System.arraycopy(b, (row + y) * src + x * bytes, buf, row * dest, dest);
                    }
                }
                b = null;
            }
            if (this.planes[index].volumeType == 5 || this.planes[index].volumeType == 6) {
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)(~buf[i] & 0xFF);
                }
            }
        } else {
            byte[] b = new byte[(int)(last - first) + 512];
            this.in.read(b, 512, b.length - 512);
            Exception exc = null;
            IFormatReader r = this.getRGBChannelCount() == 1 ? new ChannelSeparator(pict) : pict;
            try {
                Location.mapFile("OPENLAB_PICT", new ByteArrayHandle(b));
                r.setId("OPENLAB_PICT");
                if (this.getPixelType() != pict.getPixelType()) {
                    throw new FormatException("Pixel type of inner PICT does not match pixel type of Openlab file");
                }
                if (this.isIndexed()) {
                    this.luts.setElementAt(pict.get8BitLookupTable(), this.planeOffsets[this.series][this.lastPlane]);
                }
                r.openBytes(0, buf, x, y, w, h);
                r.close();
                Location.mapFile("OPENLAB_PICT", null);
            }
            catch (FormatException e) {
                exc = e;
            }
            catch (IOException e) {
                exc = e;
            }
            b = null;
            if (exc != null) {
                r.close();
                this.traceDebug(exc);
                this.in.seek(this.planes[index].planeOffset - 298L);
                if (this.in.readByte() == 1) {
                    this.in.skipBytes(128);
                }
                this.in.skipBytes(169);
                int size = 0;
                int expectedBlock = 0;
                int totalBlocks = -1;
                int pixPos = 0;
                byte[] plane = new byte[FormatTools.getPlaneSize(this)];
                while (expectedBlock != totalBlocks && this.in.getFilePointer() + 32L < this.in.length()) {
                    while (this.in.readLong() != 5284487359925219441L && this.in.getFilePointer() < this.in.length()) {
                        this.in.seek(this.in.getFilePointer() - 7L);
                    }
                    if (this.in.getFilePointer() + 4L >= this.in.length()) break;
                    int num = this.in.readInt();
                    if (num != expectedBlock) {
                        throw new FormatException("Expected iPic block not found");
                    }
                    ++expectedBlock;
                    if (totalBlocks == -1) {
                        totalBlocks = this.in.readInt();
                    } else {
                        this.in.skipBytes(4);
                    }
                    this.in.skipBytes(8);
                    size = this.in.readInt();
                    this.in.skipBytes(4);
                    if (size + pixPos > plane.length) {
                        size = plane.length - pixPos;
                    }
                    this.in.read(plane, pixPos, size);
                    pixPos += size;
                }
                int srcRow = this.getSizeX() * bpp * this.getRGBChannelCount();
                int rowLen = w * bpp * this.getRGBChannelCount();
                for (int row = 0; row < h; ++row) {
                    System.arraycopy(plane, (row + y) * srcRow + x * bpp * this.getRGBChannelCount(), buf, row * rowLen, rowLen);
                }
                plane = null;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (pict != null) {
            pict.close(fileOnly);
        }
        if (!fileOnly) {
            this.planes = null;
            this.luts = null;
            this.lastPlane = 0;
            this.version = 0;
            this.numSeries = 0;
            this.ycal = 0.0f;
            this.xcal = 0.0f;
            this.nextTag = 0L;
            this.subTag = 0;
            this.tag = 0;
            this.fmt = "";
            this.planeOffsets = null;
            this.detectorOffset = null;
            this.gain = null;
            this.zPos = null;
            this.yPos = null;
            this.xPos = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("OpenlabReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.luts = new Vector();
        this.status("Verifying Openlab LIFF format");
        this.in.order(false);
        this.in.seek(4L);
        if (!this.in.readString(4).equals("impr")) {
            throw new FormatException("Invalid LIFF file.");
        }
        this.version = this.in.readInt();
        if (this.version != 2 && this.version != 5) {
            throw new FormatException("Invalid version : " + this.version);
        }
        short planeCount = this.in.readShort();
        this.planes = new PlaneInfo[planeCount];
        this.in.skipBytes(2);
        int offset = this.in.readInt();
        this.in.seek(offset);
        this.status("Finding image offsets");
        this.ycal = 0.0f;
        this.xcal = 0.0f;
        int imagesFound = 0;
        Vector<PlaneInfo> representativePlanes = new Vector<PlaneInfo>();
        while (this.in.getFilePointer() + 8L < this.in.length()) {
            char achar;
            String className;
            int i2;
            long fp = this.in.getFilePointer();
            this.readTagHeader();
            while (this.tag < 67 || this.tag > 76) {
                this.in.seek(--fp);
                this.readTagHeader();
            }
            if (this.tag == 67 || this.tag == 68) {
                this.planes[imagesFound] = new PlaneInfo();
                this.planes[imagesFound].pict = this.fmt.toLowerCase().equals("pict");
                this.planes[imagesFound].compressed = this.subTag == 0;
                this.in.skipBytes(24);
                this.planes[imagesFound].volumeType = this.in.readShort();
                this.in.skipBytes(16);
                long pointer = this.in.getFilePointer();
                this.planes[imagesFound].planeName = this.in.readCString().trim();
                this.in.skipBytes((int)(256L - this.in.getFilePointer() + pointer));
                this.planes[imagesFound].planeOffset = this.in.getFilePointer();
                if (this.version == 2) {
                    this.in.skipBytes(2);
                    short top = this.in.readShort();
                    short left = this.in.readShort();
                    short bottom = this.in.readShort();
                    short right = this.in.readShort();
                    this.planes[imagesFound].width = right - left;
                    this.planes[imagesFound].height = bottom - top;
                } else {
                    this.planes[imagesFound].width = this.in.readInt();
                    this.planes[imagesFound].height = this.in.readInt();
                }
                for (int i3 = 0; i3 < representativePlanes.size(); ++i3) {
                    PlaneInfo p = (PlaneInfo)representativePlanes.get(i3);
                    if (this.planes[imagesFound].width != p.width || this.planes[imagesFound].height != p.height || this.planes[imagesFound].volumeType != p.volumeType && (this.planes[imagesFound].volumeType < 9 || p.volumeType < 9)) continue;
                    this.planes[imagesFound].series = i3;
                    break;
                }
                if (this.planes[imagesFound].series == -1 && !this.planes[imagesFound].planeName.equals("Original Image")) {
                    this.planes[imagesFound].series = representativePlanes.size();
                    representativePlanes.add(this.planes[imagesFound]);
                }
                if (this.planes[imagesFound].volumeType == 6) {
                    this.in.seek(this.nextTag - 2056L);
                    byte[][] lut = new byte[3][256];
                    for (i2 = 0; i2 < 256; ++i2) {
                        this.in.skipBytes(2);
                        lut[0][255 - i2] = (byte)(this.in.readShort() >> 8);
                        lut[1][255 - i2] = (byte)(this.in.readShort() >> 8);
                        lut[2][255 - i2] = (byte)(this.in.readShort() >> 8);
                    }
                    this.luts.add(lut);
                } else {
                    this.luts.add(null);
                }
                ++imagesFound;
            } else if (this.tag == 69) {
                this.in.skipBytes(4);
                short units = this.in.readShort();
                this.in.skipBytes(12);
                this.xcal = this.in.readFloat();
                this.ycal = this.in.readFloat();
                float scaling = units == 3 ? 0.001f : 1.0f;
                this.xcal *= scaling;
                this.ycal *= scaling;
            } else if (this.tag == 72 && (className = this.in.readCString()).equals("CVariableList") && (achar = this.in.readChar()) == '\u0001') {
                int numVars = this.in.readShort();
                for (i2 = 0; i2 < numVars; ++i2) {
                    className = this.in.readCString();
                    String name = "";
                    String value = "";
                    int derivedClassVersion = this.in.read();
                    if (derivedClassVersion != 1) {
                        throw new FormatException("Invalid revision");
                    }
                    if (className.equals("CStringVariable")) {
                        int strSize = this.in.readInt();
                        value = this.in.readString(strSize);
                        this.in.skipBytes(1);
                    } else if (className.equals("CFloatVariable")) {
                        value = String.valueOf(this.in.readDouble());
                    }
                    int baseClassVersion = this.in.read();
                    if (baseClassVersion != 1 && baseClassVersion != 2) {
                        throw new FormatException("Invalid revision: " + baseClassVersion);
                    }
                    int strSize = this.in.readInt();
                    name = this.in.readString(strSize);
                    this.in.skipBytes(baseClassVersion * 2 + 1);
                    this.addGlobalMeta(name, value);
                    if (name.equals("Gain")) {
                        this.gain = value;
                        continue;
                    }
                    if (name.equals("Offset")) {
                        this.detectorOffset = value;
                        continue;
                    }
                    if (name.equals("X-Y Stage: X Position")) {
                        this.xPos = value;
                        continue;
                    }
                    if (name.equals("X-Y Stage: Y Position")) {
                        this.yPos = value;
                        continue;
                    }
                    if (!name.equals("ZPosition")) continue;
                    this.zPos = value;
                }
            }
            this.in.seek(this.nextTag);
        }
        int nSeries = representativePlanes.size();
        this.planeOffsets = new int[nSeries][];
        Vector<Integer> tmpOffsets = new Vector<Integer>();
        Vector<String> names = new Vector<String>();
        this.core = new CoreMetadata[nSeries];
        for (i = 0; i < nSeries; ++i) {
            int q;
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            for (q = 0; q < this.planes.length; ++q) {
                if (this.planes[q] == null || this.planes[q].series != i) continue;
                tmpOffsets.add(q);
                names.add(this.planes[q].planeName);
            }
            this.planeOffsets[i] = new int[tmpOffsets.size()];
            for (q = 0; q < this.planeOffsets[i].length; ++q) {
                this.planeOffsets[i][q] = (Integer)tmpOffsets.get(q);
                this.addSeriesMeta("Plane " + q + " Name", names.get(q));
            }
            tmpOffsets.clear();
            names.clear();
        }
        this.setSeries(0);
        for (i = 0; i < nSeries; ++i) {
            this.core[i].indexed = false;
            this.core[i].sizeX = this.planes[this.planeOffsets[i][0]].width;
            this.core[i].sizeY = this.planes[this.planeOffsets[i][0]].height;
            this.core[i].imageCount = this.planeOffsets[i].length;
            switch (this.planes[this.planeOffsets[i][0]].volumeType) {
                case 1: 
                case 2: 
                case 5: {
                    this.core[i].pixelType = 1;
                    this.core[i].rgb = false;
                    this.core[i].sizeC = 1;
                    this.core[i].interleaved = false;
                    this.core[i].indexed = this.planes[this.planeOffsets[i][0]].pict;
                    break;
                }
                case 6: {
                    this.core[i].pixelType = 1;
                    this.core[i].rgb = false;
                    this.core[i].sizeC = 1;
                    this.core[i].interleaved = false;
                    this.core[i].indexed = true;
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    this.core[i].pixelType = 1;
                    this.core[i].rgb = true;
                    this.core[i].sizeC = 3;
                    this.core[i].interleaved = this.version == 5;
                    break;
                }
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.core[i].pixelType = 3;
                    this.core[i].rgb = false;
                    this.core[i].sizeC = 1;
                    this.core[i].interleaved = false;
                    break;
                }
                default: {
                    throw new FormatException("Unsupported plane type: " + this.planes[this.planeOffsets[i][0]].volumeType);
                }
            }
            this.core[i].sizeT = 1;
            this.core[i].sizeZ = this.core[i].imageCount;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].littleEndian = false;
            this.core[i].falseColor = false;
            this.core[i].metadataComplete = true;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, false);
        MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        store.setDimensionsPhysicalSizeX(new Float(this.xcal), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(this.ycal), 0, 0);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        try {
            if (this.gain != null) {
                store.setDetectorSettingsGain(new Float(this.gain), 0, 0);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            if (this.detectorOffset != null) {
                store.setDetectorSettingsOffset(new Float(this.detectorOffset), 0, 0);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detectorID, 0, 0);
        store.setDetectorSettingsDetector(detectorID, 0, 0);
        store.setDetectorType("Unknown", 0, 0);
        if (this.xPos != null) {
            store.setStagePositionPositionX(new Float(this.xPos), 0, 0, 0);
        }
        if (this.yPos != null) {
            store.setStagePositionPositionY(new Float(this.yPos), 0, 0, 0);
        }
        if (this.zPos != null) {
            store.setStagePositionPositionZ(new Float(this.zPos), 0, 0, 0);
        }
    }

    private void readTagHeader() throws IOException {
        this.tag = this.in.readShort();
        this.subTag = this.in.readShort();
        this.nextTag = this.version == 2 ? (long)this.in.readInt() : this.in.readLong();
        this.fmt = this.in.readString(4);
        this.in.skipBytes(this.version == 2 ? 4 : 8);
    }

    protected class PlaneInfo {
        protected long planeOffset;
        protected int zPosition;
        protected int wavelength;
        protected String planeName;
        protected long timestamp;
        protected boolean pict;
        protected boolean compressed;
        protected int volumeType;
        protected int width;
        protected int height;
        protected int series = -1;

        protected PlaneInfo() {
        }
    }
}

