/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import loci.formats.FormatTools;
import loci.formats.meta.MetadataRetrieve;

public final class ImagePlusTools {
    private ImagePlusTools() {
    }

    public static ImagePlus makeRGB(ImageProcessor[] p) {
        return ImagePlusTools.makeRGB("", p);
    }

    public static ImagePlus makeRGB(String title, ImageProcessor[] p) {
        if (p.length == 1) {
            return new ImagePlus(title, p[0]);
        }
        boolean sameType = true;
        int width = p[0].getWidth();
        int height = p[0].getHeight();
        boolean byteProc = p[0] instanceof ByteProcessor;
        boolean shortProc = p[0] instanceof ShortProcessor;
        boolean floatProc = p[0] instanceof FloatProcessor;
        for (int i = 1; i < p.length; ++i) {
            int w = p[i].getWidth();
            int h = p[i].getHeight();
            boolean b = p[i] instanceof ByteProcessor;
            boolean s = p[i] instanceof ShortProcessor;
            boolean f = p[i] instanceof FloatProcessor;
            if (w == width && h == height && b == byteProc && s == shortProc && f == floatProc) continue;
            sameType = false;
            break;
        }
        if (!sameType || p.length > 4 || p[0] instanceof ColorProcessor) {
            return null;
        }
        CompositeImage imp = null;
        if (p.length < 4 && byteProc) {
            ColorProcessor cp = new ColorProcessor(width, height);
            byte[][] bytes = new byte[p.length][];
            for (int i = 0; i < p.length; ++i) {
                bytes[i] = (byte[])p[i].getPixels();
            }
            cp.setRGB(bytes[0], bytes[1], bytes.length == 3 ? bytes[2] : new byte[width * height]);
            imp = new ImagePlus(title, (ImageProcessor)cp);
        } else if (p.length <= 7) {
            ImageStack tmpStack = new ImageStack(width, height);
            for (int i = 0; i < p.length; ++i) {
                tmpStack.addSlice("", p[i]);
            }
            ImagePlus ii = new ImagePlus(title, tmpStack);
            imp = new CompositeImage(ii, 1);
        }
        return imp;
    }

    public static void applyCalibration(MetadataRetrieve retrieve, ImagePlus imp, int series) {
        String type;
        int pixelType;
        boolean signed;
        Float tf;
        Float zf;
        Float yf;
        double xcal = Double.NaN;
        double ycal = Double.NaN;
        double zcal = Double.NaN;
        double tcal = Double.NaN;
        Float xf = retrieve.getDimensionsPhysicalSizeX(series, 0);
        if (xf != null) {
            xcal = xf.floatValue();
        }
        if ((yf = retrieve.getDimensionsPhysicalSizeY(series, 0)) != null) {
            ycal = yf.floatValue();
        }
        if ((zf = retrieve.getDimensionsPhysicalSizeZ(series, 0)) != null) {
            zcal = zf.floatValue();
        }
        if ((tf = retrieve.getDimensionsTimeIncrement(series, 0)) != null) {
            tcal = tf.floatValue();
        }
        if (xcal == xcal || ycal == ycal || zcal == zcal || tcal == tcal) {
            if (xcal != xcal) {
                xcal = ycal;
            }
            if (ycal != ycal) {
                ycal = xcal;
            }
            Calibration cal = new Calibration();
            cal.setUnit("micron");
            cal.pixelWidth = xcal;
            cal.pixelHeight = ycal;
            cal.pixelDepth = zcal;
            cal.frameInterval = tcal;
            imp.setCalibration(cal);
        }
        boolean bl = signed = (pixelType = FormatTools.pixelTypeFromString(type = retrieve.getPixelsPixelType(series, 0))) == 0 || pixelType == 2 || pixelType == 4;
        if (signed) {
            int bitsPerPixel = FormatTools.getBytesPerPixel(pixelType) * 8;
            double min = -1.0 * Math.pow(2.0, bitsPerPixel - 1);
            imp.getLocalCalibration().setFunction(0, new double[]{min, 1.0}, "gray value");
        }
    }

    public static void adjustColorRange(ImagePlus imp) {
        ImageStack s = imp.getStack();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < s.getSize(); ++i) {
            ImageProcessor p = s.getProcessor(i + 1);
            p.resetMinAndMax();
            if (p.getMin() < min) {
                min = p.getMin();
            }
            if (!(p.getMax() > max)) continue;
            max = p.getMax();
        }
        ImageProcessor p = imp.getProcessor();
        if (p instanceof ColorProcessor) {
            ((ColorProcessor)p).setMinAndMax(min, max, 3);
        } else {
            p.setMinAndMax(min, max);
        }
        imp.setProcessor(imp.getTitle(), p);
    }

    public static ImagePlus reorder(ImagePlus imp, String origOrder, String newOrder) {
        ImageStack s = imp.getStack();
        ImageStack newStack = new ImageStack(s.getWidth(), s.getHeight());
        int z = imp.getNSlices();
        int c = imp.getNChannels();
        int t = imp.getNFrames();
        int stackSize = s.getSize();
        for (int i = 0; i < stackSize; ++i) {
            int ndx = FormatTools.getReorderedIndex(origOrder, newOrder, z, c, t, stackSize, i);
            newStack.addSlice(s.getSliceLabel(ndx + 1), s.getProcessor(ndx + 1));
        }
        ImagePlus p = new ImagePlus(imp.getTitle(), newStack);
        p.setDimensions(c, z, t);
        p.setCalibration(imp.getCalibration());
        p.setFileInfo(imp.getOriginalFileInfo());
        return p;
    }
}

