/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.Prefs;
import loci.formats.IFormatReader;

public class LociPrefs {
    public static final String PREF_READER_ENABLED = "bioformats.enabled";
    public static final String PREF_READER_WINDOWLESS = "bioformats.windowless";
    public static final String PREF_ND2_NIKON = "bioformats.nd2.nikon";
    public static final String PREF_PICT_QTJAVA = "bioformats.pict.qtjava";
    public static final String PREF_QT_QTJAVA = "bioformats.qt.qtjava";
    public static final String PREF_SDT_INTENSITY = "bioformats.sdt.intensity";

    private LociPrefs() {
    }

    public static boolean isWindowless(IFormatReader r) {
        return LociPrefs.getPref(PREF_READER_WINDOWLESS, r.getClass(), false);
    }

    public static boolean isReaderEnabled(Class c) {
        return LociPrefs.getPref(PREF_READER_ENABLED, c, true);
    }

    public static boolean isND2Nikon() {
        return Prefs.get((String)PREF_ND2_NIKON, (boolean)false);
    }

    public static boolean isPictQTJava() {
        return Prefs.get((String)PREF_PICT_QTJAVA, (boolean)false);
    }

    public static boolean isQTQTJava() {
        return Prefs.get((String)PREF_QT_QTJAVA, (boolean)false);
    }

    public static boolean isSDTIntensity() {
        return Prefs.get((String)PREF_SDT_INTENSITY, (boolean)false);
    }

    private static boolean getPref(String pref, Class c, boolean defaultValue) {
        String n = c.getName();
        String readerName = n.substring(n.lastIndexOf(".") + 1, n.length() - 6);
        String key = pref + "." + readerName;
        return Prefs.get((String)key, (boolean)defaultValue);
    }
}

