/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;

public class NetcdfTools {
    private static final String NO_NETCDF_MSG = "NetCDF is required to read NetCDF/HDF variants.  Please obtain the necessary JAR files from http://loci.wisc.edu/ome/formats.html.\nRequired JAR files are netcdf-4.0.jar, bufr-1.1.00.jar, grib-5.1.03.jar , and slf4j-jdk14.jar.";
    private boolean noNetCDF;
    private ReflectedUniverse r;
    private String currentFile;
    private Vector attributeList;
    private Vector variableList;

    public NetcdfTools(String file2) throws FormatException {
        this.currentFile = file2;
        this.initialize();
    }

    public Vector getAttributeList() {
        return this.attributeList;
    }

    public Vector getVariableList() {
        return this.variableList;
    }

    public String getAttributeValue(String name) {
        String dir = this.getDirectory(name);
        String attr = this.getName(name);
        try {
            this.setupGroup(dir);
            this.r.setVar("name", attr);
            Object v = this.r.exec("attribute = g.findAttribute(name)");
            if (v == null) {
                return null;
            }
            Boolean isString = (Boolean)this.r.exec("isString = attribute.isString()");
            if (isString.booleanValue()) {
                this.r.exec("array = attribute.getValues()");
                Object[] s = (Object[])this.r.exec("s = array.copyTo1DJavaArray()");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < s.length; ++i) {
                    sb.append((String)s[i]);
                }
                return sb.toString();
            }
        }
        catch (ReflectException e) {
            LogTools.trace(e);
        }
        return null;
    }

    public Object getVariableValue(String name) {
        return this.getArray(name, null, null);
    }

    public Object getArray(String path, int[] origin, int[] lengths) {
        String dir = this.getDirectory(path);
        String attr = this.getName(path);
        try {
            this.setupGroup(dir);
            this.r.setVar("name", attr);
            this.r.setVar("origin", origin);
            this.r.setVar("shape", lengths);
            this.r.exec("var = g.findVariable(name)");
            if (origin != null && lengths != null) {
                this.r.exec("data = var.read(origin, shape)");
                this.r.exec("data = data.reduce()");
            } else {
                this.r.exec("data = var.read()");
            }
            return this.r.exec("data = data.copyToNDJavaArray()");
        }
        catch (ReflectException e) {
            LogTools.trace(e);
            return null;
        }
    }

    public Hashtable getVariableAttributes(String name) {
        String dir = this.getDirectory(name);
        String attr = this.getName(name);
        try {
            this.setupGroup(dir);
            this.r.setVar("name", attr);
            this.r.exec("var = g.findVariable(name)");
            List l = (List)this.r.exec("attributes = var.getAttributes()");
            Hashtable<Object, Object> h = new Hashtable<Object, Object>();
            for (int i = 0; i < l.size(); ++i) {
                this.r.setVar("attr", l.get(i));
                this.r.exec("array = attr.getValues()");
                h.put(this.r.exec("attr.getName()"), this.r.exec("s = array.copyTo1DJavaArray()"));
            }
            return h;
        }
        catch (ReflectException e) {
            LogTools.trace(e);
            return null;
        }
    }

    public int getDimension(String name) {
        String dir = name.substring(0, name.lastIndexOf("/"));
        String attr = name.substring(name.lastIndexOf("/") + 1);
        try {
            this.setupGroup(dir);
            this.r.setVar("name", attr);
            this.r.exec("dim = g.findDimension(name)");
            return (Integer)this.r.exec("dim.getLength()");
        }
        catch (ReflectException e) {
            LogTools.trace(e);
            return -1;
        }
    }

    public void close() {
        try {
            this.r.exec("ncfile.close()");
        }
        catch (ReflectException reflectException) {
            // empty catch block
        }
    }

    private void initialize() throws FormatException {
        this.r = null;
        try {
            this.r = new ReflectedUniverse();
            this.r.exec("import ucar.ma2.Array");
            this.r.exec("import ucar.ma2.ArrayByte");
            this.r.exec("import ucar.nc2.Attribute");
            this.r.exec("import ucar.nc2.Group");
            this.r.exec("import ucar.nc2.NetcdfFile");
        }
        catch (ReflectException exc) {
            this.noNetCDF = true;
            throw new FormatException(NO_NETCDF_MSG, exc);
        }
        catch (UnsupportedClassVersionError exc) {
            this.noNetCDF = true;
            throw new FormatException(NO_NETCDF_MSG, exc);
        }
        PrintStream out = new PrintStream(System.out){

            public void print(String s) {
                if (s == null || !s.trim().startsWith("WARN:")) {
                    super.print(s);
                }
            }

            public void println(String s) {
                if (s == null || !s.trim().startsWith("WARN:")) {
                    super.println(s);
                }
            }
        };
        System.setOut(out);
        try {
            this.r.setVar("currentId", Location.getMappedId(this.currentFile));
            this.r.exec("ncfile = NetcdfFile.open(currentId)");
            this.r.exec("root = ncfile.getRootGroup()");
            this.attributeList = new Vector();
            this.variableList = new Vector();
            Vector<Object> groups = new Vector<Object>();
            groups.add(this.r.getVar("root"));
            this.parseAttributesAndVariables(groups);
        }
        catch (ReflectException e) {
            LogTools.trace(e);
        }
    }

    private void parseAttributesAndVariables(List groups) {
        for (int i = 0; i < groups.size(); ++i) {
            try {
                String name;
                int j;
                this.r.setVar("group", groups.get(i));
                String groupName = (String)this.r.exec("groupName = group.getName()");
                List l = (List)this.r.exec("attributes = group.getAttributes()");
                for (j = 0; j < l.size(); ++j) {
                    this.r.setVar("attr", l.get(j));
                    name = (String)this.r.exec("name = attr.getName()");
                    if (!groupName.endsWith("/")) {
                        name = "/" + name;
                    }
                    this.attributeList.add(groupName + name);
                }
                l = (List)this.r.exec("variables = group.getVariables()");
                for (j = 0; j < l.size(); ++j) {
                    this.r.setVar("var", l.get(j));
                    name = (String)this.r.exec("name = var.getName()");
                    if (!groupName.endsWith("/")) {
                        name = "/" + name;
                    }
                    this.variableList.add(groupName + name);
                }
                List g = (List)this.r.exec("groups = group.getGroups()");
                this.parseAttributesAndVariables(g);
                continue;
            }
            catch (ReflectException e) {
                LogTools.trace(e);
            }
        }
    }

    private Object findGroup(String name, String parent, String store) {
        try {
            this.r.setVar("name", name);
            return this.r.exec(store + " = " + parent + ".findGroup(name)");
        }
        catch (ReflectException e) {
            LogTools.trace(e);
            return null;
        }
    }

    private void setupGroup(String name) throws ReflectException {
        if (name.indexOf("/") == -1) {
            this.r.setVar("g", this.r.getVar("root"));
            return;
        }
        StringTokenizer tokens = new StringTokenizer(name, "/");
        String parent = null;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            this.findGroup(token, parent == null ? "root" : "g", "g");
            if (!tokens.hasMoreTokens()) continue;
            parent = token;
        }
        if (parent == null) {
            this.r.setVar("g", this.r.getVar("root"));
        }
    }

    private String getDirectory(String path) {
        return path.substring(0, path.lastIndexOf("/"));
    }

    private String getName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }
}

