/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphHandler
extends DefaultHandler {
    private Hashtable metadata;
    private Vector timestamps;
    private String imageName;
    private String date;
    private Vector wavelengths;
    private Vector zPositions;
    private float pixelSizeX;
    private float pixelSizeY;
    private float temperature;
    private String binning;
    private float readOutRate;
    private float zoom;
    private float positionX;
    private float positionY;
    private Vector exposures;

    public MetamorphHandler(Hashtable metadata) {
        this.metadata = metadata;
        this.timestamps = new Vector();
        this.wavelengths = new Vector();
        this.zPositions = new Vector();
        this.exposures = new Vector();
    }

    public Vector getTimestamps() {
        return this.timestamps;
    }

    public Vector getWavelengths() {
        return this.wavelengths;
    }

    public Vector getZPositions() {
        return this.zPositions;
    }

    public String getDate() {
        return this.date;
    }

    public String getImageName() {
        return this.imageName;
    }

    public float getPixelSizeX() {
        return this.pixelSizeX;
    }

    public float getPixelSizeY() {
        return this.pixelSizeY;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public String getBinning() {
        return this.binning;
    }

    public float getReadOutRate() {
        return this.readOutRate;
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getStagePositionX() {
        return this.positionX;
    }

    public float getStagePositionY() {
        return this.positionY;
    }

    public Vector getExposures() {
        return this.exposures;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String id = attributes.getValue("id");
        String value = attributes.getValue("value");
        String delim = "&#13;&#10;";
        if (id != null && value != null) {
            if (id.equals("Description")) {
                this.metadata.remove("Comment");
                String k = null;
                String v = null;
                if (value.indexOf(delim) != -1) {
                    int currentIndex = -delim.length();
                    while (currentIndex != -1) {
                        int nextIndex = value.indexOf(delim, currentIndex += delim.length());
                        String line = null;
                        line = nextIndex == -1 ? value.substring(currentIndex, value.length()) : value.substring(currentIndex, nextIndex);
                        currentIndex = nextIndex;
                        int colon = line.indexOf(":");
                        if (colon == -1) continue;
                        k = line.substring(0, colon).trim();
                        v = line.substring(colon + 1).trim();
                        this.metadata.put(k, v);
                        this.checkKey(k, v);
                    }
                } else {
                    int colon = value.indexOf(":");
                    while (colon != -1) {
                        k = value.substring(0, colon);
                        int space = value.lastIndexOf(" ", value.indexOf(":", colon + 1));
                        if (space == -1) {
                            space = value.length();
                        }
                        v = value.substring(colon + 1, space).trim();
                        this.metadata.put(k, v);
                        value = value.substring(space).trim();
                        colon = value.indexOf(":");
                        this.checkKey(k, v);
                    }
                }
            } else {
                this.metadata.put(id, value);
                this.checkKey(id, value);
            }
        }
    }

    private void checkKey(String key, String value) {
        if (key.equals("Temperature")) {
            this.temperature = Float.parseFloat(value);
        } else if (key.equals("spatial-calibration-x")) {
            this.pixelSizeX = Float.parseFloat(value);
        } else if (key.equals("spatial-calibration-y")) {
            this.pixelSizeY = Float.parseFloat(value);
        } else if (key.equals("z-position")) {
            this.zPositions.add(new Float(value));
        } else if (key.equals("wavelength")) {
            this.wavelengths.add(new Integer(value));
        } else if (key.equals("acquisition-time-local")) {
            this.date = value;
            this.timestamps.add(this.date);
        } else if (key.equals("image-name")) {
            this.imageName = value;
        } else if (key.equals("Binning")) {
            this.binning = value;
        } else if (key.equals("Readout Frequency")) {
            this.readOutRate = Float.parseFloat(value);
        } else if (key.equals("zoom-percent")) {
            this.zoom = Float.parseFloat(value);
        } else if (key.equals("stage-position-x")) {
            this.positionX = Float.parseFloat(value);
        } else if (key.equals("stage-position-y")) {
            this.positionY = Float.parseFloat(value);
        } else if (key.equals("Speed")) {
            this.readOutRate = Float.parseFloat(value);
        } else if (key.equals("Exposure")) {
            if (value.indexOf(" ") != -1) {
                value = value.substring(0, value.indexOf(" "));
            }
            this.exposures.add(new Float(Float.parseFloat(value) / 1000.0f));
        }
    }
}

