/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import java.util.Vector;
import loci.common.RandomAccessOutputStream;
import loci.common.XMLTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.Base64Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.MetadataRetrieve;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class OMEXMLWriter
extends FormatWriter {
    private Vector xmlFragments;
    private RandomAccessOutputStream out;
    private String currentFragment;

    public OMEXMLWriter() {
        super("OME-XML", "ome");
        this.compressionTypes = new String[]{"Uncompressed", "zlib", "J2K", "JPEG"};
        this.compression = this.compressionTypes[0];
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.xmlFragments = null;
        this.initialized = false;
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(retrieve, series);
        if (!this.initialized) {
            this.out = new RandomAccessOutputStream(this.currentId);
            String xml = MetadataTools.getOMEXML(retrieve);
            this.xmlFragments = new Vector();
            this.currentFragment = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            XMLTools.parseXML(xml, (DefaultHandler)new OMEHandler());
            this.xmlFragments.add(this.currentFragment);
            this.out.writeBytes((String)this.xmlFragments.get(0));
            this.initialized = true;
        }
        boolean littleEndian = retrieve.getPixelsBigEndian(series, 0) == false;
        String type = retrieve.getPixelsPixelType(series, 0);
        int pixelType = FormatTools.pixelTypeFromString(type);
        CodecOptions options = new CodecOptions();
        options.width = retrieve.getPixelsSizeX(series, 0);
        options.height = retrieve.getPixelsSizeY(series, 0);
        options.channels = 1;
        options.interleaved = false;
        options.littleEndian = littleEndian;
        options.signed = FormatTools.isSigned(pixelType);
        int bytes = FormatTools.getBytesPerPixel(pixelType);
        options.bitsPerSample = bytes * 8;
        int nChannels = retrieve.getLogicalChannelSamplesPerPixel(series, 0);
        for (int i = 0; i < nChannels; ++i) {
            byte[] b = ImageTools.splitChannels(buf, i, nChannels, bytes, false, this.interleaved);
            if (this.compression.equals("J2K")) {
                b = new JPEG2000Codec().compress(b, options);
            } else if (this.compression.equals("JPEG")) {
                b = new JPEGCodec().compress(b, options);
            } else if (this.compression.equals("zlib")) {
                b = new ZlibCodec().compress(b, options);
            }
            byte[] encodedPix = new Base64Codec().compress(b, options);
            StringBuffer plane = new StringBuffer("\n<Bin:BinData Length=\"");
            plane.append(encodedPix.length);
            plane.append("\"");
            if (this.compression != null && !this.compression.equals("Uncompressed")) {
                plane.append(" Compression=\"");
                plane.append(this.compression);
                plane.append("\"");
            }
            plane.append(">");
            plane.append(new String(encodedPix));
            plane.append("</Bin:BinData>");
            this.out.writeBytes(plane.toString());
        }
        if (lastInSeries) {
            this.out.writeBytes((String)this.xmlFragments.get(series + 1));
        }
        if (last) {
            this.close();
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    class OMEHandler
    extends DefaultHandler {
        OMEHandler() {
        }

        public void characters(char[] ch, int start, int length) {
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + new String(ch, start, length);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            StringBuffer toAppend = new StringBuffer("\n<");
            toAppend.append(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                toAppend.append(" ");
                toAppend.append(attributes.getQName(i));
                toAppend.append("=\"");
                toAppend.append(attributes.getValue(i));
                toAppend.append("\"");
            }
            toAppend.append(">");
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + toAppend.toString();
            if (qName.equals("Pixels")) {
                OMEXMLWriter.this.xmlFragments.add(OMEXMLWriter.this.currentFragment);
                OMEXMLWriter.this.currentFragment = "";
            }
        }

        public void endElement(String uri, String localName, String qName) {
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + ("</" + qName + ">");
        }
    }
}

