/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import loci.common.ByteArrayHandle;
import loci.common.CompressedRandomAccess;
import loci.common.DataTools;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.LogTools;

public class RandomAccessInputStream
extends InputStream
implements DataInput {
    protected static final int MAX_OVERHEAD = 0x100000;
    protected static final int MAX_FILES = 100;
    protected static final int DIS = 0;
    protected static final int RAF = 1;
    protected static final int ARRAY = 2;
    private static Hashtable<RandomAccessInputStream, Boolean> fileCache = new Hashtable();
    private static int openFiles = 0;
    protected IRandomAccess raf;
    protected DataInputStream dis;
    protected long length;
    protected long fp;
    protected long afp;
    protected long mark;
    protected long nextMark;
    protected String file;
    protected byte[] buf;
    protected boolean littleEndian = false;
    protected int ext = 0;
    protected boolean compressed = false;

    public RandomAccessInputStream(String file2) throws IOException {
        this.file = file2;
        this.reopen();
        this.fp = 0L;
        this.afp = 0L;
    }

    public RandomAccessInputStream(byte[] array) throws IOException {
        this.raf = new ByteArrayHandle(array);
        this.fp = 0L;
        this.afp = 0L;
        this.length = this.raf.length();
    }

    public DataInputStream getInputStream() {
        try {
            if (Boolean.FALSE.equals(fileCache.get(this))) {
                this.reopen();
            }
        }
        catch (IOException e) {
            return null;
        }
        return this.dis;
    }

    public void setExtend(int extend) {
        this.ext = extend;
    }

    public void seek(long pos) throws IOException {
        this.afp = pos;
    }

    public int read() throws IOException {
        byte b = this.readByte();
        if (b == -1 && this.afp >= this.length() && this.ext > 0) {
            return 0;
        }
        return b;
    }

    public long length() throws IOException {
        if (Boolean.FALSE.equals(fileCache.get(this))) {
            this.reopen();
        }
        return this.length;
    }

    public long getFilePointer() {
        return this.afp;
    }

    public void close() throws IOException {
        if (Location.getMappedFile(this.file) != null) {
            return;
        }
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
        if (this.dis != null) {
            this.dis.close();
        }
        this.dis = null;
        this.buf = null;
        if (Boolean.TRUE.equals(fileCache.get(this))) {
            fileCache.put(this, false);
            --openFiles;
        }
    }

    public void order(boolean little) {
        this.littleEndian = little;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public String readString(String lastChars) throws IOException {
        StringBuffer sb = new StringBuffer();
        char c = this.readChar();
        while (lastChars.indexOf(c) == -1 && this.getFilePointer() < this.length()) {
            sb = sb.append(c);
            c = this.readChar();
        }
        return sb.toString();
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        int status = this.checkEfficiency(1);
        long oldAFP = this.afp;
        if (this.afp < this.length - 1L) {
            ++this.afp;
        }
        if (status == 0) {
            byte b = this.dis.readByte();
            ++this.fp;
            return b;
        }
        if (status == 2) {
            return this.buf[(int)oldAFP];
        }
        byte b = this.raf.readByte();
        return b;
    }

    public char readChar() throws IOException {
        return (char)this.readByte();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public int readInt() throws IOException {
        return DataTools.read4SignedBytes(this, this.littleEndian);
    }

    public String readLine() throws IOException {
        return this.readString("\n");
    }

    public String readCString() throws IOException {
        return this.readString("\\0");
    }

    public String readString(int n) throws IOException {
        byte[] b = new byte[n];
        this.read(b);
        return new String(b);
    }

    public long readLong() throws IOException {
        return DataTools.read8SignedBytes(this, this.littleEndian);
    }

    public short readShort() throws IOException {
        return DataTools.read2SignedBytes(this, this.littleEndian);
    }

    public int readUnsignedByte() throws IOException {
        return DataTools.readUnsignedByte(this);
    }

    public int readUnsignedShort() throws IOException {
        return DataTools.read2UnsignedBytes(this, this.littleEndian);
    }

    public String readUTF() throws IOException {
        return null;
    }

    public int skipBytes(int n) throws IOException {
        this.afp += (long)n;
        return n;
    }

    public int read(byte[] array) throws IOException {
        int status = this.checkEfficiency(array.length);
        int n = 0;
        if (status == 0) {
            return this.read(array, 0, array.length);
        }
        if (status == 2) {
            n = array.length;
            if ((long)this.buf.length - this.afp < (long)array.length) {
                n = this.buf.length - (int)this.afp;
            }
            System.arraycopy(this.buf, (int)this.afp, array, 0, n);
        } else {
            n = this.raf.read(array);
        }
        this.afp += (long)n;
        if (status == 0) {
            this.fp += (long)n;
        }
        if (n < array.length && this.ext > 0) {
            while (n < array.length && this.ext > 0) {
                ++n;
                --this.ext;
            }
        }
        return n;
    }

    public int read(byte[] array, int offset, int n) throws IOException {
        int toRead = n;
        int status = this.checkEfficiency(n);
        if (status == 0) {
            int p = this.dis.read(array, offset, n);
            if (p == -1) {
                return -1;
            }
            if (p >= 0 && this.fp + (long)p < this.length) {
                int k = p;
                while (k >= 0 && p < n && this.afp + (long)p <= this.length && offset + p < array.length) {
                    k = this.dis.read(array, offset + p, n - p);
                    if (k < 0) continue;
                    p += k;
                }
            }
            n = p;
        } else if (status == 2) {
            if ((long)this.buf.length - this.afp < (long)n) {
                n = this.buf.length - (int)this.afp;
            }
            System.arraycopy(this.buf, (int)this.afp, array, offset, n);
        } else {
            n = this.raf.read(array, offset, n);
        }
        this.afp += (long)n;
        if (status == 0) {
            this.fp += (long)n;
        }
        if (n < toRead && this.ext > 0) {
            while (n < array.length && this.ext > 0) {
                ++n;
                --this.ext;
            }
        }
        return n;
    }

    public void readFully(byte[] array) throws IOException {
        this.readFully(array, 0, array.length);
    }

    public void readFully(byte[] array, int offset, int n) throws IOException {
        int status = this.checkEfficiency(n);
        if (status == 0) {
            this.dis.readFully(array, offset, n);
        } else if (status == 2) {
            System.arraycopy(this.buf, (int)this.afp, array, offset, n);
        } else {
            this.raf.readFully(array, offset, n);
        }
        this.afp += (long)n;
        if (status == 0) {
            this.fp += (long)n;
        }
    }

    public int available() throws IOException {
        int available;
        if (Boolean.FALSE.equals(fileCache.get(this))) {
            this.reopen();
        }
        int n = available = this.dis != null ? this.dis.available() + this.ext : (int)(this.length() - this.getFilePointer());
        if (available < 0) {
            available = Integer.MAX_VALUE;
        }
        return available;
    }

    public void mark(int readLimit) {
        try {
            if (Boolean.FALSE.equals(fileCache.get(this))) {
                this.reopen();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.compressed) {
            this.dis.mark(readLimit);
        }
    }

    public boolean markSupported() {
        return !this.compressed;
    }

    public void reset() throws IOException {
        if (Boolean.FALSE.equals(fileCache.get(this))) {
            this.reopen();
        }
        this.dis.reset();
        this.fp = this.length() - (long)this.dis.available();
    }

    protected int checkEfficiency(int toRead) throws IOException {
        if (Boolean.FALSE.equals(fileCache.get(this))) {
            this.reopen();
        }
        if (this.dis != null && this.raf != null && this.afp + (long)toRead < 0x100000L && this.afp + (long)toRead < this.length() && this.afp + (long)toRead < (long)this.buf.length) {
            return 2;
        }
        if (this.dis != null) {
            if (this.fp < this.length()) {
                while (this.fp > this.length() - (long)this.dis.available()) {
                    while (this.fp - this.length() + (long)this.dis.available() > Integer.MAX_VALUE) {
                        this.dis.skipBytes(Integer.MAX_VALUE);
                    }
                    this.dis.skipBytes((int)(this.fp - (this.length() - (long)this.dis.available())));
                }
            } else {
                this.fp = this.afp;
                this.dis.close();
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(Location.getMappedId(this.file)), 0x100000);
                this.dis = new DataInputStream(bis);
                while (this.fp > this.length() - (long)this.dis.available()) {
                    while (this.fp - this.length() + (long)this.dis.available() > Integer.MAX_VALUE) {
                        this.dis.skipBytes(Integer.MAX_VALUE);
                    }
                    this.dis.skipBytes((int)(this.fp - this.length() + (long)this.dis.available()));
                }
            }
        }
        if (this.afp >= this.fp && this.dis != null) {
            while (this.fp < this.afp) {
                while (this.afp - this.fp > Integer.MAX_VALUE) {
                    this.fp += (long)this.dis.skipBytes(Integer.MAX_VALUE);
                }
                int skip = this.dis.skipBytes((int)(this.afp - this.fp));
                if (skip == 0) break;
                this.fp += (long)skip;
            }
            this.resetMark();
            return 0;
        }
        if (this.dis != null && this.afp >= this.mark && this.fp < this.mark) {
            boolean valid = true;
            try {
                this.dis.reset();
            }
            catch (IOException io) {
                valid = false;
            }
            if (valid) {
                this.dis.mark(0x100000);
                this.fp = this.length() - (long)this.dis.available();
                while (this.fp < this.afp) {
                    while (this.afp - this.fp > Integer.MAX_VALUE) {
                        this.fp += (long)this.dis.skipBytes(Integer.MAX_VALUE);
                    }
                    int skip = this.dis.skipBytes((int)(this.afp - this.fp));
                    if (skip == 0) break;
                    this.fp += (long)skip;
                }
                this.resetMark();
                return 0;
            }
        }
        this.raf.seek(this.afp);
        return 1;
    }

    private void resetMark() {
        if (this.fp >= this.nextMark) {
            this.dis.mark(0x100000);
        }
        this.nextMark = this.fp + 0x100000L;
        this.mark = this.fp;
    }

    private void reopen() throws IOException {
        String path = Location.getMappedId(this.file);
        File f = new File(path).getAbsoluteFile();
        this.raf = Location.getHandle(this.file);
        this.length = this.raf.length();
        if (this.raf == null) {
            throw new IOException("File not found: " + this.file);
        }
        if (f.exists()) {
            this.compressed = this.raf instanceof CompressedRandomAccess;
            if (this.compressed) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path), 0x100000);
                if (this.dis != null) {
                    this.dis.close();
                }
                this.dis = new DataInputStream(bis);
                this.buf = new byte[(int)(this.length < 0x100000L ? this.length : 0x100000L)];
                this.raf.readFully(this.buf);
                this.raf.seek(0L);
                this.nextMark = 0x100000L;
            }
        }
        fileCache.put(this, true);
        if (++openFiles > 100) {
            this.cleanCache();
        }
    }

    private void cleanCache() {
        int toClose = 90;
        RandomAccessInputStream[] files = fileCache.keySet().toArray(new RandomAccessInputStream[0]);
        int closed = 0;
        int ndx = 0;
        while (closed < toClose) {
            if (!this.equals(files[ndx]) && files[ndx].file != null && Boolean.TRUE.equals(fileCache.get(files[ndx]))) {
                try {
                    files[ndx].close();
                }
                catch (IOException exc) {
                    LogTools.trace(exc);
                }
                ++closed;
            }
            ++ndx;
        }
    }
}

