/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import loci.common.LogTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLTools {
    private XMLTools() {
    }

    public static void validateXML(String xml) {
        XMLTools.validateXML(xml, null);
    }

    public static void validateXML(String xml, String label) {
        String version;
        int dot;
        if (label == null) {
            label = "XML";
        }
        if ((dot = (version = System.getProperty("java.version")).indexOf(".")) >= 0) {
            dot = version.indexOf(".", dot + 1);
        }
        float ver = Float.NaN;
        if (dot >= 0) {
            try {
                ver = Float.parseFloat(version.substring(0, dot));
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        if (ver != ver) {
            LogTools.println("Warning: cannot determine if Java version\"" + version + "\" supports Java v1.5. XML validation may fail.");
        }
        if (ver < 1.5f) {
            return;
        }
        LogTools.println("Parsing schema path");
        ValidationSAXHandler saxHandler = new ValidationSAXHandler();
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        Exception exception = null;
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            saxParser.parse((InputStream)is, (DefaultHandler)saxHandler);
        }
        catch (ParserConfigurationException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            LogTools.println("Error parsing schema path from " + label + ":");
            LogTools.trace(exception);
            return;
        }
        String schemaPath = saxHandler.getSchemaPath();
        if (schemaPath == null) {
            LogTools.println("No schema path found. Validation cannot continue.");
            return;
        }
        LogTools.println(schemaPath);
        LogTools.println("Validating " + label);
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.setVar("xmlSchemaPath", "http://www.w3.org/2001/XMLSchema");
            r.exec("import javax.xml.validation.SchemaFactory");
            r.exec("factory = SchemaFactory.newInstance(xmlSchemaPath)");
            r.exec("import java.net.URL");
            r.setVar("schemaPath", schemaPath);
            r.exec("schemaLocation = new URL(schemaPath)");
            r.exec("schema = factory.newSchema(schemaLocation)");
            r.setAccessibilityIgnored(true);
            r.exec("validator = schema.newValidator()");
            r.exec("import java.io.StringReader");
            r.setVar("xml", xml);
            r.exec("reader = new StringReader(xml)");
            r.exec("import org.xml.sax.InputSource");
            r.exec("is = new InputSource(reader)");
            r.exec("import javax.xml.transform.sax.SAXSource");
            r.exec("source = new SAXSource(is)");
            ValidationErrorHandler errorHandler = new ValidationErrorHandler();
            r.setVar("errorHandler", errorHandler);
            r.exec("validator.setErrorHandler(errorHandler)");
            r.exec("validator.validate(source)");
            if (errorHandler.ok()) {
                LogTools.println("No validation errors found.");
            }
        }
        catch (ReflectException exc) {
            LogTools.println("Error validating " + label + ":");
            LogTools.trace(exc);
        }
    }

    public static String indentXML(String xml) {
        return XMLTools.indentXML(xml, 3, false);
    }

    public static String indentXML(String xml, int spacing) {
        return XMLTools.indentXML(xml, spacing, false);
    }

    public static String indentXML(String xml, int spacing, boolean preserveCData) {
        if (xml == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(xml, "<>", true);
        int indent = 0;
        int noSpace = 0;
        boolean first = true;
        boolean element = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.equals("")) continue;
            if (token.equals("<")) {
                element = true;
                continue;
            }
            if (element && token.equals(">")) {
                element = false;
                continue;
            }
            if (!element && preserveCData) {
                noSpace = 2;
            }
            if (noSpace == 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n");
                }
            }
            if (element && token.startsWith("/")) {
                indent -= spacing;
            }
            if (noSpace == 0) {
                for (int j = 0; j < indent; ++j) {
                    sb.append(" ");
                }
            }
            if (element) {
                sb.append("<");
            }
            sb.append(token);
            if (element) {
                sb.append(">");
            }
            if (!(noSpace != 0 || !element || token.startsWith("?") || token.startsWith("/") || token.endsWith("/") || token.startsWith("!"))) {
                indent += spacing;
            }
            if (noSpace <= 0) continue;
            --noSpace;
        }
        sb.append("\n");
        return sb.toString();
    }

    private static class ValidationErrorHandler
    implements ErrorHandler {
        private boolean ok = true;

        private ValidationErrorHandler() {
        }

        public boolean ok() {
            return this.ok;
        }

        public void error(SAXParseException e) {
            LogTools.println("error: " + e.getMessage());
            this.ok = false;
        }

        public void fatalError(SAXParseException e) {
            LogTools.println("fatal error: " + e.getMessage());
            this.ok = false;
        }

        public void warning(SAXParseException e) {
            LogTools.println("warning: " + e.getMessage());
            this.ok = false;
        }
    }

    private static class ValidationSAXHandler
    extends DefaultHandler {
        private String schemaPath;
        private boolean first;

        private ValidationSAXHandler() {
        }

        public String getSchemaPath() {
            return this.schemaPath;
        }

        public void startDocument() {
            this.schemaPath = null;
            this.first = true;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!this.first) {
                return;
            }
            this.first = false;
            int len = attributes.getLength();
            String xmlns = null;
            String xsiSchemaLocation = null;
            for (int i = 0; i < len; ++i) {
                String name = attributes.getQName(i);
                if (name.equals("xmlns")) {
                    xmlns = attributes.getValue(i);
                    continue;
                }
                if (!name.equals("schemaLocation") && !name.endsWith(":schemaLocation")) continue;
                xsiSchemaLocation = attributes.getValue(i);
            }
            if (xmlns == null || xsiSchemaLocation == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(xsiSchemaLocation);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!xmlns.equals(token)) continue;
                if (!st.hasMoreTokens()) break;
                this.schemaPath = st.nextToken();
                break;
            }
        }
    }
}

