/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.TiffRational;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;

public class GelReader
extends BaseTiffReader {
    private static final int MD_FILETAG = 33445;
    private static final int MD_SCALE_PIXEL = 33446;
    private static final int MD_LAB_NAME = 33448;
    private static final int MD_SAMPLE_INFO = 33449;
    private static final int MD_PREP_DATE = 33450;
    private static final int MD_PREP_TIME = 33451;
    private static final int MD_FILE_UNITS = 33452;
    private static final int SQUARE_ROOT = 2;
    private static final int LINEAR = 128;

    public GelReader() {
        super("Amersham Biosciences GEL", new String[]{"gel"});
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        boolean sqrt;
        boolean bl = sqrt = TiffTools.getIFDLongValue(this.ifds[no], 33445, true, 128L) == 2L;
        if (sqrt) {
            float scale = ((TiffRational)TiffTools.getIFDValue(this.ifds[no], 33446)).floatValue();
            byte[] tmp = new byte[buf.length];
            super.openBytes(no, tmp, x, y, w, h);
            int originalBytes = TiffTools.getBitsPerSample(this.ifds[no])[0] / 8;
            for (int i = 0; i < tmp.length / 4; ++i) {
                long value = DataTools.bytesToShort(tmp, i * originalBytes, originalBytes, this.isLittleEndian());
                long square = value * value;
                float pixel = (float)square * scale;
                DataTools.unpackBytes(Float.floatToIntBits(pixel), buf, i * 4, 4, this.isLittleEndian());
            }
        } else {
            super.openBytes(no, buf, x, y, w, h);
        }
        return buf;
    }

    protected void initMetadata() throws FormatException, IOException {
        this.ifds = TiffTools.getIFDs(this.in);
        if (this.ifds.length > 1) {
            Hashtable[] tmpIFDs = this.ifds;
            this.ifds = new Hashtable[tmpIFDs.length / 2];
            for (int i = 0; i < this.ifds.length; ++i) {
                this.ifds[i] = new Hashtable();
                this.ifds[i].putAll(tmpIFDs[i * 2 + 1]);
                this.ifds[i].putAll(tmpIFDs[i * 2]);
            }
        }
        super.initStandardMetadata();
        long fmt = TiffTools.getIFDLongValue(this.ifds[0], 33445, true, 128L);
        if (fmt == 2L) {
            this.core[0].pixelType = 6;
        }
        this.addGlobalMeta("Data format", fmt == 2L ? "square root" : "linear");
        TiffRational scale = (TiffRational)TiffTools.getIFDValue(this.ifds[0], 33446);
        this.addGlobalMeta("Scale factor", scale == null ? new TiffRational(1L, 1L) : scale);
        String lab = (String)TiffTools.getIFDValue(this.ifds[0], 33448);
        this.addGlobalMeta("Lab name", lab);
        String info = (String)TiffTools.getIFDValue(this.ifds[0], 33449);
        this.addGlobalMeta("Sample info", info);
        String prepDate = (String)TiffTools.getIFDValue(this.ifds[0], 33450);
        this.addGlobalMeta("Date prepared", prepDate);
        String prepTime = (String)TiffTools.getIFDValue(this.ifds[0], 33451);
        this.addGlobalMeta("Time prepared", prepTime);
        String units = (String)TiffTools.getIFDValue(this.ifds[0], 33452);
        this.addGlobalMeta("File units", units);
        this.core[0].imageCount = this.ifds.length;
        this.core[0].sizeT = this.getImageCount();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName("", 0);
        store.setImageDescription(info, 0);
        if (prepTime != null) {
            SimpleDateFormat parse = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
            Date date = parse.parse(prepTime, new ParsePosition(0));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            store.setImageCreationDate(sdf.format(date), 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.getCurrentFile(), 0);
        }
        Float pixelSize = new Float(scale.floatValue());
        store.setDimensionsPhysicalSizeX(pixelSize, 0, 0);
        store.setDimensionsPhysicalSizeY(pixelSize, 0, 0);
    }
}

