/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.NetcdfTools;
import loci.formats.meta.FilterMetadata;

public class MINCReader
extends FormatReader {
    private NetcdfTools netcdf;
    private byte[][][] pixelData;

    public MINCReader() {
        super("MINC MRI", "mnc");
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (no < this.pixelData.length) {
            for (int row = y; row < y + h; ++row) {
                if (row >= this.pixelData[no].length || x + w > this.pixelData[no][row].length) continue;
                System.arraycopy(this.pixelData[no][row], x, buf, (h - row + y - 1) * w, w);
            }
        }
        return buf;
    }

    public void close() throws IOException {
        super.close();
        if (this.netcdf != null) {
            this.netcdf.close();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("MINCReader.initFile(" + id + ")");
        super.initFile(id);
        this.netcdf = new NetcdfTools(id);
        Vector variableList = this.netcdf.getVariableList();
        for (int i = 0; i < variableList.size(); ++i) {
            String variable = (String)variableList.get(i);
            Hashtable attributes = this.netcdf.getVariableAttributes(variable);
            Object[] keys = attributes.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int j = 0; j < keys.length; ++j) {
                if (!(attributes.get(keys[j]) instanceof Object[])) continue;
                StringBuffer sb = new StringBuffer();
                Object[] o = (Object[])attributes.get(keys[j]);
                for (int q = 0; q < o.length; ++q) {
                    sb.append(o[q].toString());
                }
                this.addGlobalMeta(variable + " " + (String)keys[j], sb.toString());
            }
        }
        this.pixelData = (byte[][][])this.netcdf.getVariableValue("/image");
        this.core[0].sizeX = this.netcdf.getDimension("/zspace");
        this.core[0].sizeY = this.netcdf.getDimension("/yspace");
        this.core[0].sizeZ = this.netcdf.getDimension("/xspace");
        this.core[0].sizeT = 1;
        this.core[0].sizeC = 1;
        this.core[0].imageCount = this.core[0].sizeZ;
        this.core[0].rgb = false;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].pixelType = 1;
        this.addGlobalMeta("Comment", this.netcdf.getAttributeValue("/history"));
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setImageName("", 0);
        store.setImageDescription(this.netcdf.getAttributeValue("/history"), 0);
    }
}

