/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_1_0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_1_0.GetCapabilities;
import thredds.wcs.v1_1_0.WcsException;
import ucar.nc2.dt.GridDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    private static Logger log = LoggerFactory.getLogger(Request.class);
    private Operation operation;
    private String negotiatedVersion;
    private String expectedVersion = "1.1.0";
    private List<GetCapabilities.Section> sections;
    private List<String> identifierList;
    private String identifier;
    private String datasetPath;
    private GridDataset dataset;
    private List<String> availableCoverageNames;

    public static Request getGetCapabilitiesRequest(Operation operation, String negotiatedVersion, List<GetCapabilities.Section> sections, String datasetPath, GridDataset dataset) {
        Request req = new Request(operation, negotiatedVersion, datasetPath, dataset);
        if (!operation.equals((Object)Operation.GetCapabilities)) {
            throw new IllegalArgumentException("The \"" + operation.toString() + "\" operation not supported by this method.");
        }
        req.sections = sections;
        if (req.sections == null) {
            throw new IllegalArgumentException("Non-null section list required.");
        }
        return req;
    }

    public static Request getDescribeCoverageRequest(Operation operation, String negotiatedVersion, List<String> identifiers, String datasetPath, GridDataset dataset) throws WcsException {
        Request req = new Request(operation, negotiatedVersion, datasetPath, dataset);
        if (!operation.equals((Object)Operation.DescribeCoverage)) {
            throw new IllegalArgumentException("The \"" + operation.toString() + "\" operation not supported by this method.");
        }
        if (!req.availableCoverageNames.containsAll(identifiers)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "identifiers", "The \"identifiers\" parameter contains unrecognized values: " + identifiers);
        }
        req.identifierList = identifiers;
        return req;
    }

    public static Request getGetCoverageRequest(Operation operation, String negotiatedVersion, String identifier, String datasetPath, GridDataset dataset) throws WcsException {
        Request req = new Request(operation, negotiatedVersion, datasetPath, dataset);
        if (!operation.equals((Object)Operation.GetCoverage)) {
            throw new IllegalArgumentException("The \"" + operation.toString() + "\" operation not supported by this method.");
        }
        if (!req.availableCoverageNames.contains(identifier)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "identifier", "Unrecognized value in \"identifier\" parameter: " + identifier);
        }
        req.identifier = identifier;
        return req;
    }

    Request(Operation operation, String negotiatedVersion, String datasetPath, GridDataset dataset) {
        this.operation = operation;
        this.negotiatedVersion = negotiatedVersion;
        this.datasetPath = datasetPath;
        this.dataset = dataset;
        this.availableCoverageNames = new ArrayList<String>();
        for (GridDataset.Gridset gs : this.dataset.getGridsets()) {
            this.availableCoverageNames.add(gs.getGeoCoordSystem().getName());
        }
        if (operation == null) {
            throw new IllegalArgumentException("Non-null operation required.");
        }
        if (this.negotiatedVersion == null) {
            throw new IllegalArgumentException("Non-null negotiated version required.");
        }
        if (!this.negotiatedVersion.equals(this.expectedVersion)) {
            throw new IllegalArgumentException("Version <" + negotiatedVersion + "> not as expected <" + this.expectedVersion + ">.");
        }
        if (this.datasetPath == null) {
            throw new IllegalArgumentException("Non-null dataset path required.");
        }
        if (this.dataset == null) {
            throw new IllegalArgumentException("Non-null dataset required.");
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getDatasetPath() {
        return this.datasetPath;
    }

    public GridDataset getDataset() {
        return this.dataset;
    }

    public List<String> getAvailableCoverageNames() {
        return this.availableCoverageNames;
    }

    public List<GetCapabilities.Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public List<String> getIdentifierList() {
        return this.identifierList;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        NONE,
        GeoTIFF,
        GeoTIFF_Float,
        NetCDF3;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestEncoding {
        GET_KVP,
        POST_XML,
        POST_SOAP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        GetCapabilities,
        DescribeCoverage,
        GetCoverage;

    }
}

