/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import java.nio.ByteOrder;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TIFFStreamMetadata
extends IIOMetadata {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_tiff_stream_1.0";
    static final String nativeMetadataFormatClassName = "com.sun.media.imageioimpl.plugins.tiff.TIFFStreamMetadataFormat";
    private static final String bigEndianString = ByteOrder.BIG_ENDIAN.toString();
    private static final String littleEndianString = ByteOrder.LITTLE_ENDIAN.toString();
    public ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public TIFFStreamMetadata() {
        super(false, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
    }

    public boolean isReadOnly() {
        return false;
    }

    private static void fatal(Node node2, String reason) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(reason, node2);
    }

    public Node getAsTree(String formatName) {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode byteOrderNode = new IIOMetadataNode("ByteOrder");
        byteOrderNode.setAttribute("value", this.byteOrder.toString());
        root.appendChild(byteOrderNode);
        return root;
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        NamedNodeMap attrs;
        String order;
        Node node2 = root;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            TIFFStreamMetadata.fatal(node2, "Root must be com_sun_media_imageio_plugins_tiff_stream_1.0");
        }
        if ((node2 = node2.getFirstChild()) == null || !node2.getNodeName().equals("ByteOrder")) {
            TIFFStreamMetadata.fatal(node2, "Root must have \"ByteOrder\" child");
        }
        if ((order = (attrs = node2.getAttributes()).getNamedItem("value").getNodeValue()) == null) {
            TIFFStreamMetadata.fatal(node2, "ByteOrder node must have a \"value\" attribute");
        }
        if (order.equals(bigEndianString)) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (order.equals(littleEndianString)) {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            TIFFStreamMetadata.fatal(node2, "Incorrect value for ByteOrder \"value\" attribute");
        }
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(nativeMetadataFormatName)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
        this.mergeNativeTree(root);
    }

    public void reset() {
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }
}

