/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.ByteVector;
import loci.formats.meta.FilterMetadata;

public class ICSReader
extends FormatReader {
    private static final String[] CATEGORIES = new String[]{"ics_version", "filename", "source", "layout", "representation", "parameter", "sensor", "history", "document", "view.*", "end", "file", "offset", "parameters", "order", "sizes", "coordinates", "significant_bits", "format", "sign", "compression", "byte_order", "origin", "scale", "units", "labels", "SCIL_TYPE", "type", "model", "s_params", "gain.*", "dwell", "shutter.*", "pinhole", "laser.*", "version", "objective", "PassCount", "step.*", "date", "GMTdate", "label", "software", "author", "length", "Z (background)", "dimensions", "rep period", "image form", "extents", "offsets", "region", "expon. order", "a.*", "tau.*", "noiseval", "excitationfwhm", "created on", "text", "other text", "mode", "CFD limit low", "CFD limit high", "CFD zc level", "CFD holdoff", "SYNC zc level", "SYNC freq div", "SYNC holdoff", "TAC range", "TAC gain", "TAC offset", "TAC limit low", "ADC resolution", "Ext latch delay", "collection time", "repeat time", "stop on time", "stop on O'flow", "dither range", "count increment", "memory bank", "sync threshold", "dead time comp", "polarity", "line compressio", "scan flyback", "scan borders", "pixel time", "pixel clock", "trigger", "scan pixels x", "scan pixels y", "routing chan x", "routing chan y", "detector type", "channel.*", "filter.*", "wavelength.*", "black level.*", "ht.*", "scan resolution", "scan speed", "scan zoom", "scan pattern", "scan pos x", "scan pos y", "transmission", "x amplitude", "y amplitude", "x offset", "y offset", "x delay", "y delay", "beam zoom", "mirror .*", "direct turret", "desc exc turret", "desc emm turret", "cube", "stage_xyzum", "cube descriptio", "camera", "exposure", "bits/pixel", "binning", "left", "top", "cols", "rows", "significant_channels", "allowedlinemodes", "real_significant_bits", "sample_width", "range", "ch", "lower_limit", "higher_limit", "passcount", "detector", "dateGMT", "RefrInxMedium", "RefrInxLensMedium", "Channels", "PinholeRadius", "LambdaEx", "LambdaEm", "ExPhotonCnt", "RefInxMedium", "NumAperture", "RefInxLensMedium", "PinholeSpacing", "power", "name", "Type", "Magnification", "NA", "WorkingDistance", "Immersion", "Pinhole", "Channel .*", "Gain .*", "Shutter .*", "Position", "Size", "Port", "Cursor", "Color", "BlackLevel", "Saturation", "Gamma", "IntZoom", "Live", "Synchronize", "ShowIndex", "AutoResize", "UseUnits", "Zoom", "IgnoreAspect", "ShowCursor", "ShowAll", "Axis", "Order", "Tile", "DimViewOption", "channels", "pinholeradius", "refrinxmedium", "numaperture", "refrinxlensmedium"};
    private String currentIcsId;
    private String currentIdsId;
    private boolean versionTwo;
    private byte[] data;
    private long offset;
    private boolean gzip;
    private boolean invertY;

    public ICSReader() {
        super("Image Cytometry Standard", new String[]{"ics", "ids"});
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int row;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int len = FormatTools.getPlaneSize(this);
        int pixel = bpp * this.getRGBChannelCount();
        int rowLen = FormatTools.getPlaneSize(this, w, 1);
        this.in.seek(this.offset + (long)(no * len));
        if (!this.isRGB() && this.getSizeC() > 4) {
            if (!this.gzip && this.data == null) {
                this.data = new byte[len * this.getSizeC()];
                this.in.read(this.data);
            }
            for (row = y; row < h + y; ++row) {
                for (int col = x; col < w + x; ++col) {
                    System.arraycopy(this.data, bpp * (no + this.getSizeC() * (row * this.getSizeX() + col)), buf, bpp * (row * w + col), bpp);
                }
            }
        } else if (this.gzip) {
            if (x == 0 && this.getSizeX() == w) {
                System.arraycopy(this.data, len * no + y * rowLen, buf, 0, h * rowLen);
            } else {
                for (row = y; row < h + y; ++row) {
                    System.arraycopy(this.data, len * no + pixel * (row * this.getSizeX() + x), buf, row * rowLen, rowLen);
                }
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        if (this.invertY) {
            byte[] row2 = new byte[rowLen];
            for (int r = 0; r < h / 2; ++r) {
                int topOffset = r * rowLen;
                int bottomOffset = (h - r - 1) * rowLen;
                System.arraycopy(buf, topOffset, row2, 0, rowLen);
                System.arraycopy(buf, bottomOffset, buf, topOffset, rowLen);
                System.arraycopy(row2, 0, buf, bottomOffset, rowLen);
            }
        }
        return buf;
    }

    public String[] getUsedFiles(boolean noPixels) {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.versionTwo) {
            String[] stringArray2;
            if (noPixels) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = this.currentIcsId;
            }
            return stringArray2;
        }
        if (noPixels) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = this.currentIcsId;
        } else {
            String[] stringArray5 = new String[2];
            stringArray5[0] = this.currentIcsId;
            stringArray = stringArray5;
            stringArray5[1] = this.currentIdsId;
        }
        return stringArray;
    }

    public void close() throws IOException {
        super.close();
        this.currentIcsId = null;
        this.currentIdsId = null;
        this.data = null;
        this.versionTwo = false;
        this.gzip = false;
        this.invertY = false;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        char[] c;
        String ext;
        this.debug("ICSReader.initFile(" + id + ")");
        super.initFile(id);
        this.status("Finding companion file");
        String icsId = id;
        String idsId = id;
        int dot = id.lastIndexOf(".");
        String string = ext = dot < 0 ? "" : id.substring(dot + 1).toLowerCase();
        if (ext.equals("ics")) {
            c = idsId.toCharArray();
            int n = c.length - 2;
            c[n] = (char)(c[n] + '\u0001');
            idsId = new String(c);
        } else if (ext.equals("ids")) {
            c = icsId.toCharArray();
            int n = c.length - 2;
            c[n] = (char)(c[n] - '\u0001');
            icsId = new String(c);
        }
        if (icsId == null) {
            throw new FormatException("No ICS file found.");
        }
        Location icsFile = new Location(icsId);
        if (!icsFile.exists()) {
            throw new FormatException("ICS file not found.");
        }
        this.status("Checking file version");
        RandomAccessInputStream f = new RandomAccessInputStream(icsId);
        if (f.readString(17).trim().equals("ics_version\t2.0")) {
            this.in = new RandomAccessInputStream(icsId);
            this.versionTwo = true;
        } else {
            if (idsId == null) {
                throw new FormatException("No IDS file found.");
            }
            Location idsFile = new Location(idsId);
            if (!idsFile.exists()) {
                throw new FormatException("IDS file not found.");
            }
            this.currentIdsId = idsId;
            this.in = new RandomAccessInputStream(this.currentIdsId);
        }
        f.close();
        this.currentIcsId = icsId;
        this.status("Reading metadata");
        Float[] pixelSizes = null;
        String[] axes = null;
        int[] axisLengths = null;
        String byteOrder = null;
        String rFormat = null;
        String compression = null;
        RandomAccessInputStream reader = new RandomAccessInputStream(icsId);
        reader.seek(0L);
        reader.readString("\r\n");
        String line = reader.readString("\r\n");
        boolean signed = false;
        StringBuffer textBlock = new StringBuffer();
        float[] sizes = null;
        Integer[] emWaves = null;
        Integer[] exWaves = null;
        Float[] stagePos = null;
        String imageName = null;
        String date = null;
        String description = null;
        Float magnification = null;
        Float lensNA = null;
        Float workingDistance = null;
        String objectiveModel = null;
        String immersion = null;
        String lastName = null;
        Hashtable<Integer, Float> gains = new Hashtable<Integer, Float>();
        Hashtable<Integer, Float> pinholes = new Hashtable<Integer, Float>();
        Hashtable<Integer, Integer> wavelengths = new Hashtable<Integer, Integer>();
        Hashtable<Integer, String> channelNames = new Hashtable<Integer, String>();
        while (line != null && !line.trim().equals("end")) {
            String[] tokens = null;
            tokens = line.indexOf("\t") != -1 ? line.split("\t") : line.split(" ");
            StringBuffer key = new StringBuffer();
            for (int q = 0; q < tokens.length; ++q) {
                int n;
                String[] waves;
                StringTokenizer t;
                Float floatValue;
                String v;
                String k;
                block136: {
                    tokens[q] = tokens[q].trim();
                    if (tokens[q].length() == 0) continue;
                    boolean foundValue = true;
                    for (int i2 = 0; i2 < CATEGORIES.length; ++i2) {
                        if (!tokens[q].matches(CATEGORIES[i2])) continue;
                        foundValue = false;
                        break;
                    }
                    if (!foundValue) {
                        key.append(tokens[q]);
                        key.append(" ");
                        continue;
                    }
                    StringBuffer value = new StringBuffer(tokens[q++]);
                    while (q < tokens.length) {
                        value.append(" ");
                        value.append(tokens[q].trim());
                        ++q;
                    }
                    k = key.toString().trim().replaceAll("\t", " ");
                    v = value.toString().trim();
                    this.addGlobalMeta(k, v);
                    floatValue = null;
                    try {
                        floatValue = new Float(v);
                    }
                    catch (NumberFormatException e) {
                        if (!debug) break block136;
                        this.trace(e);
                    }
                }
                if (k.equalsIgnoreCase("layout sizes")) {
                    t = new StringTokenizer(v);
                    axisLengths = new int[t.countTokens()];
                    for (int n2 = 0; n2 < axisLengths.length; ++n2) {
                        try {
                            axisLengths[n2] = Integer.parseInt(t.nextToken().trim());
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (!debug) continue;
                            this.trace(e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("layout order")) {
                    t = new StringTokenizer(v);
                    axes = new String[t.countTokens()];
                    for (int n3 = 0; n3 < axes.length; ++n3) {
                        axes[n3] = t.nextToken().trim();
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("representation byte_order")) {
                    byteOrder = v;
                    continue;
                }
                if (k.equalsIgnoreCase("representation format")) {
                    rFormat = v;
                    continue;
                }
                if (k.equalsIgnoreCase("representation compression")) {
                    compression = v;
                    continue;
                }
                if (k.equalsIgnoreCase("parameter scale")) {
                    t = new StringTokenizer(v);
                    pixelSizes = new Float[t.countTokens()];
                    for (int n4 = 0; n4 < pixelSizes.length; ++n4) {
                        try {
                            pixelSizes[n4] = new Float(t.nextToken().trim());
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (!debug) continue;
                            this.trace(e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("representation sign")) {
                    signed = v.equals("signed");
                    continue;
                }
                if (k.equalsIgnoreCase("sensor s_params LambdaEm")) {
                    waves = v.split(" ");
                    emWaves = new Integer[waves.length];
                    for (int n5 = 0; n5 < emWaves.length; ++n5) {
                        try {
                            emWaves[n5] = new Integer((int)Float.parseFloat(waves[n5]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (!debug) continue;
                            this.trace(e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("sensor s_params LambdaEx")) {
                    waves = v.split(" ");
                    exWaves = new Integer[waves.length];
                    for (int n6 = 0; n6 < exWaves.length; ++n6) {
                        try {
                            exWaves[n6] = new Integer((int)Float.parseFloat(waves[n6]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (!debug) continue;
                            this.trace(e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history software") && v.indexOf("SVI") != -1) {
                    this.invertY = true;
                    continue;
                }
                if (k.equalsIgnoreCase("history") || k.equalsIgnoreCase("history text")) {
                    textBlock.append(v);
                    textBlock.append("\n");
                    this.metadata.remove(k);
                    continue;
                }
                if (k.equalsIgnoreCase("filename")) {
                    imageName = v;
                    continue;
                }
                if (k.equalsIgnoreCase("history date") || k.equalsIgnoreCase("history created on")) {
                    if (v.indexOf(" ") == -1) continue;
                    date = v.substring(0, v.lastIndexOf(" "));
                    String[] formats = new String[]{"EEEE, MMMM dd, yyyy HH:mm:ss", "EEE dd MMMM yyyy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EE dd MMM yyyy HH:mm:ss z"};
                    boolean success = false;
                    for (n = 0; n < formats.length; ++n) {
                        try {
                            date = DataTools.formatDate(date, formats[n]);
                            success = true;
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    if (success) continue;
                    date = null;
                    continue;
                }
                if (k.startsWith("history gain")) {
                    Integer n7 = new Integer(0);
                    try {
                        n7 = new Integer(k.substring(12).trim());
                        n7 = new Integer(n7 - 1);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (floatValue == null) continue;
                    gains.put(n7, floatValue);
                    continue;
                }
                if (k.startsWith("history laser") && k.endsWith("wavelength")) {
                    int laser = Integer.parseInt(k.substring(13, k.indexOf(" ", 13))) - 1;
                    v = v.replaceAll("nm", "").trim();
                    try {
                        wavelengths.put(new Integer(laser), new Integer(v));
                    }
                    catch (NumberFormatException e) {
                        if (!debug) continue;
                        this.trace(e);
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history objective type")) {
                    objectiveModel = v;
                    continue;
                }
                if (k.equalsIgnoreCase("history objective immersion")) {
                    immersion = v;
                    continue;
                }
                if (k.equalsIgnoreCase("history objective NA")) {
                    lensNA = floatValue;
                    continue;
                }
                if (k.equalsIgnoreCase("history objective WorkingDistance")) {
                    workingDistance = floatValue;
                    continue;
                }
                if (k.equalsIgnoreCase("history objective magnification")) {
                    magnification = floatValue;
                    continue;
                }
                if (k.equalsIgnoreCase("sensor s_params PinholeRadius")) {
                    String[] pins = v.split(" ");
                    int channel = 0;
                    for (n = 0; n < pins.length; ++n) {
                        if (pins[n].trim().equals("")) continue;
                        try {
                            pinholes.put(new Integer(channel++), new Float(pins[n]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (!debug) continue;
                            this.trace(e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history author")) {
                    lastName = v;
                    continue;
                }
                if (k.equalsIgnoreCase("history extents")) {
                    String[] lengths = v.split(" ");
                    sizes = new float[lengths.length];
                    for (int n8 = 0; n8 < sizes.length; ++n8) {
                        try {
                            sizes[n8] = Float.parseFloat(lengths[n8].trim());
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (!debug) continue;
                            this.trace(e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history stage_xyzum")) {
                    String[] positions = v.split(" ");
                    stagePos = new Float[positions.length];
                    for (int n9 = 0; n9 < stagePos.length; ++n9) {
                        try {
                            stagePos[n9] = new Float(positions[n9]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (!debug) continue;
                            this.trace(e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history other text")) {
                    description = v;
                    continue;
                }
                if (k.startsWith("history step") && k.endsWith("name")) {
                    Integer n10 = new Integer(k.substring(12, k.indexOf(" ", 12)));
                    channelNames.put(n10, v);
                    continue;
                }
                if (!k.equalsIgnoreCase("parameter ch")) continue;
                String[] names = v.split(" ");
                for (int n11 = 0; n11 < names.length; ++n11) {
                    channelNames.put(new Integer(n11), names[n11].trim());
                }
            }
            line = reader.readString("\r\n");
            if (!line.trim().equals("")) continue;
            line = null;
        }
        reader.close();
        this.addGlobalMeta("history text", textBlock.toString());
        this.status("Populating core metadata");
        this.core[0].rgb = false;
        this.core[0].dimensionOrder = "XY";
        int bitsPerPixel = 0;
        for (int i3 = 0; i3 < axes.length && i3 < axisLengths.length; ++i3) {
            if (axes[i3].equals("bits")) {
                bitsPerPixel = axisLengths[i3];
                while (bitsPerPixel % 8 != 0) {
                    ++bitsPerPixel;
                }
                if (bitsPerPixel != 24 && bitsPerPixel != 48) continue;
                bitsPerPixel /= 3;
                continue;
            }
            if (axes[i3].equals("x")) {
                this.core[0].sizeX = axisLengths[i3];
                continue;
            }
            if (axes[i3].equals("y")) {
                this.core[0].sizeY = axisLengths[i3];
                continue;
            }
            if (axes[i3].equals("z")) {
                this.core[0].sizeZ = axisLengths[i3];
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                continue;
            }
            if (axes[i3].startsWith("c")) {
                this.core[0].sizeC = axisLengths[i3];
                this.core[0].rgb = this.getSizeX() == 0 && this.getSizeC() <= 4 && this.getSizeC() > 1;
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                continue;
            }
            this.core[0].sizeT = axisLengths[i3];
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        if (this.getDimensionOrder().indexOf("Z") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("T") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        if (this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].interleaved = this.isRGB();
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        if (!this.isRGB()) {
            this.core[0].imageCount *= this.getSizeC();
        }
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        this.core[0].littleEndian = true;
        if (byteOrder != null) {
            String firstByte = byteOrder.split(" ")[0];
            int first = Integer.parseInt(firstByte);
            this.core[0].littleEndian = rFormat.equals("real") ? first == 1 : first != 1;
        }
        boolean bl = this.gzip = compression == null ? false : compression.equals("gzip");
        if (this.versionTwo) {
            String s = this.in.readString("\r\n");
            while (!s.trim().equals("end")) {
                s = this.in.readString("\r\n");
            }
        }
        this.offset = this.in.getFilePointer();
        long pixelDataSize = this.getSizeX() * this.getSizeY() * (bitsPerPixel / 8) * this.getImageCount() * this.getRGBChannelCount();
        if (this.gzip && this.in.length() - this.in.getFilePointer() < pixelDataSize) {
            this.data = new byte[(int)(this.in.length() - this.in.getFilePointer())];
            this.status("Decompressing pixel data");
            this.in.read(this.data);
            byte[] buf = new byte[8192];
            ByteVector v = new ByteVector();
            try {
                GZIPInputStream r = new GZIPInputStream(new ByteArrayInputStream(this.data));
                int n = r.read(buf, 0, buf.length);
                while (n > 0) {
                    v.add(buf, 0, n);
                    n = r.read(buf, 0, buf.length);
                }
                r.close();
                this.data = v.toByteArray();
                Location.mapFile("data.gz", null);
            }
            catch (IOException dfe) {
                throw new FormatException("Error uncompressing gzip'ed data", dfe);
            }
        } else {
            this.gzip = false;
        }
        if (bitsPerPixel < 32) {
            boolean bl2 = this.core[0].littleEndian = !this.isLittleEndian();
        }
        if (rFormat.equals("real")) {
            if (bitsPerPixel == 32) {
                this.core[0].pixelType = 6;
            } else if (bitsPerPixel == 64) {
                this.core[0].pixelType = 7;
            }
        } else if (rFormat.equals("integer")) {
            switch (bitsPerPixel) {
                case 8: {
                    this.core[0].pixelType = signed ? 0 : 1;
                    break;
                }
                case 16: {
                    this.core[0].pixelType = signed ? 2 : 3;
                    break;
                }
                case 32: {
                    this.core[0].pixelType = signed ? 4 : 5;
                }
            }
        } else {
            throw new RuntimeException("Unknown pixel format: " + rFormat);
        }
        this.status("Populating OME metadata");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName(imageName, 0);
        if (date != null) {
            store.setImageCreationDate(date, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        store.setImageDescription(description, 0);
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        if (pixelSizes != null) {
            for (int i4 = 0; i4 < pixelSizes.length; ++i4) {
                int c2;
                if (axes[i4].equals("x")) {
                    store.setDimensionsPhysicalSizeX(pixelSizes[i4], 0, 0);
                    continue;
                }
                if (axes[i4].equals("y")) {
                    store.setDimensionsPhysicalSizeY(pixelSizes[i4], 0, 0);
                    continue;
                }
                if (axes[i4].equals("z")) {
                    store.setDimensionsPhysicalSizeZ(pixelSizes[i4], 0, 0);
                    continue;
                }
                if (axes[i4].equals("t")) {
                    store.setDimensionsTimeIncrement(pixelSizes[i4], 0, 0);
                    continue;
                }
                if (!axes[i4].equals("ch") || (c2 = pixelSizes[i4].intValue()) <= 0) continue;
                store.setDimensionsWaveIncrement(new Integer(c2), 0, 0);
            }
        } else if (sizes != null) {
            if (sizes.length > 0) {
                store.setDimensionsPhysicalSizeX(new Float(sizes[0]), 0, 0);
            }
            if (sizes.length > 1) {
                sizes[1] = sizes[1] / (float)this.getSizeY();
                store.setDimensionsPhysicalSizeY(new Float(sizes[1]), 0, 0);
            }
        }
        for (int i5 = 0; i5 < this.getEffectiveSizeC(); ++i5) {
            Integer channel = new Integer(i5);
            if (channelNames.containsKey(channel)) {
                store.setLogicalChannelName((String)channelNames.get(channel), 0, i5);
            }
            if (pinholes.containsKey(channel)) {
                store.setLogicalChannelPinholeSize((Float)pinholes.get(channel), 0, i5);
            }
            if (emWaves != null && i5 < emWaves.length) {
                store.setLogicalChannelEmWave(emWaves[i5], 0, i5);
            }
            if (exWaves == null || i5 >= exWaves.length) continue;
            store.setLogicalChannelExWave(exWaves[i5], 0, i5);
        }
        Integer[] lasers = wavelengths.keySet().toArray(new Integer[0]);
        for (int i6 = 0; i6 < lasers.length; ++i6) {
            store.setLaserWavelength((Integer)wavelengths.get(lasers[i6]), 0, lasers[i6]);
        }
        if (objectiveModel != null) {
            store.setObjectiveModel(objectiveModel, 0, 0);
        }
        if (immersion != null) {
            store.setObjectiveImmersion(immersion, 0, 0);
        } else {
            store.setObjectiveImmersion("Unknown", 0, 0);
        }
        if (lensNA != null) {
            store.setObjectiveLensNA(lensNA, 0, 0);
        }
        if (workingDistance != null) {
            store.setObjectiveWorkingDistance(workingDistance, 0, 0);
        }
        if (magnification != null) {
            store.setObjectiveCalibratedMagnification(magnification, 0, 0);
        }
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
        Integer[] gainKeys = gains.keySet().toArray(new Integer[0]);
        for (i = 0; i < gainKeys.length; ++i) {
            int index = gainKeys[i];
            store.setDetectorSettingsGain((Float)gains.get(gainKeys[i]), 0, index);
            store.setDetectorType("Unknown", 0, index);
            store.setDetectorID("Detector:" + index, 0, index);
            store.setDetectorSettingsDetector("Detector:0", 0, index);
        }
        if (lastName != null) {
            store.setExperimenterLastName(lastName, 0);
        }
        if (stagePos != null) {
            for (i = 0; i < this.getImageCount(); ++i) {
                if (stagePos.length > 0) {
                    store.setStagePositionPositionX(stagePos[0], 0, 0, i);
                }
                if (stagePos.length > 1) {
                    store.setStagePositionPositionY(stagePos[1], 0, 0, i);
                }
                if (stagePos.length <= 2) continue;
                store.setStagePositionPositionZ(stagePos[2], 0, 0, i);
            }
        }
    }
}

