/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FileInfo;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;

public abstract class FormatReader
extends FormatHandler
implements IFormatReader {
    protected static final int THUMBNAIL_DIMENSION = 128;
    protected RandomAccessInputStream in;
    protected Hashtable metadata;
    protected int series = 0;
    protected CoreMetadata[] core;
    protected boolean suffixNecessary = true;
    protected boolean suffixSufficient = true;
    protected boolean normalizeData;
    protected boolean filterMetadata;
    protected boolean collectMetadata = true;
    protected boolean saveOriginalMetadata = false;
    protected boolean indexedAsRGB = false;
    protected boolean group = true;
    protected MetadataStore metadataStore = new DummyMetadata();

    public FormatReader(String format, String suffix) {
        super(format, suffix);
    }

    public FormatReader(String format, String[] suffixes) {
        super(format, suffixes);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (this.currentId != null) {
            String[] s = this.getUsedFiles();
            for (int i = 0; i < s.length; ++i) {
                if (!id.equals(s[i])) continue;
                return;
            }
        }
        this.series = 0;
        this.close();
        this.currentId = id;
        this.metadata = new Hashtable();
        this.core = new CoreMetadata[1];
        this.core[0] = new CoreMetadata();
        this.core[0].orderCertain = true;
        this.getMetadataStore().createRoot();
    }

    protected boolean isUsedFile(String file2) {
        String[] usedFiles = this.getUsedFiles();
        for (int i = 0; i < usedFiles.length; ++i) {
            if (!usedFiles[i].equals(file2) && !usedFiles[i].equals(new Location(file2).getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    protected void addMeta(String key, Object value, Hashtable meta) {
        MetadataStore store;
        String val;
        if (key == null || value == null || !this.collectMetadata) {
            return;
        }
        key = key.trim();
        boolean string = value instanceof String;
        boolean simple = string || value instanceof Number || value instanceof Boolean || value instanceof Character;
        String string2 = val = string ? (String)value : null;
        if (this.filterMetadata) {
            if (!simple) {
                return;
            }
            int maxLen = 8192;
            if (key.length() > maxLen) {
                return;
            }
            if (string && val.length() > maxLen) {
                return;
            }
            key = DataTools.sanitize(key);
            if (string) {
                val = DataTools.sanitize(val);
            }
            if (!key.matches(".*[a-zA-Z].*")) {
                return;
            }
            String[] invalidSequences = new String[]{"&lt;", "&gt;", "&amp;", "<", ">", "&"};
            for (int i = 0; i < invalidSequences.length; ++i) {
                key = key.replaceAll(invalidSequences[i], "");
                if (!string) continue;
                val = val.replaceAll(invalidSequences[i], "");
            }
            if (key.length() == 0) {
                return;
            }
            if (string && val.trim().length() == 0) {
                return;
            }
            if (string) {
                value = val;
            }
        }
        if (this.saveOriginalMetadata && simple && meta.equals(this.metadata) && MetadataTools.isOMEXMLMetadata(store = this.getMetadataStore())) {
            MetadataTools.populateOriginalMetadata(store, key, value.toString());
        }
        meta.put(key, val == null ? value : val);
    }

    protected void addGlobalMeta(String key, Object value) {
        this.addMeta(key, value, this.getGlobalMetadata());
    }

    protected void addGlobalMeta(String key, boolean value) {
        this.addGlobalMeta(key, new Boolean(value));
    }

    protected void addGlobalMeta(String key, byte value) {
        this.addGlobalMeta(key, new Byte(value));
    }

    protected void addGlobalMeta(String key, short value) {
        this.addGlobalMeta(key, new Short(value));
    }

    protected void addGlobalMeta(String key, int value) {
        this.addGlobalMeta(key, new Integer(value));
    }

    protected void addGlobalMeta(String key, long value) {
        this.addGlobalMeta(key, new Long(value));
    }

    protected void addGlobalMeta(String key, float value) {
        this.addGlobalMeta(key, new Float(value));
    }

    protected void addGlobalMeta(String key, double value) {
        this.addGlobalMeta(key, new Double(value));
    }

    protected void addGlobalMeta(String key, char value) {
        this.addGlobalMeta(key, new Character(value));
    }

    protected Object getGlobalMeta(String key) {
        return this.metadata.get(key);
    }

    protected void addSeriesMeta(String key, Object value) {
        this.addMeta(key, value, this.core[this.series].seriesMetadata);
    }

    protected void addSeriesMeta(String key, boolean value) {
        this.addSeriesMeta(key, new Boolean(value));
    }

    protected void addSeriesMeta(String key, byte value) {
        this.addSeriesMeta(key, new Byte(value));
    }

    protected void addSeriesMeta(String key, short value) {
        this.addSeriesMeta(key, new Short(value));
    }

    protected void addSeriesMeta(String key, int value) {
        this.addSeriesMeta(key, new Integer(value));
    }

    protected void addSeriesMeta(String key, long value) {
        this.addSeriesMeta(key, new Long(value));
    }

    protected void addSeriesMeta(String key, float value) {
        this.addSeriesMeta(key, new Float(value));
    }

    protected void addSeriesMeta(String key, double value) {
        this.addSeriesMeta(key, new Double(value));
    }

    protected void addSeriesMeta(String key, char value) {
        this.addSeriesMeta(key, new Character(value));
    }

    protected Object getSeriesMeta(String key) {
        return this.core[this.series].seriesMetadata.get(key);
    }

    protected byte[] readPlane(RandomAccessInputStream s, int x, int y, int w, int h, byte[] buf) throws IOException {
        int c = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (x == 0 && y == 0 && w == this.getSizeX() && h == this.getSizeY()) {
            s.read(buf);
        } else if (x == 0 && w == this.getSizeX()) {
            if (this.isInterleaved()) {
                s.skipBytes(y * w * bpp * c);
                s.read(buf, 0, h * w * bpp * c);
            } else {
                int rowLen = w * bpp;
                for (int channel = 0; channel < c; ++channel) {
                    s.skipBytes(y * rowLen);
                    s.read(buf, channel * h * rowLen, h * rowLen);
                    s.skipBytes((this.getSizeY() - y - h) * rowLen);
                }
            }
        } else if (this.isInterleaved()) {
            s.skipBytes(y * this.getSizeX() * bpp * c);
            for (int row = 0; row < h; ++row) {
                s.skipBytes(x * bpp * c);
                s.read(buf, row * w * bpp * c, w * bpp * c);
                s.skipBytes(bpp * c * (this.getSizeX() - w - x));
            }
        } else {
            for (int channel = 0; channel < c; ++channel) {
                s.skipBytes(y * this.getSizeX() * bpp);
                for (int row = 0; row < h; ++row) {
                    s.skipBytes(x * bpp);
                    s.read(buf, channel * w * h * bpp + row * w * bpp, w * bpp);
                    s.skipBytes(bpp * (this.getSizeX() - w - x));
                }
                s.skipBytes(this.getSizeX() * bpp * (this.getSizeY() - y - h));
            }
        }
        return buf;
    }

    public void setId(String id) throws FormatException, IOException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
    }

    public boolean isThisType(String name, boolean open) {
        if (!this.suffixSufficient && !open) {
            return false;
        }
        if (this.suffixNecessary || this.suffixSufficient) {
            boolean suffixMatch = super.isThisType(name);
            if (this.suffixNecessary && !suffixMatch) {
                return false;
            }
            if (suffixMatch && this.suffixSufficient) {
                return true;
            }
        }
        if (!open) {
            return false;
        }
        try {
            RandomAccessInputStream stream = new RandomAccessInputStream(name);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException exc) {
            this.traceDebug(exc);
            return false;
        }
    }

    public boolean isThisType(byte[] block) {
        try {
            RandomAccessInputStream stream = new RandomAccessInputStream(block);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException e) {
            this.traceDebug(e);
            return false;
        }
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public int getImageCount() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].imageCount;
    }

    public boolean isRGB() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].rgb;
    }

    public int getSizeX() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeX;
    }

    public int getSizeY() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeY;
    }

    public int getSizeZ() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeZ;
    }

    public int getSizeC() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeC;
    }

    public int getSizeT() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeT;
    }

    public int getPixelType() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].pixelType;
    }

    public int getEffectiveSizeC() {
        return this.getImageCount() / (this.getSizeZ() * this.getSizeT());
    }

    public int getRGBChannelCount() {
        return this.getSizeC() / this.getEffectiveSizeC();
    }

    public boolean isIndexed() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].indexed;
    }

    public boolean isFalseColor() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].falseColor;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return null;
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return null;
    }

    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].cLengths == null) {
            return new int[]{this.core[this.series].sizeC};
        }
        return this.core[this.series].cLengths;
    }

    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].cTypes == null) {
            return new String[]{"Channel"};
        }
        return this.core[this.series].cTypes;
    }

    public int getThumbSizeX() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].thumbSizeX == 0) {
            int sy;
            int thumbSizeX;
            int sx = this.getSizeX();
            int n = thumbSizeX = sx > (sy = this.getSizeY()) ? 128 : sx * 128 / sy;
            if (thumbSizeX == 0) {
                thumbSizeX = 1;
            }
            return thumbSizeX;
        }
        return this.core[this.series].thumbSizeX;
    }

    public int getThumbSizeY() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].thumbSizeY == 0) {
            int thumbSizeY;
            int sx = this.getSizeX();
            int sy = this.getSizeY();
            int n = thumbSizeY = sy > sx ? 128 : sy * 128 / sx;
            if (thumbSizeY == 0) {
                thumbSizeY = 1;
            }
            return thumbSizeY;
        }
        return this.core[this.series].thumbSizeY;
    }

    public boolean isLittleEndian() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].littleEndian;
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].dimensionOrder;
    }

    public boolean isOrderCertain() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].orderCertain;
    }

    public boolean isThumbnailSeries() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].thumbnail;
    }

    public boolean isInterleaved() {
        return this.isInterleaved(0);
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].interleaved;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int width, int height) throws FormatException, IOException {
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int ch = this.getRGBChannelCount();
        byte[] newBuffer = new byte[width * height * ch * bpp];
        return this.openBytes(no, newBuffer, x, y, width, height);
    }

    public abstract byte[] openBytes(int var1, byte[] var2, int var3, int var4, int var5, int var6) throws FormatException, IOException;

    public Class getNativeDataType() {
        return byte[].class;
    }

    public Object openData(int no, int x, int y, int width, int height) throws FormatException, IOException {
        return this.openBytes(no, x, y, width, height);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.openThumbBytes(this, no);
    }

    public void close(boolean fileOnly) throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (!fileOnly) {
            this.in = null;
            this.currentId = null;
        }
    }

    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.length;
    }

    public void setSeries(int no) {
        if (no < 0 || no >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series: " + no);
        }
        this.series = no;
    }

    public int getSeries() {
        return this.series;
    }

    public void setGroupFiles(boolean groupFiles) {
        FormatTools.assertId(this.currentId, false, 1);
        this.group = groupFiles;
    }

    public boolean isGroupFiles() {
        return this.group;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 2;
    }

    public boolean isMetadataComplete() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].metadataComplete;
    }

    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 1);
        this.normalizeData = normalize;
    }

    public boolean isNormalized() {
        return this.normalizeData;
    }

    public void setMetadataCollected(boolean collect) {
        FormatTools.assertId(this.currentId, false, 1);
        this.collectMetadata = collect;
    }

    public boolean isMetadataCollected() {
        return this.collectMetadata;
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        this.saveOriginalMetadata = populate;
    }

    public boolean isOriginalMetadataPopulated() {
        return this.saveOriginalMetadata;
    }

    public String[] getUsedFiles() {
        return this.getUsedFiles(false);
    }

    public String[] getUsedFiles(boolean noPixels) {
        int oldSeries = this.getSeries();
        Vector<String> files = new Vector<String>();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            String[] s;
            this.setSeries(i);
            for (String file2 : s = this.getSeriesUsedFiles(noPixels)) {
                if (files.contains(file2)) continue;
                files.add(file2);
            }
        }
        this.setSeries(oldSeries);
        return files.toArray(new String[files.size()]);
    }

    public String[] getSeriesUsedFiles() {
        return this.getSeriesUsedFiles(false);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] stringArray;
        if (noPixels) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.currentId;
        }
        return stringArray;
    }

    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        String[] files = this.getUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            infos[i].reader = this.getClass();
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    public FileInfo[] getAdvancedSeriesUsedFiles(boolean noPixels) {
        String[] files = this.getSeriesUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            infos[i].reader = this.getClass();
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    public String getCurrentFile() {
        return this.currentId;
    }

    public int getIndex(int z, int c, int t) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getZCTCoords(this, index);
    }

    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getGlobalMeta(field);
    }

    public Hashtable getGlobalMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.metadata;
    }

    public Hashtable getSeriesMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].seriesMetadata;
    }

    public Hashtable getMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        Hashtable h = new Hashtable(this.getGlobalMetadata());
        int oldSeries = this.getSeries();
        IMetadata meta = this.getMetadataStore() instanceof IMetadata ? (IMetadata)this.getMetadataStore() : null;
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            Object[] keys;
            String realName;
            String name = "Series " + series;
            if (meta != null && (realName = meta.getImageName(series)) != null && realName.trim().length() != 0) {
                name = realName;
            }
            this.setSeries(series);
            Hashtable seriesMetadata = this.getSeriesMetadata();
            for (Object key : keys = seriesMetadata.keySet().toArray()) {
                h.put(name + " " + key, seriesMetadata.get(key));
            }
        }
        this.setSeries(oldSeries);
        return h;
    }

    public CoreMetadata[] getCoreMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core;
    }

    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 1);
        this.filterMetadata = filter;
    }

    public boolean isMetadataFiltered() {
        return this.filterMetadata;
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 1);
        if (store == null) {
            throw new IllegalArgumentException("Metadata object cannot be null; use loci.formats.meta.DummyMetadata instead");
        }
        this.metadataStore = store;
    }

    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    public Object getMetadataStoreRoot() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getMetadataStore().getRoot();
    }

    public IFormatReader[] getUnderlyingReaders() {
        return null;
    }

    public boolean isThisType(String name) {
        return this.isThisType(name, true);
    }

    public void close() throws IOException {
        this.close(false);
    }
}

