/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.POITools;
import loci.formats.in.BMPReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;

public class FV1000Reader
extends FormatReader {
    public static final String FV1000_MAGIC_STRING_1 = "FileInformation";
    public static final String FV1000_MAGIC_STRING_2 = "Acquisition Parameters";
    public static final String[] OIB_SUFFIX = new String[]{"oib"};
    public static final String[] OIF_SUFFIX = new String[]{"oif"};
    public static final String[] FV1000_SUFFIXES = new String[]{"oib", "oif"};
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int NUM_DIMENSIONS = 9;
    private static final int POINT = 2;
    private static final int LINE = 3;
    private static final int POLYLINE = 4;
    private static final int RECTANGLE = 5;
    private static final int CIRCLE = 6;
    private static final int ELLIPSE = 7;
    private static final int POLYGON = 8;
    private static final int FREE_SHAPE = 9;
    private static final int FREE_LINE = 10;
    private static final int GRID = 11;
    private static final int ARROW = 12;
    private static final int COLOR_BAR = 13;
    private static final int SCALE = 15;
    private Vector<String> tiffs;
    private String thumbId;
    private BMPReader thumbReader;
    private Vector<String> usedFiles;
    private boolean isOIB;
    private Hashtable<String, String> oibMapping;
    private String[] code;
    private String[] size;
    private String[] pixelSize;
    private int imageDepth;
    private Vector<String> previewNames;
    private String pixelSizeX;
    private String pixelSizeY;
    private Vector<String> channelNames;
    private Vector<String> illuminations;
    private Vector<String> dyeNames;
    private Vector<Integer> emWaves;
    private Vector<Integer> exWaves;
    private Vector<Integer> wavelengths;
    private String gain;
    private String offset;
    private String voltage;
    private String pinholeSize;
    private String magnification;
    private String lensNA;
    private String objectiveName;
    private String workingDistance;
    private String creationDate;
    private POITools poi;
    private short[][][] lut;
    private int lastChannel;

    public FV1000Reader() {
        super("Olympus FV1000", new String[]{"oib", "oif", "pty", "lut"});
    }

    public boolean isThisType(String name, boolean open) {
        if (FV1000Reader.checkSuffix(name, FV1000_SUFFIXES)) {
            return true;
        }
        if (!open) {
            return false;
        }
        try {
            Location oif;
            Location parent = new Location(name).getAbsoluteFile().getParentFile();
            String path = parent.getPath();
            path = path.substring(path.lastIndexOf(File.separator) + 1);
            if (path.indexOf(".") != -1) {
                path = path.substring(0, path.lastIndexOf("."));
            }
            return (oif = new Location(parent.getParentFile(), path)).exists() && !oif.isDirectory();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 1024;
        if (!FormatTools.validStream(stream, 1024, false)) {
            return false;
        }
        String s = DataTools.stripString(stream.readString(1024));
        return s.indexOf(FV1000_MAGIC_STRING_1) >= 0 || s.indexOf(FV1000_MAGIC_STRING_2) >= 0;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        String name = id.toLowerCase();
        if (name.endsWith(".oib") || name.endsWith(".oif")) {
            return 2;
        }
        return 0;
    }

    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut == null ? (short[][])null : this.lut[this.lastChannel];
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int file2 = no;
        int image = 0;
        String filename = null;
        if (this.series == 0) {
            file2 = no / (this.getImageCount() / this.tiffs.size());
            image = no % (this.getImageCount() / this.tiffs.size());
            if (file2 < this.tiffs.size()) {
                filename = this.tiffs.get(file2);
            }
        } else {
            file2 = no / (this.getImageCount() / this.previewNames.size());
            image = no % (this.getImageCount() / this.previewNames.size());
            if (file2 < this.previewNames.size()) {
                filename = this.previewNames.get(file2);
            }
        }
        int[] coords = this.getZCTCoords(image);
        this.lastChannel = coords[1];
        if (filename == null) {
            return buf;
        }
        RandomAccessInputStream plane = this.getFile(filename);
        TiffParser tp = new TiffParser(plane);
        IFDList ifds = tp.getIFDs();
        if (image >= ifds.size()) {
            return buf;
        }
        IFD ifd = (IFD)ifds.get(image);
        if ((long)this.getSizeY() != ifd.getImageLength()) {
            tp.getSamples(ifd, buf, x, this.getIndex(coords[0], 0, coords[2]), w, 1L);
        } else {
            tp.getSamples(ifd, buf, x, y, w, h);
        }
        plane.close();
        plane = null;
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.isOIB) {
            String[] stringArray;
            if (noPixels) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.currentId;
            }
            return stringArray;
        }
        Vector<String> files = new Vector<String>();
        for (String file2 : this.usedFiles) {
            String f = file2.toLowerCase();
            if (f.endsWith(".tif") || f.endsWith(".tiff") || f.endsWith(".bmp")) continue;
            files.add(file2);
        }
        if (!noPixels) {
            if (this.getSeries() == 0) {
                files.addAll(this.tiffs);
            } else if (this.getSeries() == 1) {
                files.addAll(this.previewNames);
            }
        }
        return files.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.thumbReader != null) {
            this.thumbReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.usedFiles = null;
            this.tiffs = null;
            this.thumbReader = null;
            this.thumbId = null;
            this.isOIB = false;
            this.previewNames = null;
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.lastChannel = 0;
            this.dyeNames = null;
            this.wavelengths = null;
            this.illuminations = null;
            this.oibMapping = null;
            this.pixelSize = null;
            this.size = null;
            this.code = null;
            this.imageDepth = 0;
            this.pixelSizeY = null;
            this.pixelSizeX = null;
            this.channelNames = null;
            this.exWaves = null;
            this.emWaves = null;
            this.pinholeSize = null;
            this.voltage = null;
            this.offset = null;
            this.gain = null;
            this.workingDistance = null;
            this.objectiveName = null;
            this.lensNA = null;
            this.magnification = null;
            this.creationDate = null;
            this.lut = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        Object last;
        String s;
        this.debug("FV1000Reader.initFile(" + id + ")");
        super.initFile(id);
        this.isOIB = FV1000Reader.checkSuffix(id, OIB_SUFFIX);
        this.in = new RandomAccessInputStream(id);
        if (this.isOIB) {
            this.poi = new POITools(Location.getMappedId(id));
        }
        boolean mappedOIF = !this.isOIB && !new File(id).getAbsoluteFile().exists();
        this.channelNames = new Vector();
        this.emWaves = new Vector();
        this.exWaves = new Vector();
        this.dyeNames = new Vector();
        this.wavelengths = new Vector();
        this.illuminations = new Vector();
        String key = null;
        String value = null;
        String oifName = null;
        if (this.isOIB) {
            String infoFile = null;
            Vector<String> list = this.poi.getDocumentList();
            for (int i = 0; i < list.size(); ++i) {
                String name = list.get(i);
                if (!name.endsWith("OibInfo.txt")) continue;
                infoFile = name;
                break;
            }
            if (infoFile == null) {
                throw new FormatException("OibInfo.txt not found in " + id);
            }
            RandomAccessInputStream ras = this.poi.getDocumentStream(infoFile);
            this.oibMapping = new Hashtable();
            s = DataTools.stripString(ras.readString((int)ras.length()));
            ras.close();
            Object[] lines = s.split("\n");
            Arrays.sort(lines);
            String directoryKey = null;
            String directoryValue = null;
            for (Object line : lines) {
                if (((String)(line = ((String)line).trim())).indexOf("=") == -1) continue;
                key = ((String)line).substring(0, ((String)line).indexOf("="));
                value = ((String)line).substring(((String)line).indexOf("=") + 1);
                if (directoryKey != null && directoryValue != null) {
                    value = value.replaceAll(directoryKey, directoryValue);
                }
                if (value.indexOf("GST") != -1) {
                    String first = value.substring(0, value.indexOf("GST"));
                    String last2 = value.substring(value.lastIndexOf("=") + 1);
                    value = first + last2;
                }
                if (key.startsWith("Stream")) {
                    if (FV1000Reader.checkSuffix(value, OIF_SUFFIX)) {
                        oifName = value;
                    }
                    if (directoryKey != null && value.startsWith(directoryValue)) {
                        this.oibMapping.put(value, "Root Entry" + File.separator + directoryKey + File.separator + key);
                        continue;
                    }
                    this.oibMapping.put(value, "Root Entry" + File.separator + key);
                    continue;
                }
                if (!key.startsWith("Storage")) continue;
                directoryKey = key;
                directoryValue = value;
            }
            s = null;
        } else {
            if (!FV1000Reader.checkSuffix(id, OIF_SUFFIX)) {
                Location current = new Location(id).getAbsoluteFile();
                String parent = current.getParent();
                Location tmp = new Location(parent);
                parent = tmp.getParent();
                id = current.getName();
                String oifFile = parent + id.substring(0, id.lastIndexOf("_")) + ".oif";
                tmp = new Location(oifFile);
                if (!tmp.exists()) {
                    tmp = new Location(oifFile = oifFile.substring(0, oifFile.lastIndexOf(".")) + ".OIF");
                    if (!tmp.exists()) {
                        if (parent.endsWith(File.separator)) {
                            parent = parent.substring(0, parent.length() - 1);
                        }
                        String dir = parent.substring(parent.lastIndexOf(File.separator));
                        tmp = new Location(parent);
                        oifFile = (parent = tmp.getParent()) + dir.substring(0, dir.lastIndexOf("."));
                        if (!new Location(oifFile).exists()) {
                            throw new FormatException("OIF file not found");
                        }
                    }
                    this.currentId = oifFile;
                } else {
                    this.currentId = oifFile;
                }
                super.initFile(this.currentId);
                this.in = new RandomAccessInputStream(this.currentId);
            }
            oifName = this.currentId;
        }
        String f = new Location(oifName).getAbsoluteFile().getAbsolutePath();
        String path = this.isOIB || !f.endsWith(oifName) || mappedOIF ? "" : f.substring(0, f.lastIndexOf(File.separator) + 1);
        RandomAccessInputStream oif = null;
        try {
            oif = this.getFile(oifName);
        }
        catch (IOException e) {
            oif = this.getFile(oifName.replaceAll(".oif", ".OIF"));
        }
        s = oif.readString((int)oif.length());
        oif.close();
        this.code = new String[9];
        this.size = new String[9];
        this.pixelSize = new String[9];
        StringTokenizer st = new StringTokenizer(s, "\r\n");
        this.previewNames = new Vector();
        boolean laserEnabled = true;
        String ptyStart = null;
        String ptyEnd = null;
        String ptyPattern = null;
        String line = null;
        Vector<String> lutNames = new Vector<String>();
        Hashtable<Integer, String> filenames = new Hashtable<Integer, String>();
        Hashtable<Integer, String> roiFilenames = new Hashtable<Integer, String>();
        String prefix = "";
        while (st.hasMoreTokens()) {
            line = DataTools.stripString(st.nextToken().trim());
            if (!line.startsWith("[") && line.indexOf("=") > 0) {
                key = line.substring(0, line.indexOf("=")).trim();
                value = line.substring(line.indexOf("=") + 1).trim();
                if (value.startsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                value = value.replaceAll("/", File.separator);
                value = value.replace('\\', File.separatorChar);
                while (value.indexOf("GST") != -1) {
                    String first = value.substring(0, value.indexOf("GST"));
                    int ndx = value.indexOf(File.separator) < value.indexOf("GST") ? value.length() : value.indexOf(File.separator);
                    last = value.substring(value.lastIndexOf("=", ndx) + 1);
                    value = first + (String)last;
                }
                if (key.startsWith("IniFileName") && key.indexOf("Thumb") == -1 && !this.isPreviewName(value)) {
                    if (mappedOIF) {
                        value = value.substring(value.lastIndexOf(File.separator) + 1);
                    }
                    filenames.put(new Integer(key.substring(11)), value.trim());
                } else if (key.startsWith("RoiFileName") && key.indexOf("Thumb") == -1 && !this.isPreviewName(value)) {
                    if (mappedOIF) {
                        value = value.substring(value.lastIndexOf(File.separator) + 1);
                    }
                    try {
                        roiFilenames.put(new Integer(key.substring(11)), value.trim());
                    }
                    catch (NumberFormatException e) {}
                } else if (key.equals("PtyFileNameS")) {
                    ptyStart = value;
                } else if (key.equals("PtyFileNameE")) {
                    ptyEnd = value;
                } else if (key.equals("PtyFileNameT2")) {
                    ptyPattern = value;
                } else if (key.indexOf("Thumb") != -1) {
                    if (mappedOIF) {
                        value = value.substring(value.lastIndexOf(File.separator) + 1);
                    }
                    if (this.thumbId == null) {
                        this.thumbId = value.trim();
                    }
                } else if (key.startsWith("LutFileName")) {
                    if (mappedOIF) {
                        value = value.substring(value.lastIndexOf(File.separator) + 1);
                    }
                    lutNames.add(path + value);
                } else if (this.isPreviewName(value)) {
                    if (mappedOIF) {
                        value = value.substring(value.lastIndexOf(File.separator) + 1);
                    }
                    this.previewNames.add(path + value.trim());
                }
                this.addGlobalMeta(prefix + key, value);
                if (prefix.startsWith("[Axis ") && prefix.endsWith("Parameters Common] - ")) {
                    int ndx = Integer.parseInt(prefix.substring(6, prefix.indexOf("P")).trim());
                    if (key.equals("AxisCode")) {
                        this.code[ndx] = value;
                        continue;
                    }
                    if (key.equals("MaxSize")) {
                        this.size[ndx] = value;
                        continue;
                    }
                    if (!key.equals("Interval")) continue;
                    this.pixelSize[ndx] = value;
                    continue;
                }
                if ((prefix + key).equals("[Reference Image Parameter] - ImageDepth")) {
                    this.imageDepth = Integer.parseInt(value);
                    continue;
                }
                if ((prefix + key).equals("[Reference Image Parameter] - WidthConvertValue")) {
                    this.pixelSizeX = value;
                    continue;
                }
                if ((prefix + key).equals("[Reference Image Parameter] - HeightConvertValue")) {
                    this.pixelSizeY = value;
                    continue;
                }
                if (prefix.indexOf("[Channel ") != -1 && prefix.indexOf("Parameters] - ") != -1) {
                    if (key.equals("CH Name")) {
                        this.channelNames.add(value);
                        continue;
                    }
                    if (key.equals("DyeName")) {
                        this.dyeNames.add(value);
                        continue;
                    }
                    if (key.equals("EmissionWavelength")) {
                        this.emWaves.add(new Integer(value));
                        continue;
                    }
                    if (key.equals("ExcitationWavelength")) {
                        this.exWaves.add(new Integer(value));
                        continue;
                    }
                    if (!key.equals("LightType")) continue;
                    String illumination = value.toLowerCase();
                    illumination = illumination.indexOf("fluorescence") != -1 ? "Epifluorescence" : (illumination.indexOf("transmitted") != -1 ? "Transmitted" : null);
                    this.illuminations.add(illumination);
                    continue;
                }
                if (prefix.startsWith("[Laser ") && key.equals("Laser Enable")) {
                    laserEnabled = value.equals("1");
                    continue;
                }
                if (prefix.startsWith("[Laser ") && key.equals("LaserWavelength")) {
                    if (!laserEnabled) continue;
                    this.wavelengths.add(new Integer(value));
                    continue;
                }
                if (!key.equals("ImageCaputreDate") && !key.equals("ImageCaptureDate")) continue;
                this.creationDate = value;
                continue;
            }
            if (line.length() <= 0) continue;
            if (line.indexOf("[") == 2) {
                line = line.substring(2, line.length());
            }
            prefix = line + " - ";
        }
        if (ptyStart != null && ptyEnd != null && ptyPattern != null) {
            String[] prefixes = ptyPattern.split("%03d");
            int[] first = FV1000Reader.scanFormat(ptyPattern, ptyStart);
            last = FV1000Reader.scanFormat(ptyPattern, ptyEnd);
            int[] lengths = new int[prefixes.length - 1];
            int totalFiles = 1;
            for (int i = 0; i < first.length; ++i) {
                lengths[i] = last[i] - first[i] + 1;
                totalFiles *= lengths[i];
            }
            for (int file2 = 0; file2 < totalFiles; ++file2) {
                int[] pos = FormatTools.rasterToPosition(lengths, file2);
                StringBuffer pty = new StringBuffer();
                for (int block = 0; block < prefixes.length; ++block) {
                    pty.append(prefixes[block]);
                    if (block >= pos.length) continue;
                    String num = String.valueOf(pos[block] + 1);
                    for (int q = 0; q < 3 - num.length(); ++q) {
                        pty.append("0");
                    }
                    pty.append(num);
                }
                filenames.put(new Integer(file2), pty.toString());
            }
        }
        this.status("Initializing helper readers");
        if (this.previewNames.size() > 0) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < this.previewNames.size(); ++i) {
                String ss = this.previewNames.get(i);
                if (!(ss = this.replaceExtension(ss, "pty", "tif")).endsWith(".tif")) continue;
                v.add(ss);
            }
            this.previewNames = v;
            if (this.previewNames.size() > 0) {
                this.core = new CoreMetadata[2];
                this.core[0] = new CoreMetadata();
                this.core[1] = new CoreMetadata();
                ArrayList ifds = null;
                for (int i = 0; i < this.previewNames.size(); ++i) {
                    String previewName = this.previewNames.get(i);
                    RandomAccessInputStream preview = this.getFile(previewName);
                    TiffParser tp = new TiffParser(preview);
                    ifds = tp.getIFDs();
                    preview.close();
                    this.core[1].imageCount += ifds.size();
                }
                this.core[1].sizeX = (int)((IFD)ifds.get(0)).getImageWidth();
                this.core[1].sizeY = (int)((IFD)ifds.get(0)).getImageLength();
                this.core[1].sizeZ = 1;
                this.core[1].sizeT = 1;
                this.core[1].sizeC = this.core[1].imageCount;
                this.core[1].rgb = false;
                int bits = ((IFD)ifds.get(0)).getBitsPerSample()[0];
                while (bits % 8 != 0) {
                    ++bits;
                }
                switch (bits) {
                    case 8: {
                        this.core[1].pixelType = 1;
                        break;
                    }
                    case 16: {
                        this.core[1].pixelType = 3;
                        break;
                    }
                    case 32: {
                        this.core[1].pixelType = 5;
                    }
                }
                this.core[1].dimensionOrder = "XYCZT";
                this.core[1].indexed = false;
            }
        }
        this.core[0].imageCount = filenames.size();
        this.tiffs = new Vector(this.getImageCount());
        this.thumbReader = new BMPReader();
        this.thumbId = this.replaceExtension(this.thumbId, "pty", "bmp");
        this.thumbId = this.sanitizeFile(this.thumbId, this.isOIB || mappedOIF ? "" : path);
        this.status("Reading additional metadata");
        String tiffPath = null;
        this.core[0].dimensionOrder = "XY";
        int i = 0;
        for (int ii = 0; ii < this.getImageCount(); ++ii) {
            String file3 = (String)filenames.get(new Integer(i));
            while (file3 == null) {
                file3 = (String)filenames.get(new Integer(++i));
            }
            file3 = this.sanitizeFile(file3, this.isOIB || mappedOIF ? "" : path);
            tiffPath = file3.indexOf(File.separator) != -1 ? file3.substring(0, file3.lastIndexOf(File.separator)) : file3;
            Location ptyFile = new Location(file3);
            if (!this.isOIB && !ptyFile.exists()) {
                this.warn("Could not find .pty file (" + file3 + "); guessing at the " + "corresponding TIFF file.");
                String tiff = this.replaceExtension(file3, ".pty", ".tif");
                this.tiffs.add(ii, tiff);
            } else {
                RandomAccessInputStream ptyReader = this.getFile(file3);
                s = ptyReader.readString((int)ptyReader.length());
                ptyReader.close();
                st = new StringTokenizer(s, "\n");
                boolean zAxis = false;
                boolean cAxis = false;
                boolean tAxis = false;
                while (st.hasMoreTokens()) {
                    line = st.nextToken().trim();
                    if ((line = DataTools.stripString(line)).equals("[Axis 2 Parameters]")) {
                        cAxis = true;
                    } else if (line.equals("[Axis 3 Parameters]")) {
                        zAxis = true;
                    } else if (line.equals("[Axis 4 Parameters]")) {
                        tAxis = true;
                    }
                    if (line.startsWith("[") || line.indexOf("=") <= 0) continue;
                    key = line.substring(0, line.indexOf("=")).trim();
                    value = line.substring(line.indexOf("=") + 1).trim();
                    value = value.replaceAll("\"", "");
                    if (key.equals("DataName")) {
                        if (!this.isPreviewName(value)) {
                            value = value.replaceAll("/", File.separator);
                            value = value.replace('\\', File.separatorChar);
                            while (value.indexOf("GST") != -1) {
                                String first = value.substring(0, value.indexOf("GST"));
                                int ndx = value.indexOf(File.separator) < value.indexOf("GST") ? value.length() : value.indexOf(File.separator);
                                String last3 = value.substring(value.lastIndexOf("=", ndx) + 1);
                                value = first + last3;
                            }
                            if (mappedOIF) {
                                this.tiffs.add(ii, value);
                            } else {
                                this.tiffs.add(ii, tiffPath + File.separator + value);
                            }
                        }
                    } else if (key.equals("Number")) {
                        boolean addAxis;
                        boolean bl = addAxis = Integer.parseInt(value) > 1;
                        if (zAxis) {
                            if (addAxis && this.getDimensionOrder().indexOf("Z") == -1) {
                                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                            }
                            zAxis = false;
                        }
                        if (cAxis) {
                            if (addAxis && this.getDimensionOrder().indexOf("C") == -1) {
                                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                            }
                            cAxis = false;
                        }
                        if (tAxis) {
                            if (addAxis && this.getDimensionOrder().indexOf("T") == -1) {
                                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
                            }
                            tAxis = false;
                        }
                    }
                    this.addGlobalMeta("Image " + ii + " : " + key, value);
                    if (key.equals("AnalogPMTGain") || key.equals("CountingPMTGain")) {
                        this.gain = value;
                        continue;
                    }
                    if (key.equals("AnalogPMTOffset") || key.equals("CountingPMTOffset")) {
                        this.offset = value;
                        continue;
                    }
                    if (key.equals("Magnification")) {
                        this.magnification = value;
                        continue;
                    }
                    if (key.equals("ObjectiveLens NAValue")) {
                        this.lensNA = value;
                        continue;
                    }
                    if (key.equals("ObjectiveLens Name")) {
                        this.objectiveName = value;
                        continue;
                    }
                    if (key.equals("ObjectiveLens WDValue")) {
                        this.workingDistance = value;
                        continue;
                    }
                    if (key.equals("PMTVoltage")) {
                        this.voltage = value;
                        continue;
                    }
                    if (!key.equals("PinholeDiameter")) continue;
                    this.pinholeSize = value;
                }
            }
            ++i;
        }
        if (this.tiffs.size() != this.getImageCount()) {
            this.core[0].imageCount = this.tiffs.size();
        }
        this.usedFiles = new Vector();
        if (tiffPath != null) {
            this.usedFiles.add(id);
            if (!this.isOIB) {
                Location dir = new Location(tiffPath);
                String[] list = mappedOIF ? Location.getIdMap().keySet().toArray(new String[0]) : dir.list();
                for (int i2 = 0; i2 < list.length; ++i2) {
                    if (mappedOIF) {
                        this.usedFiles.add(list[i2]);
                        continue;
                    }
                    String p = new Location(tiffPath, list[i2]).getAbsolutePath();
                    String check = p.toLowerCase();
                    if (!check.endsWith(".tif") && !check.endsWith(".pty") && !check.endsWith(".roi") && !check.endsWith(".lut") && !check.endsWith(".bmp")) continue;
                    this.usedFiles.add(p);
                }
            }
        }
        this.status("Populating metadata");
        float sizeZ = 1.0f;
        float sizeT = 1.0f;
        int realChannels = 0;
        for (int i3 = 0; i3 < 9; ++i3) {
            int ss = Integer.parseInt(this.size[i3]);
            if (this.pixelSize[i3] == null) {
                this.pixelSize[i3] = "1.0";
            }
            this.pixelSize[i3] = this.pixelSize[i3].replaceAll("\"", "");
            Float pixel = new Float(this.pixelSize[i3]);
            if (this.code[i3].equals("X")) {
                this.core[0].sizeX = ss;
                continue;
            }
            if (this.code[i3].equals("Y")) {
                this.core[0].sizeY = ss;
                continue;
            }
            if (this.code[i3].equals("Z")) {
                this.core[0].sizeZ = ss;
                sizeZ = (float)((double)pixel.floatValue() * 0.001);
                continue;
            }
            if (this.code[i3].equals("T")) {
                this.core[0].sizeT = ss;
                sizeT = pixel.floatValue() / 1000.0f;
                continue;
            }
            if (ss <= 0) continue;
            this.core[0].sizeC = this.getSizeC() == 0 ? ss : (this.core[0].sizeC *= ss);
            if (!this.code[i3].equals("C")) continue;
            realChannels = ss;
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getImageCount() == this.getSizeC() && this.getSizeY() == 1) {
            this.core[0].imageCount *= this.getSizeZ() * this.getSizeT();
        } else if (this.getImageCount() == this.getSizeC()) {
            this.core[0].sizeZ = 1;
            this.core[0].sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeT() * this.getSizeC() != this.getImageCount()) {
            int diff = this.getSizeZ() * this.getSizeC() * this.getSizeT() - this.getImageCount();
            if (diff == this.previewNames.size() || diff < 0) {
                diff /= this.getSizeC();
                if (this.getSizeT() > 1 && this.getSizeZ() == 1) {
                    this.core[0].sizeT -= diff;
                } else if (this.getSizeZ() > 1 && this.getSizeT() == 1) {
                    this.core[0].sizeZ -= diff;
                }
            } else {
                this.core[0].imageCount += diff;
            }
        }
        if (this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("Z") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("T") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        switch (this.imageDepth) {
            case 1: {
                this.core[0].pixelType = 1;
                break;
            }
            case 2: {
                this.core[0].pixelType = 3;
                break;
            }
            case 4: {
                this.core[0].pixelType = 5;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported pixel depth: " + this.imageDepth);
            }
        }
        this.in.close();
        this.in = null;
        try {
            RandomAccessInputStream thumb = this.getFile(this.thumbId);
            byte[] b = new byte[(int)thumb.length()];
            thumb.read(b);
            thumb.close();
            Location.mapFile("thumbnail.bmp", new ByteArrayHandle(b));
            this.thumbReader.setId("thumbnail.bmp");
            for (int i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                this.core[i4].thumbSizeX = this.thumbReader.getSizeX();
                this.core[i4].thumbSizeY = this.thumbReader.getSizeY();
            }
            Location.mapFile("thumbnail.bmp", null);
        }
        catch (IOException e) {
            this.traceDebug(e);
        }
        this.lut = new short[this.getSizeC()][3][65536];
        byte[] buffer = new byte[262144];
        int count = Math.min(this.getSizeC(), lutNames.size());
        for (int c = 0; c < count; ++c) {
            try {
                RandomAccessInputStream stream = this.getFile((String)lutNames.get(c));
                stream.seek(stream.length() - 262144L);
                stream.read(buffer);
                stream.close();
                for (int q = 0; q < buffer.length; q += 4) {
                    this.lut[c][0][q / 4] = buffer[q + 1];
                    this.lut[c][1][q / 4] = buffer[q + 2];
                    this.lut[c][2][q / 4] = buffer[q + 3];
                }
                continue;
            }
            catch (IOException e) {
                this.traceDebug(e);
                this.lut = null;
                break;
            }
        }
        for (int i5 = 0; i5 < this.getSeriesCount(); ++i5) {
            this.core[i5].rgb = false;
            this.core[i5].littleEndian = true;
            this.core[i5].interleaved = false;
            this.core[i5].metadataComplete = true;
            this.core[i5].indexed = false;
            this.core[i5].falseColor = false;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        if (this.creationDate != null) {
            this.creationDate = this.creationDate.replaceAll("'", "");
            this.creationDate = DateTools.formatDate(this.creationDate, DATE_FORMAT);
        }
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i6 = 0; i6 < this.getSeriesCount(); ++i6) {
            store.setImageName("Series " + (i6 + 1), i6);
            if (this.creationDate != null) {
                store.setImageCreationDate(this.creationDate, i6);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i6);
            }
            store.setImageInstrumentRef(instrumentID, i6);
            if (this.pixelSizeX != null) {
                store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), i6, 0);
            }
            if (this.pixelSizeY != null) {
                store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), i6, 0);
            }
            store.setDimensionsPhysicalSizeZ(new Float(sizeZ), i6, 0);
            store.setDimensionsTimeIncrement(new Float(sizeT), i6, 0);
            for (int c = 0; c < this.core[i6].sizeC; ++c) {
                if (c < this.channelNames.size()) {
                    store.setLogicalChannelName(this.channelNames.get(c), i6, c);
                }
                if (c < this.emWaves.size()) {
                    store.setLogicalChannelEmWave(this.emWaves.get(c), i6, c);
                }
                if (c < this.exWaves.size()) {
                    store.setLogicalChannelExWave(this.exWaves.get(c), i6, c);
                }
                if (c >= this.illuminations.size()) continue;
                store.setLogicalChannelIlluminationType(this.illuminations.get(c), i6, c);
            }
        }
        int nLasers = Math.min(this.dyeNames.size(), this.wavelengths.size());
        for (int i7 = 0; i7 < nLasers; ++i7) {
            String lightSourceID = MetadataTools.createLSID("LightSource", 0, i7);
            store.setLightSourceID(lightSourceID, 0, i7);
            store.setLightSourceSettingsLightSource(lightSourceID, 0, i7);
            if (i7 < this.exWaves.size()) {
                store.setLightSourceSettingsWavelength(this.exWaves.get(i7), 0, i7);
            }
            store.setLaserLaserMedium(this.dyeNames.get(i7), 0, i7);
            store.setLaserWavelength(this.wavelengths.get(i7), 0, i7);
        }
        if (this.gain != null) {
            store.setDetectorGain(new Float(this.gain), 0, 0);
        }
        if (this.offset != null) {
            store.setDetectorOffset(new Float(this.offset), 0, 0);
        }
        if (this.voltage != null) {
            store.setDetectorVoltage(new Float(this.voltage), 0, 0);
        }
        store.setDetectorType("Unknown", 0, 0);
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detectorID, 0, 0);
        store.setDetectorSettingsDetector(detectorID, 0, 0);
        if (this.lensNA != null) {
            store.setObjectiveLensNA(new Float(this.lensNA), 0, 0);
        }
        store.setObjectiveModel(this.objectiveName, 0, 0);
        if (this.magnification != null) {
            store.setObjectiveNominalMagnification(new Integer((int)Float.parseFloat(this.magnification)), 0, 0);
        }
        if (this.workingDistance != null) {
            store.setObjectiveWorkingDistance(new Float(this.workingDistance), 0, 0);
        }
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        store.setObjectiveSettingsObjective(objectiveID, 0);
        int nextROI = -1;
        for (int i8 = 0; i8 < roiFilenames.size() && i8 < this.getImageCount(); ++i8) {
            int[] coordinates = this.getZCTCoords(i8);
            String filename = (String)roiFilenames.get(new Integer(i8));
            filename = this.sanitizeFile(filename, this.isOIB || mappedOIF ? "" : path);
            RandomAccessInputStream stream = this.getFile(filename);
            String data = stream.readString((int)stream.length());
            stream.close();
            String[] lines = data.split("\n");
            boolean validROI = false;
            int nextShape = -1;
            int shapeType = -1;
            String[] xc = null;
            String[] yc = null;
            int divide = 0;
            int color = 0;
            int fontSize = 0;
            int lineWidth = 0;
            int angle = 0;
            String fontName = null;
            String name = null;
            for (int q = 0; q < lines.length; ++q) {
                int point;
                int centerY;
                int height;
                lines[q] = DataTools.stripString(lines[q]);
                int eq = lines[q].indexOf("=");
                if (eq == -1) continue;
                key = lines[q].substring(0, eq).trim();
                value = lines[q].substring(eq + 1).trim();
                if (key.equals("Name")) {
                    value = value.replaceAll("\"", "");
                    try {
                        validROI = Integer.parseInt(value) > 1;
                    }
                    catch (NumberFormatException e) {
                        validROI = false;
                    }
                }
                if (!validROI) continue;
                if (key.equals("SHAPE")) {
                    shapeType = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("DIVIDE")) {
                    divide = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("FONT")) {
                    String[] fontAttributes = value.split(",");
                    fontName = fontAttributes[0];
                    fontSize = Integer.parseInt(fontAttributes[1]);
                    continue;
                }
                if (key.equals("LINEWIDTH")) {
                    lineWidth = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("FORECOLOR")) {
                    color = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("NAME")) {
                    name = value;
                    continue;
                }
                if (key.equals("ANGLE")) {
                    angle = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("X")) {
                    xc = value.split(",");
                    continue;
                }
                if (!key.equals("Y")) continue;
                yc = value.split(",");
                int x = Integer.parseInt(xc[0]);
                int width = xc.length > 1 ? Integer.parseInt(xc[1]) - x : 0;
                int y = Integer.parseInt(yc[0]);
                int n = height = yc.length > 1 ? Integer.parseInt(yc[1]) - y : 0;
                if (width + x > this.getSizeX() || height + y > this.getSizeY()) continue;
                Integer zIndex = new Integer(coordinates[0]);
                Integer tIndex = new Integer(coordinates[2]);
                if (++nextShape == 0) {
                    store.setROIZ0(zIndex, 0, ++nextROI);
                    store.setROIZ1(zIndex, 0, nextROI);
                    store.setROIT0(tIndex, 0, nextROI);
                    store.setROIT1(tIndex, 0, nextROI);
                }
                store.setShapeTheZ(zIndex, 0, nextROI, nextShape);
                store.setShapeTheT(tIndex, 0, nextROI, nextShape);
                store.setShapeFontSize(new Integer(fontSize), 0, nextROI, nextShape);
                store.setShapeFontFamily(fontName, 0, nextROI, nextShape);
                store.setShapeText(name, 0, nextROI, nextShape);
                store.setShapeStrokeWidth(new Integer(lineWidth), 0, nextROI, nextShape);
                store.setShapeStrokeColor(String.valueOf(color), 0, nextROI, nextShape);
                if (shapeType == 2) {
                    store.setPointCx(xc[0], 0, nextROI, nextShape);
                    store.setPointCy(yc[0], 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 5) {
                    store.setRectX(String.valueOf(x), 0, nextROI, nextShape);
                    store.setRectWidth(String.valueOf(width), 0, nextROI, nextShape);
                    store.setRectY(String.valueOf(y), 0, nextROI, nextShape);
                    store.setRectHeight(String.valueOf(height), 0, nextROI, nextShape);
                    int centerX = x + width / 2;
                    centerY = y + height / 2;
                    store.setRectTransform("rotate(" + angle + " " + centerX + " " + centerY + ")", 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 11) {
                    width /= divide;
                    height /= divide;
                    for (int row = 0; row < divide; ++row) {
                        for (int col = 0; col < divide; ++col) {
                            store.setRectX(String.valueOf(x + col * width), 0, nextROI, nextShape);
                            store.setRectY(String.valueOf(y + row * height), 0, nextROI, nextShape);
                            store.setRectWidth(String.valueOf(width), 0, nextROI, nextShape);
                            store.setRectHeight(String.valueOf(height), 0, nextROI, nextShape);
                            int centerX = x + col * width + width / 2;
                            int centerY2 = y + row * height + height / 2;
                            store.setRectTransform("rotate(" + angle + " " + centerX + " " + centerY2 + ")", 0, nextROI, nextShape);
                            if (row >= divide - 1 && col >= divide - 1) continue;
                            ++nextShape;
                        }
                    }
                    continue;
                }
                if (shapeType == 3) {
                    store.setLineX1(String.valueOf(x), 0, nextROI, nextShape);
                    store.setLineY1(String.valueOf(y), 0, nextROI, nextShape);
                    store.setLineX2(String.valueOf(x + width), 0, nextROI, nextShape);
                    store.setLineY2(String.valueOf(y + height), 0, nextROI, nextShape);
                    int centerX = x + width / 2;
                    centerY = y + height / 2;
                    store.setLineTransform("rotate(" + angle + " " + centerX + " " + centerY + ")", 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 6) {
                    int r = width / 2;
                    store.setCircleCx(String.valueOf(x + r), 0, nextROI, nextShape);
                    store.setCircleCy(String.valueOf(y + r), 0, nextROI, nextShape);
                    store.setCircleR(String.valueOf(r), 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 7) {
                    int rx = width / 2;
                    int ry = height / 2;
                    store.setEllipseCx(String.valueOf(x + rx), 0, nextROI, nextShape);
                    store.setEllipseCy(String.valueOf(y + ry), 0, nextROI, nextShape);
                    store.setEllipseRx(String.valueOf(rx), 0, nextROI, nextShape);
                    store.setEllipseRy(String.valueOf(ry), 0, nextROI, nextShape);
                    store.setEllipseTransform("rotate(" + angle + " " + (x + rx) + " " + (y + ry) + ")", 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 8 || shapeType == 9) {
                    StringBuffer points = new StringBuffer();
                    for (point = 0; point < xc.length; ++point) {
                        points.append(xc[point]);
                        points.append(",");
                        points.append(yc[point]);
                        if (point >= xc.length - 1) continue;
                        points.append(" ");
                    }
                    store.setPolygonPoints(points.toString(), 0, nextROI, nextShape);
                    store.setPolygonTransform("rotate(" + angle + ")", 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType != 4 && shapeType != 10) continue;
                StringBuffer points = new StringBuffer();
                for (point = 0; point < xc.length; ++point) {
                    points.append(xc[point]);
                    points.append(",");
                    points.append(yc[point]);
                    if (point >= xc.length - 1) continue;
                    points.append(" ");
                }
                store.setPolylinePoints(points.toString(), 0, nextROI, nextShape);
                store.setPolylineTransform("rotate(" + angle + ")", 0, nextROI, nextShape);
            }
        }
    }

    private String sanitizeFile(String file2, String path) {
        String f = file2;
        f = f.replaceAll("\"", "");
        f = f.replace('\\', File.separatorChar);
        f = f.replace('/', File.separatorChar);
        if (!this.isOIB && path.equals("")) {
            return f;
        }
        return path + File.separator + f;
    }

    private RandomAccessInputStream getFile(String name) throws FormatException, IOException {
        if (this.isOIB) {
            if (name.startsWith("/") || name.startsWith("\\")) {
                name = name.substring(1);
            }
            name = name.replace('\\', '/');
            return this.poi.getDocumentStream(this.oibMapping.get(name));
        }
        return new RandomAccessInputStream(name);
    }

    private boolean isPreviewName(String name) {
        int index = name.indexOf("-R");
        return index == name.length() - 9;
    }

    private String replaceExtension(String name, String oldExt, String newExt) {
        if (!name.endsWith("." + oldExt)) {
            return name;
        }
        return name.substring(0, name.length() - oldExt.length()) + newExt;
    }

    private static int[] scanFormat(String pattern, String string) throws FormatException {
        Vector<Integer> percentOffsets = new Vector<Integer>();
        int offset = -1;
        while ((offset = pattern.indexOf(37, offset + 1)) >= 0 && offset + 1 < pattern.length()) {
            if (pattern.charAt(offset + 1) == '%') continue;
            percentOffsets.add(new Integer(offset));
        }
        int[] result = new int[percentOffsets.size()];
        int patternOffset = 0;
        offset = 0;
        for (int i = 0; i < result.length; ++i) {
            int endOffset;
            int percent = (Integer)percentOffsets.get(i);
            if (!string.regionMatches(offset, pattern, patternOffset, percent - patternOffset)) {
                throw new FormatException("String '" + string + "' does not match format '" + pattern + "'");
            }
            offset += percent - patternOffset;
            patternOffset = percent;
            for (endOffset = offset; endOffset < string.length() && Character.isDigit(string.charAt(endOffset)); ++endOffset) {
            }
            result[i] = Integer.parseInt(string.substring(offset, endOffset));
            offset = endOffset;
            while (++patternOffset < pattern.length() && pattern.charAt(patternOffset - 1) != 'd') {
            }
        }
        int remaining = pattern.length() - patternOffset;
        if (string.length() - offset != remaining || !string.regionMatches(offset, pattern, patternOffset, remaining)) {
            throw new FormatException("String '" + string + "' does not match format '" + pattern + "'");
        }
        return result;
    }
}

