/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class InCellReader
extends FormatReader {
    public static final String INCELL_MAGIC_STRING = "IN Cell Analyzer 1000";
    private static final String[] PIXELS_SUFFIXES = new String[]{"tif", "tiff", "im"};
    private Image[][][][] imageFiles;
    private MinimalTiffReader tiffReader;
    private Vector<Integer> emWaves;
    private Vector<Integer> exWaves;
    private int totalImages;
    private int imageWidth;
    private int imageHeight;
    private String creationDate;
    private String rowName;
    private String colName;
    private int startRow;
    private int startCol;
    private int fieldCount;
    private int wellRows;
    private int wellCols;
    private Hashtable wellCoordinates;
    private Vector<Float> posX;
    private Vector<Float> posY;
    private int firstRow;
    private int firstCol;
    private int lastCol;
    private boolean[][] exclude;
    private Vector channelsPerTimepoint;
    private boolean oneTimepointPerSeries;
    private int totalChannels;
    private Vector<String> metadataFiles;

    public InCellReader() {
        super("InCell 1000", new String[]{"xdce", "xml"});
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2048;
        if (!FormatTools.validStream(stream, 2048, false)) {
            return false;
        }
        String check = stream.readString(2048);
        return check.indexOf(INCELL_MAGIC_STRING) >= 0;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader == null ? (byte[][])null : this.tiffReader.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader == null ? (short[][])null : this.tiffReader.get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] coordinates = this.getZCTCoords(no);
        int well = this.getWellFromSeries(this.getSeries());
        int field = this.getFieldFromSeries(this.getSeries());
        int timepoint = this.oneTimepointPerSeries ? this.getSeries() % this.channelsPerTimepoint.size() : coordinates[2];
        int image = this.getIndex(coordinates[0], coordinates[1], 0);
        if (this.imageFiles[well][field][timepoint][image] == null) {
            return buf;
        }
        String filename = this.imageFiles[well][field][timepoint][image].filename;
        if (filename == null || !new Location(filename).exists()) {
            return buf;
        }
        if (this.imageFiles[well][field][timepoint][image].isTiff) {
            this.tiffReader.setId(filename);
            return this.tiffReader.openBytes(0, buf, x, y, w, h);
        }
        RandomAccessInputStream s = new RandomAccessInputStream(filename);
        s.skipBytes(128);
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.addAll(this.metadataFiles);
        if (!noPixels && this.imageFiles != null) {
            int well = this.getWellFromSeries(this.getSeries());
            int field = this.getFieldFromSeries(this.getSeries());
            Image[][] arr$ = this.imageFiles[well][field];
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Image[] timepoints;
                for (Image plane : timepoints = arr$[i$]) {
                    if (plane == null || plane.filename == null) continue;
                    files.add(plane.filename);
                }
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiffReader != null) {
            this.tiffReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.imageFiles = null;
            this.tiffReader = null;
            this.totalImages = 0;
            this.exWaves = null;
            this.emWaves = null;
            this.wellCoordinates = null;
            this.posX = null;
            this.posY = null;
            this.creationDate = null;
            this.wellCols = 0;
            this.wellRows = 0;
            this.startCol = 0;
            this.startRow = 0;
            this.fieldCount = 0;
            this.exclude = null;
            this.metadataFiles = null;
            this.imageHeight = 0;
            this.imageWidth = 0;
            this.colName = null;
            this.rowName = null;
            this.firstCol = 0;
            this.firstRow = 0;
            this.lastCol = 0;
            this.channelsPerTimepoint = null;
            this.oneTimepointPerSeries = false;
            this.totalChannels = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int timepoint;
        int field;
        int well;
        int i;
        String[] files;
        this.debug("InCellReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.firstRow = Integer.MAX_VALUE;
        this.firstCol = Integer.MAX_VALUE;
        this.lastCol = Integer.MIN_VALUE;
        this.emWaves = new Vector();
        this.exWaves = new Vector();
        this.channelsPerTimepoint = new Vector();
        this.metadataFiles = new Vector();
        Location directory = new Location(id).getAbsoluteFile().getParentFile();
        for (String file2 : files = directory.list(true)) {
            if (InCellReader.checkSuffix(file2, PIXELS_SUFFIXES)) continue;
            this.metadataFiles.add(new Location(directory, file2).getAbsolutePath());
        }
        this.wellCoordinates = new Hashtable();
        this.posX = new Vector();
        this.posY = new Vector();
        byte[] b = new byte[(int)this.in.length()];
        this.in.read(b);
        this.core[0].dimensionOrder = "XYZCT";
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        DefaultHandler handler = new MinimalInCellHandler();
        XMLTools.parseXML(b, handler);
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        Vector wells = new Vector();
        int seriesCount = 0;
        if (this.exclude != null) {
            for (int row = 0; row < this.wellRows; ++row) {
                for (int col = 0; col < this.wellCols; ++col) {
                    if (this.exclude[row][col]) continue;
                    seriesCount += this.imageFiles[row * this.wellCols + col].length;
                }
            }
            int expectedSeries = this.totalImages / (this.getSizeZ() * this.getSizeC() * this.getSizeT());
            seriesCount = Math.min(seriesCount, expectedSeries);
        } else {
            seriesCount = this.totalImages / (this.getSizeZ() * this.getSizeC() * this.getSizeT());
        }
        this.totalChannels = this.getSizeC();
        this.oneTimepointPerSeries = false;
        for (int i2 = 1; i2 < this.channelsPerTimepoint.size(); ++i2) {
            if (this.channelsPerTimepoint.get(i2).equals(this.channelsPerTimepoint.get(i2 - 1))) continue;
            this.oneTimepointPerSeries = true;
            break;
        }
        if (this.oneTimepointPerSeries) {
            int imageCount = 0;
            for (int i3 = 0; i3 < this.channelsPerTimepoint.size(); ++i3) {
                int c = (Integer)this.channelsPerTimepoint.get(i3);
                imageCount += c * this.getSizeZ();
            }
            seriesCount = this.totalImages / imageCount * this.getSizeT();
        }
        int sizeT = this.getSizeT();
        int sizeC = this.getSizeC();
        int z = this.getSizeZ();
        int t = this.oneTimepointPerSeries ? 1 : this.getSizeT();
        this.core = new CoreMetadata[seriesCount];
        for (int i4 = 0; i4 < seriesCount; ++i4) {
            int c = this.oneTimepointPerSeries ? (Integer)this.channelsPerTimepoint.get(i4 % sizeT) : sizeC;
            this.core[i4] = new CoreMetadata();
            this.core[i4].sizeZ = z;
            this.core[i4].sizeC = c;
            this.core[i4].sizeT = t;
            this.core[i4].imageCount = z * c * t;
            this.core[i4].dimensionOrder = "XYZCT";
        }
        int wellIndex = this.getWellFromSeries(0);
        int fieldIndex = this.getFieldFromSeries(0);
        String filename = this.imageFiles[wellIndex][fieldIndex][0][0].filename;
        boolean isTiff = this.imageFiles[wellIndex][fieldIndex][0][0].isTiff;
        if (isTiff && filename != null) {
            this.tiffReader = new MinimalTiffReader();
            this.tiffReader.setId(filename);
            boolean nextTiming = false;
            for (int i5 = 0; i5 < seriesCount; ++i5) {
                this.core[i5].sizeX = this.tiffReader.getSizeX();
                this.core[i5].sizeY = this.tiffReader.getSizeY();
                this.core[i5].interleaved = this.tiffReader.isInterleaved();
                this.core[i5].indexed = this.tiffReader.isIndexed();
                this.core[i5].rgb = this.tiffReader.isRGB();
                this.core[i5].pixelType = this.tiffReader.getPixelType();
                this.core[i5].littleEndian = this.tiffReader.isLittleEndian();
            }
        } else {
            for (int i6 = 0; i6 < seriesCount; ++i6) {
                this.core[i6].sizeX = this.imageWidth;
                this.core[i6].sizeY = this.imageHeight;
                this.core[i6].interleaved = false;
                this.core[i6].indexed = false;
                this.core[i6].rgb = false;
                this.core[i6].pixelType = 3;
                this.core[i6].littleEndian = true;
            }
        }
        MetadataTools.populatePixels(store, this, true);
        handler = new InCellHandler(store);
        XMLTools.parseXML(b, handler);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        String experimentID = MetadataTools.createLSID("Experiment", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setExperimentID(experimentID, 0);
        for (i = 0; i < seriesCount; ++i) {
            well = this.getWellFromSeries(i);
            field = this.getFieldFromSeries(i) + 1;
            timepoint = this.oneTimepointPerSeries ? i % this.channelsPerTimepoint.size() + 1 : -1;
            String imageID = MetadataTools.createLSID("Image", i);
            store.setImageID(imageID, i);
            store.setImageInstrumentRef(instrumentID, i);
            store.setImageExperimentRef(experimentID, i);
            int wellRow = well / this.wellCols;
            int wellCol = well % this.wellCols;
            char rowChar = this.rowName.charAt(this.rowName.length() - 1);
            char colChar = this.colName.charAt(this.colName.length() - 1);
            String row = this.rowName.substring(0, this.rowName.length() - 1);
            String col = this.colName.substring(0, this.colName.length() - 1);
            row = Character.isDigit(rowChar) ? row + (wellRow + Integer.parseInt(String.valueOf(rowChar))) : row + (char)(rowChar + wellRow);
            col = Character.isDigit(colChar) ? col + (wellCol + Integer.parseInt(String.valueOf(colChar))) : col + (char)(colChar + wellCol);
            String imageName = "Well " + row + "-" + col + ", Field #" + field;
            if (timepoint >= 0) {
                imageName = imageName + ", Timepoint #" + timepoint;
            }
            store.setImageName(imageName, i);
            store.setImageCreationDate(this.creationDate, i);
        }
        for (i = 0; i < seriesCount; ++i) {
            well = this.getWellFromSeries(i);
            field = this.getFieldFromSeries(i);
            timepoint = this.oneTimepointPerSeries ? i % this.channelsPerTimepoint.size() : 0;
            for (int time = 0; time < this.getSizeT(); ++time) {
                if (!this.oneTimepointPerSeries) {
                    timepoint = time;
                }
                int c = (Integer)this.channelsPerTimepoint.get(timepoint);
                for (int q = 0; q < this.getSizeZ() * c; ++q) {
                    Image img = this.imageFiles[well][field][timepoint][q];
                    if (img == null) continue;
                    int plane = time * this.getSizeZ() * c + q;
                    store.setPlaneTimingDeltaT(img.deltaT, i, 0, plane);
                    store.setPlaneTimingExposureTime(img.exposure, i, 0, plane);
                    store.setStagePositionPositionX(this.posX.get(field), i, 0, plane);
                    store.setStagePositionPositionY(this.posY.get(field), i, 0, plane);
                    store.setStagePositionPositionZ(img.zPosition, i, 0, plane);
                }
            }
        }
        for (i = 0; i < seriesCount; ++i) {
            this.setSeries(i);
            for (int q = 0; q < this.getEffectiveSizeC(); ++q) {
                if (q < this.emWaves.size()) {
                    store.setLogicalChannelEmWave(this.emWaves.get(q), i, q);
                }
                if (q >= this.exWaves.size()) continue;
                store.setLogicalChannelExWave(this.exWaves.get(q), i, q);
            }
        }
        this.setSeries(0);
        store.setPlateRowNamingConvention(this.rowName, 0);
        store.setPlateColumnNamingConvention(this.colName, 0);
        store.setPlateWellOriginX(new Double(0.5), 0);
        store.setPlateWellOriginY(new Double(0.5), 0);
        for (i = 0; i < seriesCount; ++i) {
            well = this.getWellFromSeries(i);
            field = this.getFieldFromSeries(i);
            String imageID = MetadataTools.createLSID("Image", i);
            store.setWellSampleIndex(new Integer(i), 0, well, field);
            store.setWellSampleImageRef(imageID, 0, well, field);
            store.setWellSamplePosX(this.posX.get(field), 0, well, field);
            store.setWellSamplePosY(this.posY.get(field), 0, well, field);
        }
        this.parseTextROIs(store);
    }

    private int getFieldFromSeries(int series) {
        if (this.oneTimepointPerSeries) {
            series /= this.channelsPerTimepoint.size();
        }
        return series % this.fieldCount;
    }

    private int getWellFromSeries(int series) {
        if (this.oneTimepointPerSeries) {
            series /= this.channelsPerTimepoint.size();
        }
        int well = series / this.fieldCount;
        int wellRow = well / (this.lastCol - this.firstCol + 1);
        int wellCol = well % (this.lastCol - this.firstCol + 1);
        return (wellRow + this.firstRow) * this.wellCols + wellCol + this.firstCol;
    }

    private void parseTextROIs(MetadataStore store) throws IOException {
        if (this.metadataFiles == null) {
            return;
        }
        block2: for (String file2 : this.metadataFiles) {
            if (!file2.toLowerCase().endsWith(".txt")) continue;
            RandomAccessInputStream s = new RandomAccessInputStream(file2);
            String data = s.readString((int)s.length());
            s.close();
            String[] lines = data.split("\n");
            Object[] skipRow = null;
            Object[] columns = null;
            Object[] values = null;
            String well = null;
            String prevWell = null;
            int xIndex = -1;
            int yIndex = -1;
            int cellIndex = -1;
            int wellIndex = -1;
            int areaIndex = -1;
            int image = 0;
            for (String line : lines) {
                values = line.split("\t");
                if (values.length <= 2) continue;
                if (skipRow == null) {
                    skipRow = values;
                    continue;
                }
                if (columns == null) {
                    columns = values;
                    xIndex = DataTools.indexOf(columns, "Cell cg X");
                    yIndex = DataTools.indexOf(columns, "Cell cg Y");
                    wellIndex = DataTools.indexOf(columns, "Well");
                    cellIndex = DataTools.indexOf(columns, "Cell");
                    areaIndex = DataTools.indexOf(columns, "Nuc Area");
                    continue;
                }
                if (wellIndex == -1) continue;
                well = ((String)values[wellIndex]).trim();
                if (!well.equals(prevWell) && prevWell != null) {
                    ++image;
                }
                int roiIndex = 0;
                double area = 0.0;
                String cell = ((String)values[cellIndex]).trim();
                try {
                    roiIndex = Integer.parseInt(cell) - 1;
                    area = Double.parseDouble(((String)values[areaIndex]).trim());
                }
                catch (NumberFormatException e) {
                    break block2;
                }
                double radius = Math.sqrt(area / Math.PI);
                store.setCircleCx(((String)values[xIndex]).trim(), image, roiIndex, 0);
                store.setCircleCy(((String)values[yIndex]).trim(), image, roiIndex, 0);
                store.setCircleR(String.valueOf(radius), image, roiIndex, 0);
                if (this.isMetadataCollected()) {
                    this.setSeries(image);
                    for (int col = 2; col < values.length; ++col) {
                        this.addSeriesMeta("Cell #" + cell + " " + (String)columns[col], ((String)values[col]).trim());
                    }
                }
                prevWell = well;
            }
        }
        this.setSeries(0);
    }

    static /* synthetic */ Image[][][][] access$002(InCellReader x0, Image[][][][] x1) {
        x0.imageFiles = x1;
        return x1;
    }

    static /* synthetic */ boolean[][] access$502(InCellReader x0, boolean[][] x1) {
        x0.exclude = x1;
        return x1;
    }

    class Image {
        public String filename;
        public boolean isTiff;
        public Float deltaT;
        public Float exposure;
        public Float zPosition;

        Image() {
        }
    }

    class InCellHandler
    extends DefaultHandler {
        private String currentQName;
        private boolean openImage;
        private int nextEmWave = 0;
        private int nextExWave = 0;
        private MetadataStore store;
        private int nextPlate = 0;
        private int currentRow = -1;
        private int currentCol = -1;
        private int currentField = 0;
        private int currentImage;
        private int currentPlane;
        private Float timestamp;
        private Float exposure;
        private Float zPosition;

        public InCellHandler(MetadataStore store) {
            this.store = store;
        }

        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            if (this.currentQName.equals("UserComment")) {
                this.store.setImageDescription(value, 0);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("Image")) {
                InCellReader.this.wellCoordinates.put(new Integer(this.currentField), new int[]{this.currentRow, this.currentCol});
                this.openImage = false;
                int well = this.currentRow * InCellReader.this.wellCols + this.currentCol;
                Image img = InCellReader.this.imageFiles[well][this.currentField][this.currentImage][this.currentPlane];
                if (img != null) {
                    img.deltaT = this.timestamp;
                    img.exposure = this.exposure;
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentQName = qName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                InCellReader.this.addGlobalMeta(qName + " - " + attributes.getQName(i), attributes.getValue(i));
            }
            if (qName.equals("Microscopy")) {
                String experimentID = MetadataTools.createLSID("Experiment", 0);
                this.store.setExperimentID(experimentID, 0);
                this.store.setExperimentType(attributes.getValue("type"), 0);
            } else if (qName.equals("Image")) {
                this.openImage = true;
                float time = Float.parseFloat(attributes.getValue("acquisition_time_ms"));
                this.timestamp = new Float(time / 1000.0f);
            } else if (qName.equals("Identifier")) {
                int t;
                this.currentField = Integer.parseInt(attributes.getValue("field_index"));
                int z = Integer.parseInt(attributes.getValue("z_index"));
                int c = Integer.parseInt(attributes.getValue("wave_index"));
                this.currentImage = t = Integer.parseInt(attributes.getValue("time_index"));
                this.currentPlane = z * InCellReader.this.getSizeC() + c;
                int well = this.currentRow * InCellReader.this.wellCols + this.currentCol;
                Image img = InCellReader.this.imageFiles[well][this.currentField][this.currentImage][this.currentPlane];
                img.zPosition = this.zPosition;
            } else if (qName.equals("FocusPosition")) {
                this.zPosition = new Float(attributes.getValue("z"));
            } else if (qName.equals("Creation")) {
                String date = attributes.getValue("date");
                String time = attributes.getValue("time");
                InCellReader.this.creationDate = date + "T" + time;
            } else if (qName.equals("ObjectiveCalibration")) {
                this.store.setObjectiveNominalMagnification(new Integer((int)Float.parseFloat(attributes.getValue("magnification"))), 0, 0);
                this.store.setObjectiveLensNA(new Float(attributes.getValue("numerical_aperture")), 0, 0);
                this.store.setObjectiveImmersion("Unknown", 0, 0);
                String objective = attributes.getValue("objective_name");
                String[] tokens = objective.split("_");
                this.store.setObjectiveManufacturer(tokens[0], 0, 0);
                if (tokens.length > 2) {
                    this.store.setObjectiveCorrection(tokens[2], 0, 0);
                } else {
                    this.store.setObjectiveCorrection("Unknown", 0, 0);
                }
                Float pixelSizeX = new Float(attributes.getValue("pixel_width"));
                Float pixelSizeY = new Float(attributes.getValue("pixel_height"));
                Float refractive = new Float(attributes.getValue("refractive_index"));
                String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
                this.store.setObjectiveID(objectiveID, 0, 0);
                for (int i = 0; i < InCellReader.this.getSeriesCount(); ++i) {
                    this.store.setObjectiveSettingsObjective(objectiveID, i);
                    this.store.setObjectiveSettingsRefractiveIndex(refractive, i);
                    this.store.setDimensionsPhysicalSizeX(pixelSizeX, i, 0);
                    this.store.setDimensionsPhysicalSizeY(pixelSizeY, i, 0);
                }
            } else if (qName.equals("ExcitationFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.exWaves.add(new Integer(wave));
                }
            } else if (qName.equals("EmissionFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.emWaves.add(new Integer(wave));
                }
            } else if (qName.equals("Camera")) {
                this.store.setDetectorModel(attributes.getValue("name"), 0, 0);
                this.store.setDetectorType("Unknown", 0, 0);
                String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                this.store.setDetectorID(detectorID, 0, 0);
                for (int i = 0; i < InCellReader.this.getSeriesCount(); ++i) {
                    InCellReader.this.setSeries(i);
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsDetector(detectorID, i, q);
                    }
                }
                InCellReader.this.setSeries(0);
            } else if (qName.equals("Binning")) {
                String binning = attributes.getValue("value");
                for (int i = 0; i < InCellReader.this.getSeriesCount(); ++i) {
                    InCellReader.this.setSeries(i);
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsBinning(binning, i, q);
                    }
                }
                InCellReader.this.setSeries(0);
            } else if (qName.equals("Gain")) {
                Float gain = new Float(attributes.getValue("value"));
                for (int i = 0; i < InCellReader.this.getSeriesCount(); ++i) {
                    InCellReader.this.setSeries(i);
                    for (int q = 0; q < InCellReader.this.getSizeC(); ++q) {
                        this.store.setDetectorSettingsGain(gain, i, q);
                    }
                }
                InCellReader.this.setSeries(0);
            } else if (qName.equals("PlateTemperature")) {
                Float temperature = new Float(attributes.getValue("value"));
                for (int i = 0; i < InCellReader.this.getSeriesCount(); ++i) {
                    this.store.setImagingEnvironmentTemperature(temperature, i);
                }
            } else if (qName.equals("Plate")) {
                this.store.setPlateName(attributes.getValue("name"), this.nextPlate);
                for (int r = 0; r < InCellReader.this.wellRows; ++r) {
                    for (int c = 0; c < InCellReader.this.wellCols; ++c) {
                        this.store.setWellRow(new Integer(r), this.nextPlate, r * InCellReader.this.wellCols + c);
                        this.store.setWellColumn(new Integer(c), this.nextPlate, r * InCellReader.this.wellCols + c);
                    }
                }
                ++this.nextPlate;
            } else if (qName.equals("Row")) {
                this.currentRow = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Column")) {
                this.currentCol = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Exposure") && this.openImage) {
                float exp = Float.parseFloat(attributes.getValue("time"));
                this.exposure = new Float(exp / 1000.0f);
            } else if (qName.equals("NamingRows")) {
                InCellReader.this.rowName = attributes.getValue("begin");
                try {
                    InCellReader.this.startRow = Integer.parseInt(InCellReader.this.rowName);
                }
                catch (NumberFormatException e) {
                    InCellReader.this.startRow = InCellReader.this.rowName.charAt(0) - 65 + 1;
                }
            } else if (qName.equals("NamingColumns")) {
                InCellReader.this.colName = attributes.getValue("begin");
                try {
                    InCellReader.this.startCol = Integer.parseInt(InCellReader.this.colName);
                }
                catch (NumberFormatException e) {
                    InCellReader.this.startCol = InCellReader.this.colName.charAt(0) - 65 + 1;
                }
            } else if (qName.equals("offset_point")) {
                InCellReader.this.posX.add(new Float(attributes.getValue("x")));
                InCellReader.this.posY.add(new Float(attributes.getValue("y")));
            }
        }
    }

    class MinimalInCellHandler
    extends DefaultHandler {
        private String currentImageFile;
        private int wellRow;
        private int wellCol;
        private int nChannels = 0;

        MinimalInCellHandler() {
        }

        public void endElement(String uri, String localName, String qName) {
            block6: {
                block7: {
                    block5: {
                        if (!qName.equals("PlateMap")) break block5;
                        InCellReader.access$002(InCellReader.this, new Image[InCellReader.this.wellRows * InCellReader.this.wellCols][InCellReader.this.fieldCount][InCellReader.this.getSizeT()][]);
                        for (int well = 0; well < InCellReader.this.wellRows * InCellReader.this.wellCols; ++well) {
                            for (int field = 0; field < InCellReader.this.fieldCount; ++field) {
                                for (int t = 0; t < InCellReader.this.getSizeT(); ++t) {
                                    int channels = (Integer)InCellReader.this.channelsPerTimepoint.get(t);
                                    ((InCellReader)InCellReader.this).imageFiles[well][field][t] = new Image[channels * InCellReader.this.getSizeZ()];
                                }
                            }
                        }
                        break block6;
                    }
                    if (!qName.equals("TimePoint")) break block7;
                    InCellReader.this.channelsPerTimepoint.add(new Integer(this.nChannels));
                    this.nChannels = 0;
                    break block6;
                }
                if (!qName.equals("Times")) break block6;
                if (InCellReader.this.channelsPerTimepoint.size() == 0) {
                    InCellReader.this.channelsPerTimepoint.add(new Integer(InCellReader.this.getSizeC()));
                }
                for (int i = 0; i < InCellReader.this.channelsPerTimepoint.size(); ++i) {
                    int c = (Integer)InCellReader.this.channelsPerTimepoint.get(i);
                    if (c != 0) continue;
                    InCellReader.this.channelsPerTimepoint.setElementAt(new Integer(InCellReader.this.getSizeC()), i);
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Plate")) {
                InCellReader.this.wellRows = Integer.parseInt(attributes.getValue("rows"));
                InCellReader.this.wellCols = Integer.parseInt(attributes.getValue("columns"));
            } else if (qName.equals("Exclude")) {
                if (InCellReader.this.exclude == null) {
                    InCellReader.access$502(InCellReader.this, new boolean[InCellReader.this.wellRows][InCellReader.this.wellCols]);
                }
                int row = Integer.parseInt(attributes.getValue("row")) - 1;
                int col = Integer.parseInt(attributes.getValue("col")) - 1;
                ((InCellReader)InCellReader.this).exclude[row][col] = true;
            } else if (qName.equals("Images")) {
                InCellReader.this.totalImages = Integer.parseInt(attributes.getValue("number"));
            } else if (qName.equals("Image")) {
                String file2 = attributes.getValue("filename");
                String thumb = attributes.getValue("thumbnail");
                Location current = new Location(InCellReader.this.currentId).getAbsoluteFile();
                Location imageFile = new Location(current.getParentFile(), file2);
                this.currentImageFile = imageFile.getAbsolutePath();
            } else if (qName.equals("Identifier")) {
                int field = Integer.parseInt(attributes.getValue("field_index"));
                int z = Integer.parseInt(attributes.getValue("z_index"));
                int c = Integer.parseInt(attributes.getValue("wave_index"));
                int t = Integer.parseInt(attributes.getValue("time_index"));
                int channels = (Integer)InCellReader.this.channelsPerTimepoint.get(t);
                int index = FormatTools.getIndex("XYZCT", InCellReader.this.getSizeZ(), channels, 1, InCellReader.this.getSizeZ() * channels, z, c, 0);
                Image img = new Image();
                Location file3 = new Location(this.currentImageFile);
                String string = img.filename = file3.exists() ? this.currentImageFile : null;
                if (img.filename == null) {
                    InCellReader.this.warn(this.currentImageFile + " does not exist.");
                }
                this.currentImageFile = this.currentImageFile.toLowerCase();
                img.isTiff = this.currentImageFile.endsWith(".tif") || this.currentImageFile.endsWith(".tiff");
                ((InCellReader)InCellReader.this).imageFiles[this.wellRow * ((InCellReader)InCellReader.this).wellCols + this.wellCol][field][t][index] = img;
            } else if (qName.equals("offset_point")) {
                InCellReader.this.fieldCount++;
            } else if (qName.equals("TimePoint")) {
                ++((InCellReader)InCellReader.this).core[0].sizeT;
            } else if (qName.equals("Wavelength")) {
                String fusion = attributes.getValue("fusion_wave");
                if (fusion.equals("false")) {
                    ++((InCellReader)InCellReader.this).core[0].sizeC;
                }
            } else if (qName.equals("AcqWave")) {
                ++this.nChannels;
            } else if (qName.equals("ZDimensionParameters")) {
                String nz = attributes.getValue("number_of_slices");
                if (nz != null) {
                    ((InCellReader)InCellReader.this).core[0].sizeZ = Integer.parseInt(nz);
                } else {
                    ((InCellReader)InCellReader.this).core[0].sizeZ = 1;
                }
            } else if (qName.equals("Row")) {
                this.wellRow = Integer.parseInt(attributes.getValue("number")) - 1;
                InCellReader.this.firstRow = Math.min(InCellReader.this.firstRow, this.wellRow);
            } else if (qName.equals("Column")) {
                this.wellCol = Integer.parseInt(attributes.getValue("number")) - 1;
                InCellReader.this.firstCol = Math.min(InCellReader.this.firstCol, this.wellCol);
                InCellReader.this.lastCol = Math.max(InCellReader.this.lastCol, this.wellCol);
            } else if (qName.equals("Size")) {
                InCellReader.this.imageWidth = Integer.parseInt(attributes.getValue("width"));
                InCellReader.this.imageHeight = Integer.parseInt(attributes.getValue("height"));
            }
        }
    }
}

