/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.AxisGuesser;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;

public class LeicaReader
extends FormatReader {
    public static final String[] LEI_SUFFIX = new String[]{"lei"};
    private static final int LEICA_MAGIC_TAG = 33923;
    private static final String DATE_FORMAT = "yyyy:MM:dd,HH:mm:ss:SSS";
    private static final Integer SERIES = new Integer(10);
    private static final Integer IMAGES = new Integer(15);
    private static final Integer DIMDESCR = new Integer(20);
    private static final Integer FILTERSET = new Integer(30);
    private static final Integer TIMEINFO = new Integer(40);
    private static final Integer SCANNERSET = new Integer(50);
    private static final Integer EXPERIMENT = new Integer(60);
    private static final Integer LUTDESC = new Integer(70);
    private static final Hashtable CHANNEL_PRIORITIES = LeicaReader.createChannelPriorities();
    private static Hashtable dimensionNames = LeicaReader.makeDimensionTable();
    protected IFDList ifds;
    protected IFDList headerIFDs;
    protected MinimalTiffReader tiff;
    protected Vector[] files;
    private int numSeries;
    private String leiFilename;
    private Vector seriesNames;
    private Vector seriesDescriptions;
    private int lastPlane = 0;
    private float[][] physicalSizes;
    private float[] pinhole;
    private float[] exposureTime;
    private int[][] channelMap;

    private static Hashtable createChannelPriorities() {
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        h.put("red", new Integer(0));
        h.put("green", new Integer(1));
        h.put("blue", new Integer(2));
        h.put("cyan", new Integer(3));
        h.put("magenta", new Integer(4));
        h.put("yellow", new Integer(5));
        h.put("black", new Integer(6));
        h.put("gray", new Integer(7));
        h.put("", new Integer(8));
        return h;
    }

    public LeicaReader() {
        super("Leica", new String[]{"lei", "tif", "tiff"});
    }

    public boolean isThisType(String name, boolean open) {
        Location lei;
        if (LeicaReader.checkSuffix(name, LEI_SUFFIX)) {
            return true;
        }
        if (!LeicaReader.checkSuffix(name, TiffReader.TIFF_SUFFIXES)) {
            return false;
        }
        if (!open) {
            return false;
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (!(lei = new Location(prefix + ".lei")).exists()) {
            lei = new Location(prefix + ".LEI");
            while (!lei.exists() && prefix.indexOf("_") != -1) {
                lei = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".lei");
                if (lei.exists()) continue;
                lei = new Location(prefix + ".LEI");
            }
        }
        return lei.exists();
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(new Integer(33923));
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            this.tiff.setId((String)this.files[this.series].get(this.lastPlane));
            return this.tiff.get8BitLookupTable();
        }
        catch (IOException e) {
            this.traceDebug(e);
            return null;
        }
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            this.tiff.setId((String)this.files[this.series].get(this.lastPlane));
            return this.tiff.get16BitLookupTable();
        }
        catch (IOException e) {
            this.traceDebug(e);
            return null;
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (!this.isRGB()) {
            int[] pos = this.getZCTCoords(no);
            pos[1] = DataTools.indexOf(this.channelMap[this.series], pos[1]);
            if (pos[1] >= 0 && pos[1] < this.getSizeC()) {
                no = this.getIndex(pos[0], pos[1], pos[2]);
            }
        }
        this.lastPlane = no;
        this.tiff.setId((String)this.files[this.series].get(no));
        return this.tiff.openBytes(0, buf, x, y, w, h);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> v = new Vector<String>();
        v.add(this.leiFilename);
        if (!noPixels) {
            v.addAll(this.files[this.getSeries()]);
        }
        return v.toArray(new String[v.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.leiFilename = null;
            this.files = null;
            this.headerIFDs = null;
            this.ifds = null;
            this.tiff = null;
            this.seriesNames = null;
            this.numSeries = 0;
            this.lastPlane = 0;
            this.channelMap = null;
            this.physicalSizes = null;
            this.seriesDescriptions = null;
            this.exposureTime = null;
            this.pinhole = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("LeicaReader.initFile(" + id + ")");
        this.close();
        if (LeicaReader.checkSuffix(id, TiffReader.TIFF_SUFFIXES)) {
            if (this.ifds == null) {
                super.initFile(id);
            }
            this.in = new RandomAccessInputStream(id);
            TiffParser tp = new TiffParser(this.in);
            this.in.order(tp.checkHeader());
            this.in.seek(0L);
            this.status("Finding companion file name");
            this.ifds = tp.getIFDs();
            if (this.ifds == null) {
                throw new FormatException("No IFDs found");
            }
            String descr = ((IFD)this.ifds.get(0)).getComment();
            descr = descr.replaceAll("\\[.*.\\]\n", "");
            String lei = id.substring(0, id.lastIndexOf(File.separator) + 1);
            StringTokenizer lines = new StringTokenizer(descr, "\n");
            String line = null;
            String key = null;
            String value = null;
            while (lines.hasMoreTokens()) {
                line = lines.nextToken();
                if (line.indexOf("=") == -1) continue;
                key = line.substring(0, line.indexOf("=")).trim();
                value = line.substring(line.indexOf("=") + 1).trim();
                this.addGlobalMeta(key, value);
                if (!key.startsWith("Series Name")) continue;
                lei = lei + value;
            }
            Location l = new Location(lei).getAbsoluteFile();
            if (l.exists()) {
                this.initFile(lei);
                return;
            }
            l = l.getParentFile();
            String[] list = l.list();
            for (int i2 = 0; i2 < list.length; ++i2) {
                if (!LeicaReader.checkSuffix(list[i2], LEI_SUFFIX)) continue;
                this.initFile(new Location(l.getAbsolutePath(), list[i2]).getAbsolutePath());
                return;
            }
            throw new FormatException("LEI file not found.");
        }
        super.initFile(id);
        this.leiFilename = new File(id).exists() ? new Location(id).getAbsolutePath() : id;
        this.in = new RandomAccessInputStream(id);
        this.seriesNames = new Vector();
        byte[] fourBytes = new byte[4];
        this.in.read(fourBytes);
        this.core[0].littleEndian = fourBytes[0] == 73 && fourBytes[1] == 73 && fourBytes[2] == 73 && fourBytes[3] == 73;
        this.in.order(this.isLittleEndian());
        this.status("Reading metadata blocks");
        this.in.skipBytes(8);
        int addr = this.in.readInt();
        this.headerIFDs = new IFDList();
        while (addr != 0) {
            IFD ifd = new IFD();
            this.headerIFDs.add(ifd);
            this.in.seek(addr + 4);
            int tag = this.in.readInt();
            while (tag != 0) {
                int offset = this.in.readInt();
                long pos = this.in.getFilePointer();
                this.in.seek(offset + 12);
                int size = this.in.readInt();
                byte[] data = new byte[size];
                this.in.read(data);
                ifd.put(new Integer(tag), data);
                this.in.seek(pos);
                tag = this.in.readInt();
            }
            addr = this.in.readInt();
        }
        this.numSeries = this.headerIFDs.size();
        this.core = new CoreMetadata[this.numSeries];
        for (int i3 = 0; i3 < this.numSeries; ++i3) {
            this.core[i3] = new CoreMetadata();
        }
        this.channelMap = new int[this.numSeries][];
        this.files = new Vector[this.numSeries];
        int nameLength = 0;
        int maxPlanes = 0;
        this.status("Parsing metadata blocks");
        this.core[0].littleEndian = !this.isLittleEndian();
        boolean seriesIndex = false;
        boolean[] valid = new boolean[this.numSeries];
        for (int i4 = 0; i4 < this.headerIFDs.size(); ++i4) {
            IFD ifd = (IFD)this.headerIFDs.get(i4);
            valid[i4] = true;
            if (ifd.get(SERIES) != null) {
                byte[] temp = (byte[])ifd.get(SERIES);
                nameLength = DataTools.bytesToInt(temp, 8, this.isLittleEndian()) * 2;
            }
            Vector<String> f = new Vector<String>();
            byte[] tempData = (byte[])ifd.get(IMAGES);
            RandomAccessInputStream data = new RandomAccessInputStream(tempData);
            data.order(this.isLittleEndian());
            int tempImages = data.readInt();
            if ((long)tempImages * (long)nameLength > data.length()) {
                data.order(!this.isLittleEndian());
                tempImages = data.readInt();
                data.order(this.isLittleEndian());
            }
            this.core[i4].sizeX = data.readInt();
            this.core[i4].sizeY = data.readInt();
            data.skipBytes(4);
            int samplesPerPixel = data.readInt();
            this.core[i4].rgb = samplesPerPixel > 1;
            this.core[i4].sizeC = samplesPerPixel;
            File dirFile = new File(id).getAbsoluteFile();
            String[] listing = null;
            String dirPrefix = "";
            if (dirFile.exists()) {
                listing = dirFile.getParentFile().list();
                dirPrefix = dirFile.getParent();
                if (!dirPrefix.endsWith(File.separator)) {
                    dirPrefix = dirPrefix + File.separator;
                }
            } else {
                listing = Location.getIdMap().keySet().toArray(new String[0]);
            }
            Vector<String> list = new Vector<String>();
            for (int k = 0; k < listing.length; ++k) {
                if (!LeicaReader.checkSuffix(listing[k], TiffReader.TIFF_SUFFIXES)) continue;
                list.add(listing[k]);
            }
            boolean tiffsExist = true;
            String prefix = "";
            for (int j = 0; j < tempImages; ++j) {
                prefix = this.getString(data, nameLength);
                f.add(dirPrefix + prefix);
                Location test = new Location((String)f.get(f.size() - 1));
                if (test.exists()) {
                    list.remove(prefix);
                }
                if (!tiffsExist) continue;
                tiffsExist = test.exists();
            }
            data.close();
            tempData = null;
            if (!tiffsExist) {
                int q;
                this.status("Handling renamed TIFF files");
                listing = list.toArray(new String[0]);
                Vector<String> filePatterns = new Vector<String>();
                for (q = 0; q < listing.length; ++q) {
                    Location l = new Location(dirPrefix, listing[q]);
                    l = l.getAbsoluteFile();
                    FilePattern pattern = new FilePattern(l);
                    AxisGuesser guess = new AxisGuesser(pattern, "XYZCT", 1, 1, 1, false);
                    String fp = pattern.getPattern();
                    if (guess.getAxisCountS() >= 1) {
                        String pre = pattern.getPrefix(guess.getAxisCountS());
                        Vector<String> fileList = new Vector<String>();
                        for (int n = 0; n < listing.length; ++n) {
                            Location p = new Location(dirPrefix, listing[n]);
                            if (!p.getAbsolutePath().startsWith(pre)) continue;
                            fileList.add(listing[n]);
                        }
                        fp = FilePattern.findPattern(l.getAbsolutePath(), dirPrefix, fileList.toArray(new String[0]));
                    }
                    if (fp == null || filePatterns.contains(fp)) continue;
                    filePatterns.add(fp);
                }
                for (q = 0; q < filePatterns.size(); ++q) {
                    int n;
                    String[] pattern = new FilePattern((String)filePatterns.get(q)).getFiles();
                    if (pattern.length != tempImages) continue;
                    boolean validPattern = true;
                    for (n = 0; n < i4; ++n) {
                        if (this.files[n] == null || !this.files[n].contains(pattern[0])) continue;
                        validPattern = false;
                        break;
                    }
                    if (!validPattern) continue;
                    this.files[i4] = new Vector();
                    for (n = 0; n < pattern.length; ++n) {
                        this.files[i4].add(pattern[n]);
                    }
                }
            } else {
                this.files[i4] = f;
            }
            if (this.files[i4] == null) {
                valid[i4] = false;
                continue;
            }
            this.core[i4].imageCount = this.files[i4].size();
            if (this.core[i4].imageCount <= maxPlanes) continue;
            maxPlanes = this.core[i4].imageCount;
        }
        int invalidCount = 0;
        for (int i5 = 0; i5 < valid.length; ++i5) {
            if (valid[i5]) continue;
            ++invalidCount;
        }
        this.numSeries -= invalidCount;
        int[] count = new int[this.getSeriesCount()];
        for (int i6 = 0; i6 < this.getSeriesCount(); ++i6) {
            count[i6] = this.core[i6].imageCount;
        }
        Vector[] tempFiles = this.files;
        IFDList tempIFDs = this.headerIFDs;
        this.core = new CoreMetadata[this.numSeries];
        this.files = new Vector[this.numSeries];
        this.headerIFDs = new IFDList();
        int index = 0;
        for (int i7 = 0; i7 < this.numSeries; ++i7) {
            this.core[i7] = new CoreMetadata();
            while (!valid[index]) {
                ++index;
            }
            this.core[i7].imageCount = count[index];
            this.files[i7] = tempFiles[index];
            Object[] sorted = this.files[i7].toArray();
            Arrays.sort(sorted);
            this.files[i7].clear();
            for (int q = 0; q < sorted.length; ++q) {
                this.files[i7].add(sorted[q]);
            }
            this.headerIFDs.add(tempIFDs.get(index));
            ++index;
        }
        this.tiff = new MinimalTiffReader();
        this.status("Populating metadata");
        if (this.headerIFDs == null) {
            this.headerIFDs = this.ifds;
        }
        int fileLength = 0;
        int resolution = -1;
        String[][] timestamps = new String[this.headerIFDs.size()][];
        this.seriesDescriptions = new Vector();
        this.physicalSizes = new float[this.headerIFDs.size()][5];
        this.pinhole = new float[this.headerIFDs.size()];
        this.exposureTime = new float[this.headerIFDs.size()];
        for (i = 0; i < this.headerIFDs.size(); ++i) {
            IFD ifd = (IFD)this.headerIFDs.get(i);
            this.core[i].littleEndian = this.isLittleEndian();
            this.setSeries(i);
            Object[] keys = ifd.keySet().toArray();
            Arrays.sort(keys);
            for (int q = 0; q < keys.length; ++q) {
                byte[] tmp = (byte[])ifd.get(keys[q]);
                if (tmp == null) continue;
                RandomAccessInputStream stream = new RandomAccessInputStream(tmp);
                stream.order(this.isLittleEndian());
                if (keys[q].equals(SERIES)) {
                    this.addSeriesMeta("Version", stream.readInt());
                    this.addSeriesMeta("Number of Series", stream.readInt());
                    fileLength = stream.readInt();
                    this.addSeriesMeta("Length of filename", fileLength);
                    int extLen = stream.readInt();
                    if (extLen > fileLength) {
                        stream.seek(8L);
                        this.core[0].littleEndian = !this.isLittleEndian();
                        stream.order(this.isLittleEndian());
                        fileLength = stream.readInt();
                        extLen = stream.readInt();
                    }
                    this.addSeriesMeta("Length of file extension", extLen);
                    this.addSeriesMeta("Image file extension", this.getString(stream, extLen));
                } else if (keys[q].equals(IMAGES)) {
                    this.core[i].imageCount = stream.readInt();
                    this.core[i].sizeX = stream.readInt();
                    this.core[i].sizeY = stream.readInt();
                    this.addSeriesMeta("Number of images", this.getImageCount());
                    this.addSeriesMeta("Image width", this.getSizeX());
                    this.addSeriesMeta("Image height", this.getSizeY());
                    this.addSeriesMeta("Bits per Sample", stream.readInt());
                    this.addSeriesMeta("Samples per pixel", stream.readInt());
                    String name = this.getString(stream, fileLength * 2);
                    if (name.indexOf(".") != -1) {
                        name = name.substring(0, name.lastIndexOf("."));
                    }
                    String[] tokens = name.split("_");
                    StringBuffer buf = new StringBuffer();
                    for (int p = 1; p < tokens.length; ++p) {
                        String lcase = tokens[p].toLowerCase();
                        if (lcase.startsWith("ch0") || lcase.startsWith("c0") || lcase.startsWith("z0") || lcase.startsWith("t0")) continue;
                        if (buf.length() > 0) {
                            buf.append("_");
                        }
                        buf.append(tokens[p]);
                    }
                    this.seriesNames.add(buf.toString());
                } else if (keys[q].equals(DIMDESCR)) {
                    this.addSeriesMeta("Voxel Version", stream.readInt());
                    this.core[i].rgb = stream.readInt() == 20;
                    this.addSeriesMeta("VoxelType", this.isRGB() ? "RGB" : "gray");
                    int bpp = stream.readInt();
                    this.addSeriesMeta("Bytes per pixel", bpp);
                    switch (bpp) {
                        case 1: {
                            this.core[i].pixelType = 1;
                            break;
                        }
                        case 3: {
                            this.core[i].pixelType = 1;
                            this.core[i].sizeC = 3;
                            this.core[i].rgb = true;
                            break;
                        }
                        case 2: {
                            this.core[i].pixelType = 3;
                            break;
                        }
                        case 6: {
                            this.core[i].pixelType = 3;
                            this.core[i].sizeC = 3;
                            this.core[i].rgb = true;
                            break;
                        }
                        case 4: {
                            this.core[i].pixelType = 5;
                            break;
                        }
                        default: {
                            throw new FormatException("Unsupported bytes per pixel (" + bpp + ")");
                        }
                    }
                    this.core[i].dimensionOrder = "XY";
                    resolution = stream.readInt();
                    this.addSeriesMeta("Real world resolution", resolution);
                    this.addSeriesMeta("Maximum voxel intensity", this.getString(stream, true));
                    this.addSeriesMeta("Minimum voxel intensity", this.getString(stream, true));
                    int len = stream.readInt();
                    stream.skipBytes(len * 2 + 4);
                    len = stream.readInt();
                    for (int j = 0; j < len; ++j) {
                        int dimId = stream.readInt();
                        String dimType = (String)dimensionNames.get(new Integer(dimId));
                        if (dimType == null) {
                            dimType = "";
                        }
                        int size = stream.readInt();
                        int distance = stream.readInt();
                        int strlen = stream.readInt() * 2;
                        String[] sizeData = this.getString(stream, strlen).split(" ");
                        String physicalSize = sizeData[0];
                        String unit = "";
                        if (sizeData.length > 1) {
                            unit = sizeData[1];
                        }
                        float physical = Float.parseFloat(physicalSize) / (float)size;
                        if (unit.equals("m")) {
                            physical *= 1000000.0f;
                        }
                        if (dimType.equals("x")) {
                            this.core[i].sizeX = size;
                            this.physicalSizes[i][0] = physical;
                        } else if (dimType.equals("y")) {
                            this.core[i].sizeY = size;
                            this.physicalSizes[i][1] = physical;
                        } else if (dimType.indexOf("z") != -1) {
                            this.core[i].sizeZ = size;
                            if (this.getDimensionOrder().indexOf("Z") == -1) {
                                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "Z";
                            }
                            this.physicalSizes[i][2] = physical;
                        } else if (dimType.equals("channel")) {
                            if (this.getSizeC() == 0) {
                                this.core[i].sizeC = 1;
                            }
                            this.core[i].sizeC *= size;
                            if (this.getDimensionOrder().indexOf("C") == -1) {
                                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "C";
                            }
                            this.physicalSizes[i][3] = physical;
                        } else {
                            this.core[i].sizeT = size;
                            if (this.getDimensionOrder().indexOf("T") == -1) {
                                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "T";
                            }
                            this.physicalSizes[i][4] = physical;
                        }
                        String dimPrefix = "Dim" + j;
                        this.addSeriesMeta(dimPrefix + " type", dimType);
                        this.addSeriesMeta(dimPrefix + " size", size);
                        this.addSeriesMeta(dimPrefix + " distance between sub-dimensions", distance);
                        this.addSeriesMeta(dimPrefix + " physical length", physicalSize + " " + unit);
                        this.addSeriesMeta(dimPrefix + " physical origin", this.getString(stream, true));
                    }
                    this.addSeriesMeta("Series name", this.getString(stream, false));
                    String description = this.getString(stream, false);
                    this.seriesDescriptions.add(description);
                    this.addSeriesMeta("Series description", description);
                } else if (keys[q].equals(TIMEINFO)) {
                    int nDims = stream.readInt();
                    this.addSeriesMeta("Number of time-stamped dimensions", nDims);
                    this.addSeriesMeta("Time-stamped dimension", stream.readInt());
                    for (int j = 0; j < nDims; ++j) {
                        String dimPrefix = "Dimension " + j;
                        this.addSeriesMeta(dimPrefix + " ID", stream.readInt());
                        this.addSeriesMeta(dimPrefix + " size", stream.readInt());
                        this.addSeriesMeta(dimPrefix + " distance", stream.readInt());
                    }
                    int numStamps = stream.readInt();
                    this.addSeriesMeta("Number of time-stamps", numStamps);
                    timestamps[i] = new String[numStamps];
                    for (int j = 0; j < numStamps; ++j) {
                        timestamps[i][j] = this.getString(stream, 64);
                        this.addSeriesMeta("Timestamp " + j, timestamps[i][j]);
                    }
                    if (stream.getFilePointer() < stream.length()) {
                        int numTMs = stream.readInt();
                        this.addSeriesMeta("Number of time-markers", numTMs);
                        for (int j = 0; j < numTMs; ++j) {
                            int numDims = stream.readInt();
                            String time = "Time-marker " + j + " Dimension ";
                            for (int k = 0; k < numDims; ++k) {
                                this.addSeriesMeta(time + k + " coordinate", stream.readInt());
                            }
                            this.addSeriesMeta("Time-marker " + j, this.getString(stream, 64));
                        }
                    }
                } else if (keys[q].equals(EXPERIMENT)) {
                    stream.skipBytes(8);
                    String description = this.getString(stream, true);
                    this.addSeriesMeta("Image Description", description);
                    this.addSeriesMeta("Main file extension", this.getString(stream, true));
                    this.addSeriesMeta("Image format identifier", this.getString(stream, true));
                    this.addSeriesMeta("Single image extension", this.getString(stream, true));
                } else if (keys[q].equals(LUTDESC)) {
                    int p;
                    int nChannels = stream.readInt();
                    if (nChannels > 0) {
                        this.core[i].indexed = true;
                    }
                    this.addSeriesMeta("Number of LUT channels", nChannels);
                    this.addSeriesMeta("ID of colored dimension", stream.readInt());
                    this.channelMap[i] = new int[nChannels];
                    String[] luts = new String[nChannels];
                    for (int j = 0; j < nChannels; ++j) {
                        String p2 = "LUT Channel " + j;
                        this.addSeriesMeta(p2 + " version", stream.readInt());
                        this.addSeriesMeta(p2 + " inverted?", stream.read() == 1);
                        this.addSeriesMeta(p2 + " description", this.getString(stream, false));
                        this.addSeriesMeta(p2 + " filename", this.getString(stream, false));
                        luts[j] = this.getString(stream, false);
                        this.addSeriesMeta(p2 + " name", luts[j]);
                        luts[j] = luts[j].toLowerCase();
                        stream.skipBytes(8);
                    }
                    for (int p3 = 0; p3 < this.channelMap[i].length; ++p3) {
                        if (!CHANNEL_PRIORITIES.containsKey(luts[p3])) {
                            luts[p3] = "";
                        }
                        this.channelMap[i][p3] = (Integer)CHANNEL_PRIORITIES.get(luts[p3]);
                    }
                    int[] sorted = new int[this.channelMap[i].length];
                    Arrays.fill(sorted, -1);
                    for (p = 0; p < sorted.length; ++p) {
                        int min = Integer.MAX_VALUE;
                        int minIndex = -1;
                        for (int n = 0; n < this.channelMap[i].length; ++n) {
                            if (this.channelMap[i][n] >= min || DataTools.containsValue(sorted, n)) continue;
                            min = this.channelMap[i][n];
                            minIndex = n;
                        }
                        sorted[p] = minIndex;
                    }
                    for (p = 0; p < this.channelMap[i].length; ++p) {
                        this.channelMap[i][sorted[p]] = p;
                    }
                }
                stream.close();
            }
            this.core[i].orderCertain = true;
            this.core[i].littleEndian = this.isLittleEndian();
            this.core[i].falseColor = true;
            this.core[i].metadataComplete = true;
            this.core[i].interleaved = false;
        }
        for (i = 0; i < this.numSeries; ++i) {
            this.setSeries(i);
            if (this.getSizeZ() == 0) {
                this.core[i].sizeZ = 1;
            }
            if (this.getSizeT() == 0) {
                this.core[i].sizeT = 1;
            }
            if (this.getSizeC() == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.getImageCount() == 0) {
                this.core[i].imageCount = 1;
            }
            if (this.getImageCount() == 1 && this.getSizeZ() * this.getSizeT() > 1) {
                this.core[i].sizeZ = 1;
                this.core[i].sizeT = 1;
            }
            if (this.getSizeY() == 1) {
                if (this.getSizeZ() > 1 && this.getImageCount() == this.getSizeC() * this.getSizeT()) {
                    this.core[i].sizeY = this.getSizeZ();
                    this.core[i].sizeZ = 1;
                } else if (this.getSizeT() > 1 && this.getImageCount() == this.getSizeC() * this.getSizeZ()) {
                    this.core[i].sizeY = this.getSizeT();
                    this.core[i].sizeT = 1;
                }
            }
            if (this.isRGB()) {
                this.core[i].indexed = false;
            }
            if (this.getDimensionOrder().indexOf("C") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "C";
            }
            if (this.getDimensionOrder().indexOf("Z") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "Z";
            }
            if (this.getDimensionOrder().indexOf("T") != -1) continue;
            this.core[i].dimensionOrder = this.core[i].dimensionOrder + "T";
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i8 = 0; i8 < this.numSeries; ++i8) {
            IFD ifd = (IFD)this.headerIFDs.get(i8);
            long firstPlane = 0L;
            if (i8 < timestamps.length && timestamps[i8] != null && timestamps[i8].length > 0) {
                firstPlane = DateTools.getTime(timestamps[i8][0], DATE_FORMAT);
                store.setImageCreationDate(DateTools.formatDate(timestamps[i8][0], DATE_FORMAT), i8);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i8);
            }
            store.setImageName((String)this.seriesNames.get(i8), i8);
            store.setImageDescription((String)this.seriesDescriptions.get(i8), i8);
            store.setImageInstrumentRef(instrumentID, i8);
            store.setDimensionsPhysicalSizeX(new Float(this.physicalSizes[i8][0]), i8, 0);
            store.setDimensionsPhysicalSizeY(new Float(this.physicalSizes[i8][1]), i8, 0);
            store.setDimensionsPhysicalSizeZ(new Float(this.physicalSizes[i8][2]), i8, 0);
            if ((int)this.physicalSizes[i8][3] > 0) {
                store.setDimensionsWaveIncrement(new Integer((int)this.physicalSizes[i8][3]), i8, 0);
            }
            store.setDimensionsTimeIncrement(new Float(this.physicalSizes[i8][4]), i8, 0);
            Object[] keys = ifd.keySet().toArray();
            for (int q = 0; q < keys.length; ++q) {
                byte[] tmp;
                if (!keys[q].equals(FILTERSET) && !keys[q].equals(SCANNERSET) || (tmp = (byte[])ifd.get(keys[q])) == null) continue;
                RandomAccessInputStream stream = new RandomAccessInputStream(tmp);
                stream.order(this.isLittleEndian());
                this.parseInstrumentData(stream, store, i8);
                stream.close();
            }
            for (int j = 0; j < this.core[i8].imageCount; ++j) {
                if (timestamps[i8] == null || j >= timestamps[i8].length) continue;
                long time = DateTools.getTime(timestamps[i8][j], DATE_FORMAT);
                float elapsedTime = (float)(time - firstPlane) / 1000.0f;
                store.setPlaneTimingDeltaT(new Float(elapsedTime), i8, 0, j);
                store.setPlaneTimingExposureTime(new Float(this.exposureTime[i8]), i8, 0, j);
            }
        }
        this.setSeries(0);
    }

    /*
     * Unable to fully structure code
     */
    private void parseInstrumentData(RandomAccessInputStream stream, MetadataStore store, int series) throws IOException {
        this.setSeries(series);
        stream.skipBytes(4);
        cbElements = stream.readInt();
        stream.skipBytes(8);
        nElements = stream.readInt();
        stream.skipBytes(4);
        channelNames = new Vector[this.getSeriesCount()];
        emWaves = new Vector[this.getSeriesCount()];
        exWaves = new Vector[this.getSeriesCount()];
        for (i = 0; i < this.getSeriesCount(); ++i) {
            channelNames[i] = new Vector<E>();
            emWaves[i] = new Vector<E>();
            exWaves[i] = new Vector<E>();
        }
        for (j = 0; j < nElements; ++j) {
            stream.seek(24 + j * cbElements);
            contentID = this.getString(stream, 128);
            description = this.getString(stream, 64);
            data = this.getString(stream, 64);
            dataType = stream.readShort();
            stream.skipBytes(6);
            switch (dataType) {
                case 2: {
                    data = String.valueOf(stream.readShort());
                    break;
                }
                case 3: {
                    data = String.valueOf(stream.readInt());
                    break;
                }
                case 4: {
                    data = String.valueOf(stream.readFloat());
                    break;
                }
                case 5: {
                    data = String.valueOf(stream.readDouble());
                    break;
                }
                case 7: 
                case 11: {
                    data = stream.read() == 0 ? "false" : "true";
                    break;
                }
                case 17: {
                    data = stream.readString(1);
                }
            }
            tokens = contentID.split("\\|");
            if (tokens[0].startsWith("CDetectionUnit")) {
                if (tokens[1].startsWith("PMT")) {
                    try {
                        ndx = tokens[1].lastIndexOf(" ") + 1;
                        detector = Integer.parseInt(tokens[1].substring(ndx)) - 1;
                        store.setDetectorType("Unknown", 0, detector);
                        if (tokens[2].equals("VideoOffset")) {
                            store.setDetectorOffset(new Float(data), 0, detector);
                        }
                        if (tokens[2].equals("HighVoltage")) {
                            store.setDetectorVoltage(new Float(data), 0, detector);
                        }
                        if (!tokens[2].equals("State")) ** GOTO lbl155
                        detectorID = MetadataTools.createLSID("Detector", new int[]{0, detector});
                        store.setDetectorID(detectorID, 0, detector);
                        for (i = 0; i < this.getSeriesCount(); ++i) {
                            if (detector >= this.core[i].sizeC) continue;
                            store.setDetectorSettingsDetector(detectorID, i, detector);
                        }
                    }
                    catch (NumberFormatException e) {
                        this.traceDebug(e);
                    }
                }
            } else if (tokens[0].startsWith("CTurret")) {
                objective = Integer.parseInt(tokens[3]);
                if (tokens[2].equals("NumericalAperture")) {
                    store.setObjectiveLensNA(new Float(data), 0, objective);
                } else if (tokens[2].equals("Objective")) {
                    objectiveData = data.split(" ");
                    model = new StringBuffer();
                    mag = null;
                    na = null;
                    correction = new StringBuffer();
                    immersion = null;
                    for (i = 0; i < objectiveData.length; ++i) {
                        if (objectiveData[i].indexOf("x") != -1 && mag == null && na == null) {
                            xIndex = objectiveData[i].indexOf("x");
                            mag = objectiveData[i].substring(0, xIndex).trim();
                            na = objectiveData[i].substring(xIndex + 1).trim();
                            continue;
                        }
                        if (mag == null && na == null) {
                            model.append(objectiveData[i]);
                            model.append(" ");
                            continue;
                        }
                        if (immersion == null) {
                            immersion = objectiveData[i];
                            continue;
                        }
                        correction.append(objectiveData[i]);
                        correction.append(" ");
                    }
                    if (immersion == null || immersion.trim().equals("")) {
                        immersion = "Unknown";
                    }
                    store.setObjectiveImmersion(immersion, 0, objective);
                    store.setObjectiveCorrection(correction.toString().trim(), 0, objective);
                    store.setObjectiveModel(model.toString().trim(), 0, objective);
                    store.setObjectiveLensNA(new Float(na), 0, objective);
                    store.setObjectiveNominalMagnification(new Integer((int)Float.parseFloat(mag)), 0, objective);
                } else if (tokens[2].equals("OrderNumber")) {
                    store.setObjectiveSerialNumber(data, 0, objective);
                } else if (tokens[2].equals("RefractionIndex")) {
                    store.setObjectiveSettingsRefractiveIndex(new Float(data), series);
                }
                objectiveID = MetadataTools.createLSID("Objective", new int[]{0, objective});
                store.setObjectiveID(objectiveID, 0, objective);
                if (objective == 0) {
                    store.setObjectiveSettingsObjective(objectiveID, series);
                    store.setImageObjective(objectiveID, series);
                }
            } else if (tokens[0].startsWith("CSpectrophotometerUnit")) {
                ndx = tokens[1].lastIndexOf(" ") + 1;
                channel = Integer.parseInt(tokens[1].substring(ndx)) - 1;
                if (tokens[2].equals("Wavelength")) {
                    wavelength = new Integer((int)Float.parseFloat(data));
                    if (tokens[3].equals("0")) {
                        emWaves[series].add(wavelength);
                    } else if (tokens[3].equals("1")) {
                        exWaves[series].add(wavelength);
                    }
                } else if (tokens[2].equals("Stain")) {
                    channelNames[series].add(data);
                }
            } else if (tokens[0].startsWith("CXYZStage")) {
                if (tokens[2].equals("XPos")) {
                    for (q = 0; q < this.core[series].imageCount; ++q) {
                        store.setStagePositionPositionX(new Float(data), series, 0, q);
                    }
                } else if (tokens[2].equals("YPos")) {
                    for (q = 0; q < this.core[series].imageCount; ++q) {
                        store.setStagePositionPositionY(new Float(data), series, 0, q);
                    }
                } else if (tokens[2].equals("ZPos")) {
                    for (q = 0; q < this.core[series].imageCount; ++q) {
                        store.setStagePositionPositionZ(new Float(data), series, 0, q);
                    }
                }
            }
lbl155:
            // 16 sources

            if (contentID.equals("dblVoxelX")) {
                this.physicalSizes[series][0] = Float.parseFloat(data);
            } else if (contentID.equals("dblVoxelY")) {
                this.physicalSizes[series][1] = Float.parseFloat(data);
            } else if (contentID.equals("dblVoxelZ")) {
                this.physicalSizes[series][2] = Float.parseFloat(data);
            } else if (contentID.equals("dblPinhole")) {
                this.pinhole[series] = Float.parseFloat(data);
            } else if (contentID.equals("dblZoom")) {
                store.setDisplayOptionsZoom(new Float(data), series);
            } else if (contentID.startsWith("nDelayTime")) {
                this.exposureTime[series] = Float.parseFloat(data);
                if (contentID.endsWith("_ms")) {
                    v0 = series;
                    this.exposureTime[v0] = this.exposureTime[v0] / 1000.0f;
                }
            }
            this.addSeriesMeta(contentID, data);
        }
        stream.close();
        for (i = 0; i < this.getSeriesCount(); ++i) {
            nextChannel = 0;
            for (channel = 0; channel < this.getEffectiveSizeC() && channel < channelNames[i].size(); ++channel) {
                name = (String)channelNames[i].get(channel);
                if (name == null || name.trim().equals("")) continue;
                store.setLogicalChannelName(name, i, nextChannel);
                store.setLogicalChannelEmWave((Integer)emWaves[i].get(channel), i, nextChannel);
                store.setLogicalChannelExWave((Integer)exWaves[i].get(channel), i, nextChannel);
                store.setLogicalChannelPinholeSize(new Float(this.pinhole[i]), i, nextChannel);
                ++nextChannel;
            }
        }
        this.setSeries(0);
    }

    private boolean usedFile(String s) {
        if (this.files == null) {
            return false;
        }
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] == null) continue;
            for (int j = 0; j < this.files[i].size(); ++j) {
                if (!((String)this.files[i].get(j)).endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    private String getString(RandomAccessInputStream stream, int len) throws IOException {
        return DataTools.stripString(stream.readString(len));
    }

    private String getString(RandomAccessInputStream stream, boolean doubleLength) throws IOException {
        int len = stream.readInt();
        if (doubleLength) {
            len *= 2;
        }
        return this.getString(stream, len);
    }

    private static Hashtable makeDimensionTable() {
        Hashtable<Integer, String> table = new Hashtable<Integer, String>();
        table.put(new Integer(0), "undefined");
        table.put(new Integer(120), "x");
        table.put(new Integer(121), "y");
        table.put(new Integer(122), "z");
        table.put(new Integer(116), "t");
        table.put(new Integer(6815843), "channel");
        table.put(new Integer(6357100), "wave length");
        table.put(new Integer(7602290), "rotation");
        table.put(new Integer(0x770078), "x-wide for the motorized xy-stage");
        table.put(new Integer(0x770079), "y-wide for the motorized xy-stage");
        table.put(new Integer(0x77007A), "z-wide for the z-stage-drive");
        table.put(new Integer(4259957), "user1 - unspecified");
        table.put(new Integer(4325493), "user2 - unspecified");
        table.put(new Integer(4391029), "user3 - unspecified");
        table.put(new Integer(6357095), "graylevel");
        table.put(new Integer(6422631), "graylevel1");
        table.put(new Integer(6488167), "graylevel2");
        table.put(new Integer(6553703), "graylevel3");
        table.put(new Integer(7864398), "logical x");
        table.put(new Integer(7929934), "logical y");
        table.put(new Integer(7995470), "logical z");
        table.put(new Integer(7602254), "logical t");
        table.put(new Integer(7077966), "logical lambda");
        table.put(new Integer(7471182), "logical rotation");
        table.put(new Integer(5767246), "logical x-wide");
        table.put(new Integer(5832782), "logical y-wide");
        table.put(new Integer(5898318), "logical z-wide");
        return table;
    }
}

