/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIASReader
extends FormatReader {
    private String[][][] tiffs;
    private MinimalTiffReader[][][] readers;
    private String resultFile = null;
    private Vector<AnalysisFile> analysisFiles;
    private int[][] wellNumber;
    private int[][] plateAndWell;
    private int tileRows;
    private int tileCols;
    private int tileWidth;
    private int tileHeight;
    private int wellColumns;
    private int[] bpp;
    private Vector<String> plateDirs;
    private Vector<String> plateFiles;
    private byte[] cachedTileBuffer;

    public MIASReader() {
        super("MIAS", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(String filename, boolean open) {
        if (!open) {
            return super.isThisType(filename, open);
        }
        Location baseFile = new Location(filename).getAbsoluteFile();
        Location wellDir = baseFile.getParentFile();
        Location experiment = wellDir.getParentFile().getParentFile();
        if (wellDir == null || experiment == null) {
            return false;
        }
        String wellName = wellDir.getName();
        boolean validName = wellName.startsWith("Well") || wellName.length() == 1 && wellName.replaceAll("\\d", "").length() == 0;
        return validName && super.isThisType(filename, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object s = ifd.getIFDValue(305);
        if (s == null) {
            return false;
        }
        String software = null;
        software = s instanceof String[] ? ((String[])s)[0] : s.toString();
        return software.startsWith("eaZYX") || software.startsWith("SCIL_Image");
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.readers == null || this.readers[0][0][0].getCurrentFile() == null) {
            return null;
        }
        return this.readers[0][0][0].get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.readers == null || this.readers[0][0][0].getCurrentFile() == null) {
            return null;
        }
        return this.readers[0][0][0].get16BitLookupTable();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int well = this.getWellNumber(this.getSeries());
        int plate = this.getPlateNumber(this.getSeries());
        if (this.tileRows == 1 && this.tileCols == 1) {
            this.readers[plate][well][no].setId(this.tiffs[plate][well][no]);
            this.readers[plate][well][no].openBytes(0, buf, x, y, w, h);
            return buf;
        }
        int outputRowLen = w * this.bpp[this.getSeries()];
        Region image = new Region(x, y, w, h);
        int outputRow = 0;
        int outputCol = 0;
        Region intersection = null;
        byte[] tileBuf = null;
        for (int row = 0; row < this.tileRows; ++row) {
            for (int col = 0; col < this.tileCols; ++col) {
                Region tile = new Region(col * this.tileWidth, row * this.tileHeight, this.tileWidth, this.tileHeight);
                if (!tile.intersects(image)) continue;
                intersection = tile.intersection(image);
                int tileIndex = (no * this.tileRows + row) * this.tileCols + col;
                tileBuf = this.getTile(plate, well, no, row, col, intersection);
                int rowLen = tileBuf.length / intersection.height;
                int outputOffset = outputRow * outputRowLen + outputCol;
                for (int trow = 0; trow < intersection.height; ++trow) {
                    System.arraycopy(tileBuf, trow * rowLen, buf, outputOffset, rowLen);
                    outputOffset += outputRowLen;
                }
                outputCol += rowLen;
            }
            if (intersection == null) continue;
            outputRow += intersection.height;
            outputCol = 0;
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        int well = this.getWellNumber(this.getSeries());
        int plate = this.getPlateNumber(this.getSeries());
        if (!noPixels) {
            files.addAll(Arrays.asList(this.tiffs[plate][well]));
        }
        for (AnalysisFile file2 : this.analysisFiles) {
            if (file2.plate != plate && file2.plate >= 0 || file2.well != well && file2.well >= 0) continue;
            files.add(file2.filename);
        }
        if (this.plateFiles != null && plate < this.plateFiles.size()) {
            files.add(this.plateFiles.get(plate));
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.readers != null) {
            MinimalTiffReader[][][] arr$ = this.readers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                MinimalTiffReader[][] wells;
                MinimalTiffReader[][] arr$2 = wells = arr$[i$];
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    MinimalTiffReader[] images;
                    for (MinimalTiffReader r : images = arr$2[i$2]) {
                        if (r == null) continue;
                        r.close(fileOnly);
                    }
                }
            }
        }
        if (!fileOnly) {
            this.readers = null;
            this.tiffs = null;
            this.tileCols = 0;
            this.tileRows = 0;
            this.resultFile = null;
            this.analysisFiles = null;
            this.wellNumber = null;
            this.tileHeight = 0;
            this.tileWidth = 0;
            this.plateDirs = null;
            this.wellColumns = 0;
            this.bpp = null;
            this.plateAndWell = null;
            this.plateFiles = null;
            this.cachedTileBuffer = null;
        }
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("MIASReader.initFile(" + id + ")");
        super.initFile(id);
        this.plateDirs = new Vector();
        this.plateFiles = new Vector();
        this.analysisFiles = new Vector();
        this.status("Building list of TIFF files");
        Location baseFile = new Location(id).getAbsoluteFile();
        Location experiment = baseFile.getParentFile().getParentFile().getParentFile();
        String experimentName = experiment.getName();
        if (experimentName.length() == 3 || experimentName.length() > 3 && experimentName.replaceAll("\\d", "").startsWith("-")) {
            experiment = experiment.getParentFile();
            experimentName = experiment.getName();
        }
        Object[] directories = experiment.list(true);
        Arrays.sort(directories);
        for (Object dir : directories) {
            Location f = new Location(experiment, (String)dir);
            if (((String)dir).equals("Batchresults")) {
                String[] results;
                for (String result : results = f.list(true)) {
                    Location file2 = new Location(f, result);
                    if (result.startsWith("NEO_Results")) {
                        this.resultFile = file2.getAbsolutePath();
                        AnalysisFile af = new AnalysisFile();
                        af.filename = this.resultFile;
                        this.analysisFiles.add(af);
                        continue;
                    }
                    if (!result.startsWith("NEO_PlateOutput_")) continue;
                    String plateIndex = result.substring(16, 19);
                    AnalysisFile af = new AnalysisFile();
                    af.filename = file2.getAbsolutePath();
                    af.plate = Integer.parseInt(plateIndex) - 1;
                    this.analysisFiles.add(af);
                }
                continue;
            }
            if (!f.isDirectory()) continue;
            this.plateDirs.add((String)dir);
        }
        int nPlates = this.plateDirs.size();
        this.tiffs = new String[nPlates][][];
        this.readers = new MinimalTiffReader[nPlates][][];
        int[][] zCount = new int[nPlates][];
        int[][] cCount = new int[nPlates][];
        int[][] tCount = new int[nPlates][];
        String[][] order = new String[nPlates][];
        this.wellNumber = new int[nPlates][];
        for (int i2 = 0; i2 < nPlates; ++i2) {
            String plate = this.plateDirs.get(i2);
            Location plateDir = new Location(experiment, plate);
            Object[] list = plateDir.list(true);
            Arrays.sort(list);
            Vector<String> wellDirectories = new Vector<String>();
            for (Object dir : list) {
                Location f = new Location(plateDir, (String)dir);
                if (f.getName().startsWith("Well") || f.getName().length() == 4) {
                    wellDirectories.add(f.getAbsolutePath());
                    continue;
                }
                if (f.getName().equals("results")) {
                    String[] resultsList;
                    for (String result : resultsList = f.list(true)) {
                        if (result.endsWith(".sav") || result.endsWith(".dsv")) continue;
                        Location r = new Location(f, result);
                        AnalysisFile af = new AnalysisFile();
                        af.filename = r.getAbsolutePath();
                        af.plate = i2;
                        if (result.toLowerCase().startsWith("well")) {
                            af.well = Integer.parseInt(result.substring(4, 8)) - 1;
                        }
                        this.analysisFiles.add(af);
                    }
                    continue;
                }
                if (!f.getName().equals("Nugenesistemplate.txt")) continue;
                this.plateFiles.add(f.getAbsolutePath());
            }
            this.readers[i2] = new MinimalTiffReader[wellDirectories.size()][];
            this.tiffs[i2] = new String[wellDirectories.size()][];
            zCount[i2] = new int[wellDirectories.size()];
            cCount[i2] = new int[wellDirectories.size()];
            tCount[i2] = new int[wellDirectories.size()];
            order[i2] = new String[wellDirectories.size()];
            this.wellNumber[i2] = new int[wellDirectories.size()];
            for (int j = 0; j < wellDirectories.size(); ++j) {
                Location well = new Location((String)wellDirectories.get(j));
                String wellName = well.getName().replaceAll("Well", "");
                this.wellNumber[i2][j] = Integer.parseInt(wellName) - 1;
                Object[] tiffFiles = well.list(true);
                Vector<String> tmpFiles = new Vector<String>();
                for (String tiff : tiffFiles) {
                    String name = tiff.toLowerCase();
                    if (!name.endsWith(".tif") && !name.endsWith(".tiff")) continue;
                    tmpFiles.add(new Location(well, tiff).getAbsolutePath());
                }
                if (tmpFiles.size() == 0) {
                    this.debug("No TIFFs in well directory " + (String)wellDirectories.get(j));
                    for (String dir : tiffFiles) {
                        String[] tiffs;
                        Location file3 = new Location(well, dir);
                        if (dir.length() != 1 || !file3.isDirectory()) continue;
                        int[] nArray = cCount[i2];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                        for (String tiff : tiffs = file3.list()) {
                            String name = tiff.toLowerCase();
                            if (!name.endsWith(".tif") && !name.endsWith(".tiff")) continue;
                            tmpFiles.add(new Location(file3, tiff).getAbsolutePath());
                        }
                    }
                }
                tiffFiles = tmpFiles.toArray(new String[0]);
                Location firstTiff = new Location(tiffFiles[0]);
                FilePattern fp = new FilePattern(firstTiff.getName(), firstTiff.getParentFile().getAbsolutePath());
                String[] blocks = fp.getPrefixes();
                BigInteger[] firstNumber = fp.getFirst();
                BigInteger[] lastNumber = fp.getLast();
                BigInteger[] step = fp.getStep();
                order[i2][j] = "XY";
                for (int block = blocks.length - 1; block >= 0; --block) {
                    blocks[block] = blocks[block].toLowerCase();
                    blocks[block] = blocks[block].substring(blocks[block].lastIndexOf("_") + 1);
                    BigInteger tmp = lastNumber[block].subtract(firstNumber[block]);
                    tmp = tmp.add(BigInteger.ONE).divide(step[block]);
                    int count = tmp.intValue();
                    if (blocks[block].equals("z")) {
                        zCount[i2][j] = count;
                        String[] stringArray = order[i2];
                        int n = j;
                        stringArray[n] = stringArray[n] + "Z";
                        continue;
                    }
                    if (blocks[block].equals("t")) {
                        tCount[i2][j] = count;
                        String[] stringArray = order[i2];
                        int n = j;
                        stringArray[n] = stringArray[n] + "T";
                        continue;
                    }
                    if (blocks[block].equals("mode")) {
                        cCount[i2][j] = count;
                        String[] stringArray = order[i2];
                        int n = j;
                        stringArray[n] = stringArray[n] + "C";
                        continue;
                    }
                    if (blocks[block].equals("im")) {
                        this.tileRows = count;
                        continue;
                    }
                    if (blocks[block].equals("")) {
                        this.tileCols = count;
                        continue;
                    }
                    if (blocks[block].replaceAll("\\d", "").length() == 0) {
                        if (block == 3) {
                            this.tileRows = count;
                            continue;
                        }
                        if (block == 2) {
                            this.tileCols = count;
                            continue;
                        }
                        if (block == 1) {
                            zCount[i2][j] = count;
                            String[] stringArray = order[i2];
                            int n = j;
                            stringArray[n] = stringArray[n] + "Z";
                            continue;
                        }
                        if (block != 0) continue;
                        tCount[i2][j] = count;
                        String[] stringArray = order[i2];
                        int n = j;
                        stringArray[n] = stringArray[n] + "T";
                        continue;
                    }
                    throw new FormatException("Unsupported block '" + blocks[block]);
                }
                Arrays.sort(tiffFiles);
                this.tiffs[i2][j] = tiffFiles;
                this.readers[i2][j] = new MinimalTiffReader[tiffFiles.length];
                for (int k = 0; k < tiffFiles.length; ++k) {
                    this.readers[i2][j][k] = new MinimalTiffReader();
                }
            }
        }
        this.status("Populating core metadata");
        int nSeries = 0;
        for (i = 0; i < this.tiffs.length; ++i) {
            nSeries += this.tiffs[i].length;
        }
        this.core = new CoreMetadata[nSeries];
        this.bpp = new int[nSeries];
        this.plateAndWell = new int[nSeries][2];
        this.readers[0][0][0].setId(this.tiffs[0][0][0]);
        this.tileWidth = this.readers[0][0][0].getSizeX();
        this.tileHeight = this.readers[0][0][0].getSizeY();
        if (this.tileCols == 0) {
            this.tileCols = 1;
        }
        if (this.tileRows == 0) {
            this.tileRows = 1;
        }
        for (i = 0; i < this.core.length; ++i) {
            Arrays.fill(this.plateAndWell[i], -1);
            this.core[i] = new CoreMetadata();
            int plate = this.getPlateNumber(i);
            int well = this.getWellNumber(i);
            this.core[i].sizeZ = zCount[plate][well];
            this.core[i].sizeC = cCount[plate][well];
            this.core[i].sizeT = tCount[plate][well];
            if (this.core[i].sizeZ == 0) {
                this.core[i].sizeZ = 1;
            }
            if (this.core[i].sizeC == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.core[i].sizeT == 0) {
                this.core[i].sizeT = 1;
            }
            this.core[i].sizeX = this.tileWidth * this.tileCols;
            this.core[i].sizeY = this.tileHeight * this.tileRows;
            this.core[i].pixelType = this.readers[0][0][0].getPixelType();
            this.core[i].sizeC *= this.readers[0][0][0].getSizeC();
            this.core[i].rgb = this.readers[0][0][0].isRGB();
            this.core[i].littleEndian = this.readers[0][0][0].isLittleEndian();
            this.core[i].interleaved = this.readers[0][0][0].isInterleaved();
            this.core[i].indexed = this.readers[0][0][0].isIndexed();
            this.core[i].falseColor = this.readers[0][0][0].isFalseColor();
            this.core[i].dimensionOrder = order[plate][well];
            if (this.core[i].dimensionOrder.indexOf("Z") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "Z";
            }
            if (this.core[i].dimensionOrder.indexOf("C") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "C";
            }
            if (this.core[i].dimensionOrder.indexOf("T") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "T";
            }
            this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeT * cCount[plate][well];
            if (this.core[i].imageCount == 0) {
                this.core[i].imageCount = 1;
            }
            this.bpp[i] = FormatTools.getBytesPerPixel(this.core[i].pixelType);
        }
        this.status("Populating metadata hashtable");
        this.wellColumns = 1;
        if (this.resultFile != null) {
            String[] lines;
            RandomAccessInputStream s = new RandomAccessInputStream(this.resultFile);
            String[] cols = null;
            Vector<String> rows = new Vector<String>();
            boolean doKeyValue = true;
            int nStarLines = 0;
            String analysisResults = s.readString((int)s.length());
            s.close();
            for (String line : lines = analysisResults.split("\n")) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("******") && line.endsWith("******")) {
                    ++nStarLines;
                }
                if (doKeyValue) {
                    String[] n = line.split("\t");
                    if (n[0].endsWith(":")) {
                        n[0] = n[0].substring(0, n[0].length() - 1);
                    }
                    if (n.length >= 2) {
                        this.addGlobalMeta(n[0], n[1]);
                    }
                } else if (cols == null) {
                    cols = line.split("\t");
                } else {
                    rows.add(line);
                }
                if (nStarLines != 2) continue;
                doKeyValue = false;
            }
            for (String row : rows) {
                String[] d = row.split("\t");
                for (int col = 3; col < cols.length; ++col) {
                    this.addGlobalMeta("Plate " + d[0] + ", Well " + d[2] + " " + cols[col], d[col]);
                    if (!cols[col].equals("AreaCode")) continue;
                    String wellID = d[col].replaceAll("\\D", "");
                    this.wellColumns = Integer.parseInt(wellID);
                }
            }
        }
        this.status("Populating MetadataStore");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setExperimentID("Experiment:" + experimentName, 0);
        store.setExperimentType("Other", 0);
        for (int plate = 0; plate < this.tiffs.length; ++plate) {
            store.setPlateColumnNamingConvention("1", plate);
            store.setPlateRowNamingConvention("A", plate);
            this.parseTemplateFile(store, plate);
            String plateDir = this.plateDirs.get(plate);
            plateDir = plateDir.substring(plateDir.indexOf("-") + 1);
            store.setPlateName(plateDir, plate);
            store.setPlateExternalIdentifier(plateDir, plate);
            int nWells = this.tiffs[plate].length;
            if (this.wellColumns == 0) {
                if (nWells == 96) {
                    this.wellColumns = 12;
                } else if (nWells == 384) {
                    this.wellColumns = 24;
                } else {
                    this.warn("Could not determine the plate dimensions.");
                    this.wellColumns = 24;
                }
            }
            for (int well = 0; well < nWells; ++well) {
                int wellIndex = this.wellNumber[plate][well];
                int row = wellIndex / this.wellColumns;
                int wellCol = well % this.wellColumns + 1;
                store.setWellRow(new Integer(row), plate, wellIndex);
                store.setWellColumn(new Integer(wellCol), plate, wellIndex);
                int series = this.getSeriesNumber(plate, well);
                String imageID = MetadataTools.createLSID("Image", series);
                store.setWellSampleImageRef(imageID, plate, wellIndex, 0);
                store.setWellSampleIndex(new Integer(series), plate, wellIndex, 0);
                store.setImageExperimentRef("Experiment:" + experimentName, series);
                char wellRow = (char)(65 + row);
                store.setImageID(imageID, series);
                store.setImageName("Plate #" + plate + ", Well " + wellRow + wellCol, series);
                String instrumentID = MetadataTools.createLSID("Instrument", series);
                store.setInstrumentID(instrumentID, series);
                store.setImageInstrumentRef(instrumentID, series);
                MetadataTools.setDefaultCreationDate(store, id, series);
            }
        }
        String[] colors = new String[this.getSizeC()];
        for (AnalysisFile af : this.analysisFiles) {
            String file4 = af.filename;
            String name = new Location(file4).getName();
            if (!name.startsWith("Well")) continue;
            int[] position = this.getPositionFromFile(file4);
            int series = this.getSeriesNumber(position[0], position[1]);
            if (name.endsWith("detail.txt")) {
                int start;
                RandomAccessInputStream s = new RandomAccessInputStream(file4);
                String data = s.readString((int)s.length());
                String[] lines = data.split("\n");
                for (start = 0; start < lines.length && !lines[start].startsWith("Label"); ++start) {
                }
                if (start >= lines.length) continue;
                String[] columns = lines[start].split("\t");
                Vector<String> columnNames = new Vector<String>();
                for (String v : columns) {
                    columnNames.add(v);
                }
                for (int j = start + 1; j < lines.length; ++j) {
                    this.populateROI(columnNames, lines[j].split("\t"), series, j - start - 1, position[2], position[3], store);
                }
                s.close();
                continue;
            }
            if (!name.endsWith("AllModesOverlay.tif") || colors[position[4]] != null) continue;
            try {
                colors[position[4]] = this.getChannelColorFromFile(file4);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (colors[position[4]] == null) continue;
            for (int s = 0; s < this.getSeriesCount(); ++s) {
                store.setChannelComponentColorDomain(colors[position[4]], s, position[4], 0);
            }
        }
    }

    private String getChannelColorFromFile(String file2) throws FormatException, IOException {
        RandomAccessInputStream s = new RandomAccessInputStream(file2);
        TiffParser tp = new TiffParser(s);
        IFD ifd = tp.getFirstIFD();
        s.close();
        int[] colorMap = ifd.getIFDIntArray(320, false);
        if (colorMap == null) {
            return null;
        }
        int[] position = this.getPositionFromFile(file2);
        int nEntries = colorMap.length / 3;
        int max = Integer.MIN_VALUE;
        int maxIndex = -1;
        for (int c = 0; c < 3; ++c) {
            int v = colorMap[c * nEntries] >> 8 & 0xFF;
            if (v > max) {
                max = v;
                maxIndex = c;
                continue;
            }
            if (v != max) continue;
            return "gray";
        }
        switch (maxIndex) {
            case 0: {
                return "R";
            }
            case 1: {
                return "G";
            }
            case 2: {
                return "B";
            }
        }
        return null;
    }

    private int[] getPositionFromFile(String file2) {
        int[] position = new int[5];
        Location plate = new Location(file2).getParentFile().getParentFile();
        if (file2.endsWith(".tif")) {
            plate = plate.getParentFile();
        }
        String plateName = plate.getName();
        position[0] = this.plateDirs.indexOf(plateName);
        file2 = file2.substring(file2.lastIndexOf(File.separator) + 1);
        String wellIndex = file2.substring(4, file2.indexOf("_"));
        position[1] = Integer.parseInt(wellIndex) - 1;
        int tIndex = file2.indexOf("_t") + 2;
        String t = file2.substring(tIndex, file2.indexOf("_", tIndex));
        position[2] = Integer.parseInt(t);
        int zIndex = file2.indexOf("_z") + 2;
        String zValue = file2.substring(zIndex, file2.indexOf("_", zIndex));
        position[3] = Integer.parseInt(zValue);
        int cIndex = file2.indexOf("mode") + 4;
        String cValue = file2.substring(cIndex, file2.indexOf("_", cIndex));
        position[4] = Integer.parseInt(cValue) - 1;
        return position;
    }

    private void populateROI(Vector<String> columns, String[] data, int series, int roi, int time, int z, MetadataStore store) {
        float cx = Float.parseFloat(data[columns.indexOf("Col")]);
        float cy = Float.parseFloat(data[columns.indexOf("Row")]);
        Integer tv = new Integer(time);
        Integer zv = new Integer(z);
        store.setROIT0(tv, series, roi);
        store.setROIT1(tv, series, roi);
        store.setROIZ0(zv, series, roi);
        store.setROIZ1(zv, series, roi);
        store.setShapeText(data[columns.indexOf("Label")], series, roi, 0);
        store.setShapeTheT(tv, series, roi, 0);
        store.setShapeTheZ(zv, series, roi, 0);
        store.setCircleCx(data[columns.indexOf("Col")], series, roi, 0);
        store.setCircleCy(data[columns.indexOf("Row")], series, roi, 0);
        float diam = Float.parseFloat(data[columns.indexOf("Cell Diam.")]);
        String radius = String.valueOf(diam / 2.0f);
        store.setCircleR(radius, series, roi, 0);
    }

    private int getSeriesNumber(int plate, int well) {
        int series = 0;
        for (int i = 0; i < plate; ++i) {
            series += this.tiffs[i].length;
        }
        return series + well;
    }

    private int getWellNumber(int series) {
        if (this.plateAndWell[series][1] == -1) {
            this.plateAndWell[series] = this.getPlateAndWell(series);
        }
        return this.plateAndWell[series][1];
    }

    private int getPlateNumber(int series) {
        if (this.plateAndWell[series][0] == -1) {
            this.plateAndWell[series] = this.getPlateAndWell(series);
        }
        return this.plateAndWell[series][0];
    }

    private int[] getPlateAndWell(int series) {
        int wellNumber = series;
        int plateNumber = 0;
        while (wellNumber >= this.tiffs[plateNumber].length) {
            wellNumber -= this.tiffs[plateNumber].length;
            ++plateNumber;
        }
        return new int[]{plateNumber, wellNumber};
    }

    private byte[] getTile(int plate, int well, int no, int row, int col, Region intersection) throws FormatException, IOException {
        intersection.x %= this.tileWidth;
        intersection.y %= this.tileHeight;
        int tileIndex = (no * this.tileRows + row) * this.tileCols + col;
        this.readers[plate][well][tileIndex].setId(this.tiffs[plate][well][tileIndex]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int ch = this.getRGBChannelCount();
        int bufferSize = intersection.width * intersection.height * ch * bpp;
        if (this.cachedTileBuffer == null || this.cachedTileBuffer.length != bufferSize) {
            this.cachedTileBuffer = new byte[bufferSize];
        }
        byte[] buf = this.readers[plate][well][tileIndex].openBytes(0, this.cachedTileBuffer, intersection.x, intersection.y, intersection.width, intersection.height);
        return buf;
    }

    private void parseTemplateFile(MetadataStore store, int plate) throws IOException {
        String[] lines;
        if (plate >= this.plateFiles.size()) {
            return;
        }
        Float physicalSizeX = null;
        Float physicalSizeY = null;
        Float exposure = null;
        Vector<String> channelNames = new Vector<String>();
        String date = null;
        String templateFile = this.plateFiles.get(plate);
        RandomAccessInputStream s = new RandomAccessInputStream(templateFile);
        for (String line : lines = s.readString((int)s.length()).split("\r\n")) {
            int eq = line.indexOf("=");
            if (eq == -1) continue;
            String key = line.substring(0, eq);
            String value = line.substring(eq + 1);
            if (key.equals("Barcode")) {
                store.setPlateExternalIdentifier(value, plate);
                continue;
            }
            if (key.equals("Carrier")) {
                store.setPlateName(value, plate);
                continue;
            }
            if (key.equals("Pixel_X")) {
                physicalSizeX = new Float(value);
                continue;
            }
            if (key.equals("Pixel_Y")) {
                physicalSizeY = new Float(value);
                continue;
            }
            if (key.equals("Objective_ID")) {
                store.setObjectiveModel(value, plate, 0);
                continue;
            }
            if (key.equals("Magnification")) {
                store.setObjectiveNominalMagnification(new Integer(value), plate, 0);
                continue;
            }
            if (key.startsWith("Mode_")) {
                channelNames.add(value);
                continue;
            }
            if (key.equals("Date")) {
                date = value;
                continue;
            }
            if (key.equals("Time")) {
                date = date + " " + value;
                continue;
            }
            if (!key.equals("Exposure")) continue;
            exposure = new Float(value);
        }
        for (int well = 0; well < this.tiffs[plate].length; ++well) {
            int series = this.getSeriesNumber(plate, well);
            if (physicalSizeX != null) {
                store.setDimensionsPhysicalSizeX(physicalSizeX, series, 0);
            }
            if (physicalSizeY != null) {
                store.setDimensionsPhysicalSizeY(physicalSizeY, series, 0);
            }
            for (int c = 0; c < channelNames.size(); ++c) {
                if (c >= this.getEffectiveSizeC()) continue;
                store.setLogicalChannelName((String)channelNames.get(c), series, c);
            }
            date = DateTools.formatDate(date, "dd/MM/yyyy HH:mm:ss");
            store.setImageCreationDate(date, series);
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneTimingExposureTime(exposure, series, 0, i);
            }
        }
    }

    class AnalysisFile {
        public String filename;
        public int plate = -1;
        public int well = -1;

        AnalysisFile() {
        }
    }
}

