/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class NRRDReader
extends FormatReader {
    public static final String NRRD_MAGIC_STRING = "NRRD";
    private ImageReader helper;
    private String dataFile;
    private String encoding;
    private long offset;
    private String[] pixelSizes;

    public NRRDReader() {
        super(NRRD_MAGIC_STRING, new String[]{"nrrd", "nhdr"});
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = NRRD_MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).startsWith(NRRD_MAGIC_STRING);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            if (this.dataFile == null) {
                return null;
            }
            return new String[]{this.currentId};
        }
        if (this.dataFile == null) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.dataFile};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.dataFile == null) {
            if (this.encoding.equals("raw")) {
                this.in.seek(this.offset + (long)(no * FormatTools.getPlaneSize(this)));
                this.readPlane(this.in, x, y, w, h, buf);
                return buf;
            }
            throw new FormatException("Unsupported encoding: " + this.encoding);
        }
        return this.helper.openBytes(no, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.helper != null) {
            this.helper.close(fileOnly);
        }
        if (!fileOnly) {
            this.helper = null;
            this.encoding = null;
            this.dataFile = null;
            this.offset = 0L;
            this.pixelSizes = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.helper = new ImageReader();
        boolean finished = false;
        int numDimensions = 0;
        this.core[0].sizeX = 1;
        this.core[0].sizeY = 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCZT";
        while (!finished) {
            String line = this.in.readLine().trim();
            if (!line.startsWith("#") && line.length() > 0 && !line.startsWith(NRRD_MAGIC_STRING)) {
                String key = line.substring(0, line.indexOf(":")).trim();
                String v = line.substring(line.indexOf(":") + 1).trim();
                this.addGlobalMeta(key, v);
                if (key.equals("type")) {
                    if (v.indexOf("char") != -1 || v.indexOf("8") != -1) {
                        this.core[0].pixelType = 1;
                    } else if (v.indexOf("short") != -1 || v.indexOf("16") != -1) {
                        this.core[0].pixelType = 3;
                    } else if (v.equals("int") || v.equals("signed int") || v.equals("int32") || v.equals("int32_t") || v.equals("uint") || v.equals("unsigned int") || v.equals("uint32") || v.equals("uint32_t")) {
                        this.core[0].pixelType = 5;
                    } else if (v.equals("float")) {
                        this.core[0].pixelType = 6;
                    } else {
                        if (!v.equals("double")) throw new FormatException("Unsupported data type: " + v);
                        this.core[0].pixelType = 7;
                    }
                } else if (key.equals("dimension")) {
                    numDimensions = Integer.parseInt(v);
                } else if (key.equals("sizes")) {
                    StringTokenizer tokens = new StringTokenizer(v, " ");
                    for (i = 0; i < numDimensions; ++i) {
                        String t = tokens.nextToken();
                        int size = Integer.parseInt(t);
                        if (numDimensions >= 3 && i == 0 && size > 1 && size <= 4) {
                            this.core[0].sizeC = size;
                            continue;
                        }
                        if (i == 0 || this.getSizeC() > 1 && i == 1) {
                            this.core[0].sizeX = size;
                            continue;
                        }
                        if (i == 1 || this.getSizeC() > 1 && i == 2) {
                            this.core[0].sizeY = size;
                            continue;
                        }
                        if (i == 2 || this.getSizeC() > 1 && i == 3) {
                            this.core[0].sizeZ = size;
                            continue;
                        }
                        if (i != 3 && (this.getSizeC() <= 1 || i != 4)) continue;
                        this.core[0].sizeT = size;
                    }
                } else if (key.equals("data file") || key.equals("datafile")) {
                    this.dataFile = v;
                } else if (key.equals("encoding")) {
                    this.encoding = v;
                } else if (key.equals("endian")) {
                    this.core[0].littleEndian = v.equals("little");
                } else if (key.equals("spacings")) {
                    this.pixelSizes = v.split(" ");
                }
            }
            if (line.length() == 0 && this.dataFile == null || line == null) {
                finished = true;
            }
            if (this.dataFile == null || this.in.length() - this.in.getFilePointer() >= 2L) continue;
            finished = true;
        }
        if (this.dataFile == null) {
            this.offset = this.in.getFilePointer();
        } else {
            File f = new File(this.currentId);
            if (f.exists() && f.getParentFile() != null) {
                this.dataFile = f.getParentFile().getAbsolutePath() + File.separator + this.dataFile;
            }
            this.helper.setId(this.dataFile);
        }
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = true;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        for (i = 0; i < this.pixelSizes.length; ++i) {
            Float f = new Float(this.pixelSizes[i].trim());
            if (i == 0) {
                store.setDimensionsPhysicalSizeX(f, 0, 0);
                continue;
            }
            if (i == 1) {
                store.setDimensionsPhysicalSizeY(f, 0, 0);
                continue;
            }
            if (i != 2) continue;
            store.setDimensionsPhysicalSizeZ(f, 0, 0);
        }
    }
}

