/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.ByteVector;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.FilterMetadata;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class NativeND2Reader
extends FormatReader {
    public static final long ND2_MAGIC_BYTES_1 = -623985142L;
    public static final long ND2_MAGIC_BYTES_2 = 1783636000L;
    private long[][] offsets;
    private boolean isJPEG;
    private boolean isLossless;
    private Vector<Long> zs = new Vector();
    private Vector<Long> ts = new Vector();
    private Vector<Double> tsT = new Vector();
    private int numSeries;
    private float pixelSizeX;
    private float pixelSizeY;
    private float pixelSizeZ;
    private String voltage;
    private String mag;
    private String na;
    private String objectiveModel;
    private String immersion;
    private String correction;
    private Vector<String> channelNames;
    private Vector<String> modality;
    private Vector<String> binning;
    private Vector<Float> speed;
    private Vector<Float> gain;
    private Vector<Float> temperature;
    private Vector<Float> exposureTime;
    private Vector<Integer> exWave;
    private Vector<Integer> emWave;
    private Vector<Integer> power;
    private Vector<Hashtable<String, String>> rois;
    private String cameraModel;
    private int fieldIndex;

    public NativeND2Reader() {
        super("Nikon ND2", new String[]{"nd2", "jp2"});
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        long magic1 = stream.readInt() & 0xFFFFFFFF;
        long magic2 = stream.readInt() & 0xFFFFFFFF;
        return magic1 == -623985142L || magic2 == 1783636000L;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.offsets[this.series][no]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bpp * this.getRGBChannelCount();
        long maxFP = no == this.getImageCount() - 1 ? this.in.length() : this.offsets[this.series][no + 1];
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        options.maxBytes = (int)maxFP;
        if (this.isJPEG) {
            byte[] tmp = new JPEG2000Codec().decompress(this.in, options);
            for (int row = y; row < h + y; ++row) {
                System.arraycopy(tmp, pixel * row * this.getSizeX(), buf, pixel * w * (row - y), pixel * w);
            }
            System.arraycopy(tmp, 0, buf, 0, Math.min(tmp.length, buf.length));
            tmp = null;
        } else if (this.isLossless) {
            int effectiveX = this.getSizeX();
            if (this.getSizeX() % 2 != 0) {
                ++effectiveX;
            }
            byte[] t = new ZlibCodec().decompress(this.in, options);
            for (int row = 0; row < h; ++row) {
                int offset = (row + y) * effectiveX * pixel + x * pixel;
                if (offset + w * pixel > t.length) continue;
                System.arraycopy(t, offset, buf, row * w * pixel, w * pixel);
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.zs.clear();
            this.ts.clear();
            this.isLossless = false;
            this.isJPEG = false;
            this.numSeries = 0;
            this.tsT.clear();
            this.pixelSizeZ = 0.0f;
            this.pixelSizeY = 0.0f;
            this.pixelSizeX = 0.0f;
            this.correction = null;
            this.immersion = null;
            this.objectiveModel = null;
            this.na = null;
            this.mag = null;
            this.voltage = null;
            this.channelNames = null;
            this.binning = null;
            this.speed = null;
            this.gain = null;
            this.temperature = null;
            this.exposureTime = null;
            this.modality = null;
            this.exWave = null;
            this.emWave = null;
            this.power = null;
            this.cameraModel = null;
            this.fieldIndex = 0;
            this.rois = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int numBands;
        super.initFile(id);
        this.channelNames = new Vector();
        this.binning = new Vector();
        this.speed = new Vector();
        this.gain = new Vector();
        this.temperature = new Vector();
        this.exposureTime = new Vector();
        this.modality = new Vector();
        this.exWave = new Vector();
        this.emWave = new Vector();
        this.power = new Vector();
        this.rois = new Vector();
        this.in = new RandomAccessInputStream(id);
        if (this.in.read() == -38 && this.in.read() == -50) {
            int i2;
            int i3;
            int i4;
            this.isJPEG = false;
            this.in.seek(0L);
            this.in.order(true);
            Vector<Long> imageOffsets = new Vector<Long>();
            Vector<int[]> imageLengths = new Vector<int[]>();
            Vector<Long> xmlOffsets = new Vector<Long>();
            Vector<int[]> xmlLengths = new Vector<int[]>();
            Vector<Long> customDataOffsets = new Vector<Long>();
            Vector<int[]> customDataLengths = new Vector<int[]>();
            while (this.in.getFilePointer() < this.in.length() - 1L && this.in.getFilePointer() >= 0L) {
                int b1 = this.in.read();
                int b2 = this.in.read();
                int b3 = this.in.read();
                int b4 = this.in.read();
                while ((b1 != -38 || b2 != -50 || b3 != -66 || b4 != 10) && this.in.getFilePointer() < this.in.length() - 1L) {
                    b1 = b2;
                    b2 = b3;
                    b3 = b4;
                    b4 = this.in.read();
                }
                if (this.in.getFilePointer() >= this.in.length() - 1L) break;
                int lenOne = this.in.readInt();
                int lenTwo = this.in.readInt();
                int len = lenOne + lenTwo;
                this.in.skipBytes(4);
                String blockType = this.in.readString(12);
                long fp = this.in.getFilePointer() - 12L;
                int skip = len - 12 - lenOne * 2;
                if (skip <= 0) {
                    skip += lenOne * 2;
                }
                this.in.skipBytes(skip);
                if (blockType.startsWith("ImageDataSeq")) {
                    imageOffsets.add(new Long(fp));
                    imageLengths.add(new int[]{lenOne, lenTwo});
                    continue;
                }
                if (blockType.startsWith("Image")) {
                    xmlOffsets.add(new Long(fp));
                    xmlLengths.add(new int[]{lenOne, lenTwo});
                    continue;
                }
                if (!blockType.startsWith("CustomData|A")) continue;
                customDataOffsets.add(new Long(fp));
                customDataLengths.add(new int[]{lenOne, lenTwo});
            }
            ND2Handler handler = new ND2Handler();
            ByteVector xml = new ByteVector();
            for (int i5 = 0; i5 < xmlOffsets.size(); ++i5) {
                long offset = (Long)xmlOffsets.get(i5);
                int[] p = (int[])xmlLengths.get(i5);
                int length = p[0] + p[1];
                byte[] b = new byte[length];
                this.in.seek(offset);
                this.in.read(b);
                int off = 0;
                for (int j = 0; j < length; ++j) {
                    char c = (char)b[j];
                    if (off == 0 && c == '!' || c == '\u0000') {
                        off = j + 1;
                    }
                    if (!Character.isISOControl(c) && Character.isDefined(c)) continue;
                    b[j] = 32;
                }
                if (length - off < 5 || b[off] != 60 || b[off + 1] != 63 || b[off + 2] != 120 || b[off + 3] != 109 || b[off + 4] != 108) continue;
                boolean endBracketFound = false;
                while (!endBracketFound) {
                    if (b[off++] != 62) continue;
                    endBracketFound = true;
                }
                xml.add(b, off, b.length - off);
            }
            String xmlString = new String(xml.toByteArray());
            xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ND2>" + xmlString + "</ND2>";
            this.core[0].dimensionOrder = "";
            XMLTools.parseXML(xmlString, (DefaultHandler)handler);
            if (this.numSeries == 0) {
                this.numSeries = 1;
            }
            if (this.getSizeZ() == 0) {
                for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                    this.core[i4].sizeZ = 1;
                }
            }
            if (this.getSizeT() == 0) {
                for (i4 = 0; i4 < this.getSeriesCount(); ++i4) {
                    this.core[i4].sizeT = 1;
                }
            }
            long firstOffset = (Long)imageOffsets.get(0);
            long secondOffset = imageOffsets.size() > 1 ? ((Long)imageOffsets.get(1)).longValue() : this.in.length();
            int planeSize = this.getSizeX() * this.getSizeY() * this.getSizeC() * FormatTools.getBytesPerPixel(this.getPixelType());
            if (this.isLossless) {
                planeSize /= 4;
            }
            if (secondOffset - firstOffset < (long)planeSize) {
                this.debug("Correcting SizeC: was " + this.getSizeC());
                this.debug("plane size = " + planeSize);
                this.debug("available bytes = " + (secondOffset - firstOffset));
                this.core[0].sizeC = 1;
            }
            for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                this.core[i3].imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
                if (imageOffsets.size() / this.getSeriesCount() < this.core[i3].imageCount) {
                    this.core[i3].imageCount /= this.getSizeC();
                }
                if (this.core[i3].imageCount <= imageOffsets.size() / this.getSeriesCount()) continue;
                if (this.core[i3].imageCount == imageOffsets.size()) {
                    CoreMetadata originalCore = this.core[0];
                    this.core = new CoreMetadata[]{originalCore};
                    this.numSeries = 1;
                    break;
                }
                this.core[i3].imageCount = imageOffsets.size() / this.getSeriesCount();
                this.core[i3].sizeZ = 1;
                this.core[i3].sizeT = this.core[i3].imageCount;
            }
            if (this.numSeries * this.getImageCount() == 1 && imageOffsets.size() > 1) {
                for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                    this.core[i3].imageCount = imageOffsets.size() / this.getSeriesCount();
                    this.core[i3].sizeZ = this.getImageCount();
                    this.core[i3].sizeT = 1;
                }
            }
            if (this.getSizeC() > 1 && this.getDimensionOrder().indexOf("C") == -1) {
                this.core[0].dimensionOrder = "C" + this.getDimensionOrder();
                ++this.fieldIndex;
            }
            this.core[0].dimensionOrder = "XY" + this.getDimensionOrder();
            if (this.getDimensionOrder().indexOf("Z") == -1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
            }
            if (this.getDimensionOrder().indexOf("C") == -1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
            }
            if (this.getDimensionOrder().indexOf("T") == -1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
            }
            this.offsets = new long[this.numSeries][this.getImageCount()];
            int[] lengths = new int[4];
            int nextChar = 2;
            for (int i6 = 0; i6 < lengths.length; ++i6) {
                if (i6 == this.fieldIndex) {
                    lengths[i6] = this.core.length;
                    continue;
                }
                char axis = this.getDimensionOrder().charAt(nextChar++);
                if (axis == 'Z') {
                    lengths[i6] = this.getSizeZ();
                    continue;
                }
                if (axis == 'C') {
                    lengths[i6] = 1;
                    continue;
                }
                if (axis != 'T') continue;
                lengths[i6] = this.getSizeT();
            }
            int[] zctLengths = new int[4];
            System.arraycopy(lengths, 0, zctLengths, 0, lengths.length);
            zctLengths[this.fieldIndex] = 1;
            for (int i7 = 0; i7 < imageOffsets.size(); ++i7) {
                long offset = (Long)imageOffsets.get(i7);
                int[] p = (int[])imageLengths.get(i7);
                int length = p[0] + p[1];
                this.in.seek(offset);
                byte[] b = new byte[p[0]];
                this.in.read(b);
                StringBuffer sb = new StringBuffer();
                int pt = 13;
                while (b[pt] != 33) {
                    sb.append((char)b[pt++]);
                }
                b = null;
                int ndx = Integer.parseInt(sb.toString());
                if (this.getSizeC() == 0) {
                    int sizeC = length / (this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()));
                    for (int q = 0; q < this.getSeriesCount(); ++q) {
                        this.core[q].sizeC = sizeC;
                    }
                }
                int[] pos = FormatTools.rasterToPosition(lengths, ndx);
                int seriesIndex = pos[this.fieldIndex];
                pos[this.fieldIndex] = 0;
                int plane = FormatTools.positionToRaster(zctLengths, pos);
                if (seriesIndex >= this.offsets.length || plane >= this.offsets[seriesIndex].length) continue;
                this.offsets[seriesIndex][plane] = offset + (long)p[0] + 8L;
            }
            Vector<long[]> tmpOffsets = new Vector<long[]>();
            for (i2 = 0; i2 < this.offsets.length; ++i2) {
                if (this.offsets[i2][0] <= 0L) continue;
                tmpOffsets.add(this.offsets[i2]);
            }
            this.offsets = new long[tmpOffsets.size()][];
            for (i2 = 0; i2 < tmpOffsets.size(); ++i2) {
                this.offsets[i2] = (long[])tmpOffsets.get(i2);
            }
            if (this.offsets.length != this.getSeriesCount()) {
                int x = this.getSizeX();
                int y = this.getSizeY();
                int c = this.getSizeC();
                int pixelType = this.getPixelType();
                boolean rgb = this.isRGB();
                String order = this.getDimensionOrder();
                this.core = new CoreMetadata[this.offsets.length];
                for (int i8 = 0; i8 < this.offsets.length; ++i8) {
                    this.core[i8] = new CoreMetadata();
                    this.core[i8].sizeX = x;
                    this.core[i8].sizeY = y;
                    this.core[i8].sizeC = c == 0 ? 1 : c;
                    this.core[i8].pixelType = pixelType;
                    this.core[i8].rgb = rgb;
                    this.core[i8].sizeZ = 1;
                    this.core[i8].dimensionOrder = order;
                    int invalid = 0;
                    for (int q = 0; q < this.offsets[i8].length; ++q) {
                        if (this.offsets[i8][q] != 0L) continue;
                        ++invalid;
                    }
                    this.core[i8].imageCount = this.offsets[i8].length - invalid;
                    this.core[i8].sizeT = this.core[i8].imageCount / (rgb ? 1 : this.core[i8].sizeC);
                    if (this.core[i8].sizeT != 0) continue;
                    this.core[i8].sizeT = 1;
                }
            } else {
                for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                    this.core[i2].sizeX = this.getSizeX();
                    this.core[i2].sizeY = this.getSizeY();
                    this.core[i2].sizeC = this.getSizeC() == 0 ? 1 : this.getSizeC();
                    this.core[i2].sizeZ = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
                    this.core[i2].sizeT = this.getSizeT() == 0 ? 1 : this.getSizeT();
                    this.core[i2].imageCount = this.getImageCount();
                    this.core[i2].pixelType = this.getPixelType();
                    this.core[i2].dimensionOrder = this.getDimensionOrder();
                }
            }
            for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                this.core[i2].rgb = this.getSizeC() > 1;
                this.core[i2].littleEndian = true;
                this.core[i2].interleaved = true;
                this.core[i2].indexed = false;
                this.core[i2].falseColor = false;
                this.core[i2].metadataComplete = true;
                this.core[i2].imageCount = this.core[i2].sizeZ * this.core[i2].sizeT;
                if (this.core[i2].rgb) continue;
                this.core[i2].imageCount *= this.core[i2].sizeC;
            }
            if (customDataOffsets.size() > 0) {
                this.in.seek((Long)customDataOffsets.get(0));
                int[] p = (int[])customDataLengths.get(0);
                int len = p[0] + p[1];
                int timestampBytes = imageOffsets.size() * 8;
                this.in.skipBytes(len - timestampBytes);
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    this.setSeries(series);
                    for (int plane = 0; plane < this.getImageCount(); ++plane) {
                        double time = this.in.readDouble() / 1000.0;
                        this.tsT.add(new Double(time));
                        this.addSeriesMeta("timestamp " + plane, time);
                    }
                }
                this.setSeries(0);
            }
            this.populateMetadataStore();
            return;
        }
        this.in.seek(0L);
        this.isJPEG = true;
        this.status("Calculating image offsets");
        Vector<Long> vs = new Vector<Long>();
        long pos = this.in.getFilePointer();
        boolean lastBoxFound = false;
        int length = 0;
        int box = 0;
        int x = 0;
        int y = 0;
        int c = 0;
        int type = 0;
        while (!lastBoxFound) {
            pos = this.in.getFilePointer();
            long nextPos = pos + (long)(length = this.in.readInt());
            if (nextPos < 0L || nextPos >= this.in.length() || length == 0) {
                lastBoxFound = true;
            }
            box = this.in.readInt();
            pos = this.in.getFilePointer();
            length -= 8;
            if (box == 1785737827) {
                vs.add(new Long(pos));
            } else if (box == 1785737832) {
                this.in.skipBytes(4);
                String s = this.in.readString(4);
                if (s.equals("ihdr")) {
                    y = this.in.readInt();
                    x = this.in.readInt();
                    c = this.in.readShort();
                    type = this.in.readInt();
                    type = type == 252117248 || type == 0xF070000 ? 3 : 1;
                }
            }
            if (lastBoxFound || box == 1785737832) continue;
            this.in.skipBytes(length);
        }
        this.status("Finding XML metadata");
        this.in.seek((Long)vs.get(vs.size() - 1));
        boolean found = false;
        long off = -1L;
        byte[] buf = new byte[8192];
        block22: while (!found && this.in.getFilePointer() < this.in.length()) {
            int read = 0;
            if (this.in.getFilePointer() == ((Long)vs.get(vs.size() - 1)).longValue()) {
                read = this.in.read(buf);
            } else {
                System.arraycopy(buf, buf.length - 10, buf, 0, 10);
                read = this.in.read(buf, 10, buf.length - 10);
            }
            if (read == buf.length) {
                read -= 10;
            }
            for (int i9 = 0; i9 < read + 9; ++i9) {
                if (buf[i9] != -1 || buf[i9 + 1] != -39) continue;
                found = true;
                off = this.in.getFilePointer() - (long)(read + 10) + (long)i9;
                i9 = buf.length;
                continue block22;
            }
        }
        buf = null;
        this.status("Parsing XML");
        if (off > 0L && off < this.in.length() - 5L && this.in.length() - off - 5L > 14L) {
            this.in.seek(off + 4L);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><NIKON>");
            String s = null;
            short blockLength = 0;
            while (this.in.getFilePointer() < this.in.length() && (blockLength = this.in.readShort()) >= 2) {
                int closedBracket;
                s = this.in.readString(blockLength - 2);
                int openBracket = (s = s.replaceAll("<!--.+?>", "")).indexOf("<");
                if (openBracket == -1 || (closedBracket = s.lastIndexOf(">") + 1) < openBracket || (s = s.substring(openBracket, closedBracket).trim()).indexOf("CalibrationSeq") != -1 || s.indexOf("VCAL") != -1 || s.indexOf("jp2cLUNK") != -1) continue;
                sb.append(s);
            }
            sb.append("</NIKON>");
            this.status("Finished assembling XML string");
            ND2Handler handler = new ND2Handler();
            int offset = 0;
            int len = sb.length();
            for (int i10 = 0; i10 < len; ++i10) {
                char ch = sb.charAt(i10);
                if (offset == 0 && ch == '!') {
                    offset = i10 + 1;
                }
                if (!Character.isISOControl(ch) && Character.isDefined(ch)) continue;
                sb.setCharAt(i10, ' ');
            }
            this.core[0].dimensionOrder = "";
            String xml = sb.toString().substring(offset, len - offset);
            XMLTools.parseXML(xml, (DefaultHandler)handler);
            xml = null;
        }
        this.status("Populating metadata");
        this.core[0].pixelType = 1;
        this.offsets = new long[1][2];
        this.offsets[0][0] = (Long)vs.get(0);
        if (this.offsets[0].length > 1 && vs.size() > 1) {
            this.offsets[0][1] = (Long)vs.get(1);
        }
        this.in.seek(this.offsets[0][0]);
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        int n = c = (numBands = c) > 1 ? numBands : this.getSizeC();
        if (numBands == 1 && this.getImageCount() == 1) {
            c = 1;
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].sizeC = c;
            this.core[i].rgb = numBands > 1;
            this.core[i].pixelType = type;
        }
        if (this.isRGB() && this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = "C" + this.getDimensionOrder();
        }
        if (this.getDimensionOrder().indexOf("Z") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("T") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        this.core[0].dimensionOrder = "XY" + this.getDimensionOrder();
        if (this.getImageCount() == 0) {
            int channels;
            this.core[0].imageCount = vs.size();
            this.core[0].sizeZ = Math.max(this.zs.size(), 1);
            this.core[0].sizeT = Math.max(this.ts.size(), 1);
            int n2 = channels = this.isRGB() ? 1 : this.getSizeC();
            if (channels * this.getSizeZ() * this.getSizeT() != this.getImageCount()) {
                this.core[0].sizeZ = 1;
                this.core[0].sizeT = this.getImageCount() / channels;
                this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * channels;
            }
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].sizeZ = this.getSizeZ();
            this.core[i].sizeT = this.getSizeT();
            this.core[i].imageCount = this.getSizeZ() * this.getSizeT() * (this.isRGB() ? 1 : this.getSizeC());
            this.core[i].dimensionOrder = this.getDimensionOrder();
            this.core[i].sizeX = x;
            this.core[i].sizeY = y;
            this.core[i].interleaved = false;
            this.core[i].littleEndian = false;
            this.core[i].metadataComplete = true;
        }
        int nplanes = this.getSizeZ() * this.getEffectiveSizeC();
        if (this.numSeries == 0) {
            this.numSeries = 1;
        }
        if (this.numSeries * nplanes * this.getSizeT() > vs.size()) {
            this.numSeries = vs.size() / (nplanes * this.getSizeT());
        }
        this.offsets = new long[this.numSeries][this.getImageCount()];
        for (int i11 = 0; i11 < this.getSizeT(); ++i11) {
            for (int j = 0; j < this.numSeries; ++j) {
                for (int q = 0; q < nplanes; ++q) {
                    this.offsets[j][i11 * nplanes + q] = (Long)vs.remove(0);
                }
            }
        }
        this.populateMetadataStore();
    }

    private void populateMetadataStore() {
        int i;
        int i2;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            store.setImageName("Series " + (i2 + 1), i2);
            MetadataTools.setDefaultCreationDate(store, this.currentId, i2);
            store.setImageInstrumentRef(instrumentID, i2);
        }
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), i2, 0);
            store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), i2, 0);
            store.setDimensionsPhysicalSizeZ(new Float(this.pixelSizeZ), i2, 0);
        }
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            if (this.tsT.size() <= 0) continue;
            this.setSeries(i2);
            for (int n = 0; n < this.getImageCount(); ++n) {
                int[] coords = this.getZCTCoords(n);
                int stampIndex = coords[2];
                if (this.tsT.size() == this.getImageCount()) {
                    stampIndex = n;
                }
                float stamp = this.tsT.get(stampIndex).floatValue();
                store.setPlaneTimingDeltaT(new Float(stamp), i2, 0, n);
                int index = i2 * this.getSizeC() + coords[1];
                if (index >= this.exposureTime.size()) continue;
                store.setPlaneTimingExposureTime(this.exposureTime.get(index), i2, 0, n);
            }
        }
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detectorID, 0, 0);
        store.setDetectorModel(this.cameraModel, 0, 0);
        store.setDetectorType("Unknown", 0, 0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                int index = i * this.getSizeC() + c;
                if (index < this.channelNames.size()) {
                    store.setLogicalChannelName(this.channelNames.get(index), i, c);
                }
                if (index < this.modality.size()) {
                    store.setLogicalChannelMode(this.modality.get(index), i, c);
                }
                if (index < this.emWave.size()) {
                    store.setLogicalChannelEmWave(this.emWave.get(index), i, c);
                }
                if (index < this.exWave.size()) {
                    store.setLogicalChannelExWave(this.exWave.get(index), i, c);
                }
                if (index < this.binning.size()) {
                    store.setDetectorSettingsBinning(this.binning.get(index), i, c);
                }
                if (index < this.gain.size()) {
                    store.setDetectorSettingsGain(this.gain.get(index), i, c);
                }
                if (index < this.speed.size()) {
                    store.setDetectorSettingsReadOutRate(this.speed.get(index), i, c);
                }
                store.setDetectorSettingsDetector(detectorID, i, c);
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (i * this.getSizeC() >= this.temperature.size()) continue;
            Float temp = this.temperature.get(i * this.getSizeC());
            store.setImagingEnvironmentTemperature(temp, i);
        }
        if (this.voltage != null) {
            store.setDetectorSettingsVoltage(new Float(this.voltage), 0, 0);
        }
        if (this.na != null) {
            store.setObjectiveLensNA(new Float(this.na), 0, 0);
        }
        if (this.mag != null) {
            store.setObjectiveCalibratedMagnification(new Float(this.mag), 0, 0);
        }
        if (this.objectiveModel != null) {
            store.setObjectiveModel(this.objectiveModel, 0, 0);
        }
        if (this.immersion == null) {
            this.immersion = "Unknown";
        }
        store.setObjectiveImmersion(this.immersion, 0, 0);
        if (this.correction == null || this.correction.length() == 0) {
            this.correction = "Unknown";
        }
        store.setObjectiveCorrection(this.correction, 0, 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        for (int i3 = 0; i3 < this.getSeriesCount(); ++i3) {
            store.setObjectiveSettingsObjective(objectiveID, 0);
        }
        this.setSeries(0);
        for (int r = 0; r < this.rois.size(); ++r) {
            Hashtable<String, String> roi = this.rois.get(r);
            String type = roi.get("ROIType");
            store.setShapeLocked(new Boolean(roi.get("locked")), 0, r, 0);
            store.setShapeStrokeWidth(new Integer(roi.get("line-width")), 0, r, 0);
            store.setShapeVisibility(new Boolean(roi.get("visible")), 0, r, 0);
            store.setShapeStrokeColor(roi.get("color"), 0, r, 0);
            if (type.equals("Text")) {
                store.setShapeFontFamily(roi.get("fFaceName"), 0, r, 0);
                store.setShapeFontSize(new Integer(roi.get("fHeight")), 0, r, 0);
                store.setShapeText(roi.get("eval-text"), 0, r, 0);
                store.setShapeFontWeight(roi.get("fWeight"), 0, r, 0);
                boolean italic = Integer.parseInt(roi.get("fItalic")) != 0;
                boolean underline = Integer.parseInt(roi.get("fUnderline")) != 0;
                boolean strikeOut = Integer.parseInt(roi.get("fStrikeOut")) != 0;
                store.setShapeFontStyle(italic ? "italic" : "normal", 0, r, 0);
                store.setShapeTextDecoration(underline ? "underline" : (strikeOut ? "line-through" : "normal"), 0, r, 0);
                String rectangle = roi.get("rectangle");
                String[] p = rectangle.split(",");
                double[] points = new double[p.length];
                for (int i4 = 0; i4 < p.length; ++i4) {
                    points[i4] = Double.parseDouble(p[i4]);
                }
                store.setRectX(p[0], 0, r, 0);
                store.setRectY(p[1], 0, r, 0);
                store.setRectWidth(String.valueOf(points[2] - points[0]), 0, r, 0);
                store.setRectHeight(String.valueOf(points[3] - points[1]), 0, r, 0);
                continue;
            }
            if (!type.equals("HorizontalLine") && !type.equals("VerticalLine")) continue;
            String segments = roi.get("segments");
            segments = segments.replaceAll("\\[", "");
            segments = segments.replaceAll("\\]", "");
            String[] points = segments.split("\\)");
            StringBuffer sb = new StringBuffer();
            for (int i5 = 0; i5 < points.length; ++i5) {
                points[i5] = points[i5].substring(points[i5].indexOf(":") + 1);
                sb.append(points[i5]);
                if (i5 >= points.length - 1) continue;
                sb.append(" ");
            }
            store.setPolylinePoints(sb.toString(), 0, r, 0);
        }
    }

    private void parseKeyAndValue(String key, String value, String runtype) {
        block33: {
            block44: {
                block42: {
                    block43: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block37: {
                                            block36: {
                                                block35: {
                                                    block34: {
                                                        block32: {
                                                            if (key == null || value == null) {
                                                                return;
                                                            }
                                                            this.addGlobalMeta(key, value);
                                                            if (!key.endsWith("dCalibration")) break block32;
                                                            this.pixelSizeY = this.pixelSizeX = Float.parseFloat(value);
                                                            break block33;
                                                        }
                                                        if (!key.endsWith("dZStep")) break block34;
                                                        this.pixelSizeZ = Float.parseFloat(value);
                                                        break block33;
                                                    }
                                                    if (!key.endsWith("Gain")) break block35;
                                                    this.gain.add(new Float(value));
                                                    break block33;
                                                }
                                                if (!key.endsWith("dLampVoltage")) break block36;
                                                this.voltage = value;
                                                break block33;
                                            }
                                            if (!key.endsWith("dObjectiveMag") || this.mag != null) break block37;
                                            this.mag = value;
                                            break block33;
                                        }
                                        if (!key.endsWith("dObjectiveNA")) break block38;
                                        this.na = value;
                                        break block33;
                                    }
                                    if (!key.equals("sObjective") && !key.equals("wsObjectiveName")) break block39;
                                    String[] tokens = value.split(" ");
                                    int magIndex = -1;
                                    for (int i = 0; i < tokens.length; ++i) {
                                        if (tokens[i].indexOf("x") == -1) continue;
                                        magIndex = i;
                                        break;
                                    }
                                    StringBuffer s = new StringBuffer();
                                    for (int i = 0; i < magIndex; ++i) {
                                        s.append(tokens[i]);
                                    }
                                    this.correction = s.toString();
                                    if (magIndex >= 0) {
                                        this.mag = tokens[magIndex].substring(0, tokens[magIndex].indexOf("x"));
                                    }
                                    if (magIndex + 1 < tokens.length) {
                                        this.immersion = tokens[magIndex + 1];
                                    }
                                    break block33;
                                }
                                if (!key.endsWith("dTimeMSec")) break block40;
                                long v = (long)Double.parseDouble(value);
                                if (!this.ts.contains(new Long(v))) {
                                    this.ts.add(new Long(v));
                                    this.addGlobalMeta("number of timepoints", this.ts.size());
                                }
                                break block33;
                            }
                            if (!key.endsWith("dZPos")) break block41;
                            long v = (long)Double.parseDouble(value);
                            if (!this.zs.contains(new Long(v))) {
                                this.zs.add(new Long(v));
                            }
                            break block33;
                        }
                        if (!key.endsWith("uiCount")) break block42;
                        if (runtype == null) break block33;
                        if (!runtype.endsWith("ZStackLoop")) break block43;
                        if (this.getSizeZ() != 0) break block33;
                        this.core[0].sizeZ = Integer.parseInt(value);
                        if (this.getDimensionOrder().indexOf("Z") != -1) break block33;
                        this.core[0].dimensionOrder = "Z" + this.getDimensionOrder();
                        break block33;
                    }
                    if (!runtype.endsWith("TimeLoop") || this.getSizeT() != 0) break block33;
                    this.core[0].sizeT = Integer.parseInt(value);
                    if (this.getDimensionOrder().indexOf("T") != -1) break block33;
                    this.core[0].dimensionOrder = "T" + this.getDimensionOrder();
                    break block33;
                }
                if (!key.equals("VirtualComponents")) break block44;
                if (this.getSizeC() != 0) break block33;
                this.core[0].sizeC = Integer.parseInt(value);
                if (this.getDimensionOrder().indexOf("C") != -1) break block33;
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C" + this.getDimensionOrder();
                break block33;
            }
            if (key.startsWith("TextInfoItem") || key.endsWith("TextInfoItem")) {
                this.metadata.remove(key);
                value = value.replaceAll("&#x000d;&#x000a;", "\n");
                StringTokenizer tokens = new StringTokenizer(value, "\n");
                while (tokens.hasMoreTokens()) {
                    String t = tokens.nextToken().trim();
                    if (t.startsWith("Dimensions:")) {
                        t = t.substring(11);
                        StringTokenizer dims = new StringTokenizer(t, " x ");
                        this.core[0].sizeZ = 1;
                        this.core[0].sizeT = 1;
                        this.core[0].sizeC = 1;
                        while (dims.hasMoreTokens()) {
                            String dim = dims.nextToken().trim();
                            int v = Integer.parseInt(dim.replaceAll("\\D", ""));
                            v = Math.max(v, 1);
                            if (dim.startsWith("XY")) {
                                this.numSeries = v;
                                if (this.numSeries <= 1) continue;
                                int x = this.getSizeX();
                                int y = this.getSizeY();
                                int z = this.getSizeZ();
                                int tSize = this.getSizeT();
                                int c = this.getSizeC();
                                String order = this.getDimensionOrder();
                                this.core = new CoreMetadata[this.numSeries];
                                for (int i = 0; i < this.numSeries; ++i) {
                                    this.core[i] = new CoreMetadata();
                                    this.core[i].sizeX = x;
                                    this.core[i].sizeY = y;
                                    this.core[i].sizeZ = z == 0 ? 1 : z;
                                    this.core[i].sizeC = c == 0 ? 1 : c;
                                    this.core[i].sizeT = tSize == 0 ? 1 : tSize;
                                    this.core[i].dimensionOrder = order;
                                }
                                continue;
                            }
                            if (dim.startsWith("T")) {
                                this.core[0].sizeT = v;
                                continue;
                            }
                            if (dim.startsWith("Z")) {
                                this.core[0].sizeZ = v;
                                continue;
                            }
                            this.core[0].sizeC = v;
                        }
                        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
                        continue;
                    }
                    if (t.startsWith("Number of Picture Planes")) {
                        this.core[0].sizeC = Integer.parseInt(t.replaceAll("\\D", ""));
                        continue;
                    }
                    String[] v = t.split(":");
                    if (v.length == 2) {
                        if (v[0].equals("Name")) {
                            this.channelNames.add(v[1]);
                            continue;
                        }
                        if (v[0].equals("Modality")) {
                            this.modality.add(v[1]);
                            continue;
                        }
                        if (v[0].equals("Camera Type")) {
                            this.cameraModel = v[1];
                            continue;
                        }
                        if (v[0].equals("Binning")) {
                            this.binning.add(v[1]);
                            continue;
                        }
                        if (v[0].equals("Readout Speed")) {
                            int last = v[1].lastIndexOf(" ");
                            if (last != -1) {
                                v[1] = v[1].substring(0, last);
                            }
                            this.speed.add(new Float(v[1]));
                            continue;
                        }
                        if (v[0].equals("Temperature")) {
                            String temp = v[1].replaceAll("[\\D&&[^-.]]", "");
                            this.temperature.add(new Float(temp));
                            continue;
                        }
                        if (!v[0].equals("Exposure")) continue;
                        String[] s = v[1].trim().split(" ");
                        try {
                            float time = Float.parseFloat(s[0]);
                            if (s[1].equals("ms")) {
                                time /= 1000.0f;
                            }
                            this.exposureTime.add(new Float(time));
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (v[0].startsWith("- Step")) {
                        int space = v[0].indexOf(" ", v[0].indexOf("Step") + 1);
                        int last = v[0].indexOf(" ", space + 1);
                        if (last == -1) {
                            last = v[0].length();
                        }
                        this.pixelSizeZ = Float.parseFloat(v[0].substring(space, last));
                        continue;
                    }
                    if (!v[0].equals("Line")) continue;
                    String[] values = t.split(";");
                    for (int q = 0; q < values.length; ++q) {
                        int colon = values[q].indexOf(":");
                        String nextKey = values[q].substring(0, colon).trim();
                        String nextValue = values[q].substring(colon + 1).trim();
                        if (nextKey.equals("Emission wavelength")) {
                            this.emWave.add(new Integer(nextValue));
                            continue;
                        }
                        if (nextKey.equals("Excitation wavelength")) {
                            this.exWave.add(new Integer(nextValue));
                            continue;
                        }
                        if (!nextKey.equals("Power")) continue;
                        this.power.add(new Integer((int)Float.parseFloat(nextValue)));
                    }
                }
            }
        }
    }

    class ND2Handler
    extends DefaultHandler {
        private String prefix = null;
        private String prevRuntype = null;

        ND2Handler() {
        }

        public void endElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
                this.prefix = null;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String value = attributes.getValue("value");
            if (qName.equals("uiWidth")) {
                ((NativeND2Reader)NativeND2Reader.this).core[0].sizeX = Integer.parseInt(value);
            } else if (qName.equals("uiWidthBytes") || qName.equals("uiBpcInMemory")) {
                int div = qName.equals("uiWidthBytes") ? NativeND2Reader.this.getSizeX() : 8;
                int bytes = Integer.parseInt(value) / div;
                switch (bytes) {
                    case 2: {
                        ((NativeND2Reader)NativeND2Reader.this).core[0].pixelType = 3;
                        break;
                    }
                    case 4: {
                        ((NativeND2Reader)NativeND2Reader.this).core[0].pixelType = 5;
                        break;
                    }
                    default: {
                        ((NativeND2Reader)NativeND2Reader.this).core[0].pixelType = 1;
                    }
                }
                NativeND2Reader.this.parseKeyAndValue(qName, value, this.prevRuntype);
            } else if (qName.startsWith("item_")) {
                int v = Integer.parseInt(qName.substring(qName.indexOf("_") + 1));
                if (v == NativeND2Reader.this.numSeries) {
                    NativeND2Reader.this.fieldIndex = NativeND2Reader.this.getDimensionOrder().length();
                    NativeND2Reader.this.numSeries++;
                }
            } else if (qName.equals("uiCompCount")) {
                int v = Integer.parseInt(value);
                ((NativeND2Reader)NativeND2Reader.this).core[0].sizeC = Math.max(NativeND2Reader.this.getSizeC(), v);
            } else if (qName.equals("uiHeight")) {
                ((NativeND2Reader)NativeND2Reader.this).core[0].sizeY = Integer.parseInt(value);
            } else if (qName.startsWith("TextInfo")) {
                NativeND2Reader.this.parseKeyAndValue(qName, attributes.getValue("Text"), this.prevRuntype);
                NativeND2Reader.this.parseKeyAndValue(qName, value, this.prevRuntype);
            } else if (qName.equals("dCompressionParam")) {
                NativeND2Reader.this.isLossless = Integer.parseInt(value) > 0;
                NativeND2Reader.this.parseKeyAndValue(qName, value, this.prevRuntype);
            } else if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
                this.prefix = qName + " " + attributes.getValue("_SEQUENCE_INDEX");
            } else if (qName.equals("HorizontalLine") || qName.equals("VerticalLine") || qName.equals("Text")) {
                Hashtable<String, String> roi = new Hashtable<String, String>();
                roi.put("ROIType", qName);
                for (int q = 0; q < attributes.getLength(); ++q) {
                    roi.put(attributes.getQName(q), attributes.getValue(q));
                }
                NativeND2Reader.this.rois.add(roi);
            } else {
                StringBuffer sb = new StringBuffer();
                if (this.prefix != null) {
                    sb.append(this.prefix);
                    sb.append(" ");
                }
                sb.append(qName);
                NativeND2Reader.this.parseKeyAndValue(sb.toString(), value, this.prevRuntype);
            }
            this.prevRuntype = attributes.getValue("runtype");
        }
    }
}

