/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.FilterMetadata;

public class PerkinElmerReader
extends FormatReader {
    public static final String[] CFG_SUFFIX = new String[]{"cfg"};
    public static final String[] ANO_SUFFIX = new String[]{"ano"};
    public static final String[] REC_SUFFIX = new String[]{"rec"};
    public static final String[] TIM_SUFFIX = new String[]{"tim"};
    public static final String[] CSV_SUFFIX = new String[]{"csv"};
    public static final String[] ZPO_SUFFIX = new String[]{"zpo"};
    public static final String[] HTM_SUFFIX = new String[]{"htm"};
    public static final String HTML_REGEX = "<p>|</p>|<br>|<hr>|<b>|</b>|<HTML>|<HEAD>|</HTML>|</HEAD>|<h1>|</h1>|<HR>|</body>";
    public static final String DATE_FORMAT = "HH:mm:ss (MM/dd/yyyy)";
    protected MinimalTiffReader tiff;
    protected String[] files;
    private boolean isTiff = true;
    private Vector<String> allFiles;
    private String details;
    private String sliceSpace;
    private float pixelSizeX = 1.0f;
    private float pixelSizeY = 1.0f;
    private String finishTime = null;
    private String startTime = null;
    private float originX = 0.0f;
    private float originY = 0.0f;
    private float originZ = 0.0f;

    public PerkinElmerReader() {
        super("PerkinElmer", new String[]{"ano", "cfg", "csv", "htm", "rec", "tim", "zpo"});
    }

    public boolean isThisType(String name, boolean open) {
        Location htmlFile;
        boolean binFile;
        block9: {
            if (super.isThisType(name, open)) {
                return true;
            }
            if (!open) {
                return false;
            }
            String ext = name;
            if (ext.indexOf(".") != -1) {
                ext = ext.substring(ext.lastIndexOf(".") + 1);
            }
            binFile = true;
            try {
                Integer.parseInt(ext, 16);
            }
            catch (NumberFormatException e) {
                ext = ext.toLowerCase();
                if (ext.equals("tif") || ext.equals("tiff")) break block9;
                binFile = false;
            }
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (prefix.indexOf("_") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("_"));
        }
        if (!(htmlFile = new Location(prefix + ".htm")).exists()) {
            htmlFile = new Location(prefix + ".HTM");
            while (!htmlFile.exists() && prefix.indexOf("_") != -1) {
                htmlFile = new Location((prefix = prefix.substring(0, prefix.indexOf("_"))) + ".htm");
                if (htmlFile.exists()) continue;
                htmlFile = new Location(prefix + ".HTM");
            }
        }
        return htmlFile.exists() && (binFile || super.isThisType(name, false));
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.isTiff) {
            this.tiff.setId(this.files[no / this.getSizeC()]);
            return this.tiff.openBytes(0, buf, x, y, w, h);
        }
        RandomAccessInputStream ras = new RandomAccessInputStream(this.files[no]);
        ras.seek(6L);
        this.readPlane(ras, x, y, w, h, buf);
        ras.close();
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            Vector<String> files = new Vector<String>();
            if (this.isTiff) {
                for (int i = 0; i < this.allFiles.size(); ++i) {
                    String f = this.allFiles.get(i).toLowerCase();
                    if (f.endsWith(".tif") || f.endsWith(".tiff")) continue;
                    files.add(this.allFiles.get(i));
                }
            } else {
                for (int i = 0; i < this.allFiles.size(); ++i) {
                    String f = this.allFiles.get(i);
                    String ext = f.substring(f.lastIndexOf(".") + 1);
                    try {
                        Integer.parseInt(ext, 16);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        files.add(f);
                    }
                }
            }
            return files.toArray(new String[0]);
        }
        return this.allFiles.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiff = null;
            this.allFiles = null;
            this.files = null;
            this.sliceSpace = null;
            this.details = null;
            this.isTiff = true;
            this.pixelSizeY = 1.0f;
            this.pixelSizeX = 1.0f;
            this.startTime = null;
            this.finishTime = null;
            this.originZ = 0.0f;
            this.originY = 0.0f;
            this.originX = 0.0f;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] tokens;
        int j;
        int i;
        String workingDirPath;
        if (this.currentId != null && (id.equals(this.currentId) || this.isUsedFile(id))) {
            return;
        }
        this.status("Finding HTML companion file");
        this.debug("PerkinElmerReader.initFile(" + id + ")");
        if (!PerkinElmerReader.checkSuffix(id, HTM_SUFFIX)) {
            String[] ls;
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            for (String file2 : ls = parent.list()) {
                if (!PerkinElmerReader.checkSuffix(file2, HTM_SUFFIX) || file2.startsWith(".")) continue;
                id = new Location(parent.getAbsolutePath(), file2).getAbsolutePath();
                break;
            }
        }
        super.initFile(id);
        this.allFiles = new Vector();
        Location tmpFile = new Location(id).getAbsoluteFile();
        Location workingDir = tmpFile.getParentFile();
        if (workingDir == null) {
            workingDir = new Location(".");
        }
        if (!(workingDirPath = workingDir.getPath()).equals("")) {
            workingDirPath = workingDirPath + File.separator;
        }
        String[] ls = workingDir.list();
        if (!new Location(id).exists()) {
            ls = Location.getIdMap().keySet().toArray(new String[0]);
            workingDirPath = "";
        }
        Vector<String> v = new Vector<String>();
        for (int i2 = 0; i2 < ls.length; ++i2) {
            String file3 = ls[i2];
            if (file3.indexOf(File.separator) != -1) {
                file3 = file3.substring(file3.lastIndexOf(File.separator) + 1);
            }
            if (file3.startsWith(".")) continue;
            v.add(ls[i2]);
        }
        ls = v.toArray(new String[0]);
        this.status("Searching for all metadata companion files");
        String cfgFile = null;
        String anoFile = null;
        String recFile = null;
        String timFile = null;
        String csvFile = null;
        String zpoFile = null;
        String htmFile = null;
        int filesPt = 0;
        this.files = new String[ls.length];
        int dot = id.lastIndexOf(".");
        String check = dot < 0 ? id : id.substring(0, dot);
        check = check.substring(check.lastIndexOf(File.separator) + 1);
        String prefix = null;
        for (int i3 = 0; i3 < ls.length; ++i3) {
            String s;
            int d = ls[i3].lastIndexOf(".");
            while (d == -1 && i3 < ls.length - 1) {
                d = ls[++i3].lastIndexOf(".");
            }
            String string = s = d < 0 ? ls[i3] : ls[i3].substring(0, d);
            if (!s.startsWith(check) && !check.startsWith(s) && (prefix == null || !s.startsWith(prefix))) continue;
            prefix = ls[i3].substring(0, d);
            if (cfgFile == null && PerkinElmerReader.checkSuffix(ls[i3], CFG_SUFFIX)) {
                cfgFile = ls[i3];
            }
            if (anoFile == null && PerkinElmerReader.checkSuffix(ls[i3], ANO_SUFFIX)) {
                anoFile = ls[i3];
            }
            if (recFile == null && PerkinElmerReader.checkSuffix(ls[i3], REC_SUFFIX)) {
                recFile = ls[i3];
            }
            if (timFile == null && PerkinElmerReader.checkSuffix(ls[i3], TIM_SUFFIX)) {
                timFile = ls[i3];
            }
            if (csvFile == null && PerkinElmerReader.checkSuffix(ls[i3], CSV_SUFFIX)) {
                csvFile = ls[i3];
            }
            if (zpoFile == null && PerkinElmerReader.checkSuffix(ls[i3], ZPO_SUFFIX)) {
                zpoFile = ls[i3];
            }
            if (htmFile == null && PerkinElmerReader.checkSuffix(ls[i3], HTM_SUFFIX)) {
                htmFile = ls[i3];
            }
            if (PerkinElmerReader.checkSuffix(ls[i3], TiffReader.TIFF_SUFFIXES)) {
                this.files[filesPt++] = workingDirPath + ls[i3];
            }
            try {
                String ext = ls[i3].substring(ls[i3].lastIndexOf(".") + 1);
                Integer.parseInt(ext, 16);
                this.isTiff = false;
                this.files[filesPt++] = workingDirPath + ls[i3];
                continue;
            }
            catch (NumberFormatException exc) {
                this.traceDebug(exc);
            }
        }
        String[] tempFiles = this.files;
        this.files = new String[filesPt];
        this.status("Finding image files");
        int extCount = 0;
        Vector<String> foundExts = new Vector<String>();
        for (i = 0; i < filesPt; ++i) {
            String ext = tempFiles[i].substring(tempFiles[i].lastIndexOf(".") + 1);
            if (foundExts.contains(ext)) continue;
            ++extCount;
            foundExts.add(ext);
        }
        foundExts = null;
        for (i = 0; i < filesPt; i += extCount) {
            Vector<String> extSet = new Vector<String>();
            for (int j2 = 0; j2 < extCount; ++j2) {
                String file4 = tempFiles[i + j2];
                if (extSet.size() == 0) {
                    extSet.add(file4);
                    continue;
                }
                if (file4 == null) continue;
                String ext = file4.substring(file4.lastIndexOf(".") + 1);
                int extNum = Integer.parseInt(ext, 16);
                int insert = -1;
                for (int pos = 0; insert == -1 && pos < extSet.size(); ++pos) {
                    String posString = (String)extSet.get(pos);
                    int posNum = Integer.parseInt(posString = posString.substring(posString.lastIndexOf(".") + 1), 16);
                    if (extNum >= posNum) continue;
                    insert = pos;
                }
                if (insert == -1) {
                    extSet.add(tempFiles[i + j2]);
                    continue;
                }
                extSet.add(insert, tempFiles[i + j2]);
            }
            int length = Math.min(extCount, extSet.size());
            for (int j3 = 0; j3 < length; ++j3) {
                this.files[i + j3] = (String)extSet.get(j3);
            }
        }
        for (i = 0; i < this.files.length; ++i) {
            this.allFiles.add(this.files[i]);
        }
        if (this.isTiff) {
            Arrays.sort(this.files);
        } else {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int cmp;
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    String prefix1 = s1;
                    String prefix2 = s2;
                    String suffix1 = s1;
                    String suffix2 = s2;
                    if (s1.indexOf(".") != -1) {
                        prefix1 = s1.substring(0, s1.lastIndexOf("."));
                        suffix1 = s1.substring(s1.lastIndexOf(".") + 1);
                    }
                    if (s2.indexOf(".") != -1) {
                        prefix2 = s2.substring(0, s2.lastIndexOf("."));
                        suffix2 = s2.substring(s2.lastIndexOf(".") + 1);
                    }
                    if ((cmp = prefix1.compareTo(prefix2)) != 0) {
                        return cmp;
                    }
                    return Integer.parseInt(suffix1, 16) - Integer.parseInt(suffix2, 16);
                }
            };
            Arrays.sort(this.files, c);
        }
        this.core[0].imageCount = this.files.length;
        this.tiff = new MinimalTiffReader();
        this.status("Parsing metadata values");
        this.addUsedFile(workingDirPath, cfgFile);
        this.addUsedFile(workingDirPath, anoFile);
        this.addUsedFile(workingDirPath, recFile);
        this.addUsedFile(workingDirPath, timFile);
        if (timFile != null) {
            timFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, csvFile);
        if (csvFile != null) {
            csvFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, zpoFile);
        if (zpoFile != null) {
            zpoFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, htmFile);
        if (htmFile != null) {
            htmFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        if (timFile != null) {
            RandomAccessInputStream read = new RandomAccessInputStream(timFile);
            String[] tokens2 = read.readString((int)read.length()).split("\\s");
            int tNum = 0;
            String[] hashKeys = new String[]{"Number of Wavelengths/Timepoints", "Zero 1", "Zero 2", "Number of slices", "Extra int", "Calibration Unit", "Pixel Size Y", "Pixel Size X", "Image Width", "Image Length", "Origin X", "SubfileType X", "Dimension Label X", "Origin Y", "SubfileType Y", "Dimension Label Y", "Origin Z", "SubfileType Z", "Dimension Label Z"};
            for (String token : tokens2) {
                if (token.trim().length() == 0) continue;
                if (tNum >= hashKeys.length) break;
                if (token.equals("um")) {
                    tNum = 5;
                }
                while (!(tNum != 1 && tNum != 2 || token.trim().equals("0"))) {
                    ++tNum;
                }
                if (tNum == 4) {
                    try {
                        Integer.parseInt(token);
                    }
                    catch (NumberFormatException e) {}
                }
                int n = ++tNum;
                ++tNum;
                this.parseKeyValue(hashKeys[n], token);
            }
            read.close();
        }
        if (csvFile != null) {
            RandomAccessInputStream read = new RandomAccessInputStream(csvFile);
            String[] tokens3 = read.readString((int)read.length()).split("\\s");
            Vector<String> tmp = new Vector<String>();
            for (String token : tokens3) {
                if (token.trim().length() <= 0) continue;
                tmp.add(token.trim());
            }
            tokens3 = tmp.toArray(new String[0]);
            read.close();
            int tNum = 0;
            String[] hashKeys = new String[]{"Calibration Unit", "Pixel Size X", "Pixel Size Y", "Z slice space"};
            int pt = 0;
            j = 0;
            while (j < tokens3.length) {
                String key = null;
                String value = null;
                if (tNum < 7) {
                    ++j;
                } else if (tNum > 7 && tNum < 12 || tNum > 12 && tNum < 18 || tNum > 18 && tNum < 22) {
                    ++j;
                } else if (pt < hashKeys.length) {
                    key = hashKeys[pt++];
                    value = tokens3[j++];
                } else {
                    key = tokens3[j++] + tokens3[j++];
                    value = tokens3[j++];
                }
                this.parseKeyValue(key, value);
                ++tNum;
            }
        }
        if (zpoFile != null && csvFile == null) {
            RandomAccessInputStream read = new RandomAccessInputStream(zpoFile);
            String[] tokens4 = read.readString((int)read.length()).split("\\s");
            for (int t = 0; t < tokens4.length; ++t) {
                this.addGlobalMeta("Z slice #" + t + " position", tokens4[t]);
            }
            read.close();
        }
        Vector<Float> exposureTimes = new Vector<Float>();
        Vector<Float> zPositions = new Vector<Float>();
        Vector<Integer> emWaves = new Vector<Integer>();
        Vector<Integer> exWaves = new Vector<Integer>();
        if (htmFile != null) {
            RandomAccessInputStream read = new RandomAccessInputStream(htmFile);
            tokens = read.readString((int)read.length()).split(HTML_REGEX);
            read.close();
            for (j = 0; j < tokens.length; ++j) {
                if (tokens[j].indexOf("<") == -1) continue;
                tokens[j] = "";
            }
            for (j = 0; j < tokens.length - 1; j += 2) {
                if (tokens[j].indexOf("Exposure") != -1) {
                    this.addGlobalMeta("Camera Data " + tokens[j].charAt(13), tokens[j]);
                    int ndx = tokens[j].indexOf("Exposure") + 9;
                    String exposure = tokens[j].substring(ndx, tokens[j].indexOf(" ", ndx)).trim();
                    if (exposure.endsWith(",")) {
                        exposure = exposure.substring(0, exposure.length() - 1);
                    }
                    exposureTimes.add(new Float(Float.parseFloat(exposure) / 1000.0f));
                    if (tokens[j].indexOf("nm") != -1) {
                        int nmIndex = tokens[j].indexOf("nm");
                        int paren = tokens[j].lastIndexOf("(", nmIndex);
                        int slash = tokens[j].lastIndexOf("/", nmIndex);
                        if (slash == -1) {
                            slash = nmIndex;
                        }
                        emWaves.add(new Integer(tokens[j].substring(paren + 1, slash).trim()));
                        if (tokens[j].indexOf("nm", nmIndex + 3) != -1) {
                            nmIndex = tokens[j].indexOf("nm", nmIndex + 3);
                            paren = tokens[j].lastIndexOf(" ", nmIndex);
                            slash = tokens[j].lastIndexOf("/", nmIndex);
                            if (slash == -1) {
                                slash = nmIndex + 2;
                            }
                            exWaves.add(new Integer(tokens[j].substring(paren + 1, slash).trim()));
                        }
                    }
                    --j;
                    continue;
                }
                if (tokens[j + 1].trim().equals("Slice Z positions")) {
                    for (int q = j + 2; q < tokens.length; ++q) {
                        if (tokens[q].trim().equals("")) continue;
                        zPositions.add(new Float(tokens[q].trim()));
                    }
                    continue;
                }
                if (tokens[j].trim().equals("")) continue;
                tokens[j] = tokens[j].trim();
                tokens[j + 1] = tokens[j + 1].trim();
                this.parseKeyValue(tokens[j], tokens[j + 1]);
            }
        } else {
            throw new FormatException("Valid header files not found.");
        }
        if (this.details != null) {
            tokens = this.details.split("\\s");
            int n = 0;
            for (String token : tokens) {
                if (token.equals("Wavelengths")) {
                    this.core[0].sizeC = n;
                } else if (token.equals("Frames")) {
                    this.core[0].sizeT = n;
                } else if (token.equals("Slices")) {
                    this.core[0].sizeZ = n;
                }
                try {
                    n = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    n = 0;
                }
            }
        }
        this.status("Populating metadata");
        if (this.isTiff) {
            this.tiff.setId(this.files[0]);
            this.core[0].pixelType = this.tiff.getPixelType();
        } else {
            RandomAccessInputStream tmp = new RandomAccessInputStream(this.files[0]);
            int bpp = (int)(tmp.length() - 6L) / (this.getSizeX() * this.getSizeY());
            tmp.close();
            switch (bpp) {
                case 1: 
                case 3: {
                    this.core[0].pixelType = 1;
                    break;
                }
                case 2: {
                    this.core[0].pixelType = 3;
                    break;
                }
                case 4: {
                    this.core[0].pixelType = 5;
                }
            }
        }
        if (this.getSizeZ() <= 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() <= 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() <= 0) {
            this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
        } else {
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            if (this.getImageCount() > this.files.length) {
                this.core[0].imageCount = this.files.length;
                this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            }
        }
        int calcCount = this.getSizeZ() * this.getEffectiveSizeC() * this.getSizeT();
        if (this.files.length > this.getImageCount() || this.getImageCount() != calcCount) {
            this.status("Removing extraneous files");
            String[] tmpFiles = this.files;
            int imageCount = Math.min(this.getImageCount(), calcCount);
            this.files = new String[imageCount];
            Hashtable<String, Integer> zSections = new Hashtable<String, Integer>();
            for (int i4 = 0; i4 < tmpFiles.length; ++i4) {
                int dotIndex;
                int underscore = tmpFiles[i4].lastIndexOf("_");
                String z = tmpFiles[i4].substring(underscore + 1, dotIndex = tmpFiles[i4].lastIndexOf("."));
                if (zSections.get(z) == null) {
                    zSections.put(z, new Integer(1));
                    continue;
                }
                int count = (Integer)zSections.get(z) + 1;
                zSections.put(z, new Integer(count));
            }
            int nextFile = 0;
            int oldFile = 0;
            Arrays.sort(tmpFiles, new PEComparator());
            Object[] keys = zSections.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i5 = 0; i5 < keys.length; ++i5) {
                int oldCount = (Integer)zSections.get(keys[i5]);
                int nPlanes = (this.isTiff ? this.tiff.getEffectiveSizeC() : this.getSizeC()) * this.getSizeT();
                int count = Math.min(oldCount, nPlanes);
                for (int j4 = 0; j4 < count; ++j4) {
                    this.files[nextFile++] = tmpFiles[oldFile++];
                }
                if (count >= oldCount) continue;
                oldFile += oldCount - count;
            }
            this.core[0].imageCount = this.getSizeZ() * this.getEffectiveSizeC() * this.getSizeT();
        }
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].rgb = this.isTiff ? this.tiff.isRGB() : false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = this.isTiff ? this.tiff.isLittleEndian() : true;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = this.isTiff ? this.tiff.isIndexed() : false;
        this.core[0].falseColor = false;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), 0, 0);
        if (this.finishTime != null) {
            this.finishTime = DateTools.formatDate(this.finishTime, DATE_FORMAT);
            store.setImageCreationDate(this.finishTime, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        for (int i6 = 0; i6 < this.getEffectiveSizeC(); ++i6) {
            if (i6 < emWaves.size()) {
                store.setLogicalChannelEmWave((Integer)emWaves.get(i6), 0, i6);
            }
            if (i6 >= exWaves.size()) continue;
            store.setLogicalChannelExWave((Integer)exWaves.get(i6), 0, i6);
        }
        long start = 0L;
        long end = 0L;
        if (this.startTime != null) {
            start = DateTools.getTime(this.startTime, DATE_FORMAT);
        }
        if (this.finishTime != null) {
            end = DateTools.getTime(this.finishTime, "yyyy-MM-dd'T'HH:mm:ss");
        }
        float secondsPerPlane = (float)(end - start) / (float)this.getImageCount() / 1000.0f;
        for (int i7 = 0; i7 < this.getImageCount(); ++i7) {
            int[] zct = this.getZCTCoords(i7);
            store.setPlaneTimingDeltaT(new Float((float)i7 * secondsPerPlane), 0, 0, i7);
            if (zct[1] < exposureTimes.size()) {
                store.setPlaneTimingExposureTime((Float)exposureTimes.get(zct[1]), 0, 0, i7);
            }
            if (zct[0] >= zPositions.size()) continue;
            store.setStagePositionPositionX(new Float(0.0), 0, 0, i7);
            store.setStagePositionPositionY(new Float(0.0), 0, 0, i7);
            store.setStagePositionPositionZ((Float)zPositions.get(zct[0]), 0, 0, i7);
        }
    }

    private void parseKeyValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.addGlobalMeta(key, value);
        try {
            if (key.equals("Image Width")) {
                this.core[0].sizeX = Integer.parseInt(value);
            } else if (key.equals("Image Length")) {
                this.core[0].sizeY = Integer.parseInt(value);
            } else if (key.equals("Number of slices")) {
                this.core[0].sizeZ = Integer.parseInt(value);
            } else if (key.equals("Experiment details:")) {
                this.details = value;
            } else if (key.equals("Z slice space")) {
                this.sliceSpace = value;
            } else if (key.equals("Pixel Size X")) {
                this.pixelSizeX = Float.parseFloat(value);
            } else if (key.equals("Pixel Size Y")) {
                this.pixelSizeY = Float.parseFloat(value);
            } else if (key.equals("Finish Time:")) {
                this.finishTime = value;
            } else if (key.equals("Start Time:")) {
                this.startTime = value;
            } else if (key.equals("Origin X")) {
                this.originX = Float.parseFloat(value);
            } else if (key.equals("Origin Y")) {
                this.originY = Float.parseFloat(value);
            } else if (key.equals("Origin Z")) {
                this.originZ = Float.parseFloat(value);
            }
        }
        catch (NumberFormatException exc) {
            this.traceDebug(exc);
        }
    }

    private void addUsedFile(String workingDirPath, String file2) {
        if (file2 == null) {
            return;
        }
        Location f = new Location(workingDirPath, file2);
        if (!workingDirPath.equals("")) {
            this.allFiles.add(f.getAbsolutePath());
        } else {
            this.allFiles.add(file2);
        }
    }

    class PEComparator
    implements Comparator {
        PEComparator() {
        }

        public int compare(Object o1, Object o2) {
            String prefix2;
            String s2;
            String s1 = o1.toString();
            if (s1.equals(s2 = o2.toString())) {
                return 0;
            }
            int underscore1 = Math.max(s1.lastIndexOf("_"), 0);
            int underscore2 = Math.max(s2.lastIndexOf("_"), 0);
            int dot1 = Math.max(s1.lastIndexOf("."), 0);
            int dot2 = Math.max(s2.lastIndexOf("."), 0);
            String prefix1 = s1.substring(0, underscore1);
            if (!prefix1.equals(prefix2 = s2.substring(0, underscore2))) {
                return prefix1.compareTo(prefix2);
            }
            try {
                int z1 = Integer.parseInt(s1.substring(underscore1 + 1, dot1));
                int z2 = Integer.parseInt(s2.substring(underscore2 + 1, dot2));
                if (z1 < z2) {
                    return -1;
                }
                if (z2 < z1) {
                    return 1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                int ext1 = Integer.parseInt(s1.substring(dot1 + 1), 16);
                int ext2 = Integer.parseInt(s2.substring(dot2 + 1), 16);
                if (ext1 < ext2) {
                    return -1;
                }
                if (ext1 > ext2) {
                    return 1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return 0;
        }

        public boolean equals(Object o) {
            return this.compare(this, o) == 0;
        }
    }
}

