/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;

public abstract class ImageIOWriter
extends FormatWriter {
    protected String kind;
    protected RandomAccessOutputStream out;

    public ImageIOWriter(String format, String suffix, String kind) {
        super(format, suffix);
        this.kind = kind;
    }

    public ImageIOWriter(String format, String[] suffixes, String kind) {
        super(format, suffixes);
        this.kind = kind;
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        MetadataRetrieve meta = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(meta, series);
        int width = meta.getPixelsSizeX(series, 0);
        int height = meta.getPixelsSizeY(series, 0);
        int type = FormatTools.pixelTypeFromString(meta.getPixelsPixelType(series, 0));
        Integer nChannels = meta.getLogicalChannelSamplesPerPixel(series, 0);
        if (nChannels == null) {
            this.warn("SamplesPerPixel #0 is null.  It is assumed to be 1.");
        }
        int channels = nChannels == null ? 1 : nChannels;
        boolean littleEndian = meta.getPixelsBigEndian(series, 0) == false;
        BufferedImage image = AWTImageTools.makeImage(buf, width, height, channels, this.interleaved, FormatTools.getBytesPerPixel(type), FormatTools.isFloatingPoint(type), littleEndian, FormatTools.isSigned(type));
        this.saveImage(image, series, lastInSeries, last);
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        BufferedImage img = AWTImageTools.makeBuffered(image, this.cm);
        int type = AWTImageTools.getPixelType(img);
        int[] types = this.getPixelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != type) continue;
            this.out = new RandomAccessOutputStream(this.currentId);
            ImageIO.write((RenderedImage)img, this.kind, this.out);
            return;
        }
        throw new FormatException("Floating point data not supported.");
    }

    public int[] getPixelTypes() {
        return new int[]{1, 3};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
    }
}

