/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.io.IOException;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTTiffTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;

public class TiffWriter
extends FormatWriter {
    protected long lastOffset = 0L;
    protected RandomAccessOutputStream out;
    protected Vector imageCounts;
    protected boolean isBigTiff;

    public TiffWriter() {
        this("Tagged Image File Format", new String[]{"tif", "tiff"});
    }

    public TiffWriter(String format, String[] exts) {
        super(format, exts);
        this.compressionTypes = new String[]{"Uncompressed", "LZW", "J2K", "J2K-Lossy", "JPEG"};
        this.isBigTiff = false;
    }

    public void saveImage(Image image, IFD ifd, boolean last) {
    }

    public void saveBytes(byte[] buf, IFD ifd, boolean last) throws IOException, FormatException {
        this.saveBytes(buf, ifd, 0, last, last);
    }

    public void saveBytes(byte[] buf, IFD ifd, int series, boolean lastInSeries, boolean last) throws IOException, FormatException {
        boolean littleEndian;
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(retrieve, series);
        Boolean bigEndian = retrieve.getPixelsBigEndian(series, 0);
        boolean bl = bigEndian == null ? false : (littleEndian = bigEndian == false);
        if (!this.initialized) {
            this.imageCounts = new Vector();
            this.initialized = true;
            this.out = new RandomAccessOutputStream(this.currentId);
            RandomAccessInputStream tmp = new RandomAccessInputStream(this.currentId);
            if (tmp.length() == 0L) {
                TiffSaver tiffSaver = new TiffSaver(this.out);
                tiffSaver.writeHeader(littleEndian, this.isBigTiff);
                this.lastOffset = this.isBigTiff ? 16L : 8L;
            } else {
                TiffParser tiffParser = new TiffParser(tmp);
                tiffParser.checkHeader();
                long offset = tiffParser.getFirstOffset();
                long ifdMax = (tmp.length() - 8L) / 18L;
                for (long ifdNum = 0L; ifdNum < ifdMax; ++ifdNum) {
                    tiffParser.getIFD(ifdNum, offset);
                    offset = tmp.readInt();
                    if (offset <= 0L || offset >= tmp.length()) break;
                }
                this.lastOffset = offset;
            }
            tmp.close();
        }
        int width = retrieve.getPixelsSizeX(series, 0);
        int height = retrieve.getPixelsSizeY(series, 0);
        Integer channels = retrieve.getLogicalChannelSamplesPerPixel(series, 0);
        if (channels == null) {
            this.warn("SamplesPerPixel #0 is null.  It is assumed to be 1.");
        }
        int c = channels == null ? 1 : channels;
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsPixelType(series, 0));
        int bytesPerPixel = FormatTools.getBytesPerPixel(type);
        ifd.put(new Integer(256), new Integer(width));
        ifd.put(new Integer(257), new Integer(height));
        int plane = width * height * c * bytesPerPixel;
        if (!this.isBigTiff) {
            RandomAccessInputStream tmp = new RandomAccessInputStream(this.currentId);
            boolean bl2 = this.isBigTiff = tmp.length() + (long)(2 * plane) >= 0x100000000L;
            if (this.isBigTiff) {
                throw new FormatException("File is too large; call setBigTiff(true)");
            }
            tmp.close();
        }
        ifd.put(new Integer(0), new Boolean(littleEndian));
        this.out.seek(this.out.length());
        this.lastOffset += AWTTiffTools.writeImage(buf, ifd, this.out, this.lastOffset, last, this.isBigTiff, this.getColorModel(), type, this.interleaved);
        if (last) {
            this.close();
        }
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        IFD h = new IFD();
        if (this.compression == null) {
            this.compression = "";
        }
        Integer compressType = new Integer(1);
        if (this.compression.equals("LZW")) {
            compressType = new Integer(5);
        } else if (this.compression.equals("J2K")) {
            compressType = new Integer(33003);
        } else if (this.compression.equals("J2K-Lossy")) {
            compressType = new Integer(33004);
        } else if (this.compression.equals("JPEG")) {
            compressType = new Integer(7);
        }
        h.put(new Integer(259), compressType);
        this.saveBytes(buf, h, series, lastInSeries, last);
    }

    public boolean canDoStacks() {
        return true;
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
        this.lastOffset = 0L;
        this.imageCounts = null;
        this.isBigTiff = false;
    }

    public void setBigTiff(boolean bigTiff) {
        FormatTools.assertId(this.currentId, false, 1);
        this.isBigTiff = bigTiff;
    }
}

