/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import loci.formats.FormatException;

public final class PhotoInterp {
    public static final int WHITE_IS_ZERO = 0;
    public static final int BLACK_IS_ZERO = 1;
    public static final int RGB = 2;
    public static final int RGB_PALETTE = 3;
    public static final int TRANSPARENCY_MASK = 4;
    public static final int CMYK = 5;
    public static final int Y_CB_CR = 6;
    public static final int CIE_LAB = 8;
    public static final int CFA_ARRAY = 32803;

    private PhotoInterp() {
    }

    public static String getPIName(int photoInterp) {
        switch (photoInterp) {
            case 0: {
                return "WhiteIsZero";
            }
            case 1: {
                return "BlackIsZero";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "Palette";
            }
            case 4: {
                return "Transparency Mask";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CIELAB";
            }
            case 32803: {
                return "Color Filter Array";
            }
        }
        return null;
    }

    public static String getPIMeta(int photoInterp) {
        switch (photoInterp) {
            case 0: {
                return "Monochrome";
            }
            case 1: {
                return "Monochrome";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "Monochrome";
            }
            case 4: {
                return "RGB";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "RGB";
            }
            case 8: {
                return "RGB";
            }
            case 32803: {
                return "RGB";
            }
        }
        return null;
    }

    public static void checkPI(int photoInterp) throws FormatException {
        if (photoInterp == 4) {
            throw new FormatException("Sorry, Transparency Mask PhotometricInterpretation is not supported");
        }
        if (photoInterp == 8) {
            throw new FormatException("Sorry, CIELAB PhotometricInterpretation is not supported");
        }
        if (photoInterp != 0 && photoInterp != 1 && photoInterp != 2 && photoInterp != 3 && photoInterp != 5 && photoInterp != 6 && photoInterp != 32803) {
            throw new FormatException("Unknown PhotometricInterpretation (" + photoInterp + ")");
        }
    }
}

