/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.gui.GenericDialog;
import java.awt.Container;
import java.awt.Rectangle;
import loci.formats.IFormatReader;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.prefs.OptionsDialog;
import loci.plugins.util.WindowTools;

public class CropDialog
extends OptionsDialog {
    protected ImporterOptions options;
    protected IFormatReader r;
    protected String[] labels;
    protected boolean[] series;
    protected Rectangle[] box;

    public CropDialog(ImporterOptions options, IFormatReader r, String[] labels, boolean[] series, Rectangle[] box) {
        super(options);
        this.options = options;
        this.r = r;
        this.labels = labels;
        this.series = series;
        this.box = box;
    }

    public int showDialog() {
        int i;
        GenericDialog gd = new GenericDialog("Bio-Formats Crop Options");
        for (i = 0; i < this.series.length; ++i) {
            if (!this.series[i]) continue;
            this.r.setSeries(i);
            gd.addMessage(this.labels[i].replaceAll("_", " "));
            gd.addNumericField("X_Coordinate_" + (i + 1), 0.0, 0);
            gd.addNumericField("Y_Coordinate_" + (i + 1), 0.0, 0);
            gd.addNumericField("Width_" + (i + 1), (double)this.r.getSizeX(), 0);
            gd.addNumericField("Height_" + (i + 1), (double)this.r.getSizeY(), 0);
        }
        WindowTools.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        for (i = 0; i < this.series.length; ++i) {
            if (!this.series[i]) continue;
            this.r.setSeries(i);
            this.box[i].x = (int)gd.getNextNumber();
            this.box[i].y = (int)gd.getNextNumber();
            this.box[i].width = (int)gd.getNextNumber();
            this.box[i].height = (int)gd.getNextNumber();
            if (this.box[i].x < 0) {
                this.box[i].x = 0;
            }
            if (this.box[i].y < 0) {
                this.box[i].y = 0;
            }
            if (this.box[i].x >= this.r.getSizeX()) {
                this.box[i].x = this.r.getSizeX() - this.box[i].width - 1;
            }
            if (this.box[i].y >= this.r.getSizeY()) {
                this.box[i].y = this.r.getSizeY() - this.box[i].height - 1;
            }
            if (this.box[i].width < 1) {
                this.box[i].width = 1;
            }
            if (this.box[i].height < 1) {
                this.box[i].height = 1;
            }
            if (this.box[i].width + this.box[i].x > this.r.getSizeX()) {
                this.box[i].width = this.r.getSizeX() - this.box[i].x;
            }
            if (this.box[i].height + this.box[i].y <= this.r.getSizeY()) continue;
            this.box[i].height = this.r.getSizeY() - this.box[i].y;
        }
        return 0;
    }
}

