/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.gui.GenericDialog;
import java.awt.Container;
import loci.formats.IFormatReader;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.prefs.OptionsDialog;
import loci.plugins.util.WindowTools;

public class RangeDialog
extends OptionsDialog {
    protected ImporterOptions options;
    protected IFormatReader r;
    protected boolean[] series;
    protected String[] seriesLabels;
    protected int[] cBegin;
    protected int[] cEnd;
    protected int[] cStep;
    protected int[] zBegin;
    protected int[] zEnd;
    protected int[] zStep;
    protected int[] tBegin;
    protected int[] tEnd;
    protected int[] tStep;

    public RangeDialog(ImporterOptions options, IFormatReader r, boolean[] series, String[] seriesLabels, int[] cBegin, int[] cEnd, int[] cStep, int[] zBegin, int[] zEnd, int[] zStep, int[] tBegin, int[] tEnd, int[] tStep) {
        super(options);
        this.options = options;
        this.r = r;
        this.series = series;
        this.seriesLabels = seriesLabels;
        this.cBegin = cBegin;
        this.cEnd = cEnd;
        this.cStep = cStep;
        this.zBegin = zBegin;
        this.zEnd = zEnd;
        this.zStep = zStep;
        this.tBegin = tBegin;
        this.tEnd = tEnd;
        this.tStep = tStep;
    }

    public int showDialog() {
        int i;
        int seriesCount = this.r.getSeriesCount();
        GenericDialog gd = new GenericDialog("Bio-Formats Range Options");
        for (i = 0; i < seriesCount; ++i) {
            String s;
            if (!this.series[i]) continue;
            this.r.setSeries(i);
            gd.addMessage(this.seriesLabels[i].replaceAll("_", " "));
            String string = s = seriesCount > 1 ? "_" + (i + 1) : "";
            if (this.r.getEffectiveSizeC() > 1) {
                gd.addNumericField("C_Begin" + s, (double)(this.cBegin[i] + 1), 0);
                gd.addNumericField("C_End" + s, (double)(this.cEnd[i] + 1), 0);
                gd.addNumericField("C_Step" + s, (double)this.cStep[i], 0);
            }
            if (this.r.getSizeZ() > 1) {
                gd.addNumericField("Z_Begin" + s, (double)(this.zBegin[i] + 1), 0);
                gd.addNumericField("Z_End" + s, (double)(this.zEnd[i] + 1), 0);
                gd.addNumericField("Z_Step" + s, (double)this.zStep[i], 0);
            }
            if (this.r.getSizeT() <= 1) continue;
            gd.addNumericField("T_Begin" + s, (double)(this.tBegin[i] + 1), 0);
            gd.addNumericField("T_End" + s, (double)(this.tEnd[i] + 1), 0);
            gd.addNumericField("T_Step" + s, (double)this.tStep[i], 0);
        }
        WindowTools.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        for (i = 0; i < seriesCount; ++i) {
            int maxC;
            if (!this.series[i]) continue;
            this.r.setSeries(i);
            int sizeC = this.r.getEffectiveSizeC();
            int sizeZ = this.r.getSizeZ();
            int sizeT = this.r.getSizeT();
            boolean certain = this.r.isOrderCertain();
            if (this.r.getEffectiveSizeC() > 1) {
                this.cBegin[i] = (int)gd.getNextNumber() - 1;
                this.cEnd[i] = (int)gd.getNextNumber() - 1;
                this.cStep[i] = (int)gd.getNextNumber();
            }
            if (this.r.getSizeZ() > 1) {
                this.zBegin[i] = (int)gd.getNextNumber() - 1;
                this.zEnd[i] = (int)gd.getNextNumber() - 1;
                this.zStep[i] = (int)gd.getNextNumber();
            }
            if (this.r.getSizeT() > 1) {
                this.tBegin[i] = (int)gd.getNextNumber() - 1;
                this.tEnd[i] = (int)gd.getNextNumber() - 1;
                this.tStep[i] = (int)gd.getNextNumber();
            }
            int n = maxC = certain ? sizeC : this.r.getImageCount();
            if (this.cBegin[i] < 0) {
                this.cBegin[i] = 0;
            }
            if (this.cBegin[i] >= maxC) {
                this.cBegin[i] = maxC - 1;
            }
            if (this.cEnd[i] < this.cBegin[i]) {
                this.cEnd[i] = this.cBegin[i];
            }
            if (this.cEnd[i] >= maxC) {
                this.cEnd[i] = maxC - 1;
            }
            if (this.cStep[i] < 1) {
                this.cStep[i] = 1;
            }
            if (this.zBegin[i] < 0) {
                this.zBegin[i] = 0;
            }
            if (this.zBegin[i] >= sizeZ) {
                this.zBegin[i] = sizeZ - 1;
            }
            if (this.zEnd[i] < this.zBegin[i]) {
                this.zEnd[i] = this.zBegin[i];
            }
            if (this.zEnd[i] >= sizeZ) {
                this.zEnd[i] = sizeZ - 1;
            }
            if (this.zStep[i] < 1) {
                this.zStep[i] = 1;
            }
            if (this.tBegin[i] < 0) {
                this.tBegin[i] = 0;
            }
            if (this.tBegin[i] >= sizeT) {
                this.tBegin[i] = sizeT - 1;
            }
            if (this.tEnd[i] < this.tBegin[i]) {
                this.tEnd[i] = this.tBegin[i];
            }
            if (this.tEnd[i] >= sizeT) {
                this.tEnd[i] = sizeT - 1;
            }
            if (this.tStep[i] >= 1) continue;
            this.tStep[i] = 1;
        }
        return 0;
    }
}

