/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.ddf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import loci.poi.ddf.EscherProperty;
import loci.poi.ddf.EscherPropertyFactory;
import loci.poi.ddf.EscherRecord;
import loci.poi.ddf.EscherRecordFactory;
import loci.poi.ddf.EscherSerializationListener;
import loci.poi.util.HexDump;
import loci.poi.util.LittleEndian;

public class EscherOptRecord
extends EscherRecord {
    public static final short RECORD_ID = -4085;
    public static final String RECORD_DESCRIPTION = "msofbtOPT";
    private List properties = new ArrayList();

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        EscherPropertyFactory f = new EscherPropertyFactory();
        this.properties = f.createProperties(data, pos, this.getInstance());
        return bytesRemaining + 8;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        EscherProperty escherProperty;
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        LittleEndian.putInt(data, offset + 4, this.getPropertiesSize());
        int pos = offset + 8;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            escherProperty = (EscherProperty)iterator.next();
            pos += escherProperty.serializeSimplePart(data, pos);
        }
        iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            escherProperty = (EscherProperty)iterator.next();
            pos += escherProperty.serializeComplexPart(data, pos);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    public short getOptions() {
        this.setOptions((short)(this.properties.size() << 4 | 3));
        return super.getOptions();
    }

    public String getRecordName() {
        return "Opt";
    }

    private int getPropertiesSize() {
        int totalSize = 0;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty escherProperty = (EscherProperty)iterator.next();
            totalSize += escherProperty.getPropertySize();
        }
        return totalSize;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer propertiesBuf = new StringBuffer();
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            propertiesBuf.append("    " + iterator.next().toString() + nl);
        }
        return "loci.poi.ddf.EscherOptRecord:" + nl + "  isContainer: " + this.isContainerRecord() + nl + "  options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  numchildren: " + this.getChildRecords().size() + nl + "  properties:" + nl + propertiesBuf.toString();
    }

    public List getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int index) {
        return (EscherProperty)this.properties.get(index);
    }

    public void addEscherProperty(EscherProperty prop) {
        this.properties.add(prop);
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator(){

            public int compare(Object o1, Object o2) {
                EscherProperty p1 = (EscherProperty)o1;
                EscherProperty p2 = (EscherProperty)o2;
                return new Short(p1.getPropertyNumber()).compareTo(new Short(p2.getPropertyNumber()));
            }
        });
    }
}

