/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import java.awt.image.ColorModel;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChannelDefinitionBox
extends Box {
    private short num;
    private short[] channels;
    private short[] types;
    private short[] associations;

    private static int computeLength(ColorModel colorModel) {
        int length = colorModel.getComponentSize().length - 1;
        return 10 + (colorModel.isAlphaPremultiplied() ? length * 18 : length * 12);
    }

    public static void fillBasedOnBands(int numComps, boolean isPremultiplied, short[] c, short[] t, short[] a) {
        int i;
        int num = numComps * (isPremultiplied ? 3 : 2);
        if (isPremultiplied) {
            for (i = numComps * 2; i < num; ++i) {
                c[i] = (short)(i - numComps * 2);
                t[i] = 2;
                a[i] = (short)(i + 1 - numComps * 2);
            }
        }
        for (i = 0; i < numComps; ++i) {
            int j = i + numComps;
            c[i] = (short)i;
            t[i] = 0;
            a[j] = a[i] = (short)(i + 1);
            c[j] = (short)numComps;
            t[j] = 1;
        }
    }

    public ChannelDefinitionBox(ColorModel colorModel) {
        super(ChannelDefinitionBox.computeLength(colorModel), 1667523942, null);
        short length = (short)(colorModel.getComponentSize().length - 1);
        this.num = (short)(length * (colorModel.isAlphaPremultiplied() ? 3 : 2));
        this.channels = new short[this.num];
        this.types = new short[this.num];
        this.associations = new short[this.num];
        ChannelDefinitionBox.fillBasedOnBands(length, colorModel.isAlphaPremultiplied(), this.channels, this.types, this.associations);
    }

    public ChannelDefinitionBox(byte[] data) {
        super(8 + data.length, 1667523942, data);
    }

    public ChannelDefinitionBox(short[] channel, short[] types, short[] associations) {
        super(10 + channel.length * 6, 1667523942, null);
        this.num = (short)channel.length;
        this.channels = channel;
        this.types = types;
        this.associations = associations;
    }

    public ChannelDefinitionBox(Node node2) throws IIOInvalidTreeException {
        super(node2);
        NodeList children = node2.getChildNodes();
        int index = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("NumberOfDefinition".equals(name)) {
                this.num = Box.getShortElementValue(child);
            }
            if (!"Definitions".equals(name)) continue;
            this.channels = new short[this.num];
            this.types = new short[this.num];
            this.associations = new short[this.num];
            NodeList children1 = child.getChildNodes();
            for (int j = 0; j < children1.getLength(); ++j) {
                child = children1.item(j);
                name = child.getNodeName();
                if ("ChannelNumber".equals(name)) {
                    this.channels[index] = Box.getShortElementValue(child);
                }
                if ("ChannelType".equals(name)) {
                    this.types[index] = Box.getShortElementValue(child);
                }
                if (!"Association".equals(name)) continue;
                this.associations[index++] = Box.getShortElementValue(child);
            }
        }
    }

    protected void parse(byte[] data) {
        this.num = (short)(data[0] << 8 | data[1]);
        this.channels = new short[this.num];
        this.types = new short[this.num];
        this.associations = new short[this.num];
        int j = 2;
        for (int i = 0; i < this.num; ++i) {
            this.channels[i] = (short)(((data[j++] & 0xFF) << 8) + (data[j++] & 0xFF));
            this.types[i] = (short)(((data[j++] & 0xFF) << 8) + (data[j++] & 0xFF));
            this.associations[i] = (short)(((data[j++] & 0xFF) << 8) + (data[j++] & 0xFF));
        }
    }

    public short[] getChannel() {
        return this.channels;
    }

    public short[] getTypes() {
        return this.types;
    }

    public short[] getAssociation() {
        return this.associations;
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode node2 = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(node2);
        IIOMetadataNode child = new IIOMetadataNode("NumberOfDefinition");
        child.setUserObject(new Short(this.num));
        child.setNodeValue("" + this.num);
        node2.appendChild(child);
        child = new IIOMetadataNode("Definitions");
        node2.appendChild(child);
        for (int i = 0; i < this.num; ++i) {
            IIOMetadataNode child1 = new IIOMetadataNode("ChannelNumber");
            child1.setUserObject(new Short(this.channels[i]));
            child1.setNodeValue("" + this.channels[i]);
            child.appendChild(child1);
            child1 = new IIOMetadataNode("ChannelType");
            child1.setUserObject(new Short(this.types[i]));
            child1.setNodeValue("" + this.types[i]);
            child.appendChild(child1);
            child1 = new IIOMetadataNode("Association");
            child1.setUserObject(new Short(this.associations[i]));
            child1.setNodeValue("" + this.associations[i]);
            child.appendChild(child1);
        }
        return node2;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        int len = this.num * 6 + 2;
        this.data = new byte[len];
        this.data[0] = (byte)(this.num >> 8);
        this.data[1] = (byte)(this.num & 0xFF);
        int j = 2;
        for (int i = 0; i < this.num; ++i) {
            this.data[j++] = (byte)(this.channels[i] >> 8);
            this.data[j++] = (byte)(this.channels[i] & 0xFF);
            this.data[j++] = (byte)(this.types[i] >> 8);
            this.data[j++] = (byte)(this.types[i] & 0xFF);
            this.data[j++] = (byte)(this.associations[i] >> 8);
            this.data[j++] = (byte)(this.associations[i] & 0xFF);
        }
    }
}

