/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffRational;
import loci.formats.tiff.TiffSaver;

public final class AWTTiffTools {
    public static long writeImage(byte[] buf, IFD ifd, RandomAccessOutputStream out, long offset, boolean last, boolean bigTiff, ColorModel colorModel, int pixelType, boolean interleaved) throws FormatException, IOException {
        int compression;
        boolean indexed;
        if (buf == null) {
            throw new FormatException("Byte array is null");
        }
        LogTools.debug("writeImage (offset=" + offset + "; last=" + last + ")");
        boolean little = ifd.isLittleEndian();
        int width = (int)ifd.getImageWidth();
        int height = (int)ifd.getImageLength();
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int plane = width * height * bytesPerPixel;
        int nChannels = buf.length / plane;
        boolean bl = indexed = colorModel != null && colorModel instanceof IndexColorModel;
        if (ifd == null) {
            ifd = new IFD();
        }
        ifd.putIFDValue(256, width);
        ifd.putIFDValue(257, height);
        if (ifd.getIFDValue(258) == null) {
            int bps = 8 * bytesPerPixel;
            int[] bpsArray = new int[nChannels];
            Arrays.fill(bpsArray, bps);
            ifd.putIFDValue(258, bpsArray);
        }
        if (FormatTools.isFloatingPoint(pixelType)) {
            ifd.putIFDValue(339, 3);
        }
        if (ifd.getIFDValue(259) == null) {
            ifd.putIFDValue(259, 1);
        }
        if (ifd.getIFDValue(262) == null) {
            int photometricInterpretation = indexed ? 3 : (nChannels == 1 ? 1 : 2);
            ifd.putIFDValue(262, photometricInterpretation);
        }
        if (ifd.getIFDValue(277) == null) {
            ifd.putIFDValue(277, nChannels);
        }
        if (ifd.getIFDValue(282) == null) {
            ifd.putIFDValue(282, new TiffRational(1L, 1L));
        }
        if (ifd.getIFDValue(283) == null) {
            ifd.putIFDValue(283, new TiffRational(1L, 1L));
        }
        if (ifd.getIFDValue(296) == null) {
            ifd.putIFDValue(296, 1);
        }
        if (ifd.getIFDValue(305) == null) {
            ifd.putIFDValue(305, "LOCI Bio-Formats");
        }
        if (ifd.getIFDValue(270) == null) {
            ifd.putIFDValue(270, "");
        }
        if (indexed && ifd.getIFDValue(320) == null) {
            byte[][] lut = new byte[3][256];
            IndexColorModel model = (IndexColorModel)colorModel;
            model.getReds(lut[0]);
            model.getGreens(lut[1]);
            model.getBlues(lut[2]);
            int[] colorMap = new int[768];
            for (int i = 0; i < lut.length; ++i) {
                for (int j = 0; j < lut[0].length; ++j) {
                    colorMap[i * lut[0].length + j] = (lut[i][j] & 0xFF) << 8;
                }
            }
            ifd.putIFDValue(320, colorMap);
        }
        boolean fullImageCompression = (compression = ifd.getCompression()) == 33003 || compression == 33004 || compression == 7;
        int pixels = fullImageCompression ? width * height : width;
        int stripSize = Math.max(8192, pixels * bytesPerPixel * nChannels);
        int rowsPerStrip = stripSize / (width * bytesPerPixel * nChannels);
        int stripsPerImage = (height + rowsPerStrip - 1) / rowsPerStrip;
        int[] bps = (int[])ifd.getIFDValue(258, true, int[].class);
        ByteArrayOutputStream[] stripBuf = new ByteArrayOutputStream[stripsPerImage];
        DataOutputStream[] stripOut = new DataOutputStream[stripsPerImage];
        for (int i = 0; i < stripsPerImage; ++i) {
            stripBuf[i] = new ByteArrayOutputStream(stripSize);
            stripOut[i] = new DataOutputStream(stripBuf[i]);
        }
        for (int y = 0; y < height; ++y) {
            int strip = y / rowsPerStrip;
            for (int x = 0; x < width; ++x) {
                int ndx = y * width * bytesPerPixel + x * bytesPerPixel;
                for (int c = 0; c < nChannels; ++c) {
                    for (int n = 0; n < bps[c] / 8; ++n) {
                        int off = interleaved ? ndx * nChannels + c * bytesPerPixel + n : c * plane + ndx + n;
                        stripOut[strip].writeByte(buf[off]);
                    }
                }
            }
        }
        int planarConfig = ifd.getPlanarConfiguration();
        int predictor = ifd.getIFDIntValue(317, false, 1);
        byte[][] strips = new byte[stripsPerImage][];
        for (int i = 0; i < stripsPerImage; ++i) {
            strips[i] = stripBuf[i].toByteArray();
            TiffCompression.difference(strips[i], bps, width, planarConfig, predictor);
            strips[i] = TiffCompression.compress(strips[i], ifd);
        }
        long[] stripByteCounts = new long[stripsPerImage];
        long[] stripOffsets = new long[stripsPerImage];
        ifd.putIFDValue(273, stripOffsets);
        ifd.putIFDValue(278, rowsPerStrip);
        ifd.putIFDValue(279, stripByteCounts);
        Object[] keys = ifd.keySet().toArray();
        Arrays.sort(keys);
        int keyCount = keys.length;
        if (ifd.containsKey(new Integer(0))) {
            --keyCount;
        }
        if (ifd.containsKey(new Integer(1))) {
            --keyCount;
        }
        int bytesPerEntry = bigTiff ? 20 : 12;
        int ifdBytes = (bigTiff ? 16 : 6) + bytesPerEntry * keyCount;
        long pixelBytes = 0L;
        for (int i = 0; i < stripsPerImage; ++i) {
            stripByteCounts[i] = strips[i].length;
            stripOffsets[i] = pixelBytes + offset + (long)ifdBytes;
            pixelBytes += stripByteCounts[i];
        }
        ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(ifdBytes);
        DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
        ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
        DataOutputStream extraOut = new DataOutputStream(extraBuf);
        offset += (long)ifdBytes + pixelBytes;
        if (bigTiff) {
            DataTools.writeLong(ifdOut, keyCount, little);
        } else {
            DataTools.writeShort(ifdOut, keyCount, little);
        }
        for (int k = 0; k < keys.length; ++k) {
            Object key = keys[k];
            if (!(key instanceof Integer)) {
                throw new FormatException("Malformed IFD tag (" + key + ")");
            }
            if ((Integer)key == 0 || (Integer)key == 1) continue;
            Object value = ifd.get(key);
            String sk = IFD.getIFDTagName((Integer)key);
            String sv = value instanceof int[] ? "int[" + ((int[])value).length + "]" : value.toString();
            LogTools.debug("writeImage: writing " + sk + " (value=" + sv + ")");
            TiffSaver.writeIFDValue(ifdOut, extraBuf, extraOut, offset, (Integer)key, value, bigTiff, little);
        }
        if (bigTiff) {
            DataTools.writeLong(ifdOut, last ? 0L : offset + (long)extraBuf.size(), little);
        } else {
            DataTools.writeInt(ifdOut, last ? 0 : (int)(offset + (long)extraBuf.size()), little);
        }
        byte[] ifdArray = ifdBuf.toByteArray();
        byte[] extraArray = extraBuf.toByteArray();
        long numBytes = ifdArray.length + extraArray.length;
        out.write(ifdArray);
        for (int i = 0; i < strips.length; ++i) {
            out.write(strips[i]);
            numBytes += (long)strips[i].length;
        }
        out.write(extraArray);
        return numBytes;
    }
}

