/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;

public class ImarisTiffReader
extends BaseTiffReader {
    public ImarisTiffReader() {
        super("Bitplane Imaris 3 (TIFF)", "ims");
        this.suffixSufficient = false;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("ImarisTiffReader.initFile(" + id + ")");
        super.initFile(id);
        this.status("Verifying IFD sanity");
        IFDList tmp = new IFDList();
        for (int i = 0; i < this.ifds.size(); ++i) {
            IFD ifd = (IFD)this.ifds.get(i);
            long[] byteCounts = ifd.getIFDLongArray(325, false);
            long[] offsets = ifd.getIFDLongArray(324, false);
            for (int j = 0; j < byteCounts.length; ++j) {
                IFD t = new IFD(ifd);
                t.putIFDValue(325, byteCounts[j]);
                t.putIFDValue(324, offsets[j]);
                tmp.add(t);
            }
        }
        String comment = ((IFD)this.ifds.get(0)).getComment();
        this.status("Populating metadata");
        this.core[0].sizeC = this.ifds.size();
        this.core[0].sizeZ = tmp.size() / this.getSizeC();
        this.core[0].sizeT = 1;
        this.core[0].sizeX = (int)((IFD)this.ifds.get(0)).getImageWidth();
        this.core[0].sizeY = (int)((IFD)this.ifds.get(0)).getImageLength();
        this.ifds = tmp;
        this.core[0].imageCount = this.getSizeC() * this.getSizeZ();
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].interleaved = false;
        this.core[0].rgb = this.getImageCount() != this.getSizeZ() * this.getSizeC() * this.getSizeT();
        this.core[0].pixelType = ((IFD)this.ifds.get(0)).getPixelType();
        this.status("Parsing comment");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        String description = null;
        String creationDate = null;
        Vector<Integer> emWave = new Vector<Integer>();
        Vector<Integer> exWave = new Vector<Integer>();
        Vector<String> channelNames = new Vector<String>();
        if (comment != null && comment.startsWith("[")) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals).trim();
                String value = line.substring(equals + 1).trim();
                this.addGlobalMeta(key, value);
                if (key.equals("Description")) {
                    description = value;
                    continue;
                }
                if (key.equals("LSMEmissionWavelength") && !value.equals("0")) {
                    emWave.add(new Integer(value));
                    continue;
                }
                if (key.equals("LSMExcitationWavelength") && !value.equals("0")) {
                    exWave.add(new Integer(value));
                    continue;
                }
                if (key.equals("Name") && !this.currentId.endsWith(value)) {
                    channelNames.add(value);
                    continue;
                }
                if (!key.equals("RecordingDate")) continue;
                value = value.replaceAll(" ", "T");
                creationDate = value.substring(0, value.indexOf("."));
            }
            this.metadata.remove("Comment");
        }
        store.setImageDescription(description, 0);
        store.setImageCreationDate(creationDate, 0);
        for (int i = 0; i < emWave.size(); ++i) {
            store.setLogicalChannelEmWave((Integer)emWave.get(i), 0, i);
            store.setLogicalChannelExWave((Integer)exWave.get(i), 0, i);
            store.setLogicalChannelName((String)channelNames.get(i), 0, i);
        }
    }
}

