/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class DateTools {
    public static final int UNIX = 0;
    public static final int COBOL = 1;
    public static final int MICROSOFT = 2;
    public static final int ZVI = 3;
    public static final long UNIX_EPOCH = 0L;
    public static final long COBOL_EPOCH = 11644473600000L;
    public static final long MICROSOFT_EPOCH = 2209143600000L;
    public static final long ZVI_EPOCH = 2921084975759000L;
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    private DateTools() {
    }

    public static String convertDate(long stamp, int format) {
        long ms = stamp;
        switch (format) {
            case 0: {
                ms -= 0L;
                break;
            }
            case 1: {
                ms -= 11644473600000L;
                break;
            }
            case 2: {
                ms -= 2209143600000L;
                break;
            }
            case 3: {
                ms -= 2921084975759000L;
            }
        }
        SimpleDateFormat fmt = new SimpleDateFormat(ISO8601_FORMAT);
        StringBuffer sb = new StringBuffer();
        Date d = new Date(ms);
        fmt.format(d, sb, new FieldPosition(0));
        return sb.toString();
    }

    public static String formatDate(String date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        Date d = sdf.parse(date, new ParsePosition(0));
        if (d == null) {
            return null;
        }
        sdf = new SimpleDateFormat(ISO8601_FORMAT);
        return sdf.format(d);
    }

    public static String formatDate(String date, String[] formats) {
        for (int i = 0; i < formats.length; ++i) {
            String result = DateTools.formatDate(date, formats[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static long getTime(String date, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        Date d = f.parse(date, new ParsePosition(0));
        if (d == null) {
            return -1L;
        }
        return d.getTime();
    }
}

