/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import loci.common.IRandomAccess;
import loci.common.Location;

public class RandomAccessOutputStream
extends OutputStream
implements DataOutput {
    private IRandomAccess outputFile;

    public RandomAccessOutputStream(String file2) throws IOException {
        this.outputFile = Location.getHandle(file2, true);
    }

    public void seek(long pos) throws IOException {
        this.outputFile.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.outputFile.getFilePointer();
    }

    public long length() throws IOException {
        return this.outputFile.length();
    }

    public void skipBytes(int skip) throws IOException {
        this.outputFile.seek(this.outputFile.getFilePointer() + (long)skip);
    }

    public void write(byte[] b) throws IOException {
        this.outputFile.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputFile.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.outputFile.write(b);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.outputFile.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.outputFile.writeByte(v);
    }

    public void writeBytes(String s) throws IOException {
        this.outputFile.writeBytes(s);
    }

    public void writeChar(int v) throws IOException {
        this.outputFile.writeChar(v);
    }

    public void writeChars(String s) throws IOException {
        this.outputFile.writeChars(s);
    }

    public void writeDouble(double v) throws IOException {
        this.outputFile.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.outputFile.writeFloat(v);
    }

    public void writeInt(int v) throws IOException {
        this.outputFile.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.outputFile.writeLong(v);
    }

    public void writeShort(int v) throws IOException {
        this.outputFile.writeShort(v);
    }

    public void writeUTF(String str) throws IOException {
        this.outputFile.writeUTF(str);
    }

    public void close() throws IOException {
        this.outputFile.close();
    }

    public void flush() throws IOException {
    }
}

